/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.context;

import ca.uhn.fhir.rest.api.Constants;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.dstu3.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.UUIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    private static final Logger log = LoggerFactory.getLogger(BaseWorkerContext.class);
    protected Map<String, CodeSystem> codeSystems = new HashMap<String, CodeSystem>();
    protected Set<String> nonSupportedCodeSystems = new HashSet<String>();
    protected Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    protected Map<String, ConceptMap> maps = new HashMap<String, ConceptMap>();
    protected Map<String, StructureMap> transforms = new HashMap<String, StructureMap>();
    protected Map<String, DataElement> dataElements = new HashMap<String, DataElement>();
    protected Map<String, StructureDefinition> profiles = new HashMap<String, StructureDefinition>();
    protected Map<String, SearchParameter> searchParameters = new HashMap<String, SearchParameter>();
    protected Map<String, StructureDefinition> extensionDefinitions = new HashMap<String, StructureDefinition>();
    protected Map<String, Questionnaire> questionnaires = new HashMap<String, Questionnaire>();
    protected Map<String, OperationDefinition> operations = new HashMap<String, OperationDefinition>();
    protected ValueSetExpanderFactory expansionCache = new ValueSetExpansionCache(this);
    protected boolean cacheValidation;
    private Set<String> failed = new HashSet<String>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected String tsServer;
    protected String validationCachePath;
    protected String name;
    protected FHIRToolingClient txServer;
    private Bundle bndCodeSystems;
    private boolean canRunWithoutTerminology;
    protected boolean allowLoadingDuplicates;
    protected boolean noTerminologyServer;
    protected String cache;
    private int expandCodesLimit = 1000;
    protected ExpansionProfile expProfile;
    private Locale locale;
    private ResourceBundle i18Nmessages;

    public Map<String, CodeSystem> getCodeSystems() {
        return this.codeSystems;
    }

    public Map<String, DataElement> getDataElements() {
        return this.dataElements;
    }

    public Map<String, ValueSet> getValueSets() {
        return this.valueSets;
    }

    public Map<String, ConceptMap> getMaps() {
        return this.maps;
    }

    public Map<String, StructureDefinition> getProfiles() {
        return this.profiles;
    }

    public Map<String, StructureDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public Map<String, Questionnaire> getQuestionnaires() {
        return this.questionnaires;
    }

    public Map<String, OperationDefinition> getOperations() {
        return this.operations;
    }

    public void seeExtensionDefinition(String url, StructureDefinition ed) throws Exception {
        if (this.extensionDefinitions.get(ed.getUrl()) != null) {
            throw new Exception("duplicate extension definition: " + ed.getUrl());
        }
        this.extensionDefinitions.put(ed.getId(), ed);
        this.extensionDefinitions.put(url, ed);
        this.extensionDefinitions.put(ed.getUrl(), ed);
    }

    public void dropExtensionDefinition(String id) {
        StructureDefinition sd = this.extensionDefinitions.get(id);
        this.extensionDefinitions.remove(id);
        if (sd != null) {
            this.extensionDefinitions.remove(sd.getUrl());
        }
    }

    public void seeQuestionnaire(String url, Questionnaire theQuestionnaire) throws Exception {
        if (this.questionnaires.get(theQuestionnaire.getId()) != null) {
            throw new Exception("duplicate extension definition: " + theQuestionnaire.getId());
        }
        this.questionnaires.put(theQuestionnaire.getId(), theQuestionnaire);
        this.questionnaires.put(url, theQuestionnaire);
    }

    public void seeOperation(OperationDefinition opd) throws Exception {
        if (this.operations.get(opd.getUrl()) != null) {
            throw new Exception("duplicate extension definition: " + opd.getUrl());
        }
        this.operations.put(opd.getUrl(), opd);
        this.operations.put(opd.getId(), opd);
    }

    public void seeValueSet(String url, ValueSet vs) throws Exception {
        if (this.valueSets.containsKey(vs.getUrl()) && !this.allowLoadingDuplicates) {
            throw new Exception("Duplicate value set " + vs.getUrl());
        }
        this.valueSets.put(vs.getId(), vs);
        this.valueSets.put(url, vs);
        this.valueSets.put(vs.getUrl(), vs);
    }

    public void dropValueSet(String id) {
        ValueSet vs = this.valueSets.get(id);
        this.valueSets.remove(id);
        if (vs != null) {
            this.valueSets.remove(vs.getUrl());
        }
    }

    public void seeCodeSystem(String url, CodeSystem cs) throws FHIRException {
        if (this.codeSystems.containsKey(cs.getUrl()) && !this.allowLoadingDuplicates) {
            throw new FHIRException("Duplicate code system " + cs.getUrl());
        }
        this.codeSystems.put(cs.getId(), cs);
        this.codeSystems.put(url, cs);
        this.codeSystems.put(cs.getUrl(), cs);
    }

    public void dropCodeSystem(String id) {
        CodeSystem cs = this.codeSystems.get(id);
        this.codeSystems.remove(id);
        if (cs != null) {
            this.codeSystems.remove(cs.getUrl());
        }
    }

    public void seeProfile(String url, StructureDefinition p) throws Exception {
        if (this.profiles.containsKey(p.getUrl())) {
            throw new Exception("Duplicate Profile " + p.getUrl());
        }
        this.profiles.put(p.getId(), p);
        this.profiles.put(url, p);
        this.profiles.put(p.getUrl(), p);
    }

    public void dropProfile(String id) {
        StructureDefinition sd = this.profiles.get(id);
        this.profiles.remove(id);
        if (sd != null) {
            this.profiles.remove(sd.getUrl());
        }
    }

    @Override
    public CodeSystem fetchCodeSystem(String system) {
        return this.codeSystems.get(system);
    }

    @Override
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        if (this.codeSystems.containsKey(system)) {
            return true;
        }
        if (this.nonSupportedCodeSystems.contains(system)) {
            return false;
        }
        if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
            return false;
        }
        if (this.noTerminologyServer) {
            return false;
        }
        if (this.bndCodeSystems == null) {
            try {
                this.tlog("Terminology server: Check for supported code systems for " + system);
                this.bndCodeSystems = this.txServer.fetchFeed(this.txServer.getAddress() + "/CodeSystem?content-mode=not-present&_summary=true&_count=1000");
            }
            catch (Exception e) {
                if (this.canRunWithoutTerminology) {
                    this.noTerminologyServer = true;
                    log.info("==============!! Running without terminology server !!============== (" + e.getMessage() + ")");
                    return false;
                }
                throw new TerminologyServiceException((Throwable)e);
            }
        }
        if (this.bndCodeSystems != null) {
            for (Bundle.BundleEntryComponent be : this.bndCodeSystems.getEntry()) {
                CodeSystem cs = (CodeSystem)be.getResource();
                if (this.codeSystems.containsKey(cs.getUrl())) continue;
                this.codeSystems.put(cs.getUrl(), null);
            }
        }
        if (this.codeSystems.containsKey(system)) {
            return true;
        }
        this.nonSupportedCodeSystems.add(system);
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        try {
            if (vs.hasExpansion()) {
                return new ValueSetExpander.ValueSetExpansionOutcome(vs.copy());
            }
            String cacheFn = null;
            if (this.cache != null && ManagedFileAccess.file((String)(cacheFn = Utilities.path((String[])new String[]{this.cache, this.determineCacheId(vs, heirarchical) + ".json"}))).exists()) {
                return this.loadFromCache(vs.copy(), cacheFn);
            }
            if (cacheOk && vs.hasUrl()) {
                if (this.expProfile == null) {
                    throw new Exception("No ExpansionProfile provided");
                }
                ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs, this.expProfile.setExcludeNested(!heirarchical));
                if (vse.getValueset() != null && this.cache != null) {
                    FileOutputStream s = ManagedFileAccess.outStream((String)cacheFn);
                    this.newJsonParser().compose(ManagedFileAccess.outStream((String)cacheFn), vse.getValueset());
                    s.close();
                }
                return vse;
            }
            ValueSetExpander.ValueSetExpansionOutcome res = this.expandOnServer(vs, cacheFn);
            if (cacheFn != null) {
                if (res.getValueset() != null) {
                    this.saveToCache(res.getValueset(), cacheFn);
                } else {
                    OperationOutcome oo = new OperationOutcome();
                    oo.addIssue().getDetails().setText(res.getError());
                    this.saveToCache(oo, cacheFn);
                }
            }
            return res;
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
    }

    private ValueSetExpander.ValueSetExpansionOutcome loadFromCache(ValueSet vs, String cacheFn) throws FileNotFoundException, Exception {
        JsonParser parser = new JsonParser();
        Resource r = parser.parse(ManagedFileAccess.inStream((String)cacheFn));
        if (r instanceof OperationOutcome) {
            return new ValueSetExpander.ValueSetExpansionOutcome(((OperationOutcome)r).getIssue().get(0).getDetails().getText(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
        vs.setExpansion(((ValueSet)r).getExpansion());
        return new ValueSetExpander.ValueSetExpansionOutcome(vs);
    }

    private void saveToCache(Resource res, String cacheFn) throws FileNotFoundException, Exception {
        JsonParser parser = new JsonParser();
        parser.compose(ManagedFileAccess.outStream((String)cacheFn), res);
    }

    private String determineCacheId(ValueSet vs, boolean heirarchical) throws Exception {
        ValueSet vsid = new ValueSet();
        vsid.setCompose(vs.getCompose());
        JsonParser parser = new JsonParser();
        parser.setOutputStyle(IParser.OutputStyle.NORMAL);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        parser.compose(b, (Resource)vsid);
        b.close();
        Object s = new String(b.toByteArray(), Constants.CHARSET_UTF8);
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            CodeSystem cs = this.fetchCodeSystem(inc.getSystem());
            if (cs == null) continue;
            String css = this.cacheValue(cs);
            s = (String)s + css;
        }
        s = (String)s + "-" + Boolean.toString(heirarchical);
        String r = Integer.toString(((String)s).hashCode());
        return r;
    }

    private String cacheValue(CodeSystem cs) throws IOException {
        CodeSystem csid = new CodeSystem();
        csid.setId(cs.getId());
        csid.setVersion(cs.getVersion());
        csid.setContent(cs.getContent());
        csid.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY);
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            csid.getConcept().add(this.processCSConcept(cc));
        }
        JsonParser parser = new JsonParser();
        parser.setOutputStyle(IParser.OutputStyle.NORMAL);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        parser.compose(b, (Resource)csid);
        b.close();
        return new String(b.toByteArray(), Constants.CHARSET_UTF8);
    }

    private CodeSystem.ConceptDefinitionComponent processCSConcept(CodeSystem.ConceptDefinitionComponent cc) {
        CodeSystem.ConceptDefinitionComponent ccid = new CodeSystem.ConceptDefinitionComponent();
        ccid.setCode(cc.getCode());
        ccid.setDisplay(cc.getDisplay());
        for (CodeSystem.ConceptDefinitionComponent cci : cc.getConcept()) {
            ccid.getConcept().add(this.processCSConcept(cci));
        }
        return ccid;
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandOnServer(ValueSet vs, String fn) throws Exception {
        if (this.noTerminologyServer) {
            return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet: running without terminology services", ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        if (this.expProfile == null) {
            throw new Exception("No ExpansionProfile provided");
        }
        try {
            Parameters params = new Parameters();
            params.addParameter().setName("profile").setResource(this.expProfile.setIncludeDefinition(false));
            params.addParameter().setName("_limit").setValue(new IntegerType(this.expandCodesLimit));
            params.addParameter().setName("_incomplete").setValue(new BooleanType("true"));
            this.tlog("Terminology Server: $expand on " + this.getVSSummary(vs));
            ValueSet result = this.txServer.expandValueset(vs, params);
            return new ValueSetExpander.ValueSetExpansionOutcome(result);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet \"" + vs.getUrl() + ": " + e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
    }

    private String getVSSummary(ValueSet vs) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            b.append("Include " + this.getIncSummary(cc));
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getExclude()) {
            b.append("Exclude " + this.getIncSummary(cc));
        }
        return b.toString();
    }

    private String getIncSummary(ValueSet.ConceptSetComponent cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (UriType vs : cc.getValueSet()) {
            b.append(vs.asStringValue());
        }
        String vsd = b.length() > 0 ? " where the codes are in the value sets (" + b.toString() + ")" : "";
        String system = cc.getSystem();
        if (cc.hasConcept()) {
            return Integer.toString(cc.getConcept().size()) + " codes from " + system + vsd;
        }
        if (cc.hasFilter()) {
            Object s = "";
            for (ValueSet.ConceptSetFilterComponent f : cc.getFilter()) {
                if (!Utilities.noString((String)s)) {
                    s = (String)s + " & ";
                }
                s = (String)s + f.getProperty() + " " + f.getOp().toCode() + " " + f.getValue();
            }
            return "from " + system + " where " + (String)s + vsd;
        }
        return "All codes from " + system + vsd;
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, Coding coding, boolean tryCache) {
        String cacheId = this.cacheId(coding);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true, false);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(coding, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private boolean notcomplete(ValueSet vs) {
        if (!vs.hasExpansion()) {
            return true;
        }
        if (!vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-unclosed").isEmpty()) {
            return true;
        }
        return !vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").isEmpty();
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, CodeableConcept concept, boolean tryCache) {
        String cacheId = this.cacheId(concept);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (this.validationCache.containsKey(vs.getUrl()) && this.validationCache.get(vs.getUrl()).containsKey(cacheId)) {
            return this.validationCache.get(vs.getUrl()).get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true, false);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(concept, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private String cacheId(Coding coding) {
        return "|" + coding.getSystem() + "|" + coding.getVersion() + "|" + coding.getCode() + "|" + coding.getDisplay();
    }

    private String cacheId(CodeableConcept cc) {
        StringBuilder b = new StringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append("#");
            b.append(this.cacheId(c));
        }
        return b.toString();
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, Coding coding, boolean tryCache) throws Exception {
        IWorkerContext.ValidationResult res;
        IWorkerContext.ValidationResult validationResult = res = vs == null ? null : this.handleByCache(vs, coding, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("coding").setValue(coding);
        if (vs != null) {
            pin.addParameter().setName("valueSet").setResource(vs);
        }
        res = this.serverValidateCode(pin, vs == null);
        if (vs != null) {
            Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
            cache.put(this.cacheId(coding), res);
        }
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, CodeableConcept cc, boolean tryCache) throws Exception {
        IWorkerContext.ValidationResult res = this.handleByCache(vs, cc, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("codeableConcept").setValue(cc);
        pin.addParameter().setName("valueSet").setResource(vs);
        res = this.serverValidateCode(pin, false);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        cache.put(this.cacheId(cc), res);
        return res;
    }

    private IWorkerContext.ValidationResult serverValidateCode(Parameters pin, boolean doCache) throws Exception {
        if (this.noTerminologyServer) {
            return new IWorkerContext.ValidationResult(null, null, ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        String cacheName = doCache ? this.generateCacheName(pin) : null;
        IWorkerContext.ValidationResult res = this.loadFromCache(cacheName);
        if (res != null) {
            return res;
        }
        this.tlog("Terminology Server: $validate-code " + this.describeValidationParameters(pin));
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error("Can only specify profile in the context");
        }
        if (this.expProfile == null) {
            throw new Exception("No ExpansionProfile provided");
        }
        pin.addParameter().setName("profile").setResource(this.expProfile);
        Parameters pout = this.txServer.operateType(ValueSet.class, "validate-code", pin);
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        ValueSetExpander.TerminologyServiceErrorClass err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pout.getParameter()) {
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("display")) {
                display = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("cause")) continue;
            try {
                ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                if (it == ValidationMessage.IssueType.UNKNOWN) {
                    err = ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN;
                    continue;
                }
                if (it != ValidationMessage.IssueType.NOTSUPPORTED) continue;
                err = ValueSetExpander.TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
            }
            catch (FHIRException fHIRException) {}
        }
        res = !ok ? new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message, err) : (display != null ? new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setDisplay(display)) : new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent()));
        this.saveToCache(res, cacheName);
        return res;
    }

    private void tlog(String msg) {
    }

    private String describeValidationParameters(Parameters pin) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Parameters.ParametersParameterComponent p : pin.getParameter()) {
            if (p.hasValue() && p.getValue() instanceof PrimitiveType) {
                b.append(p.getName() + "=" + ((PrimitiveType)p.getValue()).asStringValue());
                continue;
            }
            if (p.hasValue() && p.getValue() instanceof Coding) {
                b.append("system=" + ((Coding)p.getValue()).getSystem());
                b.append("code=" + ((Coding)p.getValue()).getCode());
                b.append("display=" + ((Coding)p.getValue()).getDisplay());
                continue;
            }
            if (p.hasValue() && p.getValue() instanceof CodeableConcept) {
                if (((CodeableConcept)p.getValue()).hasCoding()) {
                    Coding c = ((CodeableConcept)p.getValue()).getCodingFirstRep();
                    b.append("system=" + c.getSystem());
                    b.append("code=" + c.getCode());
                    b.append("display=" + c.getDisplay());
                    continue;
                }
                if (!((CodeableConcept)p.getValue()).hasText()) continue;
                b.append("text=" + ((CodeableConcept)p.getValue()).getText());
                continue;
            }
            if (!p.hasResource() || !(p.getResource() instanceof ValueSet)) continue;
            b.append("valueset=" + this.getVSSummary((ValueSet)p.getResource()));
        }
        return b.toString();
    }

    private IWorkerContext.ValidationResult loadFromCache(String fn) throws FileNotFoundException, IOException {
        if (fn == null) {
            return null;
        }
        if (!ManagedFileAccess.file((String)fn).exists()) {
            return null;
        }
        String cnt = FileUtilities.fileToString((String)fn);
        if (cnt.startsWith("!error: ")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, cnt.substring(8));
        }
        if (cnt.startsWith("!warning: ")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, cnt.substring(10));
        }
        return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setDisplay(cnt));
    }

    private void saveToCache(IWorkerContext.ValidationResult res, String cacheName) throws IOException {
        if (cacheName == null) {
            return;
        }
        if (res.getDisplay() != null) {
            FileUtilities.stringToFile((String)res.getDisplay(), (String)cacheName);
        } else if (res.getMessage() != null) {
            if (res.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                FileUtilities.stringToFile((String)("!warning: " + res.getMessage()), (String)cacheName);
            } else {
                FileUtilities.stringToFile((String)("!error: " + res.getMessage()), (String)cacheName);
            }
        }
    }

    private String generateCacheName(Parameters pin) throws IOException {
        if (this.cache == null) {
            return null;
        }
        String json = new JsonParser().composeString(pin);
        return Utilities.path((String[])new String[]{this.cache, "vc" + Integer.toString(json.hashCode()) + ".json"});
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent inc, boolean heirachical) throws TerminologyServiceException {
        ValueSet vs = new ValueSet();
        vs.setCompose(new ValueSet.ValueSetComposeComponent());
        vs.getCompose().getInclude().add(inc);
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true, heirachical);
        ValueSet valueset = vse.getValueset();
        if (valueset == null) {
            throw new TerminologyServiceException("Error Expanding ValueSet: " + vse.getError());
        }
        return valueset.getExpansion();
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display) {
        try {
            if (this.codeSystems.containsKey(system) && this.codeSystems.get(system) != null) {
                return this.verifyCodeInCodeSystem(this.codeSystems.get(system), system, code, display);
            }
            return this.verifyCodeExternal(null, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(Coding code, ValueSet vs) {
        if (this.codeSystems.containsKey(code.getSystem()) && this.codeSystems.get(code.getSystem()) != null) {
            try {
                return this.verifyCodeInCodeSystem(this.codeSystems.get(code.getSystem()), code.getSystem(), code.getCode(), code.getDisplay());
            }
            catch (Exception e) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + String.valueOf(code) + "\" in system \"" + code.getSystem() + "\": " + e.getMessage());
            }
        }
        if (vs.hasExpansion()) {
            try {
                return this.verifyCodeInternal(vs, code.getSystem(), code.getCode(), code.getDisplay());
            }
            catch (Exception e) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + String.valueOf(code) + "\" in system \"" + code.getSystem() + "\": " + e.getMessage());
            }
        }
        try {
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Error validating code \"" + String.valueOf(code) + "\" in system \"" + code.getSystem() + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(CodeableConcept code, ValueSet vs) {
        try {
            if (vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, code);
            }
            try {
                ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true, false);
                if (vse.getValueset() != null && !this.hasTooCostlyExpansion(vse.getValueset())) {
                    return this.verifyCodeInternal(vse.getValueset(), code);
                }
            }
            catch (Exception vse) {
                // empty catch block
            }
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code.toString() + "\": " + e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.SERVER_ERROR);
        }
    }

    private boolean hasTooCostlyExpansion(ValueSet valueset) {
        return valueset != null && valueset.hasExpansion() && ToolingExtensions.hasExtension(valueset.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet vs) {
        try {
            if (system == null && display == null) {
                return this.verifyCodeInternal(vs, code);
            }
            if (this.codeSystems.containsKey(system) && this.codeSystems.get(system) != null || vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, system, code, display);
            }
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.SERVER_ERROR);
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
        try {
            ValueSet vs = new ValueSet();
            vs.setUrl(UUIDUtilities.makeUuidUrn());
            vs.getCompose().addInclude(vsi);
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    public void initTS(String cachePath, String tsServer) throws Exception {
        this.cache = cachePath;
        this.tsServer = tsServer;
        this.expansionCache = new ValueSetExpansionCache(this, null);
        this.validationCachePath = Utilities.path((String[])new String[]{cachePath, "validation.cache"});
        try {
            this.loadValidationCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadValidationCache() throws JsonSyntaxException, Exception {
    }

    @Override
    public List<ConceptMap> findMapsForSource(String url) {
        ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
        for (ConceptMap map : this.maps.values()) {
            if (!((Reference)map.getSource()).getReference().equals(url)) continue;
            res.add(map);
        }
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, CodeableConcept code) throws Exception {
        for (Coding c : code.getCoding()) {
            IWorkerContext.ValidationResult res = this.verifyCodeInternal(vs, c.getSystem(), c.getCode(), c.getDisplay());
            if (!res.isOk()) continue;
            return res;
        }
        if (code.getCoding().isEmpty()) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "None code provided");
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "None of the codes are in the specified value set");
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, String system, String code, String display) throws Exception {
        if (vs.hasExpansion()) {
            return this.verifyCodeInExpansion(vs, system, code, display);
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs, null);
        if (vse.getValueset() != null) {
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        return this.verifyCodeInExpansion(vse.getValueset(), system, code, display);
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, String code) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException, FHIRException {
        if (vs.hasExpansion()) {
            return this.verifyCodeInExpansion(vs, code);
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs, null);
        if (vse.getValueset() == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, vse.getError(), vse.getErrorClass());
        }
        return this.verifyCodeInExpansion(vse.getValueset(), code);
    }

    private IWorkerContext.ValidationResult verifyCodeInCodeSystem(CodeSystem cs, String system, String code, String display) throws Exception {
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
        if (cc == null) {
            if (cs.getContent().equals((Object)CodeSystem.CodeSystemContentMode.COMPLETE)) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + cs.getUrl());
            }
            if (!cs.getContent().equals((Object)CodeSystem.CodeSystemContentMode.NOTPRESENT)) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Unknown Code " + code + " in partial code list of " + cs.getUrl());
            }
            return this.verifyCodeExternal(null, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!display.equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Display Name for " + code + " must be one of '" + b.toString() + "'", cc);
    }

    private IWorkerContext.ValidationResult verifyCodeInExpansion(ValueSet vs, String system, String code, String display) {
        ValueSet.ValueSetExpansionContainsComponent cc = this.findCode(vs.getExpansion().getContains(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getUrl());
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
        }
        if (cc.hasDisplay()) {
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Display Name for " + code + " must be '" + cc.getDisplay() + "'", new CodeSystem.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
        }
        return null;
    }

    private IWorkerContext.ValidationResult verifyCodeInExpansion(ValueSet vs, String code) throws FHIRException {
        if (vs.getExpansion().hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            throw new FHIRException("Unable to validate core - value set is too costly to expand");
        }
        ValueSet.ValueSetExpansionContainsComponent cc = this.findCode(vs.getExpansion().getContains(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getUrl());
        }
        return null;
    }

    private ValueSet.ValueSetExpansionContainsComponent findCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            ValueSet.ValueSetExpansionContainsComponent c = this.findCode(cc.getContains(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc.getConcept(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Set<String> getNonSupportedCodeSystems() {
        return this.nonSupportedCodeSystems;
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    @Override
    @Deprecated
    public void setLogger(IWorkerContext.ILoggingService logger) {
    }

    @Override
    public ExpansionProfile getExpansionProfile() {
        return this.expProfile;
    }

    @Override
    public void setExpansionProfile(ExpansionProfile expProfile) {
        this.expProfile = expProfile;
    }

    @Override
    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public void reportStatus(JsonObject json) {
        json.addProperty("codeystem-count", (Number)this.codeSystems.size());
        json.addProperty("valueset-count", (Number)this.valueSets.size());
        json.addProperty("conceptmap-count", (Number)this.maps.size());
        json.addProperty("transforms-count", (Number)this.transforms.size());
        json.addProperty("structures-count", (Number)this.profiles.size());
    }

    public void cacheResource(Resource r) throws Exception {
        if (r instanceof ValueSet) {
            this.seeValueSet(((ValueSet)r).getUrl(), (ValueSet)r);
        } else if (r instanceof CodeSystem) {
            this.seeCodeSystem(((CodeSystem)r).getUrl(), (CodeSystem)r);
        } else if (r instanceof StructureDefinition) {
            StructureDefinition sd = (StructureDefinition)r;
            if ("http://hl7.org/fhir/StructureDefinition/Extension".equals(sd.getBaseDefinition())) {
                this.seeExtensionDefinition(sd.getUrl(), sd);
            } else if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                this.seeProfile(sd.getUrl(), sd);
            }
        }
    }

    public void dropResource(String type, String id) throws FHIRException {
        if (type.equals("ValueSet")) {
            this.dropValueSet(id);
        }
        if (type.equals("CodeSystem")) {
            this.dropCodeSystem(id);
        }
        if (type.equals("StructureDefinition")) {
            this.dropProfile(id);
            this.dropExtensionDefinition(id);
        }
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        return (StructureDefinition)this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }
}

