/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.fhirpath;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.UcumException;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.fhirpath.ExpressionNode;
import org.hl7.fhir.dstu3.fhirpath.FHIRLexer;
import org.hl7.fhir.dstu3.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.dstu3.fhirpath.TypeDetails;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.utilities.Utilities;

public class FHIRPathEngine {
    private IWorkerContext worker;
    private IEvaluationContext hostServices;
    private StringBuilder log = new StringBuilder();
    private Set<String> primitiveTypes = new HashSet<String>();
    private Map<String, StructureDefinition> allTypes = new HashMap<String, StructureDefinition>();

    public FHIRPathEngine(IWorkerContext worker) {
        this.worker = worker;
        for (StructureDefinition sd : worker.allStructures()) {
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
                this.allTypes.put(sd.getName(), sd);
            }
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
            this.primitiveTypes.add(sd.getName());
        }
    }

    public IEvaluationContext getHostServices() {
        return this.hostServices;
    }

    public void setHostServices(IEvaluationContext constantResolver) {
        this.hostServices = constantResolver;
    }

    protected void getChildrenByName(Base item, String name, List<Base> result) throws FHIRException {
        Base[] list = item.listChildrenByName(name, false);
        if (list != null) {
            for (Base v : list) {
                if (v == null) continue;
                result.add(v);
            }
        }
    }

    public ExpressionNode parse(String path) throws FHIRLexer.FHIRLexerException {
        FHIRLexer lexer = new FHIRLexer(path);
        if (lexer.done()) {
            throw lexer.error("Path cannot be empty");
        }
        ExpressionNode result = this.parseExpression(lexer, true);
        if (!lexer.done()) {
            throw lexer.error("Premature ExpressionNode termination at unexpected token \"" + lexer.getCurrent() + "\"");
        }
        result.check();
        return result;
    }

    public ExpressionNode parse(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        ExpressionNode result = this.parseExpression(lexer, true);
        result.check();
        return result;
    }

    public TypeDetails check(Object appContext, String resourceType, String context, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types;
        if (context == null) {
            types = null;
        } else if (!context.contains(".")) {
            StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, context);
            types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl());
        } else {
            StructureDefinition sd;
            Object ctxt = context.substring(0, context.indexOf(46));
            if (Utilities.isAbsoluteUrl((String)resourceType)) {
                ctxt = resourceType.substring(0, resourceType.lastIndexOf("/") + 1) + (String)ctxt;
            }
            if ((sd = this.worker.fetchResource(StructureDefinition.class, (String)ctxt)) == null) {
                throw new PathEngineException("Unknown context " + context);
            }
            ElementDefinitionMatch ed = this.getElementDefinition(sd, context, true);
            if (ed == null) {
                throw new PathEngineException("Unknown context element " + context);
            }
            if (ed.fixedType != null) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ed.fixedType);
            } else if (ed.getDefinition().getType().isEmpty() || this.isAbstractType(ed.getDefinition().getType())) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, (String)ctxt + "#" + context);
            } else {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                    types.addType(t.getCode());
                }
            }
        }
        return this.executeType(new FHIRPathUtilityClasses.ExecutionTypeContext(appContext, resourceType, context, types), types, expr, true);
    }

    public TypeDetails check(Object appContext, StructureDefinition sd, String context, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types;
        if (!context.contains(".")) {
            types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl());
        } else {
            ElementDefinitionMatch ed = this.getElementDefinition(sd, context, true);
            if (ed == null) {
                throw new PathEngineException("Unknown context element " + context);
            }
            if (ed.fixedType != null) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ed.fixedType);
            } else if (ed.getDefinition().getType().isEmpty() || this.isAbstractType(ed.getDefinition().getType())) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl() + "#" + context);
            } else {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                    types.addType(t.getCode());
                }
            }
        }
        return this.executeType(new FHIRPathUtilityClasses.ExecutionTypeContext(appContext, sd.getUrl(), context, types), types, expr, true);
    }

    public TypeDetails check(Object appContext, StructureDefinition sd, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types = null;
        return this.executeType(new FHIRPathUtilityClasses.ExecutionTypeContext(appContext, sd == null ? null : sd.getUrl(), null, types), types, expr, true);
    }

    public TypeDetails check(Object appContext, String resourceType, String context, String expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        return this.check(appContext, resourceType, context, this.parse(expr));
    }

    public List<Base> evaluate(Base base, ExpressionNode ExpressionNode2) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new FHIRPathUtilityClasses.ExecutionContext(null, base != null && base.isResource() ? base : null, base, null, base), list, ExpressionNode2, true);
    }

    public List<Base> evaluate(Base base, String path) throws FHIRException {
        ExpressionNode exp = this.parse(path);
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new FHIRPathUtilityClasses.ExecutionContext(null, base.isResource() ? base : null, base, null, base), list, exp, true);
    }

    public List<Base> evaluate(Object appContext, Resource resource, Base base, ExpressionNode ExpressionNode2) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new FHIRPathUtilityClasses.ExecutionContext(appContext, resource, base, null, base), list, ExpressionNode2, true);
    }

    public List<Base> evaluate(Object appContext, Base resource, Base base, ExpressionNode ExpressionNode2) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new FHIRPathUtilityClasses.ExecutionContext(appContext, resource, base, null, base), list, ExpressionNode2, true);
    }

    public List<Base> evaluate(Object appContext, Resource resource, Base base, String path) throws FHIRException {
        ExpressionNode exp = this.parse(path);
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new FHIRPathUtilityClasses.ExecutionContext(appContext, resource, base, null, base), list, exp, true);
    }

    public boolean evaluateToBoolean(Resource resource, Base base, String path) throws FHIRException {
        return this.convertToBoolean(this.evaluate(null, resource, base, path));
    }

    public boolean evaluateToBoolean(Resource resource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(null, resource, base, node));
    }

    public boolean evaluateToBoolean(Object appInfo, Resource resource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(appInfo, resource, base, node));
    }

    public boolean evaluateToBoolean(Base resource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(null, resource, base, node));
    }

    public String evaluateToString(Base base, String path) throws FHIRException {
        return this.convertToString(this.evaluate(base, path));
    }

    public String evaluateToString(Object appInfo, Base resource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToString(this.evaluate(appInfo, resource, base, node));
    }

    public String convertToString(List<Base> items) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Base item : items) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(this.convertToString(item));
        }
        return b.toString();
    }

    private String convertToString(Base item) {
        if (item.isPrimitive()) {
            return item.primitiveValue();
        }
        return item.toString();
    }

    public boolean convertToBoolean(List<Base> items) {
        if (items == null) {
            return false;
        }
        if (items.size() == 1 && items.get(0) instanceof BooleanType) {
            return (Boolean)((BooleanType)items.get(0)).getValue();
        }
        return items.size() > 0;
    }

    private void log(String name, List<Base> contents) {
        if (this.hostServices == null || !this.hostServices.log(name, contents)) {
            if (this.log.length() > 0) {
                this.log.append("; ");
            }
            this.log.append(name);
            this.log.append(": ");
            boolean first = true;
            for (Base b : contents) {
                if (first) {
                    first = false;
                } else {
                    this.log.append(",");
                }
                this.log.append(this.convertToString(b));
            }
        }
    }

    public String forLog() {
        if (this.log.length() > 0) {
            return " (" + this.log.toString() + ")";
        }
        return "";
    }

    private ExpressionNode parseExpression(FHIRLexer lexer, boolean proximal) throws FHIRLexer.FHIRLexerException {
        ExpressionNode result = new ExpressionNode(lexer.nextId());
        ExpressionNode.SourceLocation c = lexer.getCurrentStartLocation();
        result.setStart(lexer.getCurrentLocation().copy());
        if (lexer.getCurrent().equals("-")) {
            lexer.take();
            lexer.setCurrent("-" + lexer.getCurrent());
        }
        if (lexer.getCurrent().equals("+")) {
            lexer.take();
            lexer.setCurrent("+" + lexer.getCurrent());
        }
        if (lexer.isConstant(false)) {
            this.checkConstant(lexer.getCurrent(), lexer);
            result.setConstant(lexer.take());
            result.setKind(ExpressionNode.Kind.Constant);
            result.setEnd(lexer.getCurrentLocation().copy());
        } else if ("(".equals(lexer.getCurrent())) {
            lexer.next();
            result.setKind(ExpressionNode.Kind.Group);
            result.setGroup(this.parseExpression(lexer, true));
            if (!")".equals(lexer.getCurrent())) {
                throw lexer.error("Found " + lexer.getCurrent() + " expecting a \")\"");
            }
            result.setEnd(lexer.getCurrentLocation().copy());
            lexer.next();
        } else {
            if (!lexer.isToken() && !lexer.getCurrent().startsWith("\"")) {
                throw lexer.error("Found " + lexer.getCurrent() + " expecting a token name");
            }
            if (lexer.getCurrent().startsWith("\"")) {
                result.setName(lexer.readConstant("Path Name"));
            } else {
                result.setName(lexer.take());
            }
            result.setEnd(lexer.getCurrentLocation().copy());
            if (!result.checkName()) {
                throw lexer.error("Found " + result.getName() + " expecting a valid token name");
            }
            if ("(".equals(lexer.getCurrent())) {
                ExpressionNode.Function f = ExpressionNode.Function.fromCode(result.getName());
                FHIRPathUtilityClasses.FunctionDetails details = null;
                if (f == null) {
                    if (this.hostServices != null) {
                        details = this.hostServices.resolveFunction(result.getName());
                    }
                    if (details == null) {
                        throw lexer.error("The name " + result.getName() + " is not a valid function name");
                    }
                    f = ExpressionNode.Function.Custom;
                }
                result.setKind(ExpressionNode.Kind.Function);
                result.setFunction(f);
                lexer.next();
                while (!")".equals(lexer.getCurrent())) {
                    result.getParameters().add(this.parseExpression(lexer, true));
                    if (",".equals(lexer.getCurrent())) {
                        lexer.next();
                        continue;
                    }
                    if (")".equals(lexer.getCurrent())) continue;
                    throw lexer.error("The token " + lexer.getCurrent() + " is not expected here - either a \",\" or a \")\" expected");
                }
                result.setEnd(lexer.getCurrentLocation().copy());
                lexer.next();
                this.checkParameters(lexer, c, result, details);
            } else {
                result.setKind(ExpressionNode.Kind.Name);
            }
        }
        ExpressionNode focus = result;
        if ("[".equals(lexer.getCurrent())) {
            lexer.next();
            ExpressionNode item = new ExpressionNode(lexer.nextId());
            item.setKind(ExpressionNode.Kind.Function);
            item.setFunction(ExpressionNode.Function.Item);
            item.getParameters().add(this.parseExpression(lexer, true));
            if (!lexer.getCurrent().equals("]")) {
                throw lexer.error("The token " + lexer.getCurrent() + " is not expected here - a \"]\" expected");
            }
            lexer.next();
            result.setInner(item);
            focus = item;
        }
        if (".".equals(lexer.getCurrent())) {
            lexer.next();
            focus.setInner(this.parseExpression(lexer, false));
        }
        result.setProximal(proximal);
        if (proximal) {
            while (lexer.isOp()) {
                focus.setOperation(ExpressionNode.Operation.fromCode(lexer.getCurrent()));
                focus.setOpStart(lexer.getCurrentStartLocation());
                focus.setOpEnd(lexer.getCurrentLocation());
                lexer.next();
                focus.setOpNext(this.parseExpression(lexer, false));
                focus = focus.getOpNext();
            }
            result = this.organisePrecedence(lexer, result);
        }
        return result;
    }

    private ExpressionNode organisePrecedence(FHIRLexer lexer, ExpressionNode node) {
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Times, ExpressionNode.Operation.DivideBy, ExpressionNode.Operation.Div, ExpressionNode.Operation.Mod));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Plus, ExpressionNode.Operation.Minus, ExpressionNode.Operation.Concatenate));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Union));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.LessThen, ExpressionNode.Operation.Greater, ExpressionNode.Operation.LessOrEqual, ExpressionNode.Operation.GreaterOrEqual));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Is, ExpressionNode.Operation.As));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Equals, ExpressionNode.Operation.Equivalent, ExpressionNode.Operation.NotEquals, ExpressionNode.Operation.NotEquivalent));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.In, ExpressionNode.Operation.Contains));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.And));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Xor, ExpressionNode.Operation.Or));
        return node;
    }

    private ExpressionNode gatherPrecedence(FHIRLexer lexer, ExpressionNode start, EnumSet<ExpressionNode.Operation> ops) {
        ExpressionNode node;
        ExpressionNode group;
        ExpressionNode focus;
        assert (start.isProximal());
        boolean work = false;
        if (ops.contains((Object)start.getOperation())) {
            for (focus = start.getOpNext(); focus != null && focus.getOperation() != null; focus = focus.getOpNext()) {
                work = work || !ops.contains((Object)focus.getOperation());
            }
        } else {
            while (focus != null && focus.getOperation() != null) {
                work = work || ops.contains((Object)focus.getOperation());
                focus = focus.getOpNext();
            }
        }
        if (!work) {
            return start;
        }
        if (ops.contains((Object)start.getOperation())) {
            group = this.newGroup(lexer, start);
            group.setProximal(true);
            focus = start;
            start = group;
        } else {
            node = start;
            focus = node.getOpNext();
            while (!ops.contains((Object)focus.getOperation())) {
                node = focus;
                focus = focus.getOpNext();
            }
            group = this.newGroup(lexer, focus);
            node.setOpNext(group);
        }
        while (true) {
            if (ops.contains((Object)focus.getOperation())) {
                focus = focus.getOpNext();
                continue;
            }
            if (focus.getOperation() != null) {
                group.setOperation(focus.getOperation());
                group.setOpNext(focus.getOpNext());
                focus.setOperation(null);
                focus.setOpNext(null);
                node = group;
                if (focus != null) {
                    for (focus = group.getOpNext(); focus != null && !ops.contains((Object)focus.getOperation()); focus = focus.getOpNext()) {
                        node = focus;
                    }
                    if (focus != null) {
                        group = this.newGroup(lexer, focus);
                        node.setOpNext(group);
                    }
                }
            }
            if (focus == null || focus.getOperation() == null) break;
        }
        return start;
    }

    private ExpressionNode newGroup(FHIRLexer lexer, ExpressionNode next) {
        ExpressionNode result = new ExpressionNode(lexer.nextId());
        result.setKind(ExpressionNode.Kind.Group);
        result.setGroup(next);
        result.getGroup().setProximal(true);
        return result;
    }

    private void checkConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (s.startsWith("'") && s.endsWith("'")) {
            int i = 1;
            block4: while (i < s.length() - 1) {
                char ch = s.charAt(i);
                if (ch == '\\') {
                    switch (ch) {
                        case '\'': 
                        case '/': 
                        case '\\': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            ++i;
                            continue block4;
                        }
                        case 'u': {
                            if (Utilities.isHex((String)("0x" + s.substring(i, i + 4)))) continue block4;
                            throw lexer.error("Improper unicode escape \\u" + s.substring(i, i + 4));
                        }
                    }
                    throw lexer.error("Unknown character escape \\" + ch);
                }
                ++i;
            }
        }
    }

    private boolean checkParamCount(FHIRLexer lexer, ExpressionNode.SourceLocation location, ExpressionNode exp, int count) throws FHIRLexer.FHIRLexerException {
        if (exp.getParameters().size() != count) {
            throw lexer.error("The function \"" + exp.getName() + "\" requires " + Integer.toString(count) + " parameters", location.toString());
        }
        return true;
    }

    private boolean checkParamCount(FHIRLexer lexer, ExpressionNode.SourceLocation location, ExpressionNode exp, int countMin, int countMax) throws FHIRLexer.FHIRLexerException {
        if (exp.getParameters().size() < countMin || exp.getParameters().size() > countMax) {
            throw lexer.error("The function \"" + exp.getName() + "\" requires between " + Integer.toString(countMin) + " and " + Integer.toString(countMax) + " parameters", location.toString());
        }
        return true;
    }

    private boolean checkParameters(FHIRLexer lexer, ExpressionNode.SourceLocation location, ExpressionNode exp, FHIRPathUtilityClasses.FunctionDetails details) throws FHIRLexer.FHIRLexerException {
        switch (exp.getFunction()) {
            case Empty: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Not: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Exists: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case SubsetOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case SupersetOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case IsDistinct: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Distinct: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Count: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Where: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Select: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case All: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case Repeat: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Item: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case As: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Is: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Single: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case First: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Last: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Tail: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Skip: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Take: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Iif: {
                return this.checkParamCount(lexer, location, exp, 2, 3);
            }
            case ToInteger: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToDecimal: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToString: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Substring: {
                return this.checkParamCount(lexer, location, exp, 1, 2);
            }
            case StartsWith: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case EndsWith: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Matches: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case ReplaceMatches: {
                return this.checkParamCount(lexer, location, exp, 2);
            }
            case Contains: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Replace: {
                return this.checkParamCount(lexer, location, exp, 2);
            }
            case Length: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Children: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Descendants: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case MemberOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Trace: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Today: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Now: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Resolve: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Extension: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case HasValue: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Alias: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case AliasAs: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Custom: {
                return this.checkParamCount(lexer, location, exp, details.getMinParameters(), details.getMaxParameters());
            }
        }
        return false;
    }

    private List<Base> execute(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp, boolean atEntry) throws FHIRException {
        List<Base> work = new ArrayList<Base>();
        switch (exp.getKind()) {
            case Name: {
                if (atEntry && exp.getName().equals("$this")) {
                    work.add(context.getThisItem());
                    break;
                }
                for (Base item : focus) {
                    List<Base> outcome = this.execute(context, item, exp, atEntry);
                    for (Base base : outcome) {
                        if (base == null) continue;
                        work.add(base);
                    }
                }
                break;
            }
            case Function: {
                List<Base> work2 = this.evaluateFunction(context, focus, exp);
                work.addAll(work2);
                break;
            }
            case Constant: {
                Base b = this.processConstant(context, exp.getConstant());
                if (b == null) break;
                work.add(b);
                break;
            }
            case Group: {
                List<Base> work2 = this.execute(context, focus, exp.getGroup(), atEntry);
                work.addAll(work2);
            }
        }
        if (exp.getInner() != null) {
            work = this.execute(context, work, exp.getInner(), false);
        }
        if (exp.isProximal() && exp.getOperation() != null) {
            ExpressionNode last = exp;
            for (ExpressionNode next = exp.getOpNext(); next != null; next = next.getOpNext()) {
                List<Base> work2 = this.preOperate(work, last.getOperation());
                if (work2 != null) {
                    work = work2;
                } else if (last.getOperation() == ExpressionNode.Operation.Is || last.getOperation() == ExpressionNode.Operation.As) {
                    work2 = this.executeTypeName(context, focus, next, false);
                    work = this.operate(work, last.getOperation(), work2);
                } else {
                    work2 = this.execute(context, focus, next, true);
                    work = this.operate(work, last.getOperation(), work2);
                }
                last = next;
            }
        }
        return work;
    }

    private List<Base> executeTypeName(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode next, boolean atEntry) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new StringType(next.getName()));
        return result;
    }

    private List<Base> preOperate(List<Base> left, ExpressionNode.Operation operation) {
        switch (operation) {
            case And: {
                return this.isBoolean(left, false) ? this.makeBoolean(false) : null;
            }
            case Or: {
                return this.isBoolean(left, true) ? this.makeBoolean(true) : null;
            }
            case Implies: {
                return this.convertToBoolean(left) ? null : this.makeBoolean(true);
            }
        }
        return null;
    }

    private List<Base> makeBoolean(boolean b) {
        ArrayList<Base> res = new ArrayList<Base>();
        res.add(new BooleanType(b));
        return res;
    }

    private TypeDetails executeTypeName(FHIRPathUtilityClasses.ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp, boolean atEntry) throws PathEngineException, DefinitionException {
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, exp.getName());
    }

    private TypeDetails executeType(FHIRPathUtilityClasses.ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp, boolean atEntry) throws PathEngineException, DefinitionException {
        TypeDetails result = new TypeDetails(null, new String[0]);
        switch (exp.getKind()) {
            case Name: {
                if (atEntry && exp.getName().equals("$this")) {
                    result.update(context.getThisItem());
                    break;
                }
                if (atEntry && focus == null) {
                    result.update(this.executeContextType(context, exp.getName()));
                    break;
                }
                for (String s : focus.getTypes()) {
                    result.update(this.executeType(s, exp, atEntry));
                }
                if (!result.hasNoTypes()) break;
                throw new PathEngineException("The name " + exp.getName() + " is not valid for any of the possible types: " + focus.describe());
            }
            case Function: {
                result.update(this.evaluateFunctionType(context, focus, exp));
                break;
            }
            case Constant: {
                result.update(this.readConstantType(context, exp.getConstant()));
                break;
            }
            case Group: {
                result.update(this.executeType(context, focus, exp.getGroup(), atEntry));
            }
        }
        exp.setTypes(result);
        if (exp.getInner() != null) {
            result = this.executeType(context, result, exp.getInner(), false);
        }
        if (exp.isProximal() && exp.getOperation() != null) {
            ExpressionNode last = exp;
            for (ExpressionNode next = exp.getOpNext(); next != null; next = next.getOpNext()) {
                TypeDetails work = last.getOperation() == ExpressionNode.Operation.Is || last.getOperation() == ExpressionNode.Operation.As ? this.executeTypeName(context, focus, next, atEntry) : this.executeType(context, focus, next, atEntry);
                result = this.operateTypes(result, last.getOperation(), work);
                last = next;
            }
            exp.setOpTypes(result);
        }
        return result;
    }

    private Base processConstant(FHIRPathUtilityClasses.ExecutionContext context, String constant) throws PathEngineException {
        if (constant.equals("true")) {
            return new BooleanType(true);
        }
        if (constant.equals("false")) {
            return new BooleanType(false);
        }
        if (constant.equals("{}")) {
            return null;
        }
        if (Utilities.isInteger((String)constant)) {
            return new IntegerType(constant);
        }
        if (Utilities.isDecimal((String)constant, (boolean)false)) {
            return new DecimalType(constant);
        }
        if (constant.startsWith("'")) {
            return new StringType(this.processConstantString(constant));
        }
        if (constant.startsWith("%")) {
            return this.resolveConstant(context, constant);
        }
        if (constant.startsWith("@")) {
            return this.processDateConstant(context.getAppInfo(), constant.substring(1));
        }
        return new StringType(constant);
    }

    private Base processDateConstant(Object appInfo, String value) throws PathEngineException {
        if (value.startsWith("T")) {
            return new TimeType(value.substring(1));
        }
        String v = value;
        if (v.length() > 10) {
            int i = v.substring(10).indexOf("-");
            if (i == -1) {
                i = v.substring(10).indexOf("+");
            }
            if (i == -1) {
                i = v.substring(10).indexOf("Z");
            }
            String string = v = i == -1 ? value : v.substring(0, 10 + i);
        }
        if (v.length() > 10) {
            return new DateTimeType(value);
        }
        return new DateType(value);
    }

    private Base resolveConstant(FHIRPathUtilityClasses.ExecutionContext context, String s) throws PathEngineException {
        if (s.equals("%sct")) {
            return new StringType("http://snomed.info/sct");
        }
        if (s.equals("%loinc")) {
            return new StringType("http://loinc.org");
        }
        if (s.equals("%ucum")) {
            return new StringType("http://unitsofmeasure.org");
        }
        if (s.equals("%resource")) {
            if (context.getResource() == null) {
                throw new PathEngineException("Cannot use %resource in this context");
            }
            return context.getResource();
        }
        if (s.equals("%context")) {
            return context.getContext();
        }
        if (s.equals("%us-zip")) {
            return new StringType("[0-9]{5}(-[0-9]{4}){0,1}");
        }
        if (s.startsWith("%\"vs-")) {
            return new StringType("http://hl7.org/fhir/ValueSet/" + s.substring(5, s.length() - 1));
        }
        if (s.startsWith("%\"cs-")) {
            return new StringType("http://hl7.org/fhir/" + s.substring(5, s.length() - 1));
        }
        if (s.startsWith("%\"ext-")) {
            return new StringType("http://hl7.org/fhir/StructureDefinition/" + s.substring(6, s.length() - 1));
        }
        if (this.hostServices == null) {
            throw new PathEngineException("Unknown fixed constant '" + s + "'");
        }
        return this.hostServices.resolveConstant(context.getAppInfo(), s.substring(1));
    }

    private String processConstantString(String s) throws PathEngineException {
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < s.length() - 1) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                switch (s.charAt(++i)) {
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case '\'': {
                        b.append('\'');
                        break;
                    }
                    case '\\': {
                        b.append('\\');
                        break;
                    }
                    case '/': {
                        b.append('/');
                        break;
                    }
                    case 'u': {
                        int uc = Integer.parseInt(s.substring(++i, i + 4), 16);
                        b.append((char)uc);
                        i += 3;
                        break;
                    }
                    default: {
                        throw new PathEngineException("Unknown character escape \\" + s.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    private List<Base> operate(List<Base> left, ExpressionNode.Operation operation, List<Base> right) throws FHIRException {
        switch (operation) {
            case Equals: {
                return this.opEquals(left, right);
            }
            case Equivalent: {
                return this.opEquivalent(left, right);
            }
            case NotEquals: {
                return this.opNotEquals(left, right);
            }
            case NotEquivalent: {
                return this.opNotEquivalent(left, right);
            }
            case LessThen: {
                return this.opLessThen(left, right);
            }
            case Greater: {
                return this.opGreater(left, right);
            }
            case LessOrEqual: {
                return this.opLessOrEqual(left, right);
            }
            case GreaterOrEqual: {
                return this.opGreaterOrEqual(left, right);
            }
            case Union: {
                return this.opUnion(left, right);
            }
            case In: {
                return this.opIn(left, right);
            }
            case Contains: {
                return this.opContains(left, right);
            }
            case Or: {
                return this.opOr(left, right);
            }
            case And: {
                return this.opAnd(left, right);
            }
            case Xor: {
                return this.opXor(left, right);
            }
            case Implies: {
                return this.opImplies(left, right);
            }
            case Plus: {
                return this.opPlus(left, right);
            }
            case Times: {
                return this.opTimes(left, right);
            }
            case Minus: {
                return this.opMinus(left, right);
            }
            case Concatenate: {
                return this.opConcatenate(left, right);
            }
            case DivideBy: {
                return this.opDivideBy(left, right);
            }
            case Div: {
                return this.opDiv(left, right);
            }
            case Mod: {
                return this.opMod(left, right);
            }
            case Is: {
                return this.opIs(left, right);
            }
            case As: {
                return this.opAs(left, right);
            }
        }
        throw new Error("Not Done Yet: " + operation.toCode());
    }

    private List<Base> opAs(List<Base> left, List<Base> right) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (left.size() != 1 || right.size() != 1) {
            return result;
        }
        String tn = this.convertToString(right);
        if (tn.equals(left.get(0).fhirType())) {
            result.add(left.get(0));
        }
        return result;
    }

    private List<Base> opIs(List<Base> left, List<Base> right) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (left.size() != 1 || right.size() != 1) {
            result.add(new BooleanType(false));
        } else {
            String tn = this.convertToString(right);
            result.add(new BooleanType(left.get(0).hasType(tn)));
        }
        return result;
    }

    private TypeDetails operateTypes(TypeDetails left, ExpressionNode.Operation operation, TypeDetails right) {
        switch (operation) {
            case Equals: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Equivalent: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case NotEquals: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case NotEquivalent: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case LessThen: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Greater: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case LessOrEqual: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case GreaterOrEqual: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Is: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case As: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, right.getTypes());
            }
            case Union: {
                return left.union(right);
            }
            case Or: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case And: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Xor: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Implies: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Times: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("decimal");
                }
                return result;
            }
            case DivideBy: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("decimal");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("decimal");
                }
                return result;
            }
            case Concatenate: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "");
                return result;
            }
            case Plus: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("decimal");
                } else if (left.hasType(this.worker, "string", "id", "code", "uri") && right.hasType(this.worker, "string", "id", "code", "uri")) {
                    result.addType("string");
                }
                return result;
            }
            case Minus: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("decimal");
                }
                return result;
            }
            case Div: 
            case Mod: {
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("decimal");
                }
                return result;
            }
            case In: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Contains: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
        }
        return null;
    }

    private List<Base> opEquals(List<Base> left, List<Base> right) {
        if (left.size() != right.size()) {
            return this.makeBoolean(false);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            if (this.doEquals(left.get(i), right.get(i))) continue;
            res = false;
            break;
        }
        return this.makeBoolean(res);
    }

    private List<Base> opNotEquals(List<Base> left, List<Base> right) {
        if (left.size() != right.size()) {
            return this.makeBoolean(true);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            if (this.doEquals(left.get(i), right.get(i))) continue;
            res = false;
            break;
        }
        return this.makeBoolean(!res);
    }

    private boolean doEquals(Base left, Base right) {
        if (left.isPrimitive() && right.isPrimitive()) {
            return Base.equals(left.primitiveValue(), right.primitiveValue());
        }
        return Base.compareDeep(left, right, false);
    }

    private boolean doEquivalent(Base left, Base right) throws PathEngineException {
        if (left.hasType("integer") && right.hasType("integer")) {
            return this.doEquals(left, right);
        }
        if (left.hasType("boolean") && right.hasType("boolean")) {
            return this.doEquals(left, right);
        }
        if (left.hasType("integer", "decimal", "unsignedInt", "positiveInt") && right.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            return Utilities.equivalentNumber((String)left.primitiveValue(), (String)right.primitiveValue());
        }
        if (left.hasType("date", "dateTime", "time", "instant") && right.hasType("date", "dateTime", "time", "instant")) {
            return Utilities.equivalentNumber((String)left.primitiveValue(), (String)right.primitiveValue());
        }
        if (left.hasType("string", "id", "code", "uri") && right.hasType("string", "id", "code", "uri")) {
            return Utilities.equivalent((String)this.convertToString(left), (String)this.convertToString(right));
        }
        throw new PathEngineException(String.format("Unable to determine equivalence between %s and %s", left.fhirType(), right.fhirType()));
    }

    private List<Base> opEquivalent(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() != right.size()) {
            return this.makeBoolean(false);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < right.size(); ++j) {
                if (!this.doEquivalent(left.get(i), right.get(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            res = false;
            break;
        }
        return this.makeBoolean(res);
    }

    private List<Base> opNotEquivalent(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() != right.size()) {
            return this.makeBoolean(true);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < right.size(); ++j) {
                if (!this.doEquivalent(left.get(i), right.get(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            res = false;
            break;
        }
        return this.makeBoolean(!res);
    }

    private List<Base> opLessThen(List<Base> left, List<Base> right) throws FHIRException {
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType("string") && r.hasType("string")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) < 0);
            }
            if ((l.hasType("integer") || l.hasType("decimal")) && (r.hasType("integer") || r.hasType("decimal"))) {
                return this.makeBoolean(new Double(l.primitiveValue()) < new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) < 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) < 0);
            }
        } else if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("unit");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("unit"), true)) {
                return this.opLessThen(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"));
            }
            throw new InternalErrorException("Canonical Comparison isn't done yet");
        }
        return new ArrayList<Base>();
    }

    private List<Base> opGreater(List<Base> left, List<Base> right) throws FHIRException {
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType("string") && r.hasType("string")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) > 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) > new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) > 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) > 0);
            }
        } else if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("unit");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("unit"), true)) {
                return this.opGreater(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"));
            }
            throw new InternalErrorException("Canonical Comparison isn't done yet");
        }
        return new ArrayList<Base>();
    }

    private List<Base> opLessOrEqual(List<Base> left, List<Base> right) throws FHIRException {
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType("string") && r.hasType("string")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) <= 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) <= new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) <= 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) <= 0);
            }
        } else if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            String runit;
            List<Base> lUnits = left.get(0).listChildrenByName("unit");
            String lunit = lUnits.size() == 1 ? lUnits.get(0).primitiveValue() : null;
            List<Base> rUnits = right.get(0).listChildrenByName("unit");
            String string = runit = rUnits.size() == 1 ? rUnits.get(0).primitiveValue() : null;
            if (lunit == null && runit == null || lunit.equals(runit)) {
                return this.opLessOrEqual(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"));
            }
            throw new InternalErrorException("Canonical Comparison isn't done yet");
        }
        return new ArrayList<Base>();
    }

    private List<Base> opGreaterOrEqual(List<Base> left, List<Base> right) throws FHIRException {
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType("string") && r.hasType("string")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) >= 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) >= new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) >= 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) >= 0);
            }
        } else if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("unit");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("unit"), true)) {
                return this.opGreaterOrEqual(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"));
            }
            throw new InternalErrorException("Canonical Comparison isn't done yet");
        }
        return new ArrayList<Base>();
    }

    private List<Base> opIn(List<Base> left, List<Base> right) {
        boolean ans = true;
        for (Base l : left) {
            boolean f = false;
            for (Base r : right) {
                if (!this.doEquals(l, r)) continue;
                f = true;
                break;
            }
            if (f) continue;
            ans = false;
            break;
        }
        return this.makeBoolean(ans);
    }

    private List<Base> opContains(List<Base> left, List<Base> right) {
        boolean ans = true;
        for (Base r : right) {
            boolean f = false;
            for (Base l : left) {
                if (!this.doEquals(l, r)) continue;
                f = true;
                break;
            }
            if (f) continue;
            ans = false;
            break;
        }
        return this.makeBoolean(ans);
    }

    private List<Base> opPlus(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing +: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing +: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing +: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing +: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing +: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing +: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("string", "id", "code", "uri") && r.hasType("string", "id", "code", "uri")) {
            result.add(new StringType(l.primitiveValue() + r.primitiveValue()));
        } else if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) + Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).add(new BigDecimal(r.primitiveValue()))));
        } else {
            throw new PathEngineException(String.format("Error performing +: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private List<Base> opTimes(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing *: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing *: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing +: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing *: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing *: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing *: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) * Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).multiply(new BigDecimal(r.primitiveValue()))));
        } else {
            throw new PathEngineException(String.format("Error performing *: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private List<Base> opConcatenate(List<Base> left, List<Base> right) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new StringType(this.convertToString(left) + this.convertToString(right)));
        return result;
    }

    private List<Base> opUnion(List<Base> left, List<Base> right) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : left) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        for (Base item : right) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        return result;
    }

    private boolean doContains(List<Base> list, Base item) {
        for (Base test : list) {
            if (!this.doEquals(test, item)) continue;
            return true;
        }
        return false;
    }

    private List<Base> opAnd(List<Base> left, List<Base> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return new ArrayList<Base>();
        }
        if (this.isBoolean(left, false) || this.isBoolean(right, false)) {
            return this.makeBoolean(false);
        }
        if (left.isEmpty() || right.isEmpty()) {
            return new ArrayList<Base>();
        }
        if (this.convertToBoolean(left) && this.convertToBoolean(right)) {
            return this.makeBoolean(true);
        }
        return this.makeBoolean(false);
    }

    private boolean isBoolean(List<Base> list, boolean b) {
        return list.size() == 1 && list.get(0) instanceof BooleanType && ((BooleanType)list.get(0)).booleanValue() == b;
    }

    private List<Base> opOr(List<Base> left, List<Base> right) {
        if (left.isEmpty() && right.isEmpty()) {
            return new ArrayList<Base>();
        }
        if (this.convertToBoolean(left) || this.convertToBoolean(right)) {
            return this.makeBoolean(true);
        }
        if (left.isEmpty() || right.isEmpty()) {
            return new ArrayList<Base>();
        }
        return this.makeBoolean(false);
    }

    private List<Base> opXor(List<Base> left, List<Base> right) {
        if (left.isEmpty() || right.isEmpty()) {
            return new ArrayList<Base>();
        }
        return this.makeBoolean(this.convertToBoolean(left) ^ this.convertToBoolean(right));
    }

    private List<Base> opImplies(List<Base> left, List<Base> right) {
        if (!this.convertToBoolean(left)) {
            return this.makeBoolean(true);
        }
        if (right.size() == 0) {
            return new ArrayList<Base>();
        }
        return this.makeBoolean(this.convertToBoolean(right));
    }

    private List<Base> opMinus(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing -: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing -: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing -: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing -: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing -: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing -: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) - Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).subtract(new BigDecimal(r.primitiveValue()))));
        } else {
            throw new PathEngineException(String.format("Error performing -: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private List<Base> opDivideBy(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing /: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing /: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing -: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing /: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing /: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing /: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new DecimalType(d1.divide(d2).asDecimal()));
            }
            catch (UcumException e) {
                throw new PathEngineException((Throwable)e);
            }
        } else {
            throw new PathEngineException(String.format("Error performing /: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private List<Base> opDiv(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing div: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing div: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing div: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing div: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing div: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing div: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) / Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new IntegerType(d1.divInt(d2).asDecimal()));
            }
            catch (UcumException e) {
                throw new PathEngineException((Throwable)e);
            }
        } else {
            throw new PathEngineException(String.format("Error performing div: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private List<Base> opMod(List<Base> left, List<Base> right) throws PathEngineException {
        if (left.size() == 0) {
            throw new PathEngineException("Error performing mod: left operand has no value");
        }
        if (left.size() > 1) {
            throw new PathEngineException("Error performing mod: left operand has more than one value");
        }
        if (!left.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing mod: left operand has the wrong type (%s)", left.get(0).fhirType()));
        }
        if (right.size() == 0) {
            throw new PathEngineException("Error performing mod: right operand has no value");
        }
        if (right.size() > 1) {
            throw new PathEngineException("Error performing mod: right operand has more than one value");
        }
        if (!right.get(0).isPrimitive()) {
            throw new PathEngineException(String.format("Error performing mod: right operand has the wrong type (%s)", right.get(0).fhirType()));
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) % Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new DecimalType(d1.modulo(d2).asDecimal()));
            }
            catch (UcumException e) {
                throw new PathEngineException((Throwable)e);
            }
        } else {
            throw new PathEngineException(String.format("Error performing mod: left and right operand have incompatible or illegal types (%s, %s)", left.get(0).fhirType(), right.get(0).fhirType()));
        }
        return result;
    }

    private TypeDetails readConstantType(FHIRPathUtilityClasses.ExecutionTypeContext context, String constant) throws PathEngineException {
        if (constant.equals("true")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
        }
        if (constant.equals("false")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
        }
        if (Utilities.isInteger((String)constant)) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer");
        }
        if (Utilities.isDecimal((String)constant, (boolean)false)) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "decimal");
        }
        if (constant.startsWith("%")) {
            return this.resolveConstantType(context, constant);
        }
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
    }

    private TypeDetails resolveConstantType(FHIRPathUtilityClasses.ExecutionTypeContext context, String s) throws PathEngineException {
        if (s.equals("%sct")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.equals("%loinc")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.equals("%ucum")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.equals("%resource")) {
            if (context.getResource() == null) {
                throw new PathEngineException("%resource cannot be used in this context");
            }
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, context.getResource());
        }
        if (s.equals("%context")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, context.getContext());
        }
        if (s.equals("%map-codes")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.equals("%us-zip")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.startsWith("%\"vs-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.startsWith("%\"cs-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (s.startsWith("%\"ext-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
        }
        if (this.hostServices == null) {
            throw new PathEngineException("Unknown fixed constant type for '" + s + "'");
        }
        return this.hostServices.resolveConstantType(context.getAppInfo(), s);
    }

    private List<Base> execute(FHIRPathUtilityClasses.ExecutionContext context, Base item, ExpressionNode exp, boolean atEntry) throws FHIRException {
        Base temp;
        ArrayList<Base> result = new ArrayList<Base>();
        if (atEntry && Character.isUpperCase(exp.getName().charAt(0))) {
            if (item.isResource() && item.fhirType().equals(exp.getName())) {
                result.add(item);
            }
        } else {
            this.getChildrenByName(item, exp.getName(), result);
        }
        if (result.size() == 0 && atEntry && context.getAppInfo() != null && (temp = this.hostServices.resolveConstant(context.getAppInfo(), exp.getName())) != null) {
            result.add(temp);
        }
        return result;
    }

    private TypeDetails executeContextType(FHIRPathUtilityClasses.ExecutionTypeContext context, String name) throws PathEngineException, DefinitionException {
        if (this.hostServices == null) {
            throw new PathEngineException("Unable to resolve context reference since no host services are provided");
        }
        return this.hostServices.resolveConstantType(context.getAppInfo(), name);
    }

    private TypeDetails executeType(String type, ExpressionNode exp, boolean atEntry) throws PathEngineException, DefinitionException {
        if (atEntry && Character.isUpperCase(exp.getName().charAt(0)) && this.hashTail(type).equals(exp.getName())) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, type);
        }
        TypeDetails result = new TypeDetails(null, new String[0]);
        this.getChildTypesByName(type, exp.getName(), result);
        return result;
    }

    private String hashTail(String type) {
        return type.contains("#") ? "" : type.substring(type.lastIndexOf("/") + 1);
    }

    private TypeDetails evaluateFunctionType(FHIRPathUtilityClasses.ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp) throws PathEngineException, DefinitionException {
        ArrayList<TypeDetails> paramTypes = new ArrayList<TypeDetails>();
        if (exp.getFunction() == ExpressionNode.Function.Is || exp.getFunction() == ExpressionNode.Function.As) {
            paramTypes.add(new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
        } else {
            for (ExpressionNode expr : exp.getParameters()) {
                if (exp.getFunction() == ExpressionNode.Function.Where || exp.getFunction() == ExpressionNode.Function.Select || exp.getFunction() == ExpressionNode.Function.Repeat) {
                    paramTypes.add(this.executeType(this.changeThis(context, focus), focus, expr, true));
                    continue;
                }
                paramTypes.add(this.executeType(context, focus, expr, true));
            }
        }
        switch (exp.getFunction()) {
            case Empty: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Not: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Exists: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case SubsetOf: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, focus);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case SupersetOf: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, focus);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case IsDistinct: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Distinct: {
                return focus;
            }
            case Count: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer");
            }
            case Where: {
                return focus;
            }
            case Select: {
                return this.anything(focus.getCollectionStatus());
            }
            case All: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Repeat: {
                return this.anything(focus.getCollectionStatus());
            }
            case Item: {
                this.checkOrdered(focus, "item");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer"));
                return focus;
            }
            case As: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, exp.getParameters().get(0).getName());
            }
            case Is: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Single: {
                return focus.toSingleton();
            }
            case First: {
                this.checkOrdered(focus, "first");
                return focus.toSingleton();
            }
            case Last: {
                this.checkOrdered(focus, "last");
                return focus.toSingleton();
            }
            case Tail: {
                this.checkOrdered(focus, "tail");
                return focus;
            }
            case Skip: {
                this.checkOrdered(focus, "skip");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer"));
                return focus;
            }
            case Take: {
                this.checkOrdered(focus, "take");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer"));
                return focus;
            }
            case Iif: {
                TypeDetails types = new TypeDetails(null, new String[0]);
                types.update((TypeDetails)paramTypes.get(0));
                if (paramTypes.size() > 1) {
                    types.update((TypeDetails)paramTypes.get(1));
                }
                return types;
            }
            case ToInteger: {
                this.checkContextPrimitive(focus, "toInteger");
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer");
            }
            case ToDecimal: {
                this.checkContextPrimitive(focus, "toDecimal");
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "decimal");
            }
            case ToString: {
                this.checkContextPrimitive(focus, "toString");
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case Substring: {
                this.checkContextString(focus, "subString");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case StartsWith: {
                this.checkContextString(focus, "startsWith");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case EndsWith: {
                this.checkContextString(focus, "endsWith");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Matches: {
                this.checkContextString(focus, "matches");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case ReplaceMatches: {
                this.checkContextString(focus, "replaceMatches");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case Contains: {
                this.checkContextString(focus, "contains");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Replace: {
                this.checkContextString(focus, "replace");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            case Length: {
                this.checkContextPrimitive(focus, "length");
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "integer");
            }
            case Children: {
                return this.childTypes(focus, "*");
            }
            case Descendants: {
                return this.childTypes(focus, "**");
            }
            case MemberOf: {
                this.checkContextCoded(focus, "memberOf");
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Trace: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return focus;
            }
            case Today: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "date");
            }
            case Now: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "dateTime");
            }
            case Resolve: {
                this.checkContextReference(focus, "resolve");
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "DomainResource");
            }
            case Extension: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Extension");
            }
            case HasValue: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "boolean");
            }
            case Alias: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return this.anything(ExpressionNode.CollectionStatus.SINGLETON);
            }
            case AliasAs: {
                this.checkParamTypes(exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string"));
                return focus;
            }
            case Custom: {
                return this.hostServices.checkFunction(context.getAppInfo(), exp.getName(), paramTypes);
            }
        }
        throw new Error("not Implemented yet");
    }

    private void checkParamTypes(String funcName, List<TypeDetails> paramTypes, TypeDetails ... typeSet) throws PathEngineException {
        int i = 0;
        for (TypeDetails pt : typeSet) {
            if (i == paramTypes.size()) {
                return;
            }
            TypeDetails actual = paramTypes.get(i);
            ++i;
            for (String a : actual.getTypes()) {
                if (pt.hasType(this.worker, a)) continue;
                throw new PathEngineException("The parameter type '" + a + "' is not legal for " + funcName + " parameter " + Integer.toString(i) + ". expecting " + pt.toString());
            }
        }
    }

    private void checkOrdered(TypeDetails focus, String name) throws PathEngineException {
        if (focus.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED) {
            throw new PathEngineException("The function '" + name + "'() can only be used on ordered collections");
        }
    }

    private void checkContextReference(TypeDetails focus, String name) throws PathEngineException {
        if (!(focus.hasType(this.worker, "string") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "Reference"))) {
            throw new PathEngineException("The function '" + name + "'() can only be used on string, uri, Reference");
        }
    }

    private void checkContextCoded(TypeDetails focus, String name) throws PathEngineException {
        if (!(focus.hasType(this.worker, "string") || focus.hasType(this.worker, "code") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "Coding") || focus.hasType(this.worker, "CodeableConcept"))) {
            throw new PathEngineException("The function '" + name + "'() can only be used on string, code, uri, Coding, CodeableConcept");
        }
    }

    private void checkContextString(TypeDetails focus, String name) throws PathEngineException {
        if (!(focus.hasType(this.worker, "string") || focus.hasType(this.worker, "code") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "id"))) {
            throw new PathEngineException("The function '" + name + "'() can only be used on string, uri, code, id, but found " + focus.describe());
        }
    }

    private void checkContextPrimitive(TypeDetails focus, String name) throws PathEngineException {
        if (!focus.hasType(this.primitiveTypes)) {
            throw new PathEngineException("The function '" + name + "'() can only be used on " + this.primitiveTypes.toString());
        }
    }

    private TypeDetails childTypes(TypeDetails focus, String mask) throws PathEngineException, DefinitionException {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.UNORDERED, new String[0]);
        for (String f : focus.getTypes()) {
            this.getChildTypesByName(f, mask, result);
        }
        return result;
    }

    private TypeDetails anything(ExpressionNode.CollectionStatus status) {
        return new TypeDetails(status, this.allTypes.keySet());
    }

    private List<Base> evaluateFunction(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        switch (exp.getFunction()) {
            case Empty: {
                return this.funcEmpty(context, focus, exp);
            }
            case Not: {
                return this.funcNot(context, focus, exp);
            }
            case Exists: {
                return this.funcExists(context, focus, exp);
            }
            case SubsetOf: {
                return this.funcSubsetOf(context, focus, exp);
            }
            case SupersetOf: {
                return this.funcSupersetOf(context, focus, exp);
            }
            case IsDistinct: {
                return this.funcIsDistinct(context, focus, exp);
            }
            case Distinct: {
                return this.funcDistinct(context, focus, exp);
            }
            case Count: {
                return this.funcCount(context, focus, exp);
            }
            case Where: {
                return this.funcWhere(context, focus, exp);
            }
            case Select: {
                return this.funcSelect(context, focus, exp);
            }
            case All: {
                return this.funcAll(context, focus, exp);
            }
            case Repeat: {
                return this.funcRepeat(context, focus, exp);
            }
            case Item: {
                return this.funcItem(context, focus, exp);
            }
            case As: {
                return this.funcAs(context, focus, exp);
            }
            case Is: {
                return this.funcIs(context, focus, exp);
            }
            case Single: {
                return this.funcSingle(context, focus, exp);
            }
            case First: {
                return this.funcFirst(context, focus, exp);
            }
            case Last: {
                return this.funcLast(context, focus, exp);
            }
            case Tail: {
                return this.funcTail(context, focus, exp);
            }
            case Skip: {
                return this.funcSkip(context, focus, exp);
            }
            case Take: {
                return this.funcTake(context, focus, exp);
            }
            case Iif: {
                return this.funcIif(context, focus, exp);
            }
            case ToInteger: {
                return this.funcToInteger(context, focus, exp);
            }
            case ToDecimal: {
                return this.funcToDecimal(context, focus, exp);
            }
            case ToString: {
                return this.funcToString(context, focus, exp);
            }
            case Substring: {
                return this.funcSubstring(context, focus, exp);
            }
            case StartsWith: {
                return this.funcStartsWith(context, focus, exp);
            }
            case EndsWith: {
                return this.funcEndsWith(context, focus, exp);
            }
            case Matches: {
                return this.funcMatches(context, focus, exp);
            }
            case ReplaceMatches: {
                return this.funcReplaceMatches(context, focus, exp);
            }
            case Contains: {
                return this.funcContains(context, focus, exp);
            }
            case Replace: {
                return this.funcReplace(context, focus, exp);
            }
            case Length: {
                return this.funcLength(context, focus, exp);
            }
            case Children: {
                return this.funcChildren(context, focus, exp);
            }
            case Descendants: {
                return this.funcDescendants(context, focus, exp);
            }
            case MemberOf: {
                return this.funcMemberOf(context, focus, exp);
            }
            case Trace: {
                return this.funcTrace(context, focus, exp);
            }
            case Today: {
                return this.funcToday(context, focus, exp);
            }
            case Now: {
                return this.funcNow(context, focus, exp);
            }
            case Resolve: {
                return this.funcResolve(context, focus, exp);
            }
            case Extension: {
                return this.funcExtension(context, focus, exp);
            }
            case HasValue: {
                return this.funcHasValue(context, focus, exp);
            }
            case AliasAs: {
                return this.funcAliasAs(context, focus, exp);
            }
            case Alias: {
                return this.funcAlias(context, focus, exp);
            }
            case Custom: {
                ArrayList<List<Base>> params = new ArrayList<List<Base>>();
                for (ExpressionNode p : exp.getParameters()) {
                    params.add(this.execute(context, focus, p, true));
                }
                return this.hostServices.executeFunction(context.getAppInfo(), exp.getName(), params);
            }
        }
        throw new Error("not Implemented yet");
    }

    private List<Base> funcAliasAs(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String name = nl.get(0).primitiveValue();
        context.addAlias(name, focus);
        return focus;
    }

    private List<Base> funcAlias(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String name = nl.get(0).primitiveValue();
        ArrayList<Base> res = new ArrayList<Base>();
        Base b = context.getAlias(name);
        if (b != null) {
            res.add(b);
        }
        return res;
    }

    private List<Base> funcAll(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        if (exp.getParameters().size() == 1) {
            ArrayList<Base> result = new ArrayList<Base>();
            ArrayList<Base> pc = new ArrayList<Base>();
            boolean all = true;
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                if (this.convertToBoolean(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), true))) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all));
            return result;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        boolean all = true;
        for (Base item : focus) {
            boolean v = false;
            if (item instanceof BooleanType) {
                v = ((BooleanType)item).booleanValue();
            } else {
                boolean bl = v = item != null;
            }
            if (v) continue;
            all = false;
            break;
        }
        result.add(new BooleanType(all));
        return result;
    }

    private FHIRPathUtilityClasses.ExecutionContext changeThis(FHIRPathUtilityClasses.ExecutionContext context, Base newThis) {
        return new FHIRPathUtilityClasses.ExecutionContext(context.getAppInfo(), context.getResource(), context.getContext(), context.getAliases(), newThis);
    }

    private FHIRPathUtilityClasses.ExecutionTypeContext changeThis(FHIRPathUtilityClasses.ExecutionTypeContext context, TypeDetails newThis) {
        return new FHIRPathUtilityClasses.ExecutionTypeContext(context.getAppInfo(), context.getResource(), context.getContext(), newThis);
    }

    private List<Base> funcNow(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(DateTimeType.now());
        return result;
    }

    private List<Base> funcToday(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new DateType(new Date(), TemporalPrecisionEnum.DAY));
        return result;
    }

    private List<Base> funcMemberOf(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        throw new Error("not Implemented yet");
    }

    private List<Base> funcDescendants(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> current = new ArrayList<Base>();
        current.addAll(focus);
        ArrayList<Base> added = new ArrayList<Base>();
        boolean more = true;
        while (more) {
            added.clear();
            for (Base item : current) {
                this.getChildrenByName(item, "*", added);
            }
            more = !added.isEmpty();
            result.addAll(added);
            current.clear();
            current.addAll(added);
        }
        return result;
    }

    private List<Base> funcChildren(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base b : focus) {
            this.getChildrenByName(b, "*", result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Base> funcReplace(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException, PathEngineException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) throw new PathEngineException(String.format("funcReplace() : checking for 1 string item but found %d items", focus.size()));
        String f = this.convertToString(focus.get(0));
        if (Utilities.noString((String)f)) throw new PathEngineException(String.format("funcReplace() : checking for 1 string item but found empty item", new Object[0]));
        if (exp.getParameters().size() != 2) {
            throw new PathEngineException(String.format("funcReplace() : checking for 2 arguments (pattern, substitution) but found %d items", exp.getParameters().size()));
        }
        String t = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        String r = this.convertToString(this.execute(context, focus, exp.getParameters().get(1), true));
        String n = f.replace(t, r);
        result.add(new StringType(n));
        return result;
    }

    private List<Base> funcReplaceMatches(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String regex = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        String repl = this.convertToString(this.execute(context, focus, exp.getParameters().get(1), true));
        if (focus.size() == 1 && !Utilities.noString((String)regex)) {
            result.add(new StringType(this.convertToString(focus.get(0)).replaceAll(regex, repl)));
        } else {
            result.add(new StringType(this.convertToString(focus.get(0))));
        }
        return result;
    }

    private List<Base> funcEndsWith(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String sw = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (focus.size() == 1 && !Utilities.noString((String)sw)) {
            result.add(new BooleanType(this.convertToString(focus.get(0)).endsWith(sw)));
        } else {
            result.add(new BooleanType(false));
        }
        return result;
    }

    private List<Base> funcToString(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new StringType(this.convertToString(focus)));
        return result;
    }

    private List<Base> funcToDecimal(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        String s = this.convertToString(focus);
        ArrayList<Base> result = new ArrayList<Base>();
        if (Utilities.isDecimal((String)s, (boolean)true)) {
            result.add(new DecimalType(s));
        }
        return result;
    }

    private List<Base> funcIif(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        Boolean v = this.convertToBoolean(n1);
        if (v.booleanValue()) {
            return this.execute(context, focus, exp.getParameters().get(1), true);
        }
        if (exp.getParameters().size() < 3) {
            return new ArrayList<Base>();
        }
        return this.execute(context, focus, exp.getParameters().get(2), true);
    }

    private List<Base> funcTake(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 0; i < Math.min(focus.size(), i1); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcSingle(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws PathEngineException {
        if (focus.size() == 1) {
            return focus;
        }
        throw new PathEngineException(String.format("Single() : checking for 1 item but found %d items", focus.size()));
    }

    private List<Base> funcIs(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws PathEngineException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 0 || focus.size() > 1) {
            result.add(new BooleanType(false));
        } else {
            String tn = exp.getParameters().get(0).getName();
            result.add(new BooleanType(focus.get(0).hasType(tn)));
        }
        return result;
    }

    private List<Base> funcAs(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        String tn = exp.getParameters().get(0).getName();
        for (Base b : focus) {
            if (!b.hasType(tn)) continue;
            result.add(b);
        }
        return result;
    }

    private List<Base> funcRepeat(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> current = new ArrayList<Base>();
        current.addAll(focus);
        ArrayList<Base> added = new ArrayList<Base>();
        boolean more = true;
        while (more) {
            added.clear();
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : current) {
                pc.clear();
                pc.add(item);
                added.addAll(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), false));
            }
            more = !added.isEmpty();
            result.addAll(added);
            current.clear();
            current.addAll(added);
        }
        return result;
    }

    private List<Base> funcIsDistinct(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        if (focus.size() <= 1) {
            return this.makeBoolean(true);
        }
        boolean distinct = true;
        block0: for (int i = 0; i < focus.size(); ++i) {
            for (int j = i + 1; j < focus.size(); ++j) {
                if (!this.doEquals(focus.get(j), focus.get(i))) continue;
                distinct = false;
                continue block0;
            }
        }
        return this.makeBoolean(distinct);
    }

    private List<Base> funcSupersetOf(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> target = this.execute(context, focus, exp.getParameters().get(0), true);
        boolean valid = true;
        for (Base item : target) {
            boolean found = false;
            for (Base t : focus) {
                if (!Base.compareDeep(item, t, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valid = false;
            break;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(valid));
        return result;
    }

    private List<Base> funcSubsetOf(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> target = this.execute(context, focus, exp.getParameters().get(0), true);
        boolean valid = true;
        for (Base item : focus) {
            boolean found = false;
            for (Base t : target) {
                if (!Base.compareDeep(item, t, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valid = false;
            break;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(valid));
        return result;
    }

    private List<Base> funcExists(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(!ElementUtil.isEmpty(focus)));
        return result;
    }

    private List<Base> funcResolve(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : focus) {
            String s = this.convertToString(item);
            if (item.fhirType().equals("Reference")) {
                Property p = item.getChildByName("reference");
                s = p != null && p.hasValues() ? this.convertToString(p.getValues().get(0)) : null;
            }
            if (item.fhirType().equals("canonical")) {
                s = item.primitiveValue();
            }
            if (s == null) continue;
            Base res = null;
            if (s.startsWith("#")) {
                String t = s.substring(1);
                Property p = context.getResource().getChildByName("contained");
                if (p != null) {
                    for (Base c : p.getValues()) {
                        if (!t.equals(c.getIdBase())) continue;
                        res = c;
                        break;
                    }
                }
            } else if (this.hostServices != null) {
                try {
                    res = this.hostServices.resolveReference(this, s);
                }
                catch (Exception e) {
                    res = null;
                }
            }
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    private List<Base> funcExtension(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String url = nl.get(0).primitiveValue();
        for (Base item : focus) {
            ArrayList<Base> ext = new ArrayList<Base>();
            this.getChildrenByName(item, "extension", ext);
            this.getChildrenByName(item, "modifierExtension", ext);
            for (Base ex : ext) {
                ArrayList<Base> vl = new ArrayList<Base>();
                this.getChildrenByName(ex, "url", vl);
                if (!this.convertToString(vl).equals(url)) continue;
                result.add(ex);
            }
        }
        return result;
    }

    private List<Base> funcTrace(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String name = nl.get(0).primitiveValue();
        this.log(name, focus);
        return focus;
    }

    private List<Base> funcDistinct(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        if (focus.size() <= 1) {
            return focus;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 0; i < focus.size(); ++i) {
            boolean found = false;
            for (int j = i + 1; j < focus.size(); ++j) {
                if (!this.doEquals(focus.get(j), focus.get(i))) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcMatches(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String sw = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (focus.size() == 1 && !Utilities.noString((String)sw)) {
            String st = this.convertToString(focus.get(0));
            if (Utilities.noString((String)st)) {
                result.add(new BooleanType(false));
            } else {
                result.add(new BooleanType(st.matches(sw)));
            }
        } else {
            result.add(new BooleanType(false));
        }
        return result;
    }

    private List<Base> funcContains(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String sw = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (focus.size() == 1 && !Utilities.noString((String)sw)) {
            String st = this.convertToString(focus.get(0));
            if (Utilities.noString((String)st)) {
                result.add(new BooleanType(false));
            } else {
                result.add(new BooleanType(st.contains(sw)));
            }
        } else {
            result.add(new BooleanType(false));
        }
        return result;
    }

    private List<Base> funcLength(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String s = this.convertToString(focus.get(0));
            result.add(new IntegerType(s.length()));
        }
        return result;
    }

    private List<Base> funcHasValue(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String s = this.convertToString(focus.get(0));
            result.add(new BooleanType(!Utilities.noString((String)s)));
        }
        return result;
    }

    private List<Base> funcStartsWith(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String sw = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (focus.size() == 1 && !Utilities.noString((String)sw)) {
            result.add(new BooleanType(this.convertToString(focus.get(0)).startsWith(sw)));
        } else {
            result.add(new BooleanType(false));
        }
        return result;
    }

    private List<Base> funcSubstring(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        int i2 = -1;
        if (exp.parameterCount() == 2) {
            List<Base> n2 = this.execute(context, focus, exp.getParameters().get(1), true);
            i2 = Integer.parseInt(n2.get(0).primitiveValue());
        }
        if (focus.size() == 1) {
            String sw = this.convertToString(focus.get(0));
            if (i1 < 0 || i1 >= sw.length()) {
                return new ArrayList<Base>();
            }
            String s = exp.parameterCount() == 2 ? sw.substring(i1, Math.min(sw.length(), i1 + i2)) : sw.substring(i1);
            if (!Utilities.noString((String)s)) {
                result.add(new StringType(s));
            }
        }
        return result;
    }

    private List<Base> funcToInteger(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        String s = this.convertToString(focus);
        ArrayList<Base> result = new ArrayList<Base>();
        if (Utilities.isInteger((String)s)) {
            result.add(new IntegerType(s));
        }
        return result;
    }

    private List<Base> funcCount(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new IntegerType(focus.size()));
        return result;
    }

    private List<Base> funcSkip(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = i1; i < focus.size(); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcTail(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 1; i < focus.size(); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcLast(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() > 0) {
            result.add(focus.get(focus.size() - 1));
        }
        return result;
    }

    private List<Base> funcFirst(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() > 0) {
            result.add(focus.get(0));
        }
        return result;
    }

    private List<Base> funcWhere(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> pc = new ArrayList<Base>();
        for (Base item : focus) {
            pc.clear();
            pc.add(item);
            if (!this.convertToBoolean(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), true))) continue;
            result.add(item);
        }
        return result;
    }

    private List<Base> funcSelect(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> pc = new ArrayList<Base>();
        for (Base item : focus) {
            pc.clear();
            pc.add(item);
            result.addAll(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), true));
        }
        return result;
    }

    private List<Base> funcItem(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String s = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (Utilities.isInteger((String)s) && Integer.parseInt(s) < focus.size()) {
            result.add(focus.get(Integer.parseInt(s)));
        }
        return result;
    }

    private List<Base> funcEmpty(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(ElementUtil.isEmpty(focus)));
        return result;
    }

    private List<Base> funcNot(FHIRPathUtilityClasses.ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        return this.makeBoolean(!this.convertToBoolean(focus));
    }

    private void getChildTypesByName(String type, String name, TypeDetails result) throws PathEngineException, DefinitionException {
        if (Utilities.noString((String)type)) {
            throw new PathEngineException("No type provided in BuildToolPathEvaluator.getChildTypesByName");
        }
        if (type.equals("http://hl7.org/fhir/StructureDefinition/xhtml")) {
            return;
        }
        String url = null;
        url = type.contains("#") ? type.substring(0, type.indexOf("#")) : type;
        String tail = "";
        StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, url);
        if (sd == null) {
            throw new DefinitionException("Unknown type " + type);
        }
        ArrayList<StructureDefinition> sdl = new ArrayList<StructureDefinition>();
        ElementDefinitionMatch m = null;
        if (type.contains("#")) {
            m = this.getElementDefinition(sd, type.substring(type.indexOf("#") + 1), false);
        }
        if (m != null && this.hasDataType(m.definition)) {
            if (m.fixedType != null) {
                StructureDefinition dt = this.worker.fetchTypeDefinition(m.fixedType);
                if (dt == null) {
                    throw new DefinitionException("unknown data type " + m.fixedType);
                }
                sdl.add(dt);
            } else {
                for (ElementDefinition.TypeRefComponent t : m.definition.getType()) {
                    StructureDefinition dt = this.worker.fetchTypeDefinition(t.getCode());
                    if (dt == null) {
                        throw new DefinitionException("unknown data type " + t.getCode());
                    }
                    sdl.add(dt);
                }
            }
        } else {
            sdl.add(sd);
            if (type.contains("#")) {
                tail = type.substring(type.indexOf("#") + 1);
                tail = tail.substring(tail.indexOf("."));
            }
        }
        for (StructureDefinition sdi : sdl) {
            String path = sdi.getSnapshot().getElement().get(0).getPath() + tail + ".";
            if (name.equals("**")) {
                assert (result.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED);
                for (ElementDefinition ed : sdi.getSnapshot().getElement()) {
                    if (!ed.getPath().startsWith(path)) continue;
                    for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                        if (!t.hasCode() || !t.getCodeElement().hasValue()) continue;
                        Object tn = null;
                        tn = t.getCode().equals("Element") || t.getCode().equals("BackboneElement") ? sdi.getType() + "#" + ed.getPath() : t.getCode();
                        if (t.getCode().equals("Resource")) {
                            for (String rn : this.worker.getResourceNames()) {
                                if (result.hasType(this.worker, rn)) continue;
                                this.getChildTypesByName(result.addType(rn), "**", result);
                            }
                            continue;
                        }
                        if (result.hasType(this.worker, new String[]{tn})) continue;
                        this.getChildTypesByName(result.addType((String)tn), "**", result);
                    }
                }
                continue;
            }
            if (name.equals("*")) {
                assert (result.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED);
                for (ElementDefinition ed : sdi.getSnapshot().getElement()) {
                    if (!ed.getPath().startsWith(path) || ed.getPath().substring(path.length()).contains(".")) continue;
                    for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                        if (t.getCode().equals("Element") || t.getCode().equals("BackboneElement")) {
                            result.addType(sdi.getType() + "#" + ed.getPath());
                            continue;
                        }
                        if (t.getCode().equals("Resource")) {
                            result.addTypes(this.worker.getResourceNames());
                            continue;
                        }
                        result.addType(t.getCode());
                    }
                }
                continue;
            }
            path = sdi.getSnapshot().getElement().get(0).getPath() + tail + "." + name;
            ElementDefinitionMatch ed = this.getElementDefinition(sdi, path, false);
            if (ed == null) continue;
            if (!Utilities.noString((String)ed.getFixedType())) {
                result.addType(ed.getFixedType());
                continue;
            }
            for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                if (Utilities.noString((String)t.getCode())) break;
                TypeDetails.ProfiledType pt = null;
                if (t.getCode().equals("Element") || t.getCode().equals("BackboneElement")) {
                    pt = new TypeDetails.ProfiledType(sdi.getUrl() + "#" + path);
                } else if (t.getCode().equals("Resource")) {
                    result.addTypes(this.worker.getResourceNames());
                } else {
                    pt = new TypeDetails.ProfiledType(t.getCode());
                }
                if (pt == null) continue;
                if (t.hasProfile()) {
                    pt.addProfile(t.getProfile());
                }
                if (ed.getDefinition().hasBinding()) {
                    pt.addBinding(ed.getDefinition().getBinding());
                }
                result.addType(pt);
            }
        }
    }

    private ElementDefinitionMatch getElementDefinition(StructureDefinition sd, String path, boolean allowTypedName) throws PathEngineException {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                if (ed.hasContentReference()) {
                    return this.getElementDefinitionById(sd, ed.getContentReference());
                }
                return new ElementDefinitionMatch(ed, null);
            }
            if (ed.getPath().endsWith("[x]") && path.startsWith(ed.getPath().substring(0, ed.getPath().length() - 3)) && path.length() == ed.getPath().length() - 3) {
                return new ElementDefinitionMatch(ed, null);
            }
            if (allowTypedName && ed.getPath().endsWith("[x]") && path.startsWith(ed.getPath().substring(0, ed.getPath().length() - 3)) && path.length() > ed.getPath().length() - 3) {
                String s = Utilities.uncapitalize((String)path.substring(ed.getPath().length() - 3));
                if (this.primitiveTypes.contains(s)) {
                    return new ElementDefinitionMatch(ed, s);
                }
                return new ElementDefinitionMatch(ed, path.substring(ed.getPath().length() - 3));
            }
            if (ed.getPath().contains(".") && path.startsWith(ed.getPath() + ".") && ed.getType().size() > 0 && !this.isAbstractType(ed.getType())) {
                if (ed.getType().size() > 1) {
                    throw new PathEngineException("Internal typing issue....");
                }
                StructureDefinition nsd = this.worker.fetchTypeDefinition(ed.getType().get(0).getCode());
                if (nsd == null) {
                    throw new PathEngineException("Unknown type " + ed.getType().get(0).getCode());
                }
                return this.getElementDefinition(nsd, nsd.getId() + path.substring(ed.getPath().length()), allowTypedName);
            }
            if (!ed.hasContentReference() || !path.startsWith(ed.getPath() + ".")) continue;
            ElementDefinitionMatch m = this.getElementDefinitionById(sd, ed.getContentReference());
            return this.getElementDefinition(sd, m.definition.getPath() + path.substring(ed.getPath().length()), allowTypedName);
        }
        return null;
    }

    private boolean isAbstractType(List<ElementDefinition.TypeRefComponent> list) {
        return list.size() != 1 ? true : Utilities.existsInList((String)list.get(0).getCode(), (String[])new String[]{"Element", "BackboneElement", "Resource", "DomainResource"});
    }

    private boolean hasType(ElementDefinition ed, String s) {
        for (ElementDefinition.TypeRefComponent t : ed.getType()) {
            if (!s.equalsIgnoreCase(t.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean hasDataType(ElementDefinition ed) {
        return ed.hasType() && !ed.getType().get(0).getCode().equals("Element") && !ed.getType().get(0).getCode().equals("BackboneElement");
    }

    private ElementDefinitionMatch getElementDefinitionById(StructureDefinition sd, String ref) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ref.equals("#" + ed.getId())) continue;
            return new ElementDefinitionMatch(ed, null);
        }
        return null;
    }

    public boolean hasLog() {
        return this.log != null && this.log.length() > 0;
    }

    public String takeLog() {
        if (!this.hasLog()) {
            return "";
        }
        String s = this.log.toString();
        this.log = new StringBuilder();
        return s;
    }

    public static interface IEvaluationContext {
        public Base resolveConstant(Object var1, String var2) throws PathEngineException;

        public TypeDetails resolveConstantType(Object var1, String var2) throws PathEngineException;

        public boolean log(String var1, List<Base> var2);

        public FHIRPathUtilityClasses.FunctionDetails resolveFunction(String var1);

        public TypeDetails checkFunction(Object var1, String var2, List<TypeDetails> var3) throws PathEngineException;

        public List<Base> executeFunction(Object var1, String var2, List<List<Base>> var3);

        public Base resolveReference(Object var1, String var2);
    }

    private class ElementDefinitionMatch {
        private ElementDefinition definition;
        private String fixedType;

        public ElementDefinitionMatch(ElementDefinition definition, String fixedType) {
            this.definition = definition;
            this.fixedType = fixedType;
        }

        public ElementDefinition getDefinition() {
            return this.definition;
        }

        public String getFixedType() {
            return this.fixedType;
        }
    }
}

