/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.fhirpath;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.fhirpath.TypeDetails;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.exceptions.FHIRException;

public class FHIRPathUtilityClasses {

    public static class FunctionDetails {
        private String description;
        private int minParameters;
        private int maxParameters;

        public FunctionDetails(String description, int minParameters, int maxParameters) {
            this.description = description;
            this.minParameters = minParameters;
            this.maxParameters = maxParameters;
        }

        public String getDescription() {
            return this.description;
        }

        public int getMinParameters() {
            return this.minParameters;
        }

        public int getMaxParameters() {
            return this.maxParameters;
        }
    }

    public static class ExecutionTypeContext {
        private Object appInfo;
        private String resource;
        private String context;
        private TypeDetails thisItem;

        public ExecutionTypeContext(Object appInfo, String resource, String context, TypeDetails thisItem) {
            this.appInfo = appInfo;
            this.resource = resource;
            this.context = context;
            this.thisItem = thisItem;
        }

        public String getResource() {
            return this.resource;
        }

        public TypeDetails getThisItem() {
            return this.thisItem;
        }

        public Object getAppInfo() {
            return this.appInfo;
        }

        public String getContext() {
            return this.context;
        }
    }

    public static class ExecutionContext {
        private Object appInfo;
        private Base resource;
        private Base context;
        private Base thisItem;
        private Map<String, Base> aliases;

        public ExecutionContext(Object appInfo, Base resource, Base context, Map<String, Base> aliases, Base thisItem) {
            this.appInfo = appInfo;
            this.context = context;
            this.resource = resource;
            this.aliases = aliases;
            this.thisItem = thisItem;
        }

        public Base getResource() {
            return this.resource;
        }

        public Base getThisItem() {
            return this.thisItem;
        }

        public void addAlias(String name, List<Base> focus) throws FHIRException {
            this.aliases = this.aliases == null ? new HashMap<String, Base>() : new HashMap<String, Base>(this.aliases);
            if (focus.size() > 1) {
                throw new FHIRException("Attempt to alias a collection, not a singleton");
            }
            this.aliases.put(name, focus.size() == 0 ? null : focus.get(0));
        }

        public Base getAlias(String name) {
            return this.aliases == null ? null : this.aliases.get(name);
        }

        public Object getAppInfo() {
            return this.appInfo;
        }

        public Base getContext() {
            return this.context;
        }

        public Map<String, Base> getAliases() {
            return this.aliases;
        }
    }
}

