/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ChargeItem", profile="http://hl7.org/fhir/Profile/ChargeItem")
public class ChargeItem
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for item", formalDefinition="Identifiers assigned to this event performer or other systems.")
    protected Identifier identifier;
    @Child(name="definition", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Defining information about the code of this charge item", formalDefinition="References the source of pricing information, rules of application for the code this ChargeItem uses.")
    protected List<UriType> definition;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | billable | not-billable | aborted | billed | entered-in-error | unknown", formalDefinition="The current state of the ChargeItem.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-status")
    protected Enumeration<ChargeItemStatus> status;
    @Child(name="partOf", type={ChargeItem.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Part of referenced ChargeItem", formalDefinition="ChargeItems can be grouped to larger ChargeItems covering the whole set.")
    protected List<Reference> partOf;
    protected List<ChargeItem> partOfTarget;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A code that identifies the charge, like a billing code", formalDefinition="A code that identifies the charge, like a billing code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual service was done for/to", formalDefinition="The individual or set of individuals the action is being or was performed on.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter / Episode associated with event", formalDefinition="The encounter or episode of care that establishes the context for this event.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the charged service was applied", formalDefinition="Date/time(s) or duration when the charged service was applied.")
    protected Type occurrence;
    @Child(name="participant", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who performed charged service", formalDefinition="Indicates who or what performed or participated in the charged service.")
    protected List<ChargeItemParticipantComponent> participant;
    @Child(name="performingOrganization", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization providing the charged sevice", formalDefinition="The organization requesting the service.")
    protected Reference performingOrganization;
    protected Organization performingOrganizationTarget;
    @Child(name="requestingOrganization", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization requesting the charged service", formalDefinition="The organization performing the service.")
    protected Reference requestingOrganization;
    protected Organization requestingOrganizationTarget;
    @Child(name="quantity", type={Quantity.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Quantity of which the charge item has been serviced", formalDefinition="Quantity of which the charge item has been serviced.")
    protected Quantity quantity;
    @Child(name="bodysite", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where the related service has been applied.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodysite;
    @Child(name="factorOverride", type={DecimalType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Factor overriding the associated rules", formalDefinition="Factor overriding the factor determined by the rules associated with the code.")
    protected DecimalType factorOverride;
    @Child(name="priceOverride", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Price overriding the associated rules", formalDefinition="Total price of the charge overriding the list price associated with the code.")
    protected Money priceOverride;
    @Child(name="overrideReason", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for overriding the list price/factor", formalDefinition="If the list price or the rule based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.")
    protected StringType overrideReason;
    @Child(name="enterer", type={Practitioner.class, Organization.class, Patient.class, Device.class, RelatedPerson.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual who was entering", formalDefinition="The device, practitioner, etc. who entered the charge item.")
    protected Reference enterer;
    protected Resource entererTarget;
    @Child(name="enteredDate", type={DateTimeType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date the charge item was entered", formalDefinition="Date the charge item was entered.")
    protected DateTimeType enteredDate;
    @Child(name="reason", type={CodeableConcept.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why was the charged  service rendered?", formalDefinition="Describes why the event occurred in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
    protected List<CodeableConcept> reason;
    @Child(name="service", type={DiagnosticReport.class, ImagingStudy.class, Immunization.class, MedicationAdministration.class, MedicationDispense.class, Observation.class, Procedure.class, SupplyDelivery.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Which rendered service is being charged?", formalDefinition="Indicated the rendered service that caused this charge.")
    protected List<Reference> service;
    protected List<Resource> serviceTarget;
    @Child(name="account", type={Account.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Account to place this charge", formalDefinition="Account into which this ChargeItems belongs.")
    protected List<Reference> account;
    protected List<Account> accountTarget;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the ChargeItem", formalDefinition="Comments made about the event by the performer, subject or other participants.")
    protected List<Annotation> note;
    @Child(name="supportingInformation", type={Reference.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Further information supporting the this charge", formalDefinition="Further information supporting the this charge.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    private static final long serialVersionUID = 1421123938L;
    @SearchParamDefinition(name="identifier", path="ChargeItem.identifier", description="Business Identifier for item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="performing-organization", path="ChargeItem.performingOrganization", description="Organization providing the charged sevice", type="reference", target={Organization.class})
    public static final String SP_PERFORMING_ORGANIZATION = "performing-organization";
    public static final ReferenceClientParam PERFORMING_ORGANIZATION = new ReferenceClientParam("performing-organization");
    public static final Include INCLUDE_PERFORMING_ORGANIZATION = new Include("ChargeItem:performing-organization").toLocked();
    @SearchParamDefinition(name="code", path="ChargeItem.code", description="A code that identifies the charge, like a billing code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="quantity", path="ChargeItem.quantity", description="Quantity of which the charge item has been serviced", type="quantity")
    public static final String SP_QUANTITY = "quantity";
    public static final QuantityClientParam QUANTITY = new QuantityClientParam("quantity");
    @SearchParamDefinition(name="subject", path="ChargeItem.subject", description="Individual service was done for/to", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ChargeItem:subject").toLocked();
    @SearchParamDefinition(name="participant-role", path="ChargeItem.participant.role", description="What type of performance was done", type="token")
    public static final String SP_PARTICIPANT_ROLE = "participant-role";
    public static final TokenClientParam PARTICIPANT_ROLE = new TokenClientParam("participant-role");
    @SearchParamDefinition(name="participant-actor", path="ChargeItem.participant.actor", description="Individual who was performing", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT_ACTOR = "participant-actor";
    public static final ReferenceClientParam PARTICIPANT_ACTOR = new ReferenceClientParam("participant-actor");
    public static final Include INCLUDE_PARTICIPANT_ACTOR = new Include("ChargeItem:participant-actor").toLocked();
    @SearchParamDefinition(name="occurrence", path="ChargeItem.occurrence", description="When the charged service was applied", type="date")
    public static final String SP_OCCURRENCE = "occurrence";
    public static final DateClientParam OCCURRENCE = new DateClientParam("occurrence");
    @SearchParamDefinition(name="entered-date", path="ChargeItem.enteredDate", description="Date the charge item was entered", type="date")
    public static final String SP_ENTERED_DATE = "entered-date";
    public static final DateClientParam ENTERED_DATE = new DateClientParam("entered-date");
    @SearchParamDefinition(name="patient", path="ChargeItem.subject", description="Individual service was done for/to", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ChargeItem:patient").toLocked();
    @SearchParamDefinition(name="factor-override", path="ChargeItem.factorOverride", description="Factor overriding the associated rules", type="number")
    public static final String SP_FACTOR_OVERRIDE = "factor-override";
    public static final NumberClientParam FACTOR_OVERRIDE = new NumberClientParam("factor-override");
    @SearchParamDefinition(name="service", path="ChargeItem.service", description="Which rendered service is being charged?", type="reference", target={DiagnosticReport.class, ImagingStudy.class, Immunization.class, MedicationAdministration.class, MedicationDispense.class, Observation.class, Procedure.class, SupplyDelivery.class})
    public static final String SP_SERVICE = "service";
    public static final ReferenceClientParam SERVICE = new ReferenceClientParam("service");
    public static final Include INCLUDE_SERVICE = new Include("ChargeItem:service").toLocked();
    @SearchParamDefinition(name="price-override", path="ChargeItem.priceOverride", description="Price overriding the associated rules", type="quantity")
    public static final String SP_PRICE_OVERRIDE = "price-override";
    public static final QuantityClientParam PRICE_OVERRIDE = new QuantityClientParam("price-override");
    @SearchParamDefinition(name="context", path="ChargeItem.context", description="Encounter / Episode associated with event", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("ChargeItem:context").toLocked();
    @SearchParamDefinition(name="enterer", path="ChargeItem.enterer", description="Individual who was entering", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("ChargeItem:enterer").toLocked();
    @SearchParamDefinition(name="account", path="ChargeItem.account", description="Account to place this charge", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("ChargeItem:account").toLocked();
    @SearchParamDefinition(name="requesting-organization", path="ChargeItem.requestingOrganization", description="Organization requesting the charged service", type="reference", target={Organization.class})
    public static final String SP_REQUESTING_ORGANIZATION = "requesting-organization";
    public static final ReferenceClientParam REQUESTING_ORGANIZATION = new ReferenceClientParam("requesting-organization");
    public static final Include INCLUDE_REQUESTING_ORGANIZATION = new Include("ChargeItem:requesting-organization").toLocked();

    public ChargeItem() {
    }

    public ChargeItem(Enumeration<ChargeItemStatus> status, CodeableConcept code, Reference subject) {
        this.status = status;
        this.code = code;
        this.subject = subject;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ChargeItem setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public List<UriType> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        return this.definition;
    }

    public ChargeItem setDefinition(List<UriType> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (UriType item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDefinitionElement() {
        UriType t = new UriType();
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return t;
    }

    public ChargeItem addDefinition(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return this;
    }

    public boolean hasDefinition(String value) {
        if (this.definition == null) {
            return false;
        }
        for (UriType v : this.definition) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ChargeItemStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ChargeItemStatus>(new ChargeItemStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ChargeItem setStatusElement(Enumeration<ChargeItemStatus> value) {
        this.status = value;
        return this;
    }

    public ChargeItemStatus getStatus() {
        return this.status == null ? null : (ChargeItemStatus)((Object)this.status.getValue());
    }

    public ChargeItem setStatus(ChargeItemStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ChargeItemStatus>(new ChargeItemStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public ChargeItem setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public ChargeItem addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ChargeItem setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ChargeItem setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ChargeItem setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public ChargeItem setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public ChargeItem setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public ChargeItem setOccurrence(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRFormatError("Not the right type for ChargeItem.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public List<ChargeItemParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<ChargeItemParticipantComponent>();
        }
        return this.participant;
    }

    public ChargeItem setParticipant(List<ChargeItemParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (ChargeItemParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ChargeItemParticipantComponent addParticipant() {
        ChargeItemParticipantComponent t = new ChargeItemParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<ChargeItemParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public ChargeItem addParticipant(ChargeItemParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<ChargeItemParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public ChargeItemParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Reference getPerformingOrganization() {
        if (this.performingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.performingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.performingOrganization = new Reference();
            }
        }
        return this.performingOrganization;
    }

    public boolean hasPerformingOrganization() {
        return this.performingOrganization != null && !this.performingOrganization.isEmpty();
    }

    public ChargeItem setPerformingOrganization(Reference value) {
        this.performingOrganization = value;
        return this;
    }

    public Organization getPerformingOrganizationTarget() {
        if (this.performingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.performingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.performingOrganizationTarget = new Organization();
            }
        }
        return this.performingOrganizationTarget;
    }

    public ChargeItem setPerformingOrganizationTarget(Organization value) {
        this.performingOrganizationTarget = value;
        return this;
    }

    public Reference getRequestingOrganization() {
        if (this.requestingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.requestingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestingOrganization = new Reference();
            }
        }
        return this.requestingOrganization;
    }

    public boolean hasRequestingOrganization() {
        return this.requestingOrganization != null && !this.requestingOrganization.isEmpty();
    }

    public ChargeItem setRequestingOrganization(Reference value) {
        this.requestingOrganization = value;
        return this;
    }

    public Organization getRequestingOrganizationTarget() {
        if (this.requestingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.requestingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestingOrganizationTarget = new Organization();
            }
        }
        return this.requestingOrganizationTarget;
    }

    public ChargeItem setRequestingOrganizationTarget(Organization value) {
        this.requestingOrganizationTarget = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public ChargeItem setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public List<CodeableConcept> getBodysite() {
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        return this.bodysite;
    }

    public ChargeItem setBodysite(List<CodeableConcept> theBodysite) {
        this.bodysite = theBodysite;
        return this;
    }

    public boolean hasBodysite() {
        if (this.bodysite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodysite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodysite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        this.bodysite.add(t);
        return t;
    }

    public ChargeItem addBodysite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodysite == null) {
            this.bodysite = new ArrayList<CodeableConcept>();
        }
        this.bodysite.add(t);
        return this;
    }

    public CodeableConcept getBodysiteFirstRep() {
        if (this.getBodysite().isEmpty()) {
            this.addBodysite();
        }
        return this.getBodysite().get(0);
    }

    public DecimalType getFactorOverrideElement() {
        if (this.factorOverride == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.factorOverride");
            }
            if (Configuration.doAutoCreate()) {
                this.factorOverride = new DecimalType();
            }
        }
        return this.factorOverride;
    }

    public boolean hasFactorOverrideElement() {
        return this.factorOverride != null && !this.factorOverride.isEmpty();
    }

    public boolean hasFactorOverride() {
        return this.factorOverride != null && !this.factorOverride.isEmpty();
    }

    public ChargeItem setFactorOverrideElement(DecimalType value) {
        this.factorOverride = value;
        return this;
    }

    public BigDecimal getFactorOverride() {
        return this.factorOverride == null ? null : (BigDecimal)this.factorOverride.getValue();
    }

    public ChargeItem setFactorOverride(BigDecimal value) {
        if (value == null) {
            this.factorOverride = null;
        } else {
            if (this.factorOverride == null) {
                this.factorOverride = new DecimalType();
            }
            this.factorOverride.setValue(value);
        }
        return this;
    }

    public ChargeItem setFactorOverride(long value) {
        this.factorOverride = new DecimalType();
        this.factorOverride.setValue(value);
        return this;
    }

    public ChargeItem setFactorOverride(double value) {
        this.factorOverride = new DecimalType();
        this.factorOverride.setValue(value);
        return this;
    }

    public Money getPriceOverride() {
        if (this.priceOverride == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.priceOverride");
            }
            if (Configuration.doAutoCreate()) {
                this.priceOverride = new Money();
            }
        }
        return this.priceOverride;
    }

    public boolean hasPriceOverride() {
        return this.priceOverride != null && !this.priceOverride.isEmpty();
    }

    public ChargeItem setPriceOverride(Money value) {
        this.priceOverride = value;
        return this;
    }

    public StringType getOverrideReasonElement() {
        if (this.overrideReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.overrideReason");
            }
            if (Configuration.doAutoCreate()) {
                this.overrideReason = new StringType();
            }
        }
        return this.overrideReason;
    }

    public boolean hasOverrideReasonElement() {
        return this.overrideReason != null && !this.overrideReason.isEmpty();
    }

    public boolean hasOverrideReason() {
        return this.overrideReason != null && !this.overrideReason.isEmpty();
    }

    public ChargeItem setOverrideReasonElement(StringType value) {
        this.overrideReason = value;
        return this;
    }

    public String getOverrideReason() {
        return this.overrideReason == null ? null : (String)this.overrideReason.getValue();
    }

    public ChargeItem setOverrideReason(String value) {
        if (Utilities.noString((String)value)) {
            this.overrideReason = null;
        } else {
            if (this.overrideReason == null) {
                this.overrideReason = new StringType();
            }
            this.overrideReason.setValue(value);
        }
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public ChargeItem setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Resource getEntererTarget() {
        return this.entererTarget;
    }

    public ChargeItem setEntererTarget(Resource value) {
        this.entererTarget = value;
        return this;
    }

    public DateTimeType getEnteredDateElement() {
        if (this.enteredDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ChargeItem.enteredDate");
            }
            if (Configuration.doAutoCreate()) {
                this.enteredDate = new DateTimeType();
            }
        }
        return this.enteredDate;
    }

    public boolean hasEnteredDateElement() {
        return this.enteredDate != null && !this.enteredDate.isEmpty();
    }

    public boolean hasEnteredDate() {
        return this.enteredDate != null && !this.enteredDate.isEmpty();
    }

    public ChargeItem setEnteredDateElement(DateTimeType value) {
        this.enteredDate = value;
        return this;
    }

    public Date getEnteredDate() {
        return this.enteredDate == null ? null : (Date)this.enteredDate.getValue();
    }

    public ChargeItem setEnteredDate(Date value) {
        if (value == null) {
            this.enteredDate = null;
        } else {
            if (this.enteredDate == null) {
                this.enteredDate = new DateTimeType();
            }
            this.enteredDate.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public ChargeItem setReason(List<CodeableConcept> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public ChargeItem addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableConcept getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Reference> getService() {
        if (this.service == null) {
            this.service = new ArrayList<Reference>();
        }
        return this.service;
    }

    public ChargeItem setService(List<Reference> theService) {
        this.service = theService;
        return this;
    }

    public boolean hasService() {
        if (this.service == null) {
            return false;
        }
        for (Reference item : this.service) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addService() {
        Reference t = new Reference();
        if (this.service == null) {
            this.service = new ArrayList<Reference>();
        }
        this.service.add(t);
        return t;
    }

    public ChargeItem addService(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.service == null) {
            this.service = new ArrayList<Reference>();
        }
        this.service.add(t);
        return this;
    }

    public Reference getServiceFirstRep() {
        if (this.getService().isEmpty()) {
            this.addService();
        }
        return this.getService().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public ChargeItem setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public ChargeItem addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ChargeItem setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ChargeItem addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public ChargeItem setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public ChargeItem addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this event performer or other systems.", 0, 1, this.identifier));
        children.add(new Property("definition", "uri", "References the source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("status", SP_CODE, "The current state of the ChargeItem.", 0, 1, this.status));
        children.add(new Property("partOf", "Reference(ChargeItem)", "ChargeItems can be grouped to larger ChargeItems covering the whole set.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that identifies the charge, like a billing code.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals the action is being or was performed on.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this event.", 0, 1, this.context));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence));
        children.add(new Property("participant", "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("performingOrganization", "Reference(Organization)", "The organization requesting the service.", 0, 1, this.performingOrganization));
        children.add(new Property("requestingOrganization", "Reference(Organization)", "The organization performing the service.", 0, 1, this.requestingOrganization));
        children.add(new Property(SP_QUANTITY, "Quantity", "Quantity of which the charge item has been serviced.", 0, 1, this.quantity));
        children.add(new Property("bodysite", "CodeableConcept", "The anatomical location where the related service has been applied.", 0, Integer.MAX_VALUE, this.bodysite));
        children.add(new Property("factorOverride", "decimal", "Factor overriding the factor determined by the rules associated with the code.", 0, 1, this.factorOverride));
        children.add(new Property("priceOverride", "Money", "Total price of the charge overriding the list price associated with the code.", 0, 1, this.priceOverride));
        children.add(new Property("overrideReason", "string", "If the list price or the rule based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.", 0, 1, this.overrideReason));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who entered the charge item.", 0, 1, this.enterer));
        children.add(new Property("enteredDate", "dateTime", "Date the charge item was entered.", 0, 1, this.enteredDate));
        children.add(new Property("reason", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_SERVICE, "Reference(DiagnosticReport|ImagingStudy|Immunization|MedicationAdministration|MedicationDispense|Observation|Procedure|SupplyDelivery)", "Indicated the rendered service that caused this charge.", 0, Integer.MAX_VALUE, this.service));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "Account into which this ChargeItems belongs.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("supportingInformation", "Reference(Any)", "Further information supporting the this charge.", 0, Integer.MAX_VALUE, this.supportingInformation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this event performer or other systems.", 0, 1, this.identifier);
            }
            case -1014418093: {
                return new Property("definition", "uri", "References the source of pricing information, rules of application for the code this ChargeItem uses.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -892481550: {
                return new Property("status", SP_CODE, "The current state of the ChargeItem.", 0, 1, this.status);
            }
            case -995410646: {
                return new Property("partOf", "Reference(ChargeItem)", "ChargeItems can be grouped to larger ChargeItems covering the whole set.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that identifies the charge, like a billing code.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals the action is being or was performed on.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this event.", 0, 1, this.context);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "Date/time(s) or duration when the charged service was applied.", 0, 1, this.occurrence);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 1273192628: {
                return new Property("performingOrganization", "Reference(Organization)", "The organization requesting the service.", 0, 1, this.performingOrganization);
            }
            case 1279054790: {
                return new Property("requestingOrganization", "Reference(Organization)", "The organization performing the service.", 0, 1, this.requestingOrganization);
            }
            case -1285004149: {
                return new Property(SP_QUANTITY, "Quantity", "Quantity of which the charge item has been serviced.", 0, 1, this.quantity);
            }
            case 1703573481: {
                return new Property("bodysite", "CodeableConcept", "The anatomical location where the related service has been applied.", 0, Integer.MAX_VALUE, this.bodysite);
            }
            case -451233221: {
                return new Property("factorOverride", "decimal", "Factor overriding the factor determined by the rules associated with the code.", 0, 1, this.factorOverride);
            }
            case -216803275: {
                return new Property("priceOverride", "Money", "Total price of the charge overriding the list price associated with the code.", 0, 1, this.priceOverride);
            }
            case -742878928: {
                return new Property("overrideReason", "string", "If the list price or the rule based factor associated with the code is overridden, this attribute can capture a text to indicate the  reason for this action.", 0, 1, this.overrideReason);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who entered the charge item.", 0, 1, this.enterer);
            }
            case 555978181: {
                return new Property("enteredDate", "dateTime", "Date the charge item was entered.", 0, 1, this.enteredDate);
            }
            case -934964668: {
                return new Property("reason", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1984153269: {
                return new Property(SP_SERVICE, "Reference(DiagnosticReport|ImagingStudy|Immunization|MedicationAdministration|MedicationDispense|Observation|Procedure|SupplyDelivery)", "Indicated the rendered service that caused this charge.", 0, Integer.MAX_VALUE, this.service);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "Account into which this ChargeItems belongs.", 0, Integer.MAX_VALUE, this.account);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Further information supporting the this charge.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 1273192628: {
                Base[] baseArray;
                if (this.performingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.performingOrganization;
                }
                return baseArray;
            }
            case 1279054790: {
                Base[] baseArray;
                if (this.requestingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestingOrganization;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.quantity;
                }
                return baseArray;
            }
            case 1703573481: {
                return this.bodysite == null ? new Base[]{} : this.bodysite.toArray(new Base[this.bodysite.size()]);
            }
            case -451233221: {
                Base[] baseArray;
                if (this.factorOverride == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.factorOverride;
                }
                return baseArray;
            }
            case -216803275: {
                Base[] baseArray;
                if (this.priceOverride == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.priceOverride;
                }
                return baseArray;
            }
            case -742878928: {
                Base[] baseArray;
                if (this.overrideReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.overrideReason;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.enterer;
                }
                return baseArray;
            }
            case 555978181: {
                Base[] baseArray;
                if (this.enteredDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.enteredDate;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1984153269: {
                return this.service == null ? new Base[]{} : this.service.toArray(new Base[this.service.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new ChargeItemStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((ChargeItemParticipantComponent)((Object)value));
                return value;
            }
            case 1273192628: {
                this.performingOrganization = this.castToReference(value);
                return value;
            }
            case 1279054790: {
                this.requestingOrganization = this.castToReference(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case 1703573481: {
                this.getBodysite().add(this.castToCodeableConcept(value));
                return value;
            }
            case -451233221: {
                this.factorOverride = this.castToDecimal(value);
                return value;
            }
            case -216803275: {
                this.priceOverride = this.castToMoney(value);
                return value;
            }
            case -742878928: {
                this.overrideReason = this.castToString(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case 555978181: {
                this.enteredDate = this.castToDateTime(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1984153269: {
                this.getService().add(this.castToReference(value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("definition")) {
            this.getDefinition().add(this.castToUri(value));
        } else if (name.equals("status")) {
            value = new ChargeItemStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((ChargeItemParticipantComponent)((Object)value));
        } else if (name.equals("performingOrganization")) {
            this.performingOrganization = this.castToReference(value);
        } else if (name.equals("requestingOrganization")) {
            this.requestingOrganization = this.castToReference(value);
        } else if (name.equals(SP_QUANTITY)) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("bodysite")) {
            this.getBodysite().add(this.castToCodeableConcept(value));
        } else if (name.equals("factorOverride")) {
            this.factorOverride = this.castToDecimal(value);
        } else if (name.equals("priceOverride")) {
            this.priceOverride = this.castToMoney(value);
        } else if (name.equals("overrideReason")) {
            this.overrideReason = this.castToString(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals("enteredDate")) {
            this.enteredDate = this.castToDateTime(value);
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SERVICE)) {
            this.getService().add(this.castToReference(value));
        } else if (name.equals(SP_ACCOUNT)) {
            this.getAccount().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -1014418093: {
                return this.addDefinitionElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 1273192628: {
                return this.getPerformingOrganization();
            }
            case 1279054790: {
                return this.getRequestingOrganization();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 1703573481: {
                return this.addBodysite();
            }
            case -451233221: {
                return this.getFactorOverrideElement();
            }
            case -216803275: {
                return this.getPriceOverride();
            }
            case -742878928: {
                return this.getOverrideReasonElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 555978181: {
                return this.getEnteredDateElement();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1984153269: {
                return this.addService();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case 767422259: {
                return new String[0];
            }
            case 1273192628: {
                return new String[]{"Reference"};
            }
            case 1279054790: {
                return new String[]{"Reference"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 1703573481: {
                return new String[]{"CodeableConcept"};
            }
            case -451233221: {
                return new String[]{"decimal"};
            }
            case -216803275: {
                return new String[]{"Money"};
            }
            case -742878928: {
                return new String[]{"string"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 555978181: {
                return new String[]{"dateTime"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case 1984153269: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a singleton property ChargeItem.definition");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property ChargeItem.status");
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("performingOrganization")) {
            this.performingOrganization = new Reference();
            return this.performingOrganization;
        }
        if (name.equals("requestingOrganization")) {
            this.requestingOrganization = new Reference();
            return this.requestingOrganization;
        }
        if (name.equals(SP_QUANTITY)) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("bodysite")) {
            return this.addBodysite();
        }
        if (name.equals("factorOverride")) {
            throw new FHIRException("Cannot call addChild on a singleton property ChargeItem.factorOverride");
        }
        if (name.equals("priceOverride")) {
            this.priceOverride = new Money();
            return this.priceOverride;
        }
        if (name.equals("overrideReason")) {
            throw new FHIRException("Cannot call addChild on a singleton property ChargeItem.overrideReason");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("enteredDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ChargeItem.enteredDate");
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_SERVICE)) {
            return this.addService();
        }
        if (name.equals(SP_ACCOUNT)) {
            return this.addAccount();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ChargeItem";
    }

    @Override
    public ChargeItem copy() {
        ChargeItem dst = new ChargeItem();
        this.copyValues(dst);
        Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
        if (this.definition != null) {
            dst.definition = new ArrayList<UriType>();
            for (UriType uriType : this.definition) {
                dst.definition.add(uriType.copy());
            }
        }
        Enumeration<ChargeItemStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        Type type = dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<ChargeItemParticipantComponent>();
            for (ChargeItemParticipantComponent chargeItemParticipantComponent : this.participant) {
                dst.participant.add(chargeItemParticipantComponent.copy());
            }
        }
        dst.performingOrganization = this.performingOrganization == null ? null : this.performingOrganization.copy();
        dst.requestingOrganization = this.requestingOrganization == null ? null : this.requestingOrganization.copy();
        Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.bodysite != null) {
            dst.bodysite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodysite) {
                dst.bodysite.add(codeableConcept.copy());
            }
        }
        dst.factorOverride = this.factorOverride == null ? null : this.factorOverride.copy();
        dst.priceOverride = this.priceOverride == null ? null : this.priceOverride.copy();
        dst.overrideReason = this.overrideReason == null ? null : this.overrideReason.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        DateTimeType dateTimeType = dst.enteredDate = this.enteredDate == null ? null : this.enteredDate.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        if (this.service != null) {
            dst.service = new ArrayList<Reference>();
            for (Reference reference : this.service) {
                dst.service.add(reference.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference : this.account) {
                dst.account.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
        return dst;
    }

    protected ChargeItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItem)) {
            return false;
        }
        ChargeItem o = (ChargeItem)other_;
        return ChargeItem.compareDeep(this.identifier, o.identifier, true) && ChargeItem.compareDeep(this.definition, o.definition, true) && ChargeItem.compareDeep(this.status, o.status, true) && ChargeItem.compareDeep(this.partOf, o.partOf, true) && ChargeItem.compareDeep(this.code, o.code, true) && ChargeItem.compareDeep(this.subject, o.subject, true) && ChargeItem.compareDeep(this.context, o.context, true) && ChargeItem.compareDeep(this.occurrence, o.occurrence, true) && ChargeItem.compareDeep(this.participant, o.participant, true) && ChargeItem.compareDeep(this.performingOrganization, o.performingOrganization, true) && ChargeItem.compareDeep(this.requestingOrganization, o.requestingOrganization, true) && ChargeItem.compareDeep(this.quantity, o.quantity, true) && ChargeItem.compareDeep(this.bodysite, o.bodysite, true) && ChargeItem.compareDeep(this.factorOverride, o.factorOverride, true) && ChargeItem.compareDeep(this.priceOverride, o.priceOverride, true) && ChargeItem.compareDeep(this.overrideReason, o.overrideReason, true) && ChargeItem.compareDeep(this.enterer, o.enterer, true) && ChargeItem.compareDeep(this.enteredDate, o.enteredDate, true) && ChargeItem.compareDeep(this.reason, o.reason, true) && ChargeItem.compareDeep(this.service, o.service, true) && ChargeItem.compareDeep(this.account, o.account, true) && ChargeItem.compareDeep(this.note, o.note, true) && ChargeItem.compareDeep(this.supportingInformation, o.supportingInformation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ChargeItem)) {
            return false;
        }
        ChargeItem o = (ChargeItem)other_;
        return ChargeItem.compareValues(this.definition, o.definition, true) && ChargeItem.compareValues(this.status, o.status, true) && ChargeItem.compareValues(this.factorOverride, o.factorOverride, true) && ChargeItem.compareValues(this.overrideReason, o.overrideReason, true) && ChargeItem.compareValues(this.enteredDate, o.enteredDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.status, this.partOf, this.code, this.subject, this.context, this.occurrence, this.participant, this.performingOrganization, this.requestingOrganization, this.quantity, this.bodysite, this.factorOverride, this.priceOverride, this.overrideReason, this.enterer, this.enteredDate, this.reason, this.service, this.account, this.note, this.supportingInformation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ChargeItem;
    }

    public static class ChargeItemStatusEnumFactory
    implements EnumFactory<ChargeItemStatus> {
        @Override
        public ChargeItemStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return ChargeItemStatus.PLANNED;
            }
            if ("billable".equals(codeString)) {
                return ChargeItemStatus.BILLABLE;
            }
            if ("not-billable".equals(codeString)) {
                return ChargeItemStatus.NOTBILLABLE;
            }
            if ("aborted".equals(codeString)) {
                return ChargeItemStatus.ABORTED;
            }
            if ("billed".equals(codeString)) {
                return ChargeItemStatus.BILLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ChargeItemStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ChargeItemStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        public Enumeration<ChargeItemStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ChargeItemStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.PLANNED);
            }
            if ("billable".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.BILLABLE);
            }
            if ("not-billable".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.NOTBILLABLE);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.ABORTED);
            }
            if ("billed".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.BILLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ChargeItemStatus>(this, ChargeItemStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ChargeItemStatus code) {
            if (code == ChargeItemStatus.NULL) {
                return null;
            }
            if (code == ChargeItemStatus.PLANNED) {
                return "planned";
            }
            if (code == ChargeItemStatus.BILLABLE) {
                return "billable";
            }
            if (code == ChargeItemStatus.NOTBILLABLE) {
                return "not-billable";
            }
            if (code == ChargeItemStatus.ABORTED) {
                return "aborted";
            }
            if (code == ChargeItemStatus.BILLED) {
                return "billed";
            }
            if (code == ChargeItemStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ChargeItemStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ChargeItemStatus code) {
            return code.getSystem();
        }
    }

    public static enum ChargeItemStatus {
        PLANNED,
        BILLABLE,
        NOTBILLABLE,
        ABORTED,
        BILLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ChargeItemStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("billable".equals(codeString)) {
                return BILLABLE;
            }
            if ("not-billable".equals(codeString)) {
                return NOTBILLABLE;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("billed".equals(codeString)) {
                return BILLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ChargeItemStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case BILLABLE: {
                    return "billable";
                }
                case NOTBILLABLE: {
                    return "not-billable";
                }
                case ABORTED: {
                    return "aborted";
                }
                case BILLED: {
                    return "billed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case BILLABLE: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case NOTBILLABLE: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case BILLED: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/chargeitem-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The charge item has been entered, but the charged service is not  yet complete, so it shall not be billed yet but might be used in the context of pre-authorization";
                }
                case BILLABLE: {
                    return "The charge item is ready for billing";
                }
                case NOTBILLABLE: {
                    return "The charge item has been determined to be not billable (e.g. due to rules associated with the billing code)";
                }
                case ABORTED: {
                    return "The processing of the charge was aborted";
                }
                case BILLED: {
                    return "The charge item has been billed (e.g. a billing engine has generated financial transactions by applying the associated ruled for the charge item to the context of the Encounter, and placed them into Claims/Invoices";
                }
                case ENTEREDINERROR: {
                    return "The charge item has been entered in error and should not be processed for billing";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this charge item  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case BILLABLE: {
                    return "Billable";
                }
                case NOTBILLABLE: {
                    return "Not billable";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case BILLED: {
                    return "Billed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ChargeItemParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type of performance was done", formalDefinition="Describes the type of performance or participation(e.g. primary surgeon, anaesthesiologiest, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept role;
        @Child(name="actor", type={Practitioner.class, Organization.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was performing", formalDefinition="The device, practitioner, etc. who performed or participated in the service.")
        protected Reference actor;
        protected Resource actorTarget;
        private static final long serialVersionUID = 805521719L;

        public ChargeItemParticipantComponent() {
        }

        public ChargeItemParticipantComponent(Reference actor) {
            this.actor = actor;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ChargeItemParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ChargeItemParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ChargeItemParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public ChargeItemParticipantComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Describes the type of performance or participation(e.g. primary surgeon, anaesthesiologiest, etc.).", 0, 1, this.role));
            children.add(new Property("actor", "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Describes the type of performance or participation(e.g. primary surgeon, anaesthesiologiest, etc.).", 0, 1, this.role);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|Organization|Patient|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ChargeItemParticipantComponent copy() {
            ChargeItemParticipantComponent dst = new ChargeItemParticipantComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemParticipantComponent)) {
                return false;
            }
            ChargeItemParticipantComponent o = (ChargeItemParticipantComponent)other_;
            return ChargeItemParticipantComponent.compareDeep(this.role, o.role, true) && ChargeItemParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ChargeItemParticipantComponent)) {
                return false;
            }
            ChargeItemParticipantComponent o = (ChargeItemParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.actor});
        }

        @Override
        public String fhirType() {
            return "ChargeItem.participant";
        }
    }
}

