/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ContractType;

public class ContractTypeEnumFactory
implements EnumFactory<ContractType> {
    @Override
    public ContractType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("privacy".equals(codeString)) {
            return ContractType.PRIVACY;
        }
        if ("disclosure".equals(codeString)) {
            return ContractType.DISCLOSURE;
        }
        if ("healthinsurance".equals(codeString)) {
            return ContractType.HEALTHINSURANCE;
        }
        if ("supply".equals(codeString)) {
            return ContractType.SUPPLY;
        }
        if ("consent".equals(codeString)) {
            return ContractType.CONSENT;
        }
        throw new IllegalArgumentException("Unknown ContractType code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractType code) {
        if (code == ContractType.NULL) {
            return null;
        }
        if (code == ContractType.PRIVACY) {
            return "privacy";
        }
        if (code == ContractType.DISCLOSURE) {
            return "disclosure";
        }
        if (code == ContractType.HEALTHINSURANCE) {
            return "healthinsurance";
        }
        if (code == ContractType.SUPPLY) {
            return "supply";
        }
        if (code == ContractType.CONSENT) {
            return "consent";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractType code) {
        return code.getSystem();
    }
}

