/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CqifTriggerType;

public class CqifTriggerTypeEnumFactory
implements EnumFactory<CqifTriggerType> {
    @Override
    public CqifTriggerType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("named-event".equals(codeString)) {
            return CqifTriggerType.NAMEDEVENT;
        }
        if ("periodic".equals(codeString)) {
            return CqifTriggerType.PERIODIC;
        }
        if ("data-added".equals(codeString)) {
            return CqifTriggerType.DATAADDED;
        }
        if ("data-modified".equals(codeString)) {
            return CqifTriggerType.DATAMODIFIED;
        }
        if ("data-removed".equals(codeString)) {
            return CqifTriggerType.DATAREMOVED;
        }
        if ("data-accessed".equals(codeString)) {
            return CqifTriggerType.DATAACCESSED;
        }
        if ("data-access-ended".equals(codeString)) {
            return CqifTriggerType.DATAACCESSENDED;
        }
        throw new IllegalArgumentException("Unknown CqifTriggerType code '" + codeString + "'");
    }

    @Override
    public String toCode(CqifTriggerType code) {
        if (code == CqifTriggerType.NULL) {
            return null;
        }
        if (code == CqifTriggerType.NAMEDEVENT) {
            return "named-event";
        }
        if (code == CqifTriggerType.PERIODIC) {
            return "periodic";
        }
        if (code == CqifTriggerType.DATAADDED) {
            return "data-added";
        }
        if (code == CqifTriggerType.DATAMODIFIED) {
            return "data-modified";
        }
        if (code == CqifTriggerType.DATAREMOVED) {
            return "data-removed";
        }
        if (code == CqifTriggerType.DATAACCESSED) {
            return "data-accessed";
        }
        if (code == CqifTriggerType.DATAACCESSENDED) {
            return "data-access-ended";
        }
        return "?";
    }

    @Override
    public String toSystem(CqifTriggerType code) {
        return code.getSystem();
    }
}

