/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.ListStatus;

public class ListStatusEnumFactory
implements EnumFactory<ListStatus> {
    @Override
    public ListStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("current".equals(codeString)) {
            return ListStatus.CURRENT;
        }
        if ("retired".equals(codeString)) {
            return ListStatus.RETIRED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ListStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown ListStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ListStatus code) {
        if (code == ListStatus.NULL) {
            return null;
        }
        if (code == ListStatus.CURRENT) {
            return "current";
        }
        if (code == ListStatus.RETIRED) {
            return "retired";
        }
        if (code == ListStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(ListStatus code) {
        return code.getSystem();
    }
}

