/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.XdsRelationshipType;

public class XdsRelationshipTypeEnumFactory
implements EnumFactory<XdsRelationshipType> {
    @Override
    public XdsRelationshipType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("APND".equals(codeString)) {
            return XdsRelationshipType.APND;
        }
        if ("RPLC".equals(codeString)) {
            return XdsRelationshipType.RPLC;
        }
        if ("XFRM".equals(codeString)) {
            return XdsRelationshipType.XFRM;
        }
        if ("XFRM_RPLC".equals(codeString)) {
            return XdsRelationshipType.XFRMRPLC;
        }
        if ("signs".equals(codeString)) {
            return XdsRelationshipType.SIGNS;
        }
        throw new IllegalArgumentException("Unknown XdsRelationshipType code '" + codeString + "'");
    }

    @Override
    public String toCode(XdsRelationshipType code) {
        if (code == XdsRelationshipType.NULL) {
            return null;
        }
        if (code == XdsRelationshipType.APND) {
            return "APND";
        }
        if (code == XdsRelationshipType.RPLC) {
            return "RPLC";
        }
        if (code == XdsRelationshipType.XFRM) {
            return "XFRM";
        }
        if (code == XdsRelationshipType.XFRMRPLC) {
            return "XFRM_RPLC";
        }
        if (code == XdsRelationshipType.SIGNS) {
            return "signs";
        }
        return "?";
    }

    @Override
    public String toSystem(XdsRelationshipType code) {
        return code.getSystem();
    }
}

