/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;

@Deprecated
public class QuestionnaireBuilder {
    private static final int MaxListboxCodings = 20;
    private IWorkerContext context;
    private int lastid = 0;
    private Resource resource;
    private StructureDefinition profile;
    private Questionnaire questionnaire;
    private QuestionnaireResponse response;
    private String questionnaireId;
    private Factory factory = new Factory();
    private Map<String, String> vsCache = new HashMap<String, String>();
    private ValueSetExpander expander;
    private Questionnaire prebuiltQuestionnaire;

    public QuestionnaireBuilder(IWorkerContext context) {
        this.context = context;
    }

    public Resource getReference() {
        return this.resource;
    }

    public void setReference(Resource resource) {
        this.resource = resource;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public void setProfile(StructureDefinition profile) {
        this.profile = profile;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public QuestionnaireResponse getResponse() {
        return this.response;
    }

    public void setResponse(QuestionnaireResponse response) {
        this.response = response;
    }

    public String getQuestionnaireId() {
        return this.questionnaireId;
    }

    public void setQuestionnaireId(String questionnaireId) {
        this.questionnaireId = questionnaireId;
    }

    public Questionnaire getPrebuiltQuestionnaire() {
        return this.prebuiltQuestionnaire;
    }

    public void setPrebuiltQuestionnaire(Questionnaire prebuiltQuestionnaire) {
        this.prebuiltQuestionnaire = prebuiltQuestionnaire;
    }

    public ValueSetExpander getExpander() {
        return this.expander;
    }

    public void setExpander(ValueSetExpander expander) {
        this.expander = expander;
    }

    public void build() throws FHIRException {
        if (this.profile == null) {
            throw new DefinitionException("QuestionnaireBuilder.build: no profile found");
        }
        if (this.resource != null && !this.profile.getType().equals(this.resource.getResourceType().toString())) {
            throw new DefinitionException("Wrong Type");
        }
        this.questionnaire = this.prebuiltQuestionnaire != null ? this.prebuiltQuestionnaire : new Questionnaire();
        if (this.resource != null) {
            this.response = new QuestionnaireResponse();
        }
        this.processMetadata();
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
        if (this.resource != null) {
            answerGroups.addAll(this.response.getItem());
        }
        if (this.prebuiltQuestionnaire != null) {
            Questionnaire.QuestionnaireItemComponent group = new Questionnaire.QuestionnaireItemComponent();
            group.setType(Questionnaire.QuestionnaireItemType.GROUP);
            this.buildGroup(group, this.profile, this.profile.getSnapshot().getElement().get(0), list, answerGroups);
        } else {
            this.buildGroup(this.questionnaire.getItem().get(0), this.profile, this.profile.getSnapshot().getElement().get(0), list, answerGroups);
        }
    }

    private void processMetadata() {
        BackboneElement item;
        if (this.prebuiltQuestionnaire == null) {
            this.questionnaire.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue(this.questionnaireId);
            this.questionnaire.setVersion(this.profile.getVersion());
            this.questionnaire.setStatus(this.profile.getStatus());
            this.questionnaire.setDate(this.profile.getDate());
            this.questionnaire.setPublisher(this.profile.getPublisher());
            item = new Questionnaire.QuestionnaireItemComponent();
            this.questionnaire.addItem((Questionnaire.QuestionnaireItemComponent)item);
            ((Questionnaire.QuestionnaireItemComponent)item).getCode().addAll(this.profile.getKeyword());
            this.questionnaire.setId(this.nextId("qs"));
        }
        if (this.response != null) {
            this.response.setQuestionnaire(Factory.makeReference("#" + this.questionnaire.getId()));
            this.response.getContained().add(this.questionnaire);
            this.response.setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
            item = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
            this.response.addItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item);
            item.setUserData("object", this.resource);
        }
    }

    private String nextId(String prefix) {
        ++this.lastid;
        return prefix + Integer.toString(this.lastid);
    }

    private void buildGroup(Questionnaire.QuestionnaireItemComponent group, StructureDefinition profile, ElementDefinition element, List<ElementDefinition> parents, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        group.setLinkId(element.getPath());
        group.setText(element.getShort());
        if (element.getComment() != null) {
            Questionnaire.QuestionnaireItemComponent display = new Questionnaire.QuestionnaireItemComponent();
            display.setType(Questionnaire.QuestionnaireItemType.DISPLAY);
            display.setText(element.getComment());
            group.addItem(display);
        }
        group.setType(Questionnaire.QuestionnaireItemType.GROUP);
        ToolingExtensions.addFlyOver(group, element.getDefinition());
        group.setRequired(element.getMin() > 0);
        if (element.getMin() > 0) {
            ToolingExtensions.addMin(group, element.getMin());
        }
        group.setRepeats(!element.getMax().equals("1"));
        if (!element.getMax().equals("*")) {
            ToolingExtensions.addMax(group, Integer.parseInt(element.getMax()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setLinkId(group.getLinkId());
            ag.setText(group.getText());
        }
        List<ElementDefinition> list = ProfileUtilities.getChildList(profile, element);
        for (ElementDefinition child : list) {
            if (this.isExempt(element, child) || parents.contains(child)) continue;
            ArrayList<ElementDefinition> nparents = new ArrayList<ElementDefinition>();
            nparents.addAll(parents);
            nparents.add(child);
            Questionnaire.QuestionnaireItemComponent childGroup = group.addItem();
            childGroup.setType(Questionnaire.QuestionnaireItemType.GROUP);
            ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> nResponse = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
            this.processExisting(child.getPath(), answerGroups, nResponse);
            if (child.getType().isEmpty() || this.isAbstractType(child.getType())) {
                this.buildGroup(childGroup, profile, child, nparents, nResponse);
                continue;
            }
            if (this.isInlineDataType(child.getType())) {
                this.buildGroup(childGroup, profile, child, nparents, nResponse);
                continue;
            }
            this.buildQuestion(childGroup, profile, child, child.getPath(), nResponse);
        }
    }

    private boolean isAbstractType(List<ElementDefinition.TypeRefComponent> type) {
        return type.size() == 1 && (type.get(0).getCode().equals("Element") || type.get(0).getCode().equals("BackboneElement"));
    }

    private boolean isInlineDataType(List<ElementDefinition.TypeRefComponent> type) {
        return type.size() == 1 && !Utilities.existsInList((String)type.get(0).getCode(), (String[])new String[]{"code", "string", "id", "oid", "markdown", "uri", "boolean", "decimal", "dateTime", "date", "instant", "time", "CodeableConcept", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Identifier", "integer", "positiveInt", "unsignedInt", "Coding", "Quantity", "Count", "Age", "Duration", "Distance", "Money", "Money", "Reference", "Duration", "base64Binary", "Attachment", "Age", "Range", "Timing", "Annotation", "SampledData", "Extension", "SampledData", "Narrative", "Resource", "Meta"});
    }

    private boolean isExempt(ElementDefinition element, ElementDefinition child) {
        String n = this.tail(child.getPath());
        String t = "";
        if (!element.getType().isEmpty()) {
            t = element.getType().get(0).getCode();
        }
        if (t.equals("Resource") && (n.equals("text") || n.equals("language") || n.equals("contained"))) {
            return true;
        }
        if (n.equals("extension") || n.equals("modifierExtension")) {
            return child.getType().size() <= 0 || child.getType().get(0).hasProfile();
        }
        return false;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    private void processExisting(String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> nResponse) throws FHIRException {
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            List<Base> children = ((Element)ag.getUserData("object")).listChildrenByName(this.tail(path));
            for (Base child : children) {
                if (child == null) continue;
                QuestionnaireResponse.QuestionnaireResponseItemComponent ans = ag.addItem();
                ans.setUserData("object", child);
                nResponse.add(ans);
            }
        }
    }

    private void buildQuestion(Questionnaire.QuestionnaireItemComponent group, StructureDefinition profile, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        group.setLinkId(path);
        group.setText(element.getShort());
        group.setRequired(element.getMin() > 0);
        if (element.getMin() > 0) {
            ToolingExtensions.addMin(group, element.getMin());
        }
        group.setRepeats(!element.getMax().equals(Character.valueOf('1')));
        if (!element.getMax().equals("*")) {
            ToolingExtensions.addMax(group, Integer.parseInt(element.getMax()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setLinkId(group.getLinkId());
            ag.setText(group.getText());
        }
        if (!Utilities.noString((String)element.getComment())) {
            ToolingExtensions.addFlyOver(group, element.getDefinition() + " " + element.getComment());
        } else {
            ToolingExtensions.addFlyOver(group, element.getDefinition());
        }
        if (element.getType().size() > 1 || element.getType().get(0).getCode().equals("*")) {
            List<ElementDefinition.TypeRefComponent> types = this.expandTypeList(element.getType());
            Questionnaire.QuestionnaireItemComponent q = this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, element.getPath(), "_type", "type", null, this.makeTypeList(profile, types, element.getPath()));
            for (ElementDefinition.TypeRefComponent t : types) {
                Questionnaire.QuestionnaireItemComponent sub = q.addItem();
                sub.setType(Questionnaire.QuestionnaireItemType.GROUP);
                sub.setLinkId(element.getPath() + "._" + String.valueOf(t.getUserData("text")));
                sub.setText((String)t.getUserData("text"));
                ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> selected = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
                this.selectTypes(profile, sub, t, answerGroups, selected);
                this.processDataType(profile, sub, element, element.getPath() + "._" + String.valueOf(t.getUserData("text")), t, selected);
            }
        } else {
            this.processDataType(profile, group, element, element.getPath(), element.getType().get(0), answerGroups);
        }
    }

    private List<ElementDefinition.TypeRefComponent> expandTypeList(List<ElementDefinition.TypeRefComponent> types) {
        ArrayList<ElementDefinition.TypeRefComponent> result = new ArrayList<ElementDefinition.TypeRefComponent>();
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.hasProfile()) {
                result.add(t);
                continue;
            }
            if (t.getCode().equals("*")) {
                result.add(new ElementDefinition.TypeRefComponent().setCode("integer"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("decimal"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("dateTime"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("date"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("instant"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("time"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("string"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("uri"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("boolean"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Coding"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("CodeableConcept"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Attachment"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Identifier"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Quantity"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Range"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Period"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Ratio"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("HumanName"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Address"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("ContactPoint"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Timing"));
                result.add(new ElementDefinition.TypeRefComponent().setCode("Reference"));
                continue;
            }
            result.add(t);
        }
        return result;
    }

    private ValueSet makeTypeList(StructureDefinition profile, List<ElementDefinition.TypeRefComponent> types, String path) {
        ValueSet vs = new ValueSet();
        vs.setName("Type options for " + path);
        vs.setDescription(vs.getName());
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setExpansion(new ValueSet.ValueSetExpansionComponent());
        vs.getExpansion().setIdentifier(Factory.createUUID());
        vs.getExpansion().setTimestampElement(DateTimeType.now());
        for (ElementDefinition.TypeRefComponent t : types) {
            ValueSet.ValueSetExpansionContainsComponent cc = vs.getExpansion().addContains();
            if (t.getCode().equals("Reference") && t.hasTargetProfile() && t.getTargetProfile().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                cc.setCode(t.getTargetProfile().substring(40));
                cc.setSystem("http://hl7.org/fhir/resource-types");
                cc.setDisplay(cc.getCode());
            } else {
                ProfileUtilities pu = new ProfileUtilities(this.context, null, null);
                StructureDefinition ps = null;
                if (t.hasTargetProfile()) {
                    ps = pu.getProfile(profile, t.getTargetProfile());
                } else if (t.hasProfile()) {
                    ps = pu.getProfile(profile, t.getProfile());
                }
                if (ps != null) {
                    cc.setCode(t.getTargetProfile());
                    cc.setDisplay(ps.getType());
                    cc.setSystem("http://hl7.org/fhir/resource-types");
                } else {
                    cc.setCode(t.getCode());
                    cc.setDisplay(t.getCode());
                    cc.setSystem("http://hl7.org/fhir/data-types");
                }
            }
            t.setUserData("text", cc.getCode());
        }
        return vs;
    }

    private void selectTypes(StructureDefinition profile, Questionnaire.QuestionnaireItemComponent sub, ElementDefinition.TypeRefComponent t, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> source, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> dest) throws FHIRFormatError {
        ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> temp = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent g : source) {
            if (!this.instanceOf(t, (Element)g.getUserData("object"))) continue;
            temp.add(g);
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent g : temp) {
            source.remove(g);
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent g : temp) {
            assert (g.getItem().size() == 0);
            QuestionnaireResponse.QuestionnaireResponseItemComponent q = g.addItem();
            q.setLinkId(g.getLinkId() + "._type");
            q.setText("type");
            Coding cc = new Coding();
            QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent a = q.addAnswer();
            a.setValue(cc);
            if (t.getCode().equals("Reference") && t.hasTargetProfile() && t.getTargetProfile().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                cc.setCode(t.getTargetProfile().substring(40));
                cc.setSystem("http://hl7.org/fhir/resource-types");
            } else {
                ProfileUtilities pu = new ProfileUtilities(this.context, null, null);
                StructureDefinition ps = null;
                if (t.hasTargetProfile()) {
                    ps = pu.getProfile(profile, t.getTargetProfile());
                } else if (t.hasProfile()) {
                    ps = pu.getProfile(profile, t.getProfile());
                }
                if (ps != null) {
                    cc.setCode(t.getProfile());
                    cc.setSystem("http://hl7.org/fhir/resource-types");
                } else {
                    cc.setCode(t.getCode());
                    cc.setSystem("http://hl7.org/fhir/data-types");
                }
            }
            QuestionnaireResponse.QuestionnaireResponseItemComponent subg = a.addItem();
            dest.add(subg);
            subg.setLinkId(sub.getLinkId());
            subg.setText(sub.getText());
            subg.setUserData("object", g.getUserData("object"));
        }
    }

    private boolean instanceOf(ElementDefinition.TypeRefComponent t, Element obj) {
        if (t.getCode().equals("Reference")) {
            if (!(obj instanceof Reference)) {
                return false;
            }
            String url = ((Reference)obj).getReference();
            if (url.startsWith("http:") || url.startsWith("https:")) {
                return true;
            }
            if (t.hasProfile() && t.getProfile().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                return url.startsWith(t.getProfile().substring(40) + "/");
            }
            return true;
        }
        if (t.getCode().equals("Quantity")) {
            return obj instanceof Quantity;
        }
        throw new NotImplementedException("Not Done Yet");
    }

    private Questionnaire.QuestionnaireItemComponent addQuestion(Questionnaire.QuestionnaireItemComponent group, Questionnaire.QuestionnaireItemType af, String path, String id, String name, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        return this.addQuestion(group, af, path, id, name, answerGroups, null);
    }

    private Questionnaire.QuestionnaireItemComponent addQuestion(Questionnaire.QuestionnaireItemComponent group, Questionnaire.QuestionnaireItemType af, String path, String id, String name, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups, ValueSet vs) throws FHIRException {
        Questionnaire.QuestionnaireItemComponent result = group.addItem();
        if (vs != null) {
            result.setOptions(new Reference());
            if (vs.getExpansion() == null) {
                result.getOptions().setReference(vs.getUrl());
                ToolingExtensions.addControl(result, "lookup");
            } else {
                if (Utilities.noString((String)vs.getId())) {
                    vs.setId(this.nextId("vs"));
                    this.questionnaire.getContained().add(vs);
                    this.vsCache.put(vs.getUrl(), vs.getId());
                    vs.setText(null);
                    vs.setCompose(null);
                    vs.getContact().clear();
                    vs.setPublisherElement(null);
                    vs.setCopyrightElement(null);
                }
                result.getOptions().setReference("#" + vs.getId());
            }
        }
        result.setLinkId(path + "." + id);
        result.setText(name);
        result.setType(af);
        result.setRequired(false);
        result.setRepeats(false);
        if (id.endsWith("/1")) {
            id = id.substring(0, id.length() - 2);
        }
        if (answerGroups != null) {
            for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
                List<Object> children = new ArrayList<Element>();
                QuestionnaireResponse.QuestionnaireResponseItemComponent aq = null;
                Element obj = (Element)ag.getUserData("object");
                if (this.isPrimitive((ElementDefinition.TypeRefComponent)obj)) {
                    children.add(obj);
                } else if (obj instanceof Enumeration) {
                    String value = ((Enumeration)obj).toString();
                    children.add(new StringType(value));
                } else {
                    children = obj.listChildrenByName(id);
                }
                for (Base base : children) {
                    if (base == null) continue;
                    if (aq == null) {
                        aq = ag.addItem();
                        aq.setLinkId(result.getLinkId());
                        aq.setText(result.getText());
                    }
                    aq.addAnswer().setValue(this.convertType(base, af, vs, result.getLinkId()));
                }
            }
        }
        return result;
    }

    private Type convertType(Base value, Questionnaire.QuestionnaireItemType af, ValueSet vs, String path) throws FHIRException {
        switch (af) {
            case BOOLEAN: {
                if (value instanceof BooleanType) {
                    return (Type)value;
                }
            }
            case DECIMAL: {
                if (value instanceof DecimalType) {
                    return (Type)value;
                }
            }
            case INTEGER: {
                if (value instanceof IntegerType) {
                    return (Type)value;
                }
            }
            case DATE: {
                if (value instanceof DateType) {
                    return (Type)value;
                }
            }
            case DATETIME: {
                if (value instanceof DateTimeType) {
                    return (Type)value;
                }
            }
            case TIME: {
                if (value instanceof TimeType) {
                    return (Type)value;
                }
            }
            case STRING: {
                if (value instanceof StringType) {
                    return (Type)value;
                }
                if (value instanceof UriType) {
                    return new StringType(((UriType)value).asStringValue());
                }
            }
            case TEXT: {
                if (value instanceof StringType) {
                    return (Type)value;
                }
            }
            case QUANTITY: {
                if (value instanceof Quantity) {
                    return (Type)value;
                }
            }
            case CHOICE: 
            case OPENCHOICE: {
                if (value instanceof Coding) {
                    return (Type)value;
                }
                if (value instanceof Enumeration) {
                    Coding cc = new Coding();
                    cc.setCode(((Enumeration)value).asStringValue());
                    cc.setSystem(this.getSystemForCode(vs, cc.getCode(), path));
                    return cc;
                }
                if (value instanceof StringType) {
                    Coding cc = new Coding();
                    cc.setCode(((StringType)value).asStringValue());
                    cc.setSystem(this.getSystemForCode(vs, cc.getCode(), path));
                    return cc;
                }
            }
            case REFERENCE: {
                if (value instanceof Reference) {
                    return (Type)value;
                }
                if (!(value instanceof StringType)) break;
                Reference r = new Reference();
                r.setReference(((StringType)value).asStringValue());
            }
        }
        throw new FHIRException("Unable to convert from '" + value.getClass().toString() + "' for Answer Format " + af.toCode() + ", path = " + path);
    }

    private String getSystemForCode(ValueSet vs, String code, String path) throws FHIRException {
        String result = null;
        if (vs == null) {
            if (this.prebuiltQuestionnaire == null) {
                throw new FHIRException("Logic error at path = " + path);
            }
            for (Resource r : this.prebuiltQuestionnaire.getContained()) {
                if (!(r instanceof ValueSet) || !(vs = (ValueSet)r).hasExpansion()) continue;
                for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
                    if (!c.getCode().equals(code)) continue;
                    if (result == null) {
                        result = c.getSystem();
                        continue;
                    }
                    throw new FHIRException("Multiple matches in " + vs.getUrl() + " for code " + code + " at path = " + path);
                }
            }
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (!c.getCode().equals(code)) continue;
            if (result == null) {
                result = c.getSystem();
                continue;
            }
            throw new FHIRException("Multiple matches in " + vs.getUrl() + " for code " + code + " at path = " + path);
        }
        if (result != null) {
            return result;
        }
        throw new FHIRException("Unable to resolve code " + code + " at path = " + path);
    }

    private boolean isPrimitive(ElementDefinition.TypeRefComponent t) {
        String code = t.getCode();
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private void processDataType(StructureDefinition profile, Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, ElementDefinition.TypeRefComponent t, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        if (t.getCode().equals("code")) {
            this.addCodeQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("string") || t.getCode().equals("id") || t.getCode().equals("oid") || t.getCode().equals("markdown")) {
            this.addStringQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("uri")) {
            this.addUriQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("boolean")) {
            this.addBooleanQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("decimal")) {
            this.addDecimalQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("dateTime") || t.getCode().equals("date")) {
            this.addDateTimeQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("instant")) {
            this.addInstantQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("time")) {
            this.addTimeQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("CodeableConcept")) {
            this.addCodeableConceptQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Period")) {
            this.addPeriodQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Ratio")) {
            this.addRatioQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("HumanName")) {
            this.addHumanNameQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Address")) {
            this.addAddressQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("ContactPoint")) {
            this.addContactPointQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Identifier")) {
            this.addIdentifierQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("integer") || t.getCode().equals("positiveInt") || t.getCode().equals("unsignedInt")) {
            this.addIntegerQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Coding")) {
            this.addCodingQuestions(group, element, path, answerGroups);
        } else if (Utilities.existsInList((String)t.getCode(), (String[])new String[]{"Quantity", "Count", "Age", "Duration", "Distance", "Money"})) {
            this.addQuantityQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Money")) {
            this.addMoneyQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Reference")) {
            this.addReferenceQuestions(group, element, path, t.hasTargetProfile() ? t.getTargetProfile() : null, answerGroups);
        } else if (t.getCode().equals("Duration")) {
            this.addDurationQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("base64Binary")) {
            this.addBinaryQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Attachment")) {
            this.addAttachmentQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Age")) {
            this.addAgeQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Range")) {
            this.addRangeQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Timing")) {
            this.addTimingQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Annotation")) {
            this.addAnnotationQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("SampledData")) {
            this.addSampledDataQuestions(group, element, path, answerGroups);
        } else if (t.getCode().equals("Extension")) {
            if (t.hasProfile()) {
                this.addExtensionQuestions(profile, group, element, path, t.getProfile(), answerGroups);
            }
        } else if (t.getCode().equals("SampledData")) {
            this.addSampledDataQuestions(group, element, path, answerGroups);
        } else if (!(t.getCode().equals("Narrative") || t.getCode().equals("Resource") || t.getCode().equals("Meta") || t.getCode().equals("Signature"))) {
            throw new NotImplementedException("Unhandled Data Type: " + t.getCode() + " on element " + element.getPath());
        }
    }

    private void addCodeQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "code");
        ValueSet vs = this.resolveValueSet(null, element.hasBinding() ? element.getBinding() : null);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "value", this.unCamelCase(this.tail(element.getPath())), answerGroups, vs);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private String unCamelCase(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i))) {
                result.append(' ');
            }
            result.append(s.charAt(i));
        }
        return result.toString().toLowerCase();
    }

    private void addStringQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "string");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addTimeQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "time");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.TIME, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addUriQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "uri");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addBooleanQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "boolean");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.BOOLEAN, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addDecimalQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "decimal");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addIntegerQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "integer");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.INTEGER, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addDateTimeQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "datetime");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DATETIME, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addInstantQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "instant");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DATETIME, path, "value", group.getText(), answerGroups);
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addBinaryQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) {
        ToolingExtensions.addFhirType(group, "binary");
    }

    private Questionnaire.QuestionnaireItemType answerTypeForBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
        if (binding == null) {
            return Questionnaire.QuestionnaireItemType.OPENCHOICE;
        }
        if (binding.getStrength() != Enumerations.BindingStrength.REQUIRED) {
            return Questionnaire.QuestionnaireItemType.OPENCHOICE;
        }
        return Questionnaire.QuestionnaireItemType.CHOICE;
    }

    private void addCodingQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Coding");
        this.addQuestion(group, this.answerTypeForBinding(element.hasBinding() ? element.getBinding() : null), path, "value", group.getText(), answerGroups, this.resolveValueSet(null, element.hasBinding() ? element.getBinding() : null));
        group.setText(null);
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addCodeableConceptQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "CodeableConcept");
        this.addQuestion(group, this.answerTypeForBinding(element.hasBinding() ? element.getBinding() : null), path, "coding", "code:", answerGroups, this.resolveValueSet(null, element.hasBinding() ? element.getBinding() : null));
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "text", "text:", answerGroups);
    }

    private ValueSet makeAnyValueSet() {
        return null;
    }

    private void addPeriodQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Period");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DATETIME, path, "low", "start:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DATETIME, path, "end", "end:", answerGroups);
    }

    private void addRatioQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Ratio");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "numerator", "numerator:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "denominator", "denominator:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "units", "units:", answerGroups);
    }

    private void addHumanNameQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Name");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "text", "text:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "family", "family:", answerGroups).setRepeats(true);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "given", "given:", answerGroups).setRepeats(true);
    }

    private void addAddressQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Address");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "text", "text:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "line", "line:", answerGroups).setRepeats(true);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "city", "city:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "state", "state:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "postalCode", "post code:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "country", "country:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "use", "use:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/address-use"));
    }

    private void addContactPointQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "ContactPoint");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "system", "type:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/contact-point-system"));
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "use", "use:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/contact-point-use"));
    }

    private void addIdentifierQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Identifier");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "label", "label:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "system", "system:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "value", "value:", answerGroups);
    }

    private void addSimpleQuantityQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Quantity");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "units", "units:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "code", "coded units:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "system", "units system:", answerGroups);
    }

    private void addQuantityQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Quantity");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "comparator", "comp:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/quantity-comparator"));
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "units", "units:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "code", "coded units:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "system", "units system:", answerGroups);
    }

    private void addMoneyQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Money");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "currency", "currency:", answerGroups);
    }

    private void addAgeQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Age");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "comparator", "comp:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/quantity-comparator"));
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.CHOICE, path, "units", "units:", answerGroups, this.resolveValueSet("http://hl7.org/fhir/vs/duration-units"));
    }

    private void addDurationQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Duration");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "value", "value:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "units", "units:", answerGroups);
    }

    private void addAttachmentQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) {
        ToolingExtensions.addFhirType(group, "Attachment");
    }

    private void addRangeQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Range");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "low", "low:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DECIMAL, path, "high", "high:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "units", "units:", answerGroups);
    }

    private void addSampledDataQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) {
        ToolingExtensions.addFhirType(group, "SampledData");
    }

    private void addTimingQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Schedule");
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.STRING, path, "text", "text:", answerGroups);
        this.addQuestion(group, Questionnaire.QuestionnaireItemType.DATETIME, path, "date", "date:", answerGroups);
        Questionnaire.QuestionnaireItemComponent q = this.addQuestion(group, Questionnaire.QuestionnaireItemType.REFERENCE, path, "author", "author:", answerGroups);
        ToolingExtensions.addAllowedResource(q, "Patient");
        ToolingExtensions.addAllowedResource(q, "Practitioner");
        ToolingExtensions.addAllowedResource(q, "RelatedPerson");
    }

    private void addAnnotationQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) {
        ToolingExtensions.addFhirType(group, "Annotation");
    }

    private void addReferenceQuestions(Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, String profileURL, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        ToolingExtensions.addFhirType(group, "Reference");
        Questionnaire.QuestionnaireItemComponent q = this.addQuestion(group, Questionnaire.QuestionnaireItemType.REFERENCE, path, "value", group.getText(), answerGroups);
        group.setText(null);
        String rn = null;
        rn = profileURL != null && profileURL.startsWith("http://hl7.org/fhir/StructureDefinition/") ? profileURL.substring(40) : "Any";
        if (rn.equals("Any")) {
            ToolingExtensions.addReferenceFilter(q, "subject=$subj&patient=$subj&encounter=$encounter");
        } else {
            ToolingExtensions.addAllowedResource(q, rn);
            ToolingExtensions.addReferenceFilter(q, "subject=$subj&patient=$subj&encounter=$encounter");
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent ag : answerGroups) {
            ag.setText(null);
        }
    }

    private void addExtensionQuestions(StructureDefinition profile, Questionnaire.QuestionnaireItemComponent group, ElementDefinition element, String path, String url, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> answerGroups) throws FHIRException {
        StructureDefinition ed;
        if (!Utilities.noString((String)url) && (ed = this.context.fetchResource(StructureDefinition.class, url)) != null) {
            if (answerGroups.size() > 0) {
                throw new NotImplementedException("Debug this");
            }
            this.buildQuestion(group, profile, ed.getSnapshot().getElement().get(0), path + ".extension[" + url + "]", answerGroups);
        }
    }

    private ValueSet resolveValueSet(String url) {
        return null;
    }

    private ValueSet resolveValueSet(Object object, ElementDefinition.ElementDefinitionBindingComponent binding) {
        return null;
    }
}

