/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.formats;

import java.math.BigDecimal;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.dstu3.formats.FhirFormat;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.ParserBase;
import org.hl7.fhir.dstu3.formats.XmlParser;

public abstract class FormatUtilities {
    public static final String ID_REGEX = "[A-Za-z0-9\\-\\.]{1,64}";
    public static final String FHIR_NS = "http://hl7.org/fhir";
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    public static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";

    protected String toString(String value) {
        return value;
    }

    protected String toString(int value) {
        return Integer.toString(value);
    }

    protected String toString(boolean value) {
        return Boolean.toString(value);
    }

    protected String toString(BigDecimal value) {
        return value.toString();
    }

    protected String toString(URI value) {
        return value.toString();
    }

    public static String toString(byte[] value) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])value);
        return new String(encodeBase64);
    }

    public static boolean isValidId(String tail) {
        return tail.matches(ID_REGEX);
    }

    public static String makeId(String candidate) {
        StringBuilder b = new StringBuilder();
        for (char c : candidate.toCharArray()) {
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.') && c != '-') continue;
            b.append(c);
        }
        return b.toString();
    }

    public static ParserBase makeParser(FhirFormat format) {
        switch (format) {
            case XML: {
                return new XmlParser();
            }
            case JSON: {
                return new JsonParser();
            }
            case TURTLE: {
                throw new Error("unsupported Format " + format.toString());
            }
            case JSONLD: {
                throw new Error("unsupported Format " + format.toString());
            }
            case VBAR: {
                throw new Error("unsupported Format " + format.toString());
            }
            case TEXT: {
                throw new Error("unsupported Format " + format.toString());
            }
        }
        throw new Error("unsupported Format " + format.toString());
    }

    public static ParserBase makeParser(String format) {
        if ("XML".equalsIgnoreCase(format)) {
            return new XmlParser();
        }
        if ("JSON".equalsIgnoreCase(format)) {
            return new JsonParser();
        }
        if ("TURTLE".equalsIgnoreCase(format)) {
            throw new Error("unsupported Format " + format.toString());
        }
        if ("JSONLD".equalsIgnoreCase(format)) {
            throw new Error("unsupported Format " + format.toString());
        }
        if ("VBAR".equalsIgnoreCase(format)) {
            throw new Error("unsupported Format " + format.toString());
        }
        if ("TEXT".equalsIgnoreCase(format)) {
            throw new Error("unsupported Format " + format.toString());
        }
        throw new Error("unsupported Format " + format);
    }
}

