/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.formats;

import org.hl7.fhir.dstu3.formats.FhirFormat;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.RdfParser;
import org.hl7.fhir.dstu3.formats.XmlParser;

public class ParserFactory {
    public static IParser parser(FhirFormat format) {
        switch (format) {
            case JSON: {
                return new JsonParser();
            }
            case XML: {
                return new XmlParser();
            }
            case TURTLE: {
                return new RdfParser();
            }
        }
        throw new Error("Not supported at this time");
    }

    public static IParser parser(FhirFormat format, IParser.OutputStyle style) {
        switch (format) {
            case JSON: {
                return new JsonParser().setOutputStyle(style);
            }
            case XML: {
                return new XmlParser().setOutputStyle(style);
            }
            case TURTLE: {
                return new RdfParser().setOutputStyle(style);
            }
        }
        throw new Error("Not supported at this time");
    }
}

