/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ActivityDefinition", profile="http://hl7.org/fhir/Profile/ActivityDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "description", "purpose", "usage", "approvalDate", "lastReviewDate", "effectivePeriod", "useContext", "jurisdiction", "topic", "contributor", "contact", "copyright", "relatedArtifact", "library", "kind", "code", "timing[x]", "location", "participant", "product[x]", "quantity", "dosage", "bodySite", "transform", "dynamicValue"})
public class ActivityDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the activity definition", formalDefinition="A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this activity definition is defined", formalDefinition="Explaination of why this activity definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the asset", formalDefinition="A detailed description of how the asset is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="approvalDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity definition is expected to be used", formalDefinition="The period during which the activity definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc", formalDefinition="Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="contributor", type={Contributor.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A content contributor", formalDefinition="A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.")
    protected List<Contributor> contributor;
    @Child(name="copyright", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.")
    protected MarkdownType copyright;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={Library.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the asset", formalDefinition="A reference to a Library resource containing any formal logic used by the asset.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="kind", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Kind of resource", formalDefinition="A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ProcedureRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected Enumeration<ActivityDefinitionKind> kind;
    @Child(name="code", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected CodeableConcept code;
    @Child(name="timing", type={Timing.class, DateTimeType.class, Period.class, Range.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
    protected Type timing;
    @Child(name="location", type={Location.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="participant", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who should participate in the action", formalDefinition="Indicates who should participate in performing the action described.")
    protected List<ActivityDefinitionParticipantComponent> participant;
    @Child(name="product", type={Medication.class, Substance.class, CodeableConcept.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What's administered/supplied", formalDefinition="Identifies the food, drug or other product being consumed or supplied in the activity.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected Type product;
    @Child(name="quantity", type={SimpleQuantity.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How much is administered/consumed/supplied", formalDefinition="Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).")
    protected SimpleQuantity quantity;
    @Child(name="dosage", type={Dosage.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed dosage instructions", formalDefinition="Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.")
    protected List<Dosage> dosage;
    @Child(name="bodySite", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What part of body to perform on", formalDefinition="Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="transform", type={StructureMap.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Transform to apply the template", formalDefinition="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.")
    protected Reference transform;
    protected StructureMap transformTarget;
    @Child(name="dynamicValue", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the intent resource that would contain the result.")
    protected List<ActivityDefinitionDynamicValueComponent> dynamicValue;
    private static final long serialVersionUID = 1741931476L;
    @SearchParamDefinition(name="date", path="ActivityDefinition.date", description="The activity definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier", description="External identifier for the activity definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="ActivityDefinition.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("ActivityDefinition:successor").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction", description="Intended jurisdiction for the activity definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description", description="The description of the activity definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="ActivityDefinition.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ActivityDefinition:derived-from").toLocked();
    @SearchParamDefinition(name="predecessor", path="ActivityDefinition.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("ActivityDefinition:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="ActivityDefinition.title", description="The human-friendly name of the activity definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="ActivityDefinition.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("ActivityDefinition:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="ActivityDefinition.version", description="The business version of the activity definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url", description="The uri that identifies the activity definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="effective", path="ActivityDefinition.effectivePeriod", description="The time during which the activity definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="ActivityDefinition.relatedArtifact.where(type='depends-on').resource | ActivityDefinition.library", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("ActivityDefinition:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="ActivityDefinition.name", description="Computationally friendly name of the activity definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher", description="Name of the publisher of the activity definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="ActivityDefinition.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status", description="The current status of the activity definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ActivityDefinition() {
    }

    public ActivityDefinition(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ActivityDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ActivityDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ActivityDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ActivityDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ActivityDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ActivityDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ActivityDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ActivityDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ActivityDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ActivityDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ActivityDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ActivityDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ActivityDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ActivityDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ActivityDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ActivityDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ActivityDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ActivityDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ActivityDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ActivityDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ActivityDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ActivityDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public ActivityDefinition setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public ActivityDefinition setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ActivityDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ActivityDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ActivityDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ActivityDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ActivityDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ActivityDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ActivityDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public ActivityDefinition setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public ActivityDefinition addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<Contributor> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        return this.contributor;
    }

    public ActivityDefinition setContributor(List<Contributor> theContributor) {
        this.contributor = theContributor;
        return this;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (Contributor item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Contributor addContributor() {
        Contributor t = new Contributor();
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return t;
    }

    public ActivityDefinition addContributor(Contributor t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return this;
    }

    public Contributor getContributorFirstRep() {
        if (this.getContributor().isEmpty()) {
            this.addContributor();
        }
        return this.getContributor().get(0);
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ActivityDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ActivityDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ActivityDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ActivityDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ActivityDefinition addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public ActivityDefinition setLibrary(List<Reference> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public ActivityDefinition addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public Reference getLibraryFirstRep() {
        if (this.getLibrary().isEmpty()) {
            this.addLibrary();
        }
        return this.getLibrary().get(0);
    }

    public Enumeration<ActivityDefinitionKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<ActivityDefinitionKind>(new ActivityDefinitionKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public ActivityDefinition setKindElement(Enumeration<ActivityDefinitionKind> value) {
        this.kind = value;
        return this;
    }

    public ActivityDefinitionKind getKind() {
        return this.kind == null ? null : (ActivityDefinitionKind)((Object)this.kind.getValue());
    }

    public ActivityDefinition setKind(ActivityDefinitionKind value) {
        if (value == null) {
            this.kind = null;
        } else {
            if (this.kind == null) {
                this.kind = new Enumeration<ActivityDefinitionKind>(new ActivityDefinitionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ActivityDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this.timing instanceof Timing;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this.timing instanceof DateTimeType;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this.timing instanceof Period;
    }

    public Range getTimingRange() throws FHIRException {
        if (this.timing == null) {
            return null;
        }
        if (!(this.timing instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Range)this.timing;
    }

    public boolean hasTimingRange() {
        return this.timing instanceof Range;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public ActivityDefinition setTiming(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof Timing || value instanceof DateTimeType || value instanceof Period || value instanceof Range)) {
            throw new FHIRFormatError("Not the right type for ActivityDefinition.timing[x]: " + value.fhirType());
        }
        this.timing = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public ActivityDefinition setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public ActivityDefinition setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public List<ActivityDefinitionParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        return this.participant;
    }

    public ActivityDefinition setParticipant(List<ActivityDefinitionParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (ActivityDefinitionParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActivityDefinitionParticipantComponent addParticipant() {
        ActivityDefinitionParticipantComponent t = new ActivityDefinitionParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public ActivityDefinition addParticipant(ActivityDefinitionParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public ActivityDefinitionParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Type getProduct() {
        return this.product;
    }

    public Reference getProductReference() throws FHIRException {
        if (this.product == null) {
            return null;
        }
        if (!(this.product instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
        }
        return (Reference)this.product;
    }

    public boolean hasProductReference() {
        return this.product instanceof Reference;
    }

    public CodeableConcept getProductCodeableConcept() throws FHIRException {
        if (this.product == null) {
            return null;
        }
        if (!(this.product instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.product.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.product;
    }

    public boolean hasProductCodeableConcept() {
        return this.product instanceof CodeableConcept;
    }

    public boolean hasProduct() {
        return this.product != null && !this.product.isEmpty();
    }

    public ActivityDefinition setProduct(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
            throw new FHIRFormatError("Not the right type for ActivityDefinition.product[x]: " + value.fhirType());
        }
        this.product = value;
        return this;
    }

    public SimpleQuantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new SimpleQuantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public ActivityDefinition setQuantity(SimpleQuantity value) {
        this.quantity = value;
        return this;
    }

    public List<Dosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        return this.dosage;
    }

    public ActivityDefinition setDosage(List<Dosage> theDosage) {
        this.dosage = theDosage;
        return this;
    }

    public boolean hasDosage() {
        if (this.dosage == null) {
            return false;
        }
        for (Dosage item : this.dosage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosage() {
        Dosage t = new Dosage();
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return t;
    }

    public ActivityDefinition addDosage(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return this;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public ActivityDefinition setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public ActivityDefinition addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public Reference getTransform() {
        if (this.transform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.transform");
            }
            if (Configuration.doAutoCreate()) {
                this.transform = new Reference();
            }
        }
        return this.transform;
    }

    public boolean hasTransform() {
        return this.transform != null && !this.transform.isEmpty();
    }

    public ActivityDefinition setTransform(Reference value) {
        this.transform = value;
        return this;
    }

    public StructureMap getTransformTarget() {
        if (this.transformTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.transform");
            }
            if (Configuration.doAutoCreate()) {
                this.transformTarget = new StructureMap();
            }
        }
        return this.transformTarget;
    }

    public ActivityDefinition setTransformTarget(StructureMap value) {
        this.transformTarget = value;
        return this;
    }

    public List<ActivityDefinitionDynamicValueComponent> getDynamicValue() {
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        return this.dynamicValue;
    }

    public ActivityDefinition setDynamicValue(List<ActivityDefinitionDynamicValueComponent> theDynamicValue) {
        this.dynamicValue = theDynamicValue;
        return this;
    }

    public boolean hasDynamicValue() {
        if (this.dynamicValue == null) {
            return false;
        }
        for (ActivityDefinitionDynamicValueComponent item : this.dynamicValue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActivityDefinitionDynamicValueComponent addDynamicValue() {
        ActivityDefinitionDynamicValueComponent t = new ActivityDefinitionDynamicValueComponent();
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        this.dynamicValue.add(t);
        return t;
    }

    public ActivityDefinition addDynamicValue(ActivityDefinitionDynamicValueComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        this.dynamicValue.add(t);
        return this;
    }

    public ActivityDefinitionDynamicValueComponent getDynamicValueFirstRep() {
        if (this.getDynamicValue().isEmpty()) {
            this.addDynamicValue();
        }
        return this.getDynamicValue().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this activity definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this activity definition is (or will be) published. The URL SHOULD include the major version of the activity definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the activity definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the activity definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the activity definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the activity definition.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this activity definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this activity definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the activity definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the activity definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the activity definition.", 0, 1, this.publisher));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the activity definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("purpose", "markdown", "Explaination of why this activity definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description of how the asset is used from a clinical perspective.", 0, 1, this.usage));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the activity definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate activity definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the activity definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("contributor", "Contributor", "A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.", 0, 1, this.copyright));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "Reference(Library)", "A reference to a Library resource containing any formal logic used by the asset.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("kind", "code", "A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ProcedureRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.", 0, 1, this.kind));
        children.add(new Property("code", "CodeableConcept", "Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code));
        children.add(new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing));
        children.add(new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
        children.add(new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product));
        children.add(new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).", 0, 1, this.quantity));
        children.add(new Property("dosage", "Dosage", "Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.", 0, Integer.MAX_VALUE, this.dosage));
        children.add(new Property("bodySite", "CodeableConcept", "Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("transform", "Reference(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform));
        children.add(new Property("dynamicValue", "", "Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the intent resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this activity definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this activity definition is (or will be) published. The URL SHOULD include the major version of the activity definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the activity definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the activity definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the activity definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the activity definition.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this activity definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this activity definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the activity definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the activity definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the activity definition.", 0, 1, this.publisher);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the activity definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this activity definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description of how the asset is used from a clinical perspective.", 0, 1, this.usage);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the activity definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate activity definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the activity definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1895276325: {
                return new Property("contributor", "Contributor", "A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.", 0, 1, this.copyright);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "Reference(Library)", "A reference to a Library resource containing any formal logic used by the asset.", 0, Integer.MAX_VALUE, this.library);
            }
            case 3292052: {
                return new Property("kind", "code", "A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ProcedureRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.", 0, 1, this.kind);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code);
            }
            case 164632566: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -873664438: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -497554124: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -1837458939: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -615615829: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -710871277: {
                return new Property("timing[x]", "Timing|dateTime|Period|Range", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 1753005361: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -309474065: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -669667556: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case 906854066: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -1285004149: {
                return new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).", 0, 1, this.quantity);
            }
            case -1326018889: {
                return new Property("dosage", "Dosage", "Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.", 0, Integer.MAX_VALUE, this.dosage);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case 1052666732: {
                return new Property("transform", "Reference(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform);
            }
            case 572625010: {
                return new Property("dynamicValue", "", "Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the intent resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.usage;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.kind;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.code;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.timing;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.location;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -309474065: {
                Base[] baseArray;
                if (this.product == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.product;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.quantity;
                }
                return baseArray;
            }
            case -1326018889: {
                return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case 1052666732: {
                Base[] baseArray;
                if (this.transform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.transform;
                }
                return baseArray;
            }
            case 572625010: {
                return this.dynamicValue == null ? new Base[]{} : this.dynamicValue.toArray(new Base[this.dynamicValue.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1895276325: {
                this.getContributor().add(this.castToContributor(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                return value;
            }
            case 3292052: {
                value = new ActivityDefinitionKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToType(value);
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((ActivityDefinitionParticipantComponent)((Object)value));
                return value;
            }
            case -309474065: {
                this.product = this.castToType(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToSimpleQuantity(value);
                return value;
            }
            case -1326018889: {
                this.getDosage().add(this.castToDosage(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1052666732: {
                this.transform = this.castToReference(value);
                return value;
            }
            case 572625010: {
                this.getDynamicValue().add((ActivityDefinitionDynamicValueComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("contributor")) {
            this.getContributor().add(this.castToContributor(value));
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("kind")) {
            value = new ActivityDefinitionKindEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("timing[x]")) {
            this.timing = this.castToType(value);
        } else if (name.equals("location")) {
            this.location = this.castToReference(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((ActivityDefinitionParticipantComponent)((Object)value));
        } else if (name.equals("product[x]")) {
            this.product = this.castToType(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToSimpleQuantity(value);
        } else if (name.equals("dosage")) {
            this.getDosage().add(this.castToDosage(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("transform")) {
            this.transform = this.castToReference(value);
        } else if (name.equals("dynamicValue")) {
            this.getDynamicValue().add((ActivityDefinitionDynamicValueComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 1753005361: {
                return this.getProduct();
            }
            case -309474065: {
                return this.getProduct();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -1326018889: {
                return this.addDosage();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case 1052666732: {
                return this.getTransform();
            }
            case 572625010: {
                return this.addDynamicValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1895276325: {
                return new String[]{"Contributor"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"Reference"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -873664438: {
                return new String[]{"Timing", "dateTime", "Period", "Range"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -309474065: {
                return new String[]{"Reference", "CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"SimpleQuantity"};
            }
            case -1326018889: {
                return new String[]{"Dosage"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 1052666732: {
                return new String[]{"Reference"};
            }
            case 572625010: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.publisher");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.description");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.usage");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.copyright");
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.kind");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingRange")) {
            this.timing = new Range();
            return this.timing;
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("productReference")) {
            this.product = new Reference();
            return this.product;
        }
        if (name.equals("productCodeableConcept")) {
            this.product = new CodeableConcept();
            return this.product;
        }
        if (name.equals("quantity")) {
            this.quantity = new SimpleQuantity();
            return this.quantity;
        }
        if (name.equals("dosage")) {
            return this.addDosage();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("transform")) {
            this.transform = new Reference();
            return this.transform;
        }
        if (name.equals("dynamicValue")) {
            return this.addDynamicValue();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ActivityDefinition";
    }

    @Override
    public ActivityDefinition copy() {
        ActivityDefinition dst = new ActivityDefinition();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.publisher = this.publisher == null ? null : this.publisher.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.contributor != null) {
            dst.contributor = new ArrayList<Contributor>();
            for (Contributor contributor : this.contributor) {
                dst.contributor.add(contributor.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
            for (ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : this.participant) {
                dst.participant.add(activityDefinitionParticipantComponent.copy());
            }
        }
        dst.product = this.product == null ? null : this.product.copy();
        SimpleQuantity simpleQuantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.dosage != null) {
            dst.dosage = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosage) {
                dst.dosage.add(dosage.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        Reference reference2 = dst.transform = this.transform == null ? null : this.transform.copy();
        if (this.dynamicValue != null) {
            dst.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
            for (ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : this.dynamicValue) {
                dst.dynamicValue.add(activityDefinitionDynamicValueComponent.copy());
            }
        }
        return dst;
    }

    protected ActivityDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition o = (ActivityDefinition)other_;
        return ActivityDefinition.compareDeep(this.identifier, o.identifier, true) && ActivityDefinition.compareDeep(this.purpose, o.purpose, true) && ActivityDefinition.compareDeep(this.usage, o.usage, true) && ActivityDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ActivityDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ActivityDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ActivityDefinition.compareDeep(this.topic, o.topic, true) && ActivityDefinition.compareDeep(this.contributor, o.contributor, true) && ActivityDefinition.compareDeep(this.copyright, o.copyright, true) && ActivityDefinition.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ActivityDefinition.compareDeep(this.library, o.library, true) && ActivityDefinition.compareDeep(this.kind, o.kind, true) && ActivityDefinition.compareDeep(this.code, o.code, true) && ActivityDefinition.compareDeep(this.timing, o.timing, true) && ActivityDefinition.compareDeep(this.location, o.location, true) && ActivityDefinition.compareDeep(this.participant, o.participant, true) && ActivityDefinition.compareDeep(this.product, o.product, true) && ActivityDefinition.compareDeep(this.quantity, o.quantity, true) && ActivityDefinition.compareDeep(this.dosage, o.dosage, true) && ActivityDefinition.compareDeep(this.bodySite, o.bodySite, true) && ActivityDefinition.compareDeep(this.transform, o.transform, true) && ActivityDefinition.compareDeep(this.dynamicValue, o.dynamicValue, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition o = (ActivityDefinition)other_;
        return ActivityDefinition.compareValues(this.purpose, o.purpose, true) && ActivityDefinition.compareValues(this.usage, o.usage, true) && ActivityDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ActivityDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ActivityDefinition.compareValues(this.copyright, o.copyright, true) && ActivityDefinition.compareValues(this.kind, o.kind, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.purpose, this.usage, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.contributor, this.copyright, this.relatedArtifact, this.library, this.kind, this.code, this.timing, this.location, this.participant, this.product, this.quantity, this.dosage, this.bodySite, this.transform, this.dynamicValue});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ActivityDefinition;
    }

    public static class ActivityDefinitionKindEnumFactory
    implements EnumFactory<ActivityDefinitionKind> {
        @Override
        public ActivityDefinitionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return ActivityDefinitionKind.ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ActivityDefinitionKind.ACTIVITYDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return ActivityDefinitionKind.ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return ActivityDefinitionKind.ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return ActivityDefinitionKind.APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return ActivityDefinitionKind.APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return ActivityDefinitionKind.AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return ActivityDefinitionKind.BASIC;
            }
            if ("Binary".equals(codeString)) {
                return ActivityDefinitionKind.BINARY;
            }
            if ("BodySite".equals(codeString)) {
                return ActivityDefinitionKind.BODYSITE;
            }
            if ("Bundle".equals(codeString)) {
                return ActivityDefinitionKind.BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return ActivityDefinitionKind.CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return ActivityDefinitionKind.CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return ActivityDefinitionKind.CARETEAM;
            }
            if ("ChargeItem".equals(codeString)) {
                return ActivityDefinitionKind.CHARGEITEM;
            }
            if ("Claim".equals(codeString)) {
                return ActivityDefinitionKind.CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return ActivityDefinitionKind.CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return ActivityDefinitionKind.CLINICALIMPRESSION;
            }
            if ("CodeSystem".equals(codeString)) {
                return ActivityDefinitionKind.CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return ActivityDefinitionKind.COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return ActivityDefinitionKind.COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return ActivityDefinitionKind.COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return ActivityDefinitionKind.COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return ActivityDefinitionKind.CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return ActivityDefinitionKind.CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return ActivityDefinitionKind.CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return ActivityDefinitionKind.CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return ActivityDefinitionKind.COVERAGE;
            }
            if ("DataElement".equals(codeString)) {
                return ActivityDefinitionKind.DATAELEMENT;
            }
            if ("DetectedIssue".equals(codeString)) {
                return ActivityDefinitionKind.DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return ActivityDefinitionKind.DEVICE;
            }
            if ("DeviceComponent".equals(codeString)) {
                return ActivityDefinitionKind.DEVICECOMPONENT;
            }
            if ("DeviceMetric".equals(codeString)) {
                return ActivityDefinitionKind.DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return ActivityDefinitionKind.DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return ActivityDefinitionKind.DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return ActivityDefinitionKind.DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return ActivityDefinitionKind.DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return ActivityDefinitionKind.DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return ActivityDefinitionKind.DOMAINRESOURCE;
            }
            if ("EligibilityRequest".equals(codeString)) {
                return ActivityDefinitionKind.ELIGIBILITYREQUEST;
            }
            if ("EligibilityResponse".equals(codeString)) {
                return ActivityDefinitionKind.ELIGIBILITYRESPONSE;
            }
            if ("Encounter".equals(codeString)) {
                return ActivityDefinitionKind.ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return ActivityDefinitionKind.ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ActivityDefinitionKind.ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return ActivityDefinitionKind.ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return ActivityDefinitionKind.EPISODEOFCARE;
            }
            if ("ExpansionProfile".equals(codeString)) {
                return ActivityDefinitionKind.EXPANSIONPROFILE;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return ActivityDefinitionKind.EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return ActivityDefinitionKind.FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return ActivityDefinitionKind.FLAG;
            }
            if ("Goal".equals(codeString)) {
                return ActivityDefinitionKind.GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return ActivityDefinitionKind.GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return ActivityDefinitionKind.GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return ActivityDefinitionKind.GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return ActivityDefinitionKind.HEALTHCARESERVICE;
            }
            if ("ImagingManifest".equals(codeString)) {
                return ActivityDefinitionKind.IMAGINGMANIFEST;
            }
            if ("ImagingStudy".equals(codeString)) {
                return ActivityDefinitionKind.IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return ActivityDefinitionKind.IMMUNIZATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return ActivityDefinitionKind.IMPLEMENTATIONGUIDE;
            }
            if ("Library".equals(codeString)) {
                return ActivityDefinitionKind.LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return ActivityDefinitionKind.LINKAGE;
            }
            if ("List".equals(codeString)) {
                return ActivityDefinitionKind.LIST;
            }
            if ("Location".equals(codeString)) {
                return ActivityDefinitionKind.LOCATION;
            }
            if ("Measure".equals(codeString)) {
                return ActivityDefinitionKind.MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return ActivityDefinitionKind.MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return ActivityDefinitionKind.MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATIONDISPENSE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATIONSTATEMENT;
            }
            if ("MessageDefinition".equals(codeString)) {
                return ActivityDefinitionKind.MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return ActivityDefinitionKind.MESSAGEHEADER;
            }
            if ("NamingSystem".equals(codeString)) {
                return ActivityDefinitionKind.NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return ActivityDefinitionKind.NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return ActivityDefinitionKind.OBSERVATION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return ActivityDefinitionKind.OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return ActivityDefinitionKind.OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return ActivityDefinitionKind.ORGANIZATION;
            }
            if ("Parameters".equals(codeString)) {
                return ActivityDefinitionKind.PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return ActivityDefinitionKind.PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return ActivityDefinitionKind.PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return ActivityDefinitionKind.PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return ActivityDefinitionKind.PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return ActivityDefinitionKind.PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return ActivityDefinitionKind.PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return ActivityDefinitionKind.PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return ActivityDefinitionKind.PROCEDURE;
            }
            if ("ProcedureRequest".equals(codeString)) {
                return ActivityDefinitionKind.PROCEDUREREQUEST;
            }
            if ("ProcessRequest".equals(codeString)) {
                return ActivityDefinitionKind.PROCESSREQUEST;
            }
            if ("ProcessResponse".equals(codeString)) {
                return ActivityDefinitionKind.PROCESSRESPONSE;
            }
            if ("Provenance".equals(codeString)) {
                return ActivityDefinitionKind.PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return ActivityDefinitionKind.QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return ActivityDefinitionKind.QUESTIONNAIRERESPONSE;
            }
            if ("ReferralRequest".equals(codeString)) {
                return ActivityDefinitionKind.REFERRALREQUEST;
            }
            if ("RelatedPerson".equals(codeString)) {
                return ActivityDefinitionKind.RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return ActivityDefinitionKind.REQUESTGROUP;
            }
            if ("ResearchStudy".equals(codeString)) {
                return ActivityDefinitionKind.RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return ActivityDefinitionKind.RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return ActivityDefinitionKind.RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return ActivityDefinitionKind.RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return ActivityDefinitionKind.SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return ActivityDefinitionKind.SEARCHPARAMETER;
            }
            if ("Sequence".equals(codeString)) {
                return ActivityDefinitionKind.SEQUENCE;
            }
            if ("ServiceDefinition".equals(codeString)) {
                return ActivityDefinitionKind.SERVICEDEFINITION;
            }
            if ("Slot".equals(codeString)) {
                return ActivityDefinitionKind.SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return ActivityDefinitionKind.SPECIMEN;
            }
            if ("StructureDefinition".equals(codeString)) {
                return ActivityDefinitionKind.STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return ActivityDefinitionKind.STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return ActivityDefinitionKind.SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return ActivityDefinitionKind.SUBSTANCE;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return ActivityDefinitionKind.SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return ActivityDefinitionKind.SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return ActivityDefinitionKind.TASK;
            }
            if ("TestReport".equals(codeString)) {
                return ActivityDefinitionKind.TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return ActivityDefinitionKind.TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return ActivityDefinitionKind.VALUESET;
            }
            if ("VisionPrescription".equals(codeString)) {
                return ActivityDefinitionKind.VISIONPRESCRIPTION;
            }
            throw new IllegalArgumentException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        public Enumeration<ActivityDefinitionKind> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActivityDefinitionKind>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ACCOUNT);
            }
            if ("ActivityDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ACTIVITYDEFINITION);
            }
            if ("AdverseEvent".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ADVERSEEVENT);
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ALLERGYINTOLERANCE);
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.APPOINTMENT);
            }
            if ("AppointmentResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.APPOINTMENTRESPONSE);
            }
            if ("AuditEvent".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.AUDITEVENT);
            }
            if ("Basic".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.BASIC);
            }
            if ("Binary".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.BINARY);
            }
            if ("BodySite".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.BODYSITE);
            }
            if ("Bundle".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.BUNDLE);
            }
            if ("CapabilityStatement".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CAPABILITYSTATEMENT);
            }
            if ("CarePlan".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CAREPLAN);
            }
            if ("CareTeam".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CARETEAM);
            }
            if ("ChargeItem".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CHARGEITEM);
            }
            if ("Claim".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CLAIM);
            }
            if ("ClaimResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CLAIMRESPONSE);
            }
            if ("ClinicalImpression".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CLINICALIMPRESSION);
            }
            if ("CodeSystem".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CODESYSTEM);
            }
            if ("Communication".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COMMUNICATION);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COMMUNICATIONREQUEST);
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COMPARTMENTDEFINITION);
            }
            if ("Composition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COMPOSITION);
            }
            if ("ConceptMap".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CONCEPTMAP);
            }
            if ("Condition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CONDITION);
            }
            if ("Consent".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CONSENT);
            }
            if ("Contract".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CONTRACT);
            }
            if ("Coverage".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COVERAGE);
            }
            if ("DataElement".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DATAELEMENT);
            }
            if ("DetectedIssue".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DETECTEDISSUE);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICE);
            }
            if ("DeviceComponent".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICECOMPONENT);
            }
            if ("DeviceMetric".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICEMETRIC);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICEREQUEST);
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICEUSESTATEMENT);
            }
            if ("DiagnosticReport".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DIAGNOSTICREPORT);
            }
            if ("DocumentManifest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DOCUMENTMANIFEST);
            }
            if ("DocumentReference".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DOCUMENTREFERENCE);
            }
            if ("DomainResource".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DOMAINRESOURCE);
            }
            if ("EligibilityRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ELIGIBILITYREQUEST);
            }
            if ("EligibilityResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ELIGIBILITYRESPONSE);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ENCOUNTER);
            }
            if ("Endpoint".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ENDPOINT);
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ENROLLMENTREQUEST);
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ENROLLMENTRESPONSE);
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.EPISODEOFCARE);
            }
            if ("ExpansionProfile".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.EXPANSIONPROFILE);
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.EXPLANATIONOFBENEFIT);
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.FAMILYMEMBERHISTORY);
            }
            if ("Flag".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.FLAG);
            }
            if ("Goal".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.GOAL);
            }
            if ("GraphDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.GRAPHDEFINITION);
            }
            if ("Group".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.GROUP);
            }
            if ("GuidanceResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.GUIDANCERESPONSE);
            }
            if ("HealthcareService".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.HEALTHCARESERVICE);
            }
            if ("ImagingManifest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMAGINGMANIFEST);
            }
            if ("ImagingStudy".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMAGINGSTUDY);
            }
            if ("Immunization".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMMUNIZATION);
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION);
            }
            if ("ImplementationGuide".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMPLEMENTATIONGUIDE);
            }
            if ("Library".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.LIBRARY);
            }
            if ("Linkage".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.LINKAGE);
            }
            if ("List".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.LIST);
            }
            if ("Location".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.LOCATION);
            }
            if ("Measure".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEASURE);
            }
            if ("MeasureReport".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEASUREREPORT);
            }
            if ("Media".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDIA);
            }
            if ("Medication".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATION);
            }
            if ("MedicationAdministration".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATIONADMINISTRATION);
            }
            if ("MedicationDispense".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATIONDISPENSE);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATIONREQUEST);
            }
            if ("MedicationStatement".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATIONSTATEMENT);
            }
            if ("MessageDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MESSAGEDEFINITION);
            }
            if ("MessageHeader".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MESSAGEHEADER);
            }
            if ("NamingSystem".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.NAMINGSYSTEM);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.NUTRITIONORDER);
            }
            if ("Observation".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.OBSERVATION);
            }
            if ("OperationDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.OPERATIONDEFINITION);
            }
            if ("OperationOutcome".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.OPERATIONOUTCOME);
            }
            if ("Organization".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ORGANIZATION);
            }
            if ("Parameters".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PARAMETERS);
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PATIENT);
            }
            if ("PaymentNotice".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PAYMENTNOTICE);
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PAYMENTRECONCILIATION);
            }
            if ("Person".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PERSON);
            }
            if ("PlanDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PLANDEFINITION);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PRACTITIONER);
            }
            if ("PractitionerRole".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PRACTITIONERROLE);
            }
            if ("Procedure".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PROCEDURE);
            }
            if ("ProcedureRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PROCEDUREREQUEST);
            }
            if ("ProcessRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PROCESSREQUEST);
            }
            if ("ProcessResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PROCESSRESPONSE);
            }
            if ("Provenance".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.PROVENANCE);
            }
            if ("Questionnaire".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.QUESTIONNAIRE);
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.QUESTIONNAIRERESPONSE);
            }
            if ("ReferralRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.REFERRALREQUEST);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.RELATEDPERSON);
            }
            if ("RequestGroup".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.REQUESTGROUP);
            }
            if ("ResearchStudy".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.RESEARCHSTUDY);
            }
            if ("ResearchSubject".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.RESEARCHSUBJECT);
            }
            if ("Resource".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.RESOURCE);
            }
            if ("RiskAssessment".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.RISKASSESSMENT);
            }
            if ("Schedule".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SCHEDULE);
            }
            if ("SearchParameter".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SEARCHPARAMETER);
            }
            if ("Sequence".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SEQUENCE);
            }
            if ("ServiceDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SERVICEDEFINITION);
            }
            if ("Slot".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SLOT);
            }
            if ("Specimen".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SPECIMEN);
            }
            if ("StructureDefinition".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.STRUCTUREDEFINITION);
            }
            if ("StructureMap".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.STRUCTUREMAP);
            }
            if ("Subscription".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SUBSCRIPTION);
            }
            if ("Substance".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SUBSTANCE);
            }
            if ("SupplyDelivery".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SUPPLYDELIVERY);
            }
            if ("SupplyRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SUPPLYREQUEST);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.TASK);
            }
            if ("TestReport".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.TESTREPORT);
            }
            if ("TestScript".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.TESTSCRIPT);
            }
            if ("ValueSet".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.VALUESET);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.VISIONPRESCRIPTION);
            }
            throw new FHIRException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(ActivityDefinitionKind code) {
            if (code == ActivityDefinitionKind.NULL) {
                return null;
            }
            if (code == ActivityDefinitionKind.ACCOUNT) {
                return "Account";
            }
            if (code == ActivityDefinitionKind.ACTIVITYDEFINITION) {
                return "ActivityDefinition";
            }
            if (code == ActivityDefinitionKind.ADVERSEEVENT) {
                return "AdverseEvent";
            }
            if (code == ActivityDefinitionKind.ALLERGYINTOLERANCE) {
                return "AllergyIntolerance";
            }
            if (code == ActivityDefinitionKind.APPOINTMENT) {
                return "Appointment";
            }
            if (code == ActivityDefinitionKind.APPOINTMENTRESPONSE) {
                return "AppointmentResponse";
            }
            if (code == ActivityDefinitionKind.AUDITEVENT) {
                return "AuditEvent";
            }
            if (code == ActivityDefinitionKind.BASIC) {
                return "Basic";
            }
            if (code == ActivityDefinitionKind.BINARY) {
                return "Binary";
            }
            if (code == ActivityDefinitionKind.BODYSITE) {
                return "BodySite";
            }
            if (code == ActivityDefinitionKind.BUNDLE) {
                return "Bundle";
            }
            if (code == ActivityDefinitionKind.CAPABILITYSTATEMENT) {
                return "CapabilityStatement";
            }
            if (code == ActivityDefinitionKind.CAREPLAN) {
                return "CarePlan";
            }
            if (code == ActivityDefinitionKind.CARETEAM) {
                return "CareTeam";
            }
            if (code == ActivityDefinitionKind.CHARGEITEM) {
                return "ChargeItem";
            }
            if (code == ActivityDefinitionKind.CLAIM) {
                return "Claim";
            }
            if (code == ActivityDefinitionKind.CLAIMRESPONSE) {
                return "ClaimResponse";
            }
            if (code == ActivityDefinitionKind.CLINICALIMPRESSION) {
                return "ClinicalImpression";
            }
            if (code == ActivityDefinitionKind.CODESYSTEM) {
                return "CodeSystem";
            }
            if (code == ActivityDefinitionKind.COMMUNICATION) {
                return "Communication";
            }
            if (code == ActivityDefinitionKind.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == ActivityDefinitionKind.COMPARTMENTDEFINITION) {
                return "CompartmentDefinition";
            }
            if (code == ActivityDefinitionKind.COMPOSITION) {
                return "Composition";
            }
            if (code == ActivityDefinitionKind.CONCEPTMAP) {
                return "ConceptMap";
            }
            if (code == ActivityDefinitionKind.CONDITION) {
                return "Condition";
            }
            if (code == ActivityDefinitionKind.CONSENT) {
                return "Consent";
            }
            if (code == ActivityDefinitionKind.CONTRACT) {
                return "Contract";
            }
            if (code == ActivityDefinitionKind.COVERAGE) {
                return "Coverage";
            }
            if (code == ActivityDefinitionKind.DATAELEMENT) {
                return "DataElement";
            }
            if (code == ActivityDefinitionKind.DETECTEDISSUE) {
                return "DetectedIssue";
            }
            if (code == ActivityDefinitionKind.DEVICE) {
                return "Device";
            }
            if (code == ActivityDefinitionKind.DEVICECOMPONENT) {
                return "DeviceComponent";
            }
            if (code == ActivityDefinitionKind.DEVICEMETRIC) {
                return "DeviceMetric";
            }
            if (code == ActivityDefinitionKind.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == ActivityDefinitionKind.DEVICEUSESTATEMENT) {
                return "DeviceUseStatement";
            }
            if (code == ActivityDefinitionKind.DIAGNOSTICREPORT) {
                return "DiagnosticReport";
            }
            if (code == ActivityDefinitionKind.DOCUMENTMANIFEST) {
                return "DocumentManifest";
            }
            if (code == ActivityDefinitionKind.DOCUMENTREFERENCE) {
                return "DocumentReference";
            }
            if (code == ActivityDefinitionKind.DOMAINRESOURCE) {
                return "DomainResource";
            }
            if (code == ActivityDefinitionKind.ELIGIBILITYREQUEST) {
                return "EligibilityRequest";
            }
            if (code == ActivityDefinitionKind.ELIGIBILITYRESPONSE) {
                return "EligibilityResponse";
            }
            if (code == ActivityDefinitionKind.ENCOUNTER) {
                return "Encounter";
            }
            if (code == ActivityDefinitionKind.ENDPOINT) {
                return "Endpoint";
            }
            if (code == ActivityDefinitionKind.ENROLLMENTREQUEST) {
                return "EnrollmentRequest";
            }
            if (code == ActivityDefinitionKind.ENROLLMENTRESPONSE) {
                return "EnrollmentResponse";
            }
            if (code == ActivityDefinitionKind.EPISODEOFCARE) {
                return "EpisodeOfCare";
            }
            if (code == ActivityDefinitionKind.EXPANSIONPROFILE) {
                return "ExpansionProfile";
            }
            if (code == ActivityDefinitionKind.EXPLANATIONOFBENEFIT) {
                return "ExplanationOfBenefit";
            }
            if (code == ActivityDefinitionKind.FAMILYMEMBERHISTORY) {
                return "FamilyMemberHistory";
            }
            if (code == ActivityDefinitionKind.FLAG) {
                return "Flag";
            }
            if (code == ActivityDefinitionKind.GOAL) {
                return "Goal";
            }
            if (code == ActivityDefinitionKind.GRAPHDEFINITION) {
                return "GraphDefinition";
            }
            if (code == ActivityDefinitionKind.GROUP) {
                return "Group";
            }
            if (code == ActivityDefinitionKind.GUIDANCERESPONSE) {
                return "GuidanceResponse";
            }
            if (code == ActivityDefinitionKind.HEALTHCARESERVICE) {
                return "HealthcareService";
            }
            if (code == ActivityDefinitionKind.IMAGINGMANIFEST) {
                return "ImagingManifest";
            }
            if (code == ActivityDefinitionKind.IMAGINGSTUDY) {
                return "ImagingStudy";
            }
            if (code == ActivityDefinitionKind.IMMUNIZATION) {
                return "Immunization";
            }
            if (code == ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION) {
                return "ImmunizationRecommendation";
            }
            if (code == ActivityDefinitionKind.IMPLEMENTATIONGUIDE) {
                return "ImplementationGuide";
            }
            if (code == ActivityDefinitionKind.LIBRARY) {
                return "Library";
            }
            if (code == ActivityDefinitionKind.LINKAGE) {
                return "Linkage";
            }
            if (code == ActivityDefinitionKind.LIST) {
                return "List";
            }
            if (code == ActivityDefinitionKind.LOCATION) {
                return "Location";
            }
            if (code == ActivityDefinitionKind.MEASURE) {
                return "Measure";
            }
            if (code == ActivityDefinitionKind.MEASUREREPORT) {
                return "MeasureReport";
            }
            if (code == ActivityDefinitionKind.MEDIA) {
                return "Media";
            }
            if (code == ActivityDefinitionKind.MEDICATION) {
                return "Medication";
            }
            if (code == ActivityDefinitionKind.MEDICATIONADMINISTRATION) {
                return "MedicationAdministration";
            }
            if (code == ActivityDefinitionKind.MEDICATIONDISPENSE) {
                return "MedicationDispense";
            }
            if (code == ActivityDefinitionKind.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == ActivityDefinitionKind.MEDICATIONSTATEMENT) {
                return "MedicationStatement";
            }
            if (code == ActivityDefinitionKind.MESSAGEDEFINITION) {
                return "MessageDefinition";
            }
            if (code == ActivityDefinitionKind.MESSAGEHEADER) {
                return "MessageHeader";
            }
            if (code == ActivityDefinitionKind.NAMINGSYSTEM) {
                return "NamingSystem";
            }
            if (code == ActivityDefinitionKind.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == ActivityDefinitionKind.OBSERVATION) {
                return "Observation";
            }
            if (code == ActivityDefinitionKind.OPERATIONDEFINITION) {
                return "OperationDefinition";
            }
            if (code == ActivityDefinitionKind.OPERATIONOUTCOME) {
                return "OperationOutcome";
            }
            if (code == ActivityDefinitionKind.ORGANIZATION) {
                return "Organization";
            }
            if (code == ActivityDefinitionKind.PARAMETERS) {
                return "Parameters";
            }
            if (code == ActivityDefinitionKind.PATIENT) {
                return "Patient";
            }
            if (code == ActivityDefinitionKind.PAYMENTNOTICE) {
                return "PaymentNotice";
            }
            if (code == ActivityDefinitionKind.PAYMENTRECONCILIATION) {
                return "PaymentReconciliation";
            }
            if (code == ActivityDefinitionKind.PERSON) {
                return "Person";
            }
            if (code == ActivityDefinitionKind.PLANDEFINITION) {
                return "PlanDefinition";
            }
            if (code == ActivityDefinitionKind.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == ActivityDefinitionKind.PRACTITIONERROLE) {
                return "PractitionerRole";
            }
            if (code == ActivityDefinitionKind.PROCEDURE) {
                return "Procedure";
            }
            if (code == ActivityDefinitionKind.PROCEDUREREQUEST) {
                return "ProcedureRequest";
            }
            if (code == ActivityDefinitionKind.PROCESSREQUEST) {
                return "ProcessRequest";
            }
            if (code == ActivityDefinitionKind.PROCESSRESPONSE) {
                return "ProcessResponse";
            }
            if (code == ActivityDefinitionKind.PROVENANCE) {
                return "Provenance";
            }
            if (code == ActivityDefinitionKind.QUESTIONNAIRE) {
                return "Questionnaire";
            }
            if (code == ActivityDefinitionKind.QUESTIONNAIRERESPONSE) {
                return "QuestionnaireResponse";
            }
            if (code == ActivityDefinitionKind.REFERRALREQUEST) {
                return "ReferralRequest";
            }
            if (code == ActivityDefinitionKind.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == ActivityDefinitionKind.REQUESTGROUP) {
                return "RequestGroup";
            }
            if (code == ActivityDefinitionKind.RESEARCHSTUDY) {
                return "ResearchStudy";
            }
            if (code == ActivityDefinitionKind.RESEARCHSUBJECT) {
                return "ResearchSubject";
            }
            if (code == ActivityDefinitionKind.RESOURCE) {
                return "Resource";
            }
            if (code == ActivityDefinitionKind.RISKASSESSMENT) {
                return "RiskAssessment";
            }
            if (code == ActivityDefinitionKind.SCHEDULE) {
                return "Schedule";
            }
            if (code == ActivityDefinitionKind.SEARCHPARAMETER) {
                return "SearchParameter";
            }
            if (code == ActivityDefinitionKind.SEQUENCE) {
                return "Sequence";
            }
            if (code == ActivityDefinitionKind.SERVICEDEFINITION) {
                return "ServiceDefinition";
            }
            if (code == ActivityDefinitionKind.SLOT) {
                return "Slot";
            }
            if (code == ActivityDefinitionKind.SPECIMEN) {
                return "Specimen";
            }
            if (code == ActivityDefinitionKind.STRUCTUREDEFINITION) {
                return "StructureDefinition";
            }
            if (code == ActivityDefinitionKind.STRUCTUREMAP) {
                return "StructureMap";
            }
            if (code == ActivityDefinitionKind.SUBSCRIPTION) {
                return "Subscription";
            }
            if (code == ActivityDefinitionKind.SUBSTANCE) {
                return "Substance";
            }
            if (code == ActivityDefinitionKind.SUPPLYDELIVERY) {
                return "SupplyDelivery";
            }
            if (code == ActivityDefinitionKind.SUPPLYREQUEST) {
                return "SupplyRequest";
            }
            if (code == ActivityDefinitionKind.TASK) {
                return "Task";
            }
            if (code == ActivityDefinitionKind.TESTREPORT) {
                return "TestReport";
            }
            if (code == ActivityDefinitionKind.TESTSCRIPT) {
                return "TestScript";
            }
            if (code == ActivityDefinitionKind.VALUESET) {
                return "ValueSet";
            }
            if (code == ActivityDefinitionKind.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            return "?";
        }

        @Override
        public String toSystem(ActivityDefinitionKind code) {
            return code.getSystem();
        }
    }

    public static enum ActivityDefinitionKind {
        ACCOUNT,
        ACTIVITYDEFINITION,
        ADVERSEEVENT,
        ALLERGYINTOLERANCE,
        APPOINTMENT,
        APPOINTMENTRESPONSE,
        AUDITEVENT,
        BASIC,
        BINARY,
        BODYSITE,
        BUNDLE,
        CAPABILITYSTATEMENT,
        CAREPLAN,
        CARETEAM,
        CHARGEITEM,
        CLAIM,
        CLAIMRESPONSE,
        CLINICALIMPRESSION,
        CODESYSTEM,
        COMMUNICATION,
        COMMUNICATIONREQUEST,
        COMPARTMENTDEFINITION,
        COMPOSITION,
        CONCEPTMAP,
        CONDITION,
        CONSENT,
        CONTRACT,
        COVERAGE,
        DATAELEMENT,
        DETECTEDISSUE,
        DEVICE,
        DEVICECOMPONENT,
        DEVICEMETRIC,
        DEVICEREQUEST,
        DEVICEUSESTATEMENT,
        DIAGNOSTICREPORT,
        DOCUMENTMANIFEST,
        DOCUMENTREFERENCE,
        DOMAINRESOURCE,
        ELIGIBILITYREQUEST,
        ELIGIBILITYRESPONSE,
        ENCOUNTER,
        ENDPOINT,
        ENROLLMENTREQUEST,
        ENROLLMENTRESPONSE,
        EPISODEOFCARE,
        EXPANSIONPROFILE,
        EXPLANATIONOFBENEFIT,
        FAMILYMEMBERHISTORY,
        FLAG,
        GOAL,
        GRAPHDEFINITION,
        GROUP,
        GUIDANCERESPONSE,
        HEALTHCARESERVICE,
        IMAGINGMANIFEST,
        IMAGINGSTUDY,
        IMMUNIZATION,
        IMMUNIZATIONRECOMMENDATION,
        IMPLEMENTATIONGUIDE,
        LIBRARY,
        LINKAGE,
        LIST,
        LOCATION,
        MEASURE,
        MEASUREREPORT,
        MEDIA,
        MEDICATION,
        MEDICATIONADMINISTRATION,
        MEDICATIONDISPENSE,
        MEDICATIONREQUEST,
        MEDICATIONSTATEMENT,
        MESSAGEDEFINITION,
        MESSAGEHEADER,
        NAMINGSYSTEM,
        NUTRITIONORDER,
        OBSERVATION,
        OPERATIONDEFINITION,
        OPERATIONOUTCOME,
        ORGANIZATION,
        PARAMETERS,
        PATIENT,
        PAYMENTNOTICE,
        PAYMENTRECONCILIATION,
        PERSON,
        PLANDEFINITION,
        PRACTITIONER,
        PRACTITIONERROLE,
        PROCEDURE,
        PROCEDUREREQUEST,
        PROCESSREQUEST,
        PROCESSRESPONSE,
        PROVENANCE,
        QUESTIONNAIRE,
        QUESTIONNAIRERESPONSE,
        REFERRALREQUEST,
        RELATEDPERSON,
        REQUESTGROUP,
        RESEARCHSTUDY,
        RESEARCHSUBJECT,
        RESOURCE,
        RISKASSESSMENT,
        SCHEDULE,
        SEARCHPARAMETER,
        SEQUENCE,
        SERVICEDEFINITION,
        SLOT,
        SPECIMEN,
        STRUCTUREDEFINITION,
        STRUCTUREMAP,
        SUBSCRIPTION,
        SUBSTANCE,
        SUPPLYDELIVERY,
        SUPPLYREQUEST,
        TASK,
        TESTREPORT,
        TESTSCRIPT,
        VALUESET,
        VISIONPRESCRIPTION,
        NULL;


        public static ActivityDefinitionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ACTIVITYDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return BASIC;
            }
            if ("Binary".equals(codeString)) {
                return BINARY;
            }
            if ("BodySite".equals(codeString)) {
                return BODYSITE;
            }
            if ("Bundle".equals(codeString)) {
                return BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return CAPABILITYSTATEMENT;
            }
            if ("CarePlan".equals(codeString)) {
                return CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return CARETEAM;
            }
            if ("ChargeItem".equals(codeString)) {
                return CHARGEITEM;
            }
            if ("Claim".equals(codeString)) {
                return CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return CLINICALIMPRESSION;
            }
            if ("CodeSystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return CONDITION;
            }
            if ("Consent".equals(codeString)) {
                return CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return COVERAGE;
            }
            if ("DataElement".equals(codeString)) {
                return DATAELEMENT;
            }
            if ("DetectedIssue".equals(codeString)) {
                return DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            if ("DeviceComponent".equals(codeString)) {
                return DEVICECOMPONENT;
            }
            if ("DeviceMetric".equals(codeString)) {
                return DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return DOMAINRESOURCE;
            }
            if ("EligibilityRequest".equals(codeString)) {
                return ELIGIBILITYREQUEST;
            }
            if ("EligibilityResponse".equals(codeString)) {
                return ELIGIBILITYRESPONSE;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return EPISODEOFCARE;
            }
            if ("ExpansionProfile".equals(codeString)) {
                return EXPANSIONPROFILE;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FLAG;
            }
            if ("Goal".equals(codeString)) {
                return GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("ImagingManifest".equals(codeString)) {
                return IMAGINGMANIFEST;
            }
            if ("ImagingStudy".equals(codeString)) {
                return IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return IMMUNIZATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return IMPLEMENTATIONGUIDE;
            }
            if ("Library".equals(codeString)) {
                return LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return LINKAGE;
            }
            if ("List".equals(codeString)) {
                return LIST;
            }
            if ("Location".equals(codeString)) {
                return LOCATION;
            }
            if ("Measure".equals(codeString)) {
                return MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return MEASUREREPORT;
            }
            if ("Media".equals(codeString)) {
                return MEDIA;
            }
            if ("Medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return MEDICATIONDISPENSE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("MedicationStatement".equals(codeString)) {
                return MEDICATIONSTATEMENT;
            }
            if ("MessageDefinition".equals(codeString)) {
                return MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return MESSAGEHEADER;
            }
            if ("NamingSystem".equals(codeString)) {
                return NAMINGSYSTEM;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return OBSERVATION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("Parameters".equals(codeString)) {
                return PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return PROCEDURE;
            }
            if ("ProcedureRequest".equals(codeString)) {
                return PROCEDUREREQUEST;
            }
            if ("ProcessRequest".equals(codeString)) {
                return PROCESSREQUEST;
            }
            if ("ProcessResponse".equals(codeString)) {
                return PROCESSRESPONSE;
            }
            if ("Provenance".equals(codeString)) {
                return PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return QUESTIONNAIRERESPONSE;
            }
            if ("ReferralRequest".equals(codeString)) {
                return REFERRALREQUEST;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return REQUESTGROUP;
            }
            if ("ResearchStudy".equals(codeString)) {
                return RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return SEARCHPARAMETER;
            }
            if ("Sequence".equals(codeString)) {
                return SEQUENCE;
            }
            if ("ServiceDefinition".equals(codeString)) {
                return SERVICEDEFINITION;
            }
            if ("Slot".equals(codeString)) {
                return SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return SPECIMEN;
            }
            if ("StructureDefinition".equals(codeString)) {
                return STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return SUBSTANCE;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("TestReport".equals(codeString)) {
                return TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return TESTSCRIPT;
            }
            if ("ValueSet".equals(codeString)) {
                return VALUESET;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BODYSITE: {
                    return "BodySite";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case DATAELEMENT: {
                    return "DataElement";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICECOMPONENT: {
                    return "DeviceComponent";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ELIGIBILITYREQUEST: {
                    return "EligibilityRequest";
                }
                case ELIGIBILITYRESPONSE: {
                    return "EligibilityResponse";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EXPANSIONPROFILE: {
                    return "ExpansionProfile";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGMANIFEST: {
                    return "ImagingManifest";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROCEDUREREQUEST: {
                    return "ProcedureRequest";
                }
                case PROCESSREQUEST: {
                    return "ProcessRequest";
                }
                case PROCESSRESPONSE: {
                    return "ProcessResponse";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REFERRALREQUEST: {
                    return "ReferralRequest";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SEQUENCE: {
                    return "Sequence";
                }
                case SERVICEDEFINITION: {
                    return "ServiceDefinition";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCOUNT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ACTIVITYDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADVERSEEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ALLERGYINTOLERANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case AUDITEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BASIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BINARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BODYSITE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BUNDLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAPABILITYSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAREPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CARETEAM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIMRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALIMPRESSION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPARTMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPOSITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONCEPTMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONDITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONSENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONTRACT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DATAELEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DETECTEDISSUE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICECOMPONENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEMETRIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEUSESTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DIAGNOSTICREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTMANIFEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTREFERENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOMAINRESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ELIGIBILITYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ELIGIBILITYRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENDPOINT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EPISODEOFCARE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXPANSIONPROFILE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FAMILYMEMBERHISTORY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FLAG: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GOAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GRAPHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GUIDANCERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMAGINGMANIFEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMAGINGSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIBRARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LINKAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASUREREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDIA: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONADMINISTRATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONDISPENSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEHEADER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NAMINGSYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONOUTCOME: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PARAMETERS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PATIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTNOTICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTRECONCILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PLANDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONERROLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCEDURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCEDUREREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCESSREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCESSRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROVENANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REFERRALREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REQUESTGROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSUBJECT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RISKASSESSMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SCHEDULE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SEARCHPARAMETER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SEQUENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SERVICEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SLOT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMEN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYDELIVERY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTSCRIPT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VALUESET: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCOUNT: {
                    return "A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.";
                }
                case ACTIVITYDEFINITION: {
                    return "This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.";
                }
                case ADVERSEEVENT: {
                    return "Actual or  potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.";
                }
                case ALLERGYINTOLERANCE: {
                    return "Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.";
                }
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case APPOINTMENTRESPONSE: {
                    return "A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.";
                }
                case AUDITEVENT: {
                    return "A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.";
                }
                case BASIC: {
                    return "Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.";
                }
                case BINARY: {
                    return "A binary resource can contain any content, whether text, image, pdf, zip archive, etc.";
                }
                case BODYSITE: {
                    return "Record details about the anatomical location of a specimen or body part.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.";
                }
                case BUNDLE: {
                    return "A container for a collection of resources.";
                }
                case CAPABILITYSTATEMENT: {
                    return "A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case CAREPLAN: {
                    return "Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.";
                }
                case CARETEAM: {
                    return "The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care for a patient.";
                }
                case CHARGEITEM: {
                    return "The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.";
                }
                case CLAIM: {
                    return "A provider issued list of services and products provided, or to be provided, to a patient which is provided to an insurer for payment recovery.";
                }
                case CLAIMRESPONSE: {
                    return "This resource provides the adjudication details from the processing of a Claim resource.";
                }
                case CLINICALIMPRESSION: {
                    return "A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called \"ClinicalImpression\" rather than \"ClinicalAssessment\" to avoid confusion with the recording of assessment tools such as Apgar score.";
                }
                case CODESYSTEM: {
                    return "A code system resource specifies a set of codes drawn from one or more code systems.";
                }
                case COMMUNICATION: {
                    return "An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency was notified about a reportable condition.";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.";
                }
                case COMPARTMENTDEFINITION: {
                    return "A compartment definition that defines how resources are accessed on a server.";
                }
                case COMPOSITION: {
                    return "A set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. While a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.";
                }
                case CONCEPTMAP: {
                    return "A statement of relationships from one set of concepts to one or more other concepts - either code systems or data elements, or classes in class models.";
                }
                case CONDITION: {
                    return "A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.";
                }
                case CONSENT: {
                    return "A record of a healthcare consumer\u2019s policy choices, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.";
                }
                case CONTRACT: {
                    return "A formal agreement between parties regarding the conduct of business, exchange of information or other matters.";
                }
                case COVERAGE: {
                    return "Financial instrument which may be used to reimburse or pay for health care products and services.";
                }
                case DATAELEMENT: {
                    return "The formal description of a single piece of information that can be gathered and reported.";
                }
                case DETECTEDISSUE: {
                    return "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.";
                }
                case DEVICE: {
                    return "This resource identifies an instance or a type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.  Medical devices include durable (reusable) medical equipment, implantable devices, as well as disposable equipment used for diagnostic, treatment, and research for healthcare and public health.  Non-medical devices may include items such as a machine, cellphone, computer, application, etc.";
                }
                case DEVICECOMPONENT: {
                    return "The characteristics, operational status and capabilities of a medical-related component of a medical device.";
                }
                case DEVICEMETRIC: {
                    return "Describes a measurement, calculation or setting capability of a medical device.";
                }
                case DEVICEREQUEST: {
                    return "Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.";
                }
                case DEVICEUSESTATEMENT: {
                    return "A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.";
                }
                case DIAGNOSTICREPORT: {
                    return "The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.";
                }
                case DOCUMENTMANIFEST: {
                    return "A collection of documents compiled for a purpose together with metadata that applies to the collection.";
                }
                case DOCUMENTREFERENCE: {
                    return "A reference to a document.";
                }
                case DOMAINRESOURCE: {
                    return "A resource that includes narrative, extensions, and contained resources.";
                }
                case ELIGIBILITYREQUEST: {
                    return "The EligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an EligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.";
                }
                case ELIGIBILITYRESPONSE: {
                    return "This resource provides eligibility and plan details from the processing of an Eligibility resource.";
                }
                case ENCOUNTER: {
                    return "An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.";
                }
                case ENDPOINT: {
                    return "The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.";
                }
                case ENROLLMENTREQUEST: {
                    return "This resource provides the insurance enrollment details to the insurer regarding a specified coverage.";
                }
                case ENROLLMENTRESPONSE: {
                    return "This resource provides enrollment and plan details from the processing of an Enrollment resource.";
                }
                case EPISODEOFCARE: {
                    return "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.";
                }
                case EXPANSIONPROFILE: {
                    return "Resource to define constraints on the Expansion of a FHIR ValueSet.";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.";
                }
                case FAMILYMEMBERHISTORY: {
                    return "Significant health events and conditions for a person related to the patient relevant in the context of care for the patient.";
                }
                case FLAG: {
                    return "Prospective warnings of potential issues when providing care to the patient.";
                }
                case GOAL: {
                    return "Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.";
                }
                case GRAPHDEFINITION: {
                    return "A formal computable definition of a graph of resources - that is, a coherent set of resources that form a graph by following references. The Graph Definition resource defines a set and makes rules about the set.";
                }
                case GROUP: {
                    return "Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.";
                }
                case GUIDANCERESPONSE: {
                    return "A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.";
                }
                case HEALTHCARESERVICE: {
                    return "The details of a healthcare service available at a location.";
                }
                case IMAGINGMANIFEST: {
                    return "A text description of the DICOM SOP instances selected in the ImagingManifest; or the reason for, or significance of, the selection.";
                }
                case IMAGINGSTUDY: {
                    return "Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.";
                }
                case IMMUNIZATION: {
                    return "Describes the event of a patient being administered a vaccination or a record of a vaccination as reported by a patient, a clinician or another party and may include vaccine reaction information and what vaccination protocol was followed.";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "A patient's point-in-time immunization and recommendation (i.e. forecasting a patient's immunization eligibility according to a published schedule) with optional supporting justification.";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "A set of rules of how FHIR is used to solve a particular problem. This resource is used to gather all the parts of an implementation guide into a logical whole and to publish a computable definition of all the parts.";
                }
                case LIBRARY: {
                    return "The Library resource is a general-purpose container for knowledge asset definitions. It can be used to describe and expose existing knowledge assets such as logic libraries and information model descriptions, as well as to describe a collection of knowledge assets.";
                }
                case LINKAGE: {
                    return "Identifies two or more records (resource instances) that are referring to the same real-world \"occurrence\".";
                }
                case LIST: {
                    return "A set of information summarized from a list of other resources.";
                }
                case LOCATION: {
                    return "Details and position information for a physical place where services are provided  and resources and participants may be stored, found, contained or accommodated.";
                }
                case MEASURE: {
                    return "The Measure resource provides the definition of a quality measure.";
                }
                case MEASUREREPORT: {
                    return "The MeasureReport resource contains the results of evaluating a measure.";
                }
                case MEDIA: {
                    return "A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.";
                }
                case MEDICATION: {
                    return "This resource is primarily used for the identification and definition of a medication. It covers the ingredients and the packaging for a medication.";
                }
                case MEDICATIONADMINISTRATION: {
                    return "Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.";
                }
                case MEDICATIONDISPENSE: {
                    return "Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.";
                }
                case MEDICATIONREQUEST: {
                    return "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called \"MedicationRequest\" rather than \"MedicationPrescription\" or \"MedicationOrder\" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.";
                }
                case MEDICATIONSTATEMENT: {
                    return "A record of a medication that is being consumed by a patient.   A MedicationStatement may indicate that the patient may be taking the medication now, or has taken the medication in the past or will be taking the medication in the future.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay.   The medication information may come from sources such as the patient's memory, from a prescription bottle,  or from a list of medications the patient, clinician or other party maintains \r\rThe primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication.  A medication statement is often, if not always, less specific.  There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise.  As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains.  Medication administration is more formal and is not missing detailed information.";
                }
                case MESSAGEDEFINITION: {
                    return "Defines the characteristics of a message that can be shared between systems, including the type of event that initiates the message, the content to be transmitted and what response(s), if any, are permitted.";
                }
                case MESSAGEHEADER: {
                    return "The header for a message exchange that is either requesting or responding to an action.  The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.";
                }
                case NAMINGSYSTEM: {
                    return "A curated namespace that issues unique symbols within that namespace for the identification of concepts, people, devices, etc.  Represents a \"System\" used within the Identifier and Coding data types.";
                }
                case NUTRITIONORDER: {
                    return "A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.";
                }
                case OBSERVATION: {
                    return "Measurements and simple assertions made about a patient, device or other subject.";
                }
                case OPERATIONDEFINITION: {
                    return "A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).";
                }
                case OPERATIONOUTCOME: {
                    return "A collection of error, warning or information messages that result from a system action.";
                }
                case ORGANIZATION: {
                    return "A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action.  Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, etc.";
                }
                case PARAMETERS: {
                    return "This special resource type is used to represent an operation request and response (operations.html). It has no other use, and there is no RESTful endpoint associated with it.";
                }
                case PATIENT: {
                    return "Demographics and other administrative information about an individual or animal receiving care or other health-related services.";
                }
                case PAYMENTNOTICE: {
                    return "This resource provides the status of the payment for goods and services rendered, and the request and response resource references.";
                }
                case PAYMENTRECONCILIATION: {
                    return "This resource provides payment details and claim references supporting a bulk payment.";
                }
                case PERSON: {
                    return "Demographics and administrative information about a person independent of a specific health-related context.";
                }
                case PLANDEFINITION: {
                    return "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.";
                }
                case PRACTITIONER: {
                    return "A person who is directly or indirectly involved in the provisioning of healthcare.";
                }
                case PRACTITIONERROLE: {
                    return "A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.";
                }
                case PROCEDURE: {
                    return "An action that is or was performed on a patient. This can be a physical intervention like an operation, or less invasive like counseling or hypnotherapy.";
                }
                case PROCEDUREREQUEST: {
                    return "A record of a request for diagnostic investigations, treatments, or operations to be performed.";
                }
                case PROCESSREQUEST: {
                    return "This resource provides the target, request and response, and action details for an action to be performed by the target on or about existing resources.";
                }
                case PROCESSRESPONSE: {
                    return "This resource provides processing status, errors and notes from the processing of a resource.";
                }
                case PROVENANCE: {
                    return "Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.";
                }
                case QUESTIONNAIRE: {
                    return "A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.";
                }
                case REFERRALREQUEST: {
                    return "Used to record and send details about a request for referral service or transfer of a patient to the care of another provider or provider organization.";
                }
                case RELATEDPERSON: {
                    return "Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.";
                }
                case REQUESTGROUP: {
                    return "A group of related requests that can be used to capture intended activities that have inter-dependencies such as \"give this medication after that one\".";
                }
                case RESEARCHSTUDY: {
                    return "A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge.  This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques.  A ResearchStudy involves the gathering of information about human or animal subjects.";
                }
                case RESEARCHSUBJECT: {
                    return "A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge.  This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques.  A ResearchStudy involves the gathering of information about human or animal subjects.";
                }
                case RESOURCE: {
                    return "This is the base resource type for everything.";
                }
                case RISKASSESSMENT: {
                    return "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.";
                }
                case SCHEDULE: {
                    return "A container for slots of time that may be available for booking appointments.";
                }
                case SEARCHPARAMETER: {
                    return "A search parameter that defines a named search item that can be used to search/filter on a resource.";
                }
                case SEQUENCE: {
                    return "Raw data describing a biological sequence.";
                }
                case SERVICEDEFINITION: {
                    return "The ServiceDefinition describes a unit of decision support functionality that is made available as a service, such as immunization modules or drug-drug interaction checking.";
                }
                case SLOT: {
                    return "A slot of time on a schedule that may be available for booking appointments.";
                }
                case SPECIMEN: {
                    return "A sample to be used for analysis.";
                }
                case STRUCTUREDEFINITION: {
                    return "A definition of a FHIR structure. This resource is used to describe the underlying resources, data types defined in FHIR, and also for describing extensions and constraints on resources and data types.";
                }
                case STRUCTUREMAP: {
                    return "A Map of relationships between 2 structures that can be used to transform data.";
                }
                case SUBSCRIPTION: {
                    return "The subscription resource is used to define a push based subscription from a server to another system. Once a subscription is registered with the server, the server checks every resource that is created or updated, and if the resource matches the given criteria, it sends a message on the defined \"channel\" so that another system is able to take an appropriate action.";
                }
                case SUBSTANCE: {
                    return "A homogeneous material with a definite composition.";
                }
                case SUPPLYDELIVERY: {
                    return "Record of delivery of what is supplied.";
                }
                case SUPPLYREQUEST: {
                    return "A record of a request for a medication, substance or device used in the healthcare setting.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case TESTREPORT: {
                    return "A summary of information based on the results of executing a TestScript.";
                }
                case TESTSCRIPT: {
                    return "A structured set of tests against a FHIR server implementation to determine compliance against the FHIR specification.";
                }
                case VALUESET: {
                    return "A value set specifies a set of codes drawn from one or more code systems.";
                }
                case VISIONPRESCRIPTION: {
                    return "An authorization for the supply of glasses and/or contact lenses to a patient.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BODYSITE: {
                    return "BodySite";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case DATAELEMENT: {
                    return "DataElement";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICECOMPONENT: {
                    return "DeviceComponent";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ELIGIBILITYREQUEST: {
                    return "EligibilityRequest";
                }
                case ELIGIBILITYRESPONSE: {
                    return "EligibilityResponse";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EXPANSIONPROFILE: {
                    return "ExpansionProfile";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGMANIFEST: {
                    return "ImagingManifest";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDIA: {
                    return "Media";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONSTATEMENT: {
                    return "MedicationStatement";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROCEDUREREQUEST: {
                    return "ProcedureRequest";
                }
                case PROCESSREQUEST: {
                    return "ProcessRequest";
                }
                case PROCESSRESPONSE: {
                    return "ProcessResponse";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REFERRALREQUEST: {
                    return "ReferralRequest";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SEQUENCE: {
                    return "Sequence";
                }
                case SERVICEDEFINITION: {
                    return "ServiceDefinition";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ActivityDefinitionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="patient | practitioner | related-person", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<ActivityParticipantType> type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent, etc", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-role")
        protected CodeableConcept role;
        private static final long serialVersionUID = -1450932564L;

        public ActivityDefinitionParticipantComponent() {
        }

        public ActivityDefinitionParticipantComponent(Enumeration<ActivityParticipantType> type) {
            this.type = type;
        }

        public Enumeration<ActivityParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ActivityParticipantType>(new ActivityParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ActivityDefinitionParticipantComponent setTypeElement(Enumeration<ActivityParticipantType> value) {
            this.type = value;
            return this;
        }

        public ActivityParticipantType getType() {
            return this.type == null ? null : (ActivityParticipantType)((Object)this.type.getValue());
        }

        public ActivityDefinitionParticipantComponent setType(ActivityParticipantType value) {
            if (this.type == null) {
                this.type = new Enumeration<ActivityParticipantType>(new ActivityParticipantTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ActivityDefinitionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ActivityParticipantTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ActivityParticipantTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.type");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public ActivityDefinitionParticipantComponent copy() {
            ActivityDefinitionParticipantComponent dst = new ActivityDefinitionParticipantComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.role = this.role == null ? null : this.role.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionParticipantComponent)) {
                return false;
            }
            ActivityDefinitionParticipantComponent o = (ActivityDefinitionParticipantComponent)other_;
            return ActivityDefinitionParticipantComponent.compareDeep(this.type, o.type, true) && ActivityDefinitionParticipantComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionParticipantComponent)) {
                return false;
            }
            ActivityDefinitionParticipantComponent o = (ActivityDefinitionParticipantComponent)other_;
            return ActivityDefinitionParticipantComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.role});
        }

        @Override
        public String fhirType() {
            return "ActivityDefinition.participant";
        }
    }

    @Block
    public static class ActivityDefinitionDynamicValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the dynamic value", formalDefinition="A brief, natural language description of the intended semantics of the dynamic value.")
        protected StringType description;
        @Child(name="path", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.")
        protected StringType path;
        @Child(name="language", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the expression", formalDefinition="The media type of the language for the expression.")
        protected StringType language;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected StringType expression;
        private static final long serialVersionUID = 448404361L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ActivityDefinitionDynamicValueComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ActivityDefinitionDynamicValueComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new StringType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setLanguageElement(StringType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ActivityDefinitionDynamicValueComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new StringType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public ActivityDefinitionDynamicValueComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ActivityDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the intended semantics of the dynamic value.", 0, 1, this.description));
            children.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.", 0, 1, this.path));
            children.add(new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression specifying the value of the customized element.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(ActivityDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the intended semantics of the dynamic value.", 0, 1, this.description);
                }
                case 3433509: {
                    return new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.", 0, 1, this.path);
                }
                case -1613589672: {
                    return new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression specifying the value of the customized element.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.path;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ActivityDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ActivityDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.description");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.path");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a singleton property ActivityDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public ActivityDefinitionDynamicValueComponent copy() {
            ActivityDefinitionDynamicValueComponent dst = new ActivityDefinitionDynamicValueComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionDynamicValueComponent)) {
                return false;
            }
            ActivityDefinitionDynamicValueComponent o = (ActivityDefinitionDynamicValueComponent)other_;
            return ActivityDefinitionDynamicValueComponent.compareDeep(this.description, o.description, true) && ActivityDefinitionDynamicValueComponent.compareDeep(this.path, o.path, true) && ActivityDefinitionDynamicValueComponent.compareDeep(this.language, o.language, true) && ActivityDefinitionDynamicValueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionDynamicValueComponent)) {
                return false;
            }
            ActivityDefinitionDynamicValueComponent o = (ActivityDefinitionDynamicValueComponent)other_;
            return ActivityDefinitionDynamicValueComponent.compareValues(this.description, o.description, true) && ActivityDefinitionDynamicValueComponent.compareValues(this.path, o.path, true) && ActivityDefinitionDynamicValueComponent.compareValues(this.language, o.language, true) && ActivityDefinitionDynamicValueComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.path, this.language, this.expression});
        }

        @Override
        public String fhirType() {
            return "ActivityDefinition.dynamicValue";
        }
    }

    public static class ActivityParticipantTypeEnumFactory
    implements EnumFactory<ActivityParticipantType> {
        @Override
        public ActivityParticipantType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return ActivityParticipantType.PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return ActivityParticipantType.PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return ActivityParticipantType.RELATEDPERSON;
            }
            throw new IllegalArgumentException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        public Enumeration<ActivityParticipantType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActivityParticipantType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.PATIENT);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.PRACTITIONER);
            }
            if ("related-person".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.RELATEDPERSON);
            }
            throw new FHIRException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActivityParticipantType code) {
            if (code == ActivityParticipantType.NULL) {
                return null;
            }
            if (code == ActivityParticipantType.PATIENT) {
                return "patient";
            }
            if (code == ActivityParticipantType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == ActivityParticipantType.RELATEDPERSON) {
                return "related-person";
            }
            return "?";
        }

        @Override
        public String toSystem(ActivityParticipantType code) {
            return code.getSystem();
        }
    }

    public static enum ActivityParticipantType {
        PATIENT,
        PRACTITIONER,
        RELATEDPERSON,
        NULL;


        public static ActivityParticipantType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return RELATEDPERSON;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "patient";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case RELATEDPERSON: {
                    return "related-person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The participant is the patient under evaluation";
                }
                case PRACTITIONER: {
                    return "The participant is a practitioner involved in the patient's care";
                }
                case RELATEDPERSON: {
                    return "The participant is a person related to the patient";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case RELATEDPERSON: {
                    return "Related Person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

