/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Contract;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Consent", profile="http://hl7.org/fhir/Profile/Consent")
public class Consent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for this record (external references)", formalDefinition="Unique identifier for this copy of the Consent Statement.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | proposed | active | rejected | inactive | entered-in-error", formalDefinition="Indicates the current state of this consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-state-codes")
    protected Enumeration<ConsentState> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the consent statement - for indexing/retrieval", formalDefinition="A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-category")
    protected List<CodeableConcept> category;
    @Child(name="patient", type={Patient.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the consent applies to", formalDefinition="The patient/healthcare consumer to whom this consent applies.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period that this consent applies", formalDefinition="Relevant time or time-period when this Consent is applicable.")
    protected Period period;
    @Child(name="dateTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Consent was created or indexed", formalDefinition="When this  Consent was issued / created / indexed.")
    protected DateTimeType dateTime;
    @Child(name="consentingParty", type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is agreeing to the policy and exceptions", formalDefinition="Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.")
    protected List<Reference> consentingParty;
    protected List<Resource> consentingPartyTarget;
    @Child(name="actor", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who|what controlled by this consent (or group, by role)", formalDefinition="Who or what is controlled by this consent. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
    protected List<ConsentActorComponent> actor;
    @Child(name="action", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actions controlled by this consent", formalDefinition="Actions controlled by this consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
    protected List<CodeableConcept> action;
    @Child(name="organization", type={Organization.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Custodian of the consent", formalDefinition="The organization that manages the consent, and the framework within which it is executed.")
    protected List<Reference> organization;
    protected List<Organization> organizationTarget;
    @Child(name="source", type={Attachment.class, Identifier.class, Consent.class, DocumentReference.class, Contract.class, QuestionnaireResponse.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Source from which this consent is taken", formalDefinition="The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.")
    protected Type source;
    @Child(name="policy", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Policies covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
    protected List<ConsentPolicyComponent> policy;
    @Child(name="policyRule", type={UriType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Policy that this consents to", formalDefinition="A referece to the specific computable policy.")
    protected UriType policyRule;
    @Child(name="securityLabel", type={Coding.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    protected List<Coding> securityLabel;
    @Child(name="purpose", type={Coding.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Context of activities for which the agreement is made", formalDefinition="The context of the activities a user is taking - why the user is accessing the data - that are controlled by this consent.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-PurposeOfUse")
    protected List<Coding> purpose;
    @Child(name="dataPeriod", type={Period.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timeframe for data controlled by this consent", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this consent.")
    protected Period dataPeriod;
    @Child(name="data", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data controlled by this consent", formalDefinition="The resources controlled by this consent, if specific resources are referenced.")
    protected List<ConsentDataComponent> data;
    @Child(name="except", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional rule -  addition or removal of permissions", formalDefinition="An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.")
    protected List<ExceptComponent> except;
    private static final long serialVersionUID = -345946739L;
    @SearchParamDefinition(name="date", path="Consent.dateTime", description="When this Consent was created or indexed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Consent.identifier", description="Identifier for this record (external references)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="securitylabel", path="Consent.securityLabel | Consent.except.securityLabel", description="Security Labels that define affected resources", type="token")
    public static final String SP_SECURITYLABEL = "securitylabel";
    public static final TokenClientParam SECURITYLABEL = new TokenClientParam("securitylabel");
    @SearchParamDefinition(name="period", path="Consent.period", description="Period that this consent applies", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="data", path="Consent.data.reference | Consent.except.data.reference", description="The actual data reference", type="reference")
    public static final String SP_DATA = "data";
    public static final ReferenceClientParam DATA = new ReferenceClientParam("data");
    public static final Include INCLUDE_DATA = new Include("Consent:data").toLocked();
    @SearchParamDefinition(name="purpose", path="Consent.purpose | Consent.except.purpose", description="Context of activities for which the agreement is made", type="token")
    public static final String SP_PURPOSE = "purpose";
    public static final TokenClientParam PURPOSE = new TokenClientParam("purpose");
    @SearchParamDefinition(name="source", path="Consent.source", description="Source from which this consent is taken", type="reference", target={Consent.class, Contract.class, DocumentReference.class, QuestionnaireResponse.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("Consent:source").toLocked();
    @SearchParamDefinition(name="actor", path="Consent.actor.reference | Consent.except.actor.reference", description="Resource for the actor (or group, by role)", type="reference", target={CareTeam.class, Device.class, Group.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Consent:actor").toLocked();
    @SearchParamDefinition(name="patient", path="Consent.patient", description="Who the consent applies to", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Consent:patient").toLocked();
    @SearchParamDefinition(name="organization", path="Consent.organization", description="Custodian of the consent", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Consent:organization").toLocked();
    @SearchParamDefinition(name="action", path="Consent.action | Consent.except.action", description="Actions controlled by this consent", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="consentor", path="Consent.consentingParty", description="Who is agreeing to the policy and exceptions", type="reference", target={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_CONSENTOR = "consentor";
    public static final ReferenceClientParam CONSENTOR = new ReferenceClientParam("consentor");
    public static final Include INCLUDE_CONSENTOR = new Include("Consent:consentor").toLocked();
    @SearchParamDefinition(name="category", path="Consent.category", description="Classification of the consent statement - for indexing/retrieval", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="Consent.status", description="draft | proposed | active | rejected | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Consent() {
    }

    public Consent(Enumeration<ConsentState> status, Reference patient) {
        this.status = status;
        this.patient = patient;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Consent setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<ConsentState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Consent setStatusElement(Enumeration<ConsentState> value) {
        this.status = value;
        return this;
    }

    public ConsentState getStatus() {
        return this.status == null ? null : (ConsentState)((Object)this.status.getValue());
    }

    public Consent setStatus(ConsentState value) {
        if (this.status == null) {
            this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Consent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Consent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Consent setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Consent setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Consent setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public DateTimeType getDateTimeElement() {
        if (this.dateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.dateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.dateTime = new DateTimeType();
            }
        }
        return this.dateTime;
    }

    public boolean hasDateTimeElement() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public boolean hasDateTime() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public Consent setDateTimeElement(DateTimeType value) {
        this.dateTime = value;
        return this;
    }

    public Date getDateTime() {
        return this.dateTime == null ? null : (Date)this.dateTime.getValue();
    }

    public Consent setDateTime(Date value) {
        if (value == null) {
            this.dateTime = null;
        } else {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(value);
        }
        return this;
    }

    public List<Reference> getConsentingParty() {
        if (this.consentingParty == null) {
            this.consentingParty = new ArrayList<Reference>();
        }
        return this.consentingParty;
    }

    public Consent setConsentingParty(List<Reference> theConsentingParty) {
        this.consentingParty = theConsentingParty;
        return this;
    }

    public boolean hasConsentingParty() {
        if (this.consentingParty == null) {
            return false;
        }
        for (Reference item : this.consentingParty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addConsentingParty() {
        Reference t = new Reference();
        if (this.consentingParty == null) {
            this.consentingParty = new ArrayList<Reference>();
        }
        this.consentingParty.add(t);
        return t;
    }

    public Consent addConsentingParty(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.consentingParty == null) {
            this.consentingParty = new ArrayList<Reference>();
        }
        this.consentingParty.add(t);
        return this;
    }

    public Reference getConsentingPartyFirstRep() {
        if (this.getConsentingParty().isEmpty()) {
            this.addConsentingParty();
        }
        return this.getConsentingParty().get(0);
    }

    public List<ConsentActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<ConsentActorComponent>();
        }
        return this.actor;
    }

    public Consent setActor(List<ConsentActorComponent> theActor) {
        this.actor = theActor;
        return this;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (ConsentActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentActorComponent addActor() {
        ConsentActorComponent t = new ConsentActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<ConsentActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public Consent addActor(ConsentActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<ConsentActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public ConsentActorComponent getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<CodeableConcept> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        return this.action;
    }

    public Consent setAction(List<CodeableConcept> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (CodeableConcept item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAction() {
        CodeableConcept t = new CodeableConcept();
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return t;
    }

    public Consent addAction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return this;
    }

    public CodeableConcept getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    public List<Reference> getOrganization() {
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        return this.organization;
    }

    public Consent setOrganization(List<Reference> theOrganization) {
        this.organization = theOrganization;
        return this;
    }

    public boolean hasOrganization() {
        if (this.organization == null) {
            return false;
        }
        for (Reference item : this.organization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addOrganization() {
        Reference t = new Reference();
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return t;
    }

    public Consent addOrganization(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.organization == null) {
            this.organization = new ArrayList<Reference>();
        }
        this.organization.add(t);
        return this;
    }

    public Reference getOrganizationFirstRep() {
        if (this.getOrganization().isEmpty()) {
            this.addOrganization();
        }
        return this.getOrganization().get(0);
    }

    public Type getSource() {
        return this.source;
    }

    public Attachment getSourceAttachment() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Attachment)this.source;
    }

    public boolean hasSourceAttachment() {
        return this.source instanceof Attachment;
    }

    public Identifier getSourceIdentifier() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Identifier)this.source;
    }

    public boolean hasSourceIdentifier() {
        return this.source instanceof Identifier;
    }

    public Reference getSourceReference() throws FHIRException {
        if (this.source == null) {
            return null;
        }
        if (!(this.source instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Reference)this.source;
    }

    public boolean hasSourceReference() {
        return this.source instanceof Reference;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Consent setSource(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof Attachment || value instanceof Identifier || value instanceof Reference)) {
            throw new FHIRFormatError("Not the right type for Consent.source[x]: " + value.fhirType());
        }
        this.source = value;
        return this;
    }

    public List<ConsentPolicyComponent> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        return this.policy;
    }

    public Consent setPolicy(List<ConsentPolicyComponent> thePolicy) {
        this.policy = thePolicy;
        return this;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (ConsentPolicyComponent item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentPolicyComponent addPolicy() {
        ConsentPolicyComponent t = new ConsentPolicyComponent();
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return t;
    }

    public Consent addPolicy(ConsentPolicyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.policy == null) {
            this.policy = new ArrayList<ConsentPolicyComponent>();
        }
        this.policy.add(t);
        return this;
    }

    public ConsentPolicyComponent getPolicyFirstRep() {
        if (this.getPolicy().isEmpty()) {
            this.addPolicy();
        }
        return this.getPolicy().get(0);
    }

    public UriType getPolicyRuleElement() {
        if (this.policyRule == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.policyRule");
            }
            if (Configuration.doAutoCreate()) {
                this.policyRule = new UriType();
            }
        }
        return this.policyRule;
    }

    public boolean hasPolicyRuleElement() {
        return this.policyRule != null && !this.policyRule.isEmpty();
    }

    public boolean hasPolicyRule() {
        return this.policyRule != null && !this.policyRule.isEmpty();
    }

    public Consent setPolicyRuleElement(UriType value) {
        this.policyRule = value;
        return this;
    }

    public String getPolicyRule() {
        return this.policyRule == null ? null : (String)this.policyRule.getValue();
    }

    public Consent setPolicyRule(String value) {
        if (Utilities.noString((String)value)) {
            this.policyRule = null;
        } else {
            if (this.policyRule == null) {
                this.policyRule = new UriType();
            }
            this.policyRule.setValue(value);
        }
        return this;
    }

    public List<Coding> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        return this.securityLabel;
    }

    public Consent setSecurityLabel(List<Coding> theSecurityLabel) {
        this.securityLabel = theSecurityLabel;
        return this;
    }

    public boolean hasSecurityLabel() {
        if (this.securityLabel == null) {
            return false;
        }
        for (Coding item : this.securityLabel) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSecurityLabel() {
        Coding t = new Coding();
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        this.securityLabel.add(t);
        return t;
    }

    public Consent addSecurityLabel(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<Coding>();
        }
        this.securityLabel.add(t);
        return this;
    }

    public Coding getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<Coding> getPurpose() {
        if (this.purpose == null) {
            this.purpose = new ArrayList<Coding>();
        }
        return this.purpose;
    }

    public Consent setPurpose(List<Coding> thePurpose) {
        this.purpose = thePurpose;
        return this;
    }

    public boolean hasPurpose() {
        if (this.purpose == null) {
            return false;
        }
        for (Coding item : this.purpose) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addPurpose() {
        Coding t = new Coding();
        if (this.purpose == null) {
            this.purpose = new ArrayList<Coding>();
        }
        this.purpose.add(t);
        return t;
    }

    public Consent addPurpose(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.purpose == null) {
            this.purpose = new ArrayList<Coding>();
        }
        this.purpose.add(t);
        return this;
    }

    public Coding getPurposeFirstRep() {
        if (this.getPurpose().isEmpty()) {
            this.addPurpose();
        }
        return this.getPurpose().get(0);
    }

    public Period getDataPeriod() {
        if (this.dataPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.dataPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.dataPeriod = new Period();
            }
        }
        return this.dataPeriod;
    }

    public boolean hasDataPeriod() {
        return this.dataPeriod != null && !this.dataPeriod.isEmpty();
    }

    public Consent setDataPeriod(Period value) {
        this.dataPeriod = value;
        return this;
    }

    public List<ConsentDataComponent> getData() {
        if (this.data == null) {
            this.data = new ArrayList<ConsentDataComponent>();
        }
        return this.data;
    }

    public Consent setData(List<ConsentDataComponent> theData) {
        this.data = theData;
        return this;
    }

    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        for (ConsentDataComponent item : this.data) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentDataComponent addData() {
        ConsentDataComponent t = new ConsentDataComponent();
        if (this.data == null) {
            this.data = new ArrayList<ConsentDataComponent>();
        }
        this.data.add(t);
        return t;
    }

    public Consent addData(ConsentDataComponent t) {
        if (t == null) {
            return this;
        }
        if (this.data == null) {
            this.data = new ArrayList<ConsentDataComponent>();
        }
        this.data.add(t);
        return this;
    }

    public ConsentDataComponent getDataFirstRep() {
        if (this.getData().isEmpty()) {
            this.addData();
        }
        return this.getData().get(0);
    }

    public List<ExceptComponent> getExcept() {
        if (this.except == null) {
            this.except = new ArrayList<ExceptComponent>();
        }
        return this.except;
    }

    public Consent setExcept(List<ExceptComponent> theExcept) {
        this.except = theExcept;
        return this;
    }

    public boolean hasExcept() {
        if (this.except == null) {
            return false;
        }
        for (ExceptComponent item : this.except) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExceptComponent addExcept() {
        ExceptComponent t = new ExceptComponent();
        if (this.except == null) {
            this.except = new ArrayList<ExceptComponent>();
        }
        this.except.add(t);
        return t;
    }

    public Consent addExcept(ExceptComponent t) {
        if (t == null) {
            return this;
        }
        if (this.except == null) {
            this.except = new ArrayList<ExceptComponent>();
        }
        this.except.add(t);
        return this;
    }

    public ExceptComponent getExceptFirstRep() {
        if (this.getExcept().isEmpty()) {
            this.addExcept();
        }
        return this.getExcept().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient));
        children.add(new Property(SP_PERIOD, "Period", "Relevant time or time-period when this Consent is applicable.", 0, 1, this.period));
        children.add(new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime));
        children.add(new Property("consentingParty", "Reference(Organization|Patient|Practitioner|RelatedPerson)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.consentingParty));
        children.add(new Property(SP_ACTOR, "", "Who or what is controlled by this consent. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor));
        children.add(new Property(SP_ACTION, "CodeableConcept", "Actions controlled by this consent.", 0, Integer.MAX_VALUE, this.action));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization));
        children.add(new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source));
        children.add(new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy));
        children.add(new Property("policyRule", "uri", "A referece to the specific computable policy.", 0, 1, this.policyRule));
        children.add(new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel));
        children.add(new Property(SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this consent.", 0, Integer.MAX_VALUE, this.purpose));
        children.add(new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this consent.", 0, 1, this.dataPeriod));
        children.add(new Property(SP_DATA, "", "The resources controlled by this consent, if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data));
        children.add(new Property("except", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, Integer.MAX_VALUE, this.except));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current state of this consent.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient/healthcare consumer to whom this consent applies.", 0, 1, this.patient);
            }
            case -991726143: {
                return new Property(SP_PERIOD, "Period", "Relevant time or time-period when this Consent is applicable.", 0, 1, this.period);
            }
            case 1792749467: {
                return new Property("dateTime", "dateTime", "When this  Consent was issued / created / indexed.", 0, 1, this.dateTime);
            }
            case -1886702018: {
                return new Property("consentingParty", "Reference(Organization|Patient|Practitioner|RelatedPerson)", "Either the Grantor, which is the entity responsible for granting the rights listed in a Consent Directive or the Grantee, which is the entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.consentingParty);
            }
            case 92645877: {
                return new Property(SP_ACTOR, "", "Who or what is controlled by this consent. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor);
            }
            case -1422950858: {
                return new Property(SP_ACTION, "CodeableConcept", "Actions controlled by this consent.", 0, Integer.MAX_VALUE, this.action);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization that manages the consent, and the framework within which it is executed.", 0, Integer.MAX_VALUE, this.organization);
            }
            case -1698413947: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -896505829: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case 1964406686: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -1985492188: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -244259472: {
                return new Property("source[x]", "Attachment|Identifier|Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "The source on which this consent statement is based. The source might be a scanned original paper form, or a reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, 1, this.source);
            }
            case -982670030: {
                return new Property("policy", "", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, Integer.MAX_VALUE, this.policy);
            }
            case 1593493326: {
                return new Property("policyRule", "uri", "A referece to the specific computable policy.", 0, 1, this.policyRule);
            }
            case -722296940: {
                return new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this consent. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel);
            }
            case -220463842: {
                return new Property(SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this consent.", 0, Integer.MAX_VALUE, this.purpose);
            }
            case 1177250315: {
                return new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this consent.", 0, 1, this.dataPeriod);
            }
            case 3076010: {
                return new Property(SP_DATA, "", "The resources controlled by this consent, if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data);
            }
            case -1289550567: {
                return new Property("except", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, Integer.MAX_VALUE, this.except);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 1792749467: {
                Base[] baseArray;
                if (this.dateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateTime;
                }
                return baseArray;
            }
            case -1886702018: {
                return this.consentingParty == null ? new Base[]{} : this.consentingParty.toArray(new Base[this.consentingParty.size()]);
            }
            case 92645877: {
                return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
            case 1178922291: {
                return this.organization == null ? new Base[]{} : this.organization.toArray(new Base[this.organization.size()]);
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.source;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 1593493326: {
                Base[] baseArray;
                if (this.policyRule == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.policyRule;
                }
                return baseArray;
            }
            case -722296940: {
                return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
            }
            case -220463842: {
                return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
            }
            case 1177250315: {
                Base[] baseArray;
                if (this.dataPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.dataPeriod;
                }
                return baseArray;
            }
            case 3076010: {
                return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
            }
            case -1289550567: {
                return this.except == null ? new Base[]{} : this.except.toArray(new Base[this.except.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new ConsentStateEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 1792749467: {
                this.dateTime = this.castToDateTime(value);
                return value;
            }
            case -1886702018: {
                this.getConsentingParty().add(this.castToReference(value));
                return value;
            }
            case 92645877: {
                this.getActor().add((ConsentActorComponent)((Object)value));
                return value;
            }
            case -1422950858: {
                this.getAction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1178922291: {
                this.getOrganization().add(this.castToReference(value));
                return value;
            }
            case -896505829: {
                this.source = this.castToType(value);
                return value;
            }
            case -982670030: {
                this.getPolicy().add((ConsentPolicyComponent)((Object)value));
                return value;
            }
            case 1593493326: {
                this.policyRule = this.castToUri(value);
                return value;
            }
            case -722296940: {
                this.getSecurityLabel().add(this.castToCoding(value));
                return value;
            }
            case -220463842: {
                this.getPurpose().add(this.castToCoding(value));
                return value;
            }
            case 1177250315: {
                this.dataPeriod = this.castToPeriod(value);
                return value;
            }
            case 3076010: {
                this.getData().add((ConsentDataComponent)((Object)value));
                return value;
            }
            case -1289550567: {
                this.getExcept().add((ExceptComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ConsentStateEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_PERIOD)) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("dateTime")) {
            this.dateTime = this.castToDateTime(value);
        } else if (name.equals("consentingParty")) {
            this.getConsentingParty().add(this.castToReference(value));
        } else if (name.equals(SP_ACTOR)) {
            this.getActor().add((ConsentActorComponent)((Object)value));
        } else if (name.equals(SP_ACTION)) {
            this.getAction().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ORGANIZATION)) {
            this.getOrganization().add(this.castToReference(value));
        } else if (name.equals("source[x]")) {
            this.source = this.castToType(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add((ConsentPolicyComponent)((Object)value));
        } else if (name.equals("policyRule")) {
            this.policyRule = this.castToUri(value);
        } else if (name.equals("securityLabel")) {
            this.getSecurityLabel().add(this.castToCoding(value));
        } else if (name.equals(SP_PURPOSE)) {
            this.getPurpose().add(this.castToCoding(value));
        } else if (name.equals("dataPeriod")) {
            this.dataPeriod = this.castToPeriod(value);
        } else if (name.equals(SP_DATA)) {
            this.getData().add((ConsentDataComponent)((Object)value));
        } else if (name.equals("except")) {
            this.getExcept().add((ExceptComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1792749467: {
                return this.getDateTimeElement();
            }
            case -1886702018: {
                return this.addConsentingParty();
            }
            case 92645877: {
                return this.addActor();
            }
            case -1422950858: {
                return this.addAction();
            }
            case 1178922291: {
                return this.addOrganization();
            }
            case -1698413947: {
                return this.getSource();
            }
            case -896505829: {
                return this.getSource();
            }
            case -982670030: {
                return this.addPolicy();
            }
            case 1593493326: {
                return this.getPolicyRuleElement();
            }
            case -722296940: {
                return this.addSecurityLabel();
            }
            case -220463842: {
                return this.addPurpose();
            }
            case 1177250315: {
                return this.getDataPeriod();
            }
            case 3076010: {
                return this.addData();
            }
            case -1289550567: {
                return this.addExcept();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1792749467: {
                return new String[]{"dateTime"};
            }
            case -1886702018: {
                return new String[]{"Reference"};
            }
            case 92645877: {
                return new String[0];
            }
            case -1422950858: {
                return new String[]{"CodeableConcept"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case -896505829: {
                return new String[]{"Attachment", "Identifier", "Reference"};
            }
            case -982670030: {
                return new String[0];
            }
            case 1593493326: {
                return new String[]{"uri"};
            }
            case -722296940: {
                return new String[]{"Coding"};
            }
            case -220463842: {
                return new String[]{"Coding"};
            }
            case 1177250315: {
                return new String[]{"Period"};
            }
            case 3076010: {
                return new String[0];
            }
            case -1289550567: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Consent.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_PERIOD)) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("dateTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property Consent.dateTime");
        }
        if (name.equals("consentingParty")) {
            return this.addConsentingParty();
        }
        if (name.equals(SP_ACTOR)) {
            return this.addActor();
        }
        if (name.equals(SP_ACTION)) {
            return this.addAction();
        }
        if (name.equals(SP_ORGANIZATION)) {
            return this.addOrganization();
        }
        if (name.equals("sourceAttachment")) {
            this.source = new Attachment();
            return this.source;
        }
        if (name.equals("sourceIdentifier")) {
            this.source = new Identifier();
            return this.source;
        }
        if (name.equals("sourceReference")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("policy")) {
            return this.addPolicy();
        }
        if (name.equals("policyRule")) {
            throw new FHIRException("Cannot call addChild on a singleton property Consent.policyRule");
        }
        if (name.equals("securityLabel")) {
            return this.addSecurityLabel();
        }
        if (name.equals(SP_PURPOSE)) {
            return this.addPurpose();
        }
        if (name.equals("dataPeriod")) {
            this.dataPeriod = new Period();
            return this.dataPeriod;
        }
        if (name.equals(SP_DATA)) {
            return this.addData();
        }
        if (name.equals("except")) {
            return this.addExcept();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Consent";
    }

    @Override
    public Consent copy() {
        Consent dst = new Consent();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        Enumeration<ConsentState> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.period = this.period == null ? null : this.period.copy();
        DateTimeType dateTimeType = dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        if (this.consentingParty != null) {
            dst.consentingParty = new ArrayList<Reference>();
            for (Reference reference : this.consentingParty) {
                dst.consentingParty.add(reference.copy());
            }
        }
        if (this.actor != null) {
            dst.actor = new ArrayList<ConsentActorComponent>();
            for (ConsentActorComponent consentActorComponent : this.actor) {
                dst.actor.add(consentActorComponent.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.action) {
                dst.action.add(codeableConcept.copy());
            }
        }
        if (this.organization != null) {
            dst.organization = new ArrayList<Reference>();
            for (Reference reference : this.organization) {
                dst.organization.add(reference.copy());
            }
        }
        Type type = dst.source = this.source == null ? null : this.source.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<ConsentPolicyComponent>();
            for (ConsentPolicyComponent consentPolicyComponent : this.policy) {
                dst.policy.add(consentPolicyComponent.copy());
            }
        }
        UriType uriType = dst.policyRule = this.policyRule == null ? null : this.policyRule.copy();
        if (this.securityLabel != null) {
            dst.securityLabel = new ArrayList<Coding>();
            for (Coding coding : this.securityLabel) {
                dst.securityLabel.add(coding.copy());
            }
        }
        if (this.purpose != null) {
            dst.purpose = new ArrayList<Coding>();
            for (Coding coding : this.purpose) {
                dst.purpose.add(coding.copy());
            }
        }
        Period period = dst.dataPeriod = this.dataPeriod == null ? null : this.dataPeriod.copy();
        if (this.data != null) {
            dst.data = new ArrayList<ConsentDataComponent>();
            for (ConsentDataComponent consentDataComponent : this.data) {
                dst.data.add(consentDataComponent.copy());
            }
        }
        if (this.except != null) {
            dst.except = new ArrayList<ExceptComponent>();
            for (ExceptComponent exceptComponent : this.except) {
                dst.except.add(exceptComponent.copy());
            }
        }
        return dst;
    }

    protected Consent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareDeep(this.identifier, o.identifier, true) && Consent.compareDeep(this.status, o.status, true) && Consent.compareDeep(this.category, o.category, true) && Consent.compareDeep(this.patient, o.patient, true) && Consent.compareDeep(this.period, o.period, true) && Consent.compareDeep(this.dateTime, o.dateTime, true) && Consent.compareDeep(this.consentingParty, o.consentingParty, true) && Consent.compareDeep(this.actor, o.actor, true) && Consent.compareDeep(this.action, o.action, true) && Consent.compareDeep(this.organization, o.organization, true) && Consent.compareDeep(this.source, o.source, true) && Consent.compareDeep(this.policy, o.policy, true) && Consent.compareDeep(this.policyRule, o.policyRule, true) && Consent.compareDeep(this.securityLabel, o.securityLabel, true) && Consent.compareDeep(this.purpose, o.purpose, true) && Consent.compareDeep(this.dataPeriod, o.dataPeriod, true) && Consent.compareDeep(this.data, o.data, true) && Consent.compareDeep(this.except, o.except, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareValues(this.status, o.status, true) && Consent.compareValues(this.dateTime, o.dateTime, true) && Consent.compareValues(this.policyRule, o.policyRule, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.patient, this.period, this.dateTime, this.consentingParty, this.actor, this.action, this.organization, this.source, this.policy, this.policyRule, this.securityLabel, this.purpose, this.dataPeriod, this.data, this.except});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Consent;
    }

    public static class ConsentStateEnumFactory
    implements EnumFactory<ConsentState> {
        @Override
        public ConsentState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ConsentState.DRAFT;
            }
            if ("proposed".equals(codeString)) {
                return ConsentState.PROPOSED;
            }
            if ("active".equals(codeString)) {
                return ConsentState.ACTIVE;
            }
            if ("rejected".equals(codeString)) {
                return ConsentState.REJECTED;
            }
            if ("inactive".equals(codeString)) {
                return ConsentState.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConsentState.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ConsentState code '" + codeString + "'");
        }

        public Enumeration<ConsentState> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentState>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.DRAFT);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.PROPOSED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ACTIVE);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.REJECTED);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentState code) {
            if (code == ConsentState.NULL) {
                return null;
            }
            if (code == ConsentState.DRAFT) {
                return "draft";
            }
            if (code == ConsentState.PROPOSED) {
                return "proposed";
            }
            if (code == ConsentState.ACTIVE) {
                return "active";
            }
            if (code == ConsentState.REJECTED) {
                return "rejected";
            }
            if (code == ConsentState.INACTIVE) {
                return "inactive";
            }
            if (code == ConsentState.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentState code) {
            return code.getSystem();
        }
    }

    public static enum ConsentState {
        DRAFT,
        PROPOSED,
        ACTIVE,
        REJECTED,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static ConsentState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case PROPOSED: {
                    return "proposed";
                }
                case ACTIVE: {
                    return "active";
                }
                case REJECTED: {
                    return "rejected";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case PROPOSED: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The consent is in development or awaiting use but is not yet intended to be acted upon.";
                }
                case PROPOSED: {
                    return "The consent has been proposed but not yet agreed to by all parties. The negotiation stage.";
                }
                case ACTIVE: {
                    return "The consent is to be followed and enforced.";
                }
                case REJECTED: {
                    return "The consent has been rejected by one or more of the parties.";
                }
                case INACTIVE: {
                    return "The consent is terminated or replaced.";
                }
                case ENTEREDINERROR: {
                    return "The consent was created wrongly (e.g. wrong patient) and should be ignored";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Pending";
                }
                case PROPOSED: {
                    return "Proposed";
                }
                case ACTIVE: {
                    return "Active";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ConsentActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the actor is involved", formalDefinition="How the individual is involved in the resources content that is described in the consent.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected CodeableConcept role;
        @Child(name="reference", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource for the actor (or group, by role)", formalDefinition="The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = 1152919415L;

        public ConsentActorComponent() {
        }

        public ConsentActorComponent(CodeableConcept role, Reference reference) {
            this.role = role;
            this.reference = reference;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentActorComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ConsentActorComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentActorComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConsentActorComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ConsentActorComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the consent.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson)", "The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the consent.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson)", "The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConsentActorComponent copy() {
            ConsentActorComponent dst = new ConsentActorComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentActorComponent)) {
                return false;
            }
            ConsentActorComponent o = (ConsentActorComponent)other_;
            return ConsentActorComponent.compareDeep(this.role, o.role, true) && ConsentActorComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentActorComponent)) {
                return false;
            }
            ConsentActorComponent o = (ConsentActorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.actor";
        }
    }

    @Block
    public static class ConsentPolicyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Enforcement source for policy", formalDefinition="Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.")
        protected UriType authority;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific policy covered by this consent", formalDefinition="The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.")
        protected UriType uri;
        private static final long serialVersionUID = 672275705L;

        public UriType getAuthorityElement() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new UriType();
                }
            }
            return this.authority;
        }

        public boolean hasAuthorityElement() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public ConsentPolicyComponent setAuthorityElement(UriType value) {
            this.authority = value;
            return this;
        }

        public String getAuthority() {
            return this.authority == null ? null : (String)this.authority.getValue();
        }

        public ConsentPolicyComponent setAuthority(String value) {
            if (Utilities.noString((String)value)) {
                this.authority = null;
            } else {
                if (this.authority == null) {
                    this.authority = new UriType();
                }
                this.authority.setValue(value);
            }
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ConsentPolicyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ConsentPolicyComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.", 0, 1, this.authority));
            children.add(new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "uri", "Entity or Organization having regulatory jurisdiction or accountability for \u00a0enforcing policies pertaining to Consent Directives.", 0, 1, this.authority);
                }
                case 116076: {
                    return new Property("uri", "uri", "The references to the policies that are included in this consent scope. Policies may be organizational, but are often defined jurisdictionally, or in law.", 0, 1, this.uri);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = this.castToUri(value);
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = this.castToUri(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthorityElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"uri"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.authority");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentPolicyComponent copy() {
            ConsentPolicyComponent dst = new ConsentPolicyComponent();
            this.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareDeep(this.authority, o.authority, true) && ConsentPolicyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyComponent)) {
                return false;
            }
            ConsentPolicyComponent o = (ConsentPolicyComponent)other_;
            return ConsentPolicyComponent.compareValues(this.authority, o.authority, true) && ConsentPolicyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.uri});
        }

        @Override
        public String fhirType() {
            return "Consent.policy";
        }
    }

    @Block
    public static class ConsentDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = -424898645L;

        public ConsentDataComponent() {
        }

        public ConsentDataComponent(Enumeration<ConsentDataMeaning> meaning, Reference reference) {
            this.meaning = meaning;
            this.reference = reference;
        }

        public Enumeration<ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentDataComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public ConsentDataComponent setMeaningElement(Enumeration<ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public ConsentDataComponent setMeaning(ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentDataComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConsentDataComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ConsentDataComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConsentDataComponent copy() {
            ConsentDataComponent dst = new ConsentDataComponent();
            this.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentDataComponent)) {
                return false;
            }
            ConsentDataComponent o = (ConsentDataComponent)other_;
            return ConsentDataComponent.compareDeep(this.meaning, o.meaning, true) && ConsentDataComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentDataComponent)) {
                return false;
            }
            ConsentDataComponent o = (ConsentDataComponent)other_;
            return ConsentDataComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.data";
        }
    }

    @Block
    public static class ExceptComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="deny | permit", formalDefinition="Action  to take - permit or deny - when the exception conditions are met.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-except-type")
        protected Enumeration<ConsentExceptType> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for this exception", formalDefinition="The timeframe in this exception is valid.")
        protected Period period;
        @Child(name="actor", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Who|what controlled by this exception (or group, by role)", formalDefinition="Who or what is controlled by this Exception. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected List<ExceptActorComponent> actor;
        @Child(name="action", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions controlled by this exception", formalDefinition="Actions controlled by this Exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        protected List<CodeableConcept> action;
        @Child(name="securityLabel", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A set of security labels that define which resources are controlled by this exception. If more than one label is specified, all resources must have all the specified labels.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        protected List<Coding> securityLabel;
        @Child(name="purpose", type={Coding.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Context of activities covered by this exception", formalDefinition="The context of the activities a user is taking - why the user is accessing the data - that are controlled by this exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-PurposeOfUse")
        protected List<Coding> purpose;
        @Child(name="class", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. Resource Type, Profile, or CDA etc", formalDefinition="The class of information covered by this exception. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        protected List<Coding> class_;
        @Child(name="code", type={Coding.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. LOINC or SNOMED CT code, etc in the content", formalDefinition="If this code is found in an instance, then the exception applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-code")
        protected List<Coding> code;
        @Child(name="dataPeriod", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for data controlled by this exception", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this exception.")
        protected Period dataPeriod;
        @Child(name="data", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Data controlled by this exception", formalDefinition="The resources controlled by this exception, if specific resources are referenced.")
        protected List<ExceptDataComponent> data;
        private static final long serialVersionUID = 1586636291L;

        public ExceptComponent() {
        }

        public ExceptComponent(Enumeration<ConsentExceptType> type) {
            this.type = type;
        }

        public Enumeration<ConsentExceptType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConsentExceptType>(new ConsentExceptTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ExceptComponent setTypeElement(Enumeration<ConsentExceptType> value) {
            this.type = value;
            return this;
        }

        public ConsentExceptType getType() {
            return this.type == null ? null : (ConsentExceptType)((Object)this.type.getValue());
        }

        public ExceptComponent setType(ConsentExceptType value) {
            if (this.type == null) {
                this.type = new Enumeration<ConsentExceptType>(new ConsentExceptTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ExceptComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<ExceptActorComponent> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<ExceptActorComponent>();
            }
            return this.actor;
        }

        public ExceptComponent setActor(List<ExceptActorComponent> theActor) {
            this.actor = theActor;
            return this;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (ExceptActorComponent item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExceptActorComponent addActor() {
            ExceptActorComponent t = new ExceptActorComponent();
            if (this.actor == null) {
                this.actor = new ArrayList<ExceptActorComponent>();
            }
            this.actor.add(t);
            return t;
        }

        public ExceptComponent addActor(ExceptActorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<ExceptActorComponent>();
            }
            this.actor.add(t);
            return this;
        }

        public ExceptActorComponent getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                this.addActor();
            }
            return this.getActor().get(0);
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public ExceptComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public ExceptComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public ExceptComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public ExceptComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public List<Coding> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            return this.purpose;
        }

        public ExceptComponent setPurpose(List<Coding> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (Coding item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurpose() {
            Coding t = new Coding();
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return t;
        }

        public ExceptComponent addPurpose(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return this;
        }

        public Coding getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        public List<Coding> getClass_() {
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            return this.class_;
        }

        public ExceptComponent setClass_(List<Coding> theClass_) {
            this.class_ = theClass_;
            return this;
        }

        public boolean hasClass_() {
            if (this.class_ == null) {
                return false;
            }
            for (Coding item : this.class_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addClass_() {
            Coding t = new Coding();
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return t;
        }

        public ExceptComponent addClass_(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.class_ == null) {
                this.class_ = new ArrayList<Coding>();
            }
            this.class_.add(t);
            return this;
        }

        public Coding getClass_FirstRep() {
            if (this.getClass_().isEmpty()) {
                this.addClass_();
            }
            return this.getClass_().get(0);
        }

        public List<Coding> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            return this.code;
        }

        public ExceptComponent setCode(List<Coding> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (Coding item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addCode() {
            Coding t = new Coding();
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return t;
        }

        public ExceptComponent addCode(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<Coding>();
            }
            this.code.add(t);
            return this;
        }

        public Coding getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getDataPeriod() {
            if (this.dataPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptComponent.dataPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataPeriod = new Period();
                }
            }
            return this.dataPeriod;
        }

        public boolean hasDataPeriod() {
            return this.dataPeriod != null && !this.dataPeriod.isEmpty();
        }

        public ExceptComponent setDataPeriod(Period value) {
            this.dataPeriod = value;
            return this;
        }

        public List<ExceptDataComponent> getData() {
            if (this.data == null) {
                this.data = new ArrayList<ExceptDataComponent>();
            }
            return this.data;
        }

        public ExceptComponent setData(List<ExceptDataComponent> theData) {
            this.data = theData;
            return this;
        }

        public boolean hasData() {
            if (this.data == null) {
                return false;
            }
            for (ExceptDataComponent item : this.data) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ExceptDataComponent addData() {
            ExceptDataComponent t = new ExceptDataComponent();
            if (this.data == null) {
                this.data = new ArrayList<ExceptDataComponent>();
            }
            this.data.add(t);
            return t;
        }

        public ExceptComponent addData(ExceptDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new ArrayList<ExceptDataComponent>();
            }
            this.data.add(t);
            return this;
        }

        public ExceptDataComponent getDataFirstRep() {
            if (this.getData().isEmpty()) {
                this.addData();
            }
            return this.getData().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Action  to take - permit or deny - when the exception conditions are met.", 0, 1, this.type));
            children.add(new Property(Consent.SP_PERIOD, "Period", "The timeframe in this exception is valid.", 0, 1, this.period));
            children.add(new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this Exception. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor));
            children.add(new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Exception.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this exception. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this exception.", 0, Integer.MAX_VALUE, this.purpose));
            children.add(new Property("class", "Coding", "The class of information covered by this exception. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_));
            children.add(new Property("code", "Coding", "If this code is found in an instance, then the exception applies.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this exception.", 0, 1, this.dataPeriod));
            children.add(new Property(Consent.SP_DATA, "", "The resources controlled by this exception, if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Action  to take - permit or deny - when the exception conditions are met.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property(Consent.SP_PERIOD, "Period", "The timeframe in this exception is valid.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this Exception. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor);
                }
                case -1422950858: {
                    return new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this Exception.", 0, Integer.MAX_VALUE, this.action);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "A set of security labels that define which resources are controlled by this exception. If more than one label is specified, all resources must have all the specified labels.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case -220463842: {
                    return new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this exception.", 0, Integer.MAX_VALUE, this.purpose);
                }
                case 94742904: {
                    return new Property("class", "Coding", "The class of information covered by this exception. The type can be a FHIR resource type, a profile on a type, or a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.class_);
                }
                case 3059181: {
                    return new Property("code", "Coding", "If this code is found in an instance, then the exception applies.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1177250315: {
                    return new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this exception.", 0, 1, this.dataPeriod);
                }
                case 3076010: {
                    return new Property(Consent.SP_DATA, "", "The resources controlled by this exception, if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
                case 94742904: {
                    return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1177250315: {
                    Base[] baseArray;
                    if (this.dataPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataPeriod;
                    }
                    return baseArray;
                }
                case 3076010: {
                    return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ConsentExceptTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.getActor().add((ExceptActorComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(this.castToCoding(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(this.castToCoding(value));
                    return value;
                }
                case 94742904: {
                    this.getClass_().add(this.castToCoding(value));
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCoding(value));
                    return value;
                }
                case 1177250315: {
                    this.dataPeriod = this.castToPeriod(value);
                    return value;
                }
                case 3076010: {
                    this.getData().add((ExceptDataComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConsentExceptTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals(Consent.SP_PERIOD)) {
                this.period = this.castToPeriod(value);
            } else if (name.equals(Consent.SP_ACTOR)) {
                this.getActor().add((ExceptActorComponent)((Object)value));
            } else if (name.equals(Consent.SP_ACTION)) {
                this.getAction().add(this.castToCodeableConcept(value));
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(this.castToCoding(value));
            } else if (name.equals(Consent.SP_PURPOSE)) {
                this.getPurpose().add(this.castToCoding(value));
            } else if (name.equals("class")) {
                this.getClass_().add(this.castToCoding(value));
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCoding(value));
            } else if (name.equals("dataPeriod")) {
                this.dataPeriod = this.castToPeriod(value);
            } else if (name.equals(Consent.SP_DATA)) {
                this.getData().add((ExceptDataComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.addActor();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case -220463842: {
                    return this.addPurpose();
                }
                case 94742904: {
                    return this.addClass_();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1177250315: {
                    return this.getDataPeriod();
                }
                case 3076010: {
                    return this.addData();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case -220463842: {
                    return new String[]{"Coding"};
                }
                case 94742904: {
                    return new String[]{"Coding"};
                }
                case 3059181: {
                    return new String[]{"Coding"};
                }
                case 1177250315: {
                    return new String[]{"Period"};
                }
                case 3076010: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.type");
            }
            if (name.equals(Consent.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Consent.SP_ACTOR)) {
                return this.addActor();
            }
            if (name.equals(Consent.SP_ACTION)) {
                return this.addAction();
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(Consent.SP_PURPOSE)) {
                return this.addPurpose();
            }
            if (name.equals("class")) {
                return this.addClass_();
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("dataPeriod")) {
                this.dataPeriod = new Period();
                return this.dataPeriod;
            }
            if (name.equals(Consent.SP_DATA)) {
                return this.addData();
            }
            return super.addChild(name);
        }

        @Override
        public ExceptComponent copy() {
            ExceptComponent dst = new ExceptComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.actor != null) {
                dst.actor = new ArrayList<ExceptActorComponent>();
                for (ExceptActorComponent exceptActorComponent : this.actor) {
                    dst.actor.add(exceptActorComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding : this.securityLabel) {
                    dst.securityLabel.add(coding.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<Coding>();
                for (Coding coding : this.purpose) {
                    dst.purpose.add(coding.copy());
                }
            }
            if (this.class_ != null) {
                dst.class_ = new ArrayList<Coding>();
                for (Coding coding : this.class_) {
                    dst.class_.add(coding.copy());
                }
            }
            if (this.code != null) {
                dst.code = new ArrayList<Coding>();
                for (Coding coding : this.code) {
                    dst.code.add(coding.copy());
                }
            }
            Period period2 = dst.dataPeriod = this.dataPeriod == null ? null : this.dataPeriod.copy();
            if (this.data != null) {
                dst.data = new ArrayList<ExceptDataComponent>();
                for (ExceptDataComponent exceptDataComponent : this.data) {
                    dst.data.add(exceptDataComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptComponent)) {
                return false;
            }
            ExceptComponent o = (ExceptComponent)other_;
            return ExceptComponent.compareDeep(this.type, o.type, true) && ExceptComponent.compareDeep(this.period, o.period, true) && ExceptComponent.compareDeep(this.actor, o.actor, true) && ExceptComponent.compareDeep(this.action, o.action, true) && ExceptComponent.compareDeep(this.securityLabel, o.securityLabel, true) && ExceptComponent.compareDeep(this.purpose, o.purpose, true) && ExceptComponent.compareDeep(this.class_, o.class_, true) && ExceptComponent.compareDeep(this.code, o.code, true) && ExceptComponent.compareDeep(this.dataPeriod, o.dataPeriod, true) && ExceptComponent.compareDeep(this.data, o.data, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptComponent)) {
                return false;
            }
            ExceptComponent o = (ExceptComponent)other_;
            return ExceptComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.actor, this.action, this.securityLabel, this.purpose, this.class_, this.code, this.dataPeriod, this.data});
        }

        @Override
        public String fhirType() {
            return "Consent.except";
        }
    }

    @Block
    public static class ExceptDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = -424898645L;

        public ExceptDataComponent() {
        }

        public ExceptDataComponent(Enumeration<ConsentDataMeaning> meaning, Reference reference) {
            this.meaning = meaning;
            this.reference = reference;
        }

        public Enumeration<ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptDataComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public ExceptDataComponent setMeaningElement(Enumeration<ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public ExceptDataComponent setMeaning(ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<ConsentDataMeaning>(new ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptDataComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ExceptDataComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ExceptDataComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new ConsentDataMeaningEnumFactory().fromType(this.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a singleton property Consent.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ExceptDataComponent copy() {
            ExceptDataComponent dst = new ExceptDataComponent();
            this.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptDataComponent)) {
                return false;
            }
            ExceptDataComponent o = (ExceptDataComponent)other_;
            return ExceptDataComponent.compareDeep(this.meaning, o.meaning, true) && ExceptDataComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptDataComponent)) {
                return false;
            }
            ExceptDataComponent o = (ExceptDataComponent)other_;
            return ExceptDataComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.except.data";
        }
    }

    @Block
    public static class ExceptActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the actor is involved", formalDefinition="How the individual is involved in the resources content that is described in the exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected CodeableConcept role;
        @Child(name="reference", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource for the actor (or group, by role)", formalDefinition="The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected Reference reference;
        protected Resource referenceTarget;
        private static final long serialVersionUID = 1152919415L;

        public ExceptActorComponent() {
        }

        public ExceptActorComponent(CodeableConcept role, Reference reference) {
            this.role = role;
            this.reference = reference;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptActorComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ExceptActorComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ExceptActorComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ExceptActorComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public ExceptActorComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson)", "The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson)", "The resource that identifies the actor. To identify a actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ExceptActorComponent copy() {
            ExceptActorComponent dst = new ExceptActorComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptActorComponent)) {
                return false;
            }
            ExceptActorComponent o = (ExceptActorComponent)other_;
            return ExceptActorComponent.compareDeep(this.role, o.role, true) && ExceptActorComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ExceptActorComponent)) {
                return false;
            }
            ExceptActorComponent o = (ExceptActorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "Consent.except.actor";
        }
    }

    public static class ConsentExceptTypeEnumFactory
    implements EnumFactory<ConsentExceptType> {
        @Override
        public ConsentExceptType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return ConsentExceptType.DENY;
            }
            if ("permit".equals(codeString)) {
                return ConsentExceptType.PERMIT;
            }
            throw new IllegalArgumentException("Unknown ConsentExceptType code '" + codeString + "'");
        }

        public Enumeration<ConsentExceptType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentExceptType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return new Enumeration<ConsentExceptType>(this, ConsentExceptType.DENY);
            }
            if ("permit".equals(codeString)) {
                return new Enumeration<ConsentExceptType>(this, ConsentExceptType.PERMIT);
            }
            throw new FHIRException("Unknown ConsentExceptType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentExceptType code) {
            if (code == ConsentExceptType.NULL) {
                return null;
            }
            if (code == ConsentExceptType.DENY) {
                return "deny";
            }
            if (code == ConsentExceptType.PERMIT) {
                return "permit";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentExceptType code) {
            return code.getSystem();
        }
    }

    public static enum ConsentExceptType {
        DENY,
        PERMIT,
        NULL;


        public static ConsentExceptType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("deny".equals(codeString)) {
                return DENY;
            }
            if ("permit".equals(codeString)) {
                return PERMIT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentExceptType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DENY: {
                    return "deny";
                }
                case PERMIT: {
                    return "permit";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DENY: {
                    return "http://hl7.org/fhir/consent-except-type";
                }
                case PERMIT: {
                    return "http://hl7.org/fhir/consent-except-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DENY: {
                    return "Consent is denied for actions meeting these rules";
                }
                case PERMIT: {
                    return "Consent is provided for actions meeting these rules";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DENY: {
                    return "Opt Out";
                }
                case PERMIT: {
                    return "Opt In";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConsentDataMeaningEnumFactory
    implements EnumFactory<ConsentDataMeaning> {
        @Override
        public ConsentDataMeaning fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return ConsentDataMeaning.INSTANCE;
            }
            if ("related".equals(codeString)) {
                return ConsentDataMeaning.RELATED;
            }
            if ("dependents".equals(codeString)) {
                return ConsentDataMeaning.DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return ConsentDataMeaning.AUTHOREDBY;
            }
            throw new IllegalArgumentException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public Enumeration<ConsentDataMeaning> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentDataMeaning>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.INSTANCE);
            }
            if ("related".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.RELATED);
            }
            if ("dependents".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.DEPENDENTS);
            }
            if ("authoredby".equals(codeString)) {
                return new Enumeration<ConsentDataMeaning>(this, ConsentDataMeaning.AUTHOREDBY);
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentDataMeaning code) {
            if (code == ConsentDataMeaning.NULL) {
                return null;
            }
            if (code == ConsentDataMeaning.INSTANCE) {
                return "instance";
            }
            if (code == ConsentDataMeaning.RELATED) {
                return "related";
            }
            if (code == ConsentDataMeaning.DEPENDENTS) {
                return "dependents";
            }
            if (code == ConsentDataMeaning.AUTHOREDBY) {
                return "authoredby";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentDataMeaning code) {
            return code.getSystem();
        }
    }

    public static enum ConsentDataMeaning {
        INSTANCE,
        RELATED,
        DEPENDENTS,
        AUTHOREDBY,
        NULL;


        public static ConsentDataMeaning fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("related".equals(codeString)) {
                return RELATED;
            }
            if ("dependents".equals(codeString)) {
                return DEPENDENTS;
            }
            if ("authoredby".equals(codeString)) {
                return AUTHOREDBY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentDataMeaning code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case RELATED: {
                    return "related";
                }
                case DEPENDENTS: {
                    return "dependents";
                }
                case AUTHOREDBY: {
                    return "authoredby";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case RELATED: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case DEPENDENTS: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case AUTHOREDBY: {
                    return "http://hl7.org/fhir/consent-data-meaning";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The consent applies directly to the instance of the resource";
                }
                case RELATED: {
                    return "The consent applies directly to the instance of the resource and instances it refers to";
                }
                case DEPENDENTS: {
                    return "The consent applies directly to the instance of the resource and instances that refer to it";
                }
                case AUTHOREDBY: {
                    return "The consent applies to instances of resources that are authored by";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case RELATED: {
                    return "Related";
                }
                case DEPENDENTS: {
                    return "Dependents";
                }
                case AUTHOREDBY: {
                    return "AuthoredBy";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

