/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PlanDefinition", profile="http://hl7.org/fhir/Profile/PlanDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "type", "status", "experimental", "date", "publisher", "description", "purpose", "usage", "approvalDate", "lastReviewDate", "effectivePeriod", "useContext", "jurisdiction", "topic", "contributor", "contact", "copyright", "relatedArtifact", "library", "goal", "action"})
public class PlanDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the plan definition", formalDefinition="A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="order-set | protocol | eca-rule", formalDefinition="The type of asset the plan definition represents, e.g. an order set, protocol, or event-condition-action rule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/plan-definition-type")
    protected CodeableConcept type;
    @Child(name="purpose", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this plan definition is defined", formalDefinition="Explaination of why this plan definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the asset", formalDefinition="A detailed description of how the asset is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="approvalDate", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the plan definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the plan definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the plan definition is expected to be used", formalDefinition="The period during which the plan definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc", formalDefinition="Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="contributor", type={Contributor.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A content contributor", formalDefinition="A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.")
    protected List<Contributor> contributor;
    @Child(name="copyright", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.")
    protected MarkdownType copyright;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Related artifacts for the asset", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={Library.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the plan definition", formalDefinition="A reference to a Library resource containing any formal logic used by the plan definition.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="goal", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What the plan is trying to accomplish", formalDefinition="Goals that describe what the activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.")
    protected List<PlanDefinitionGoalComponent> goal;
    @Child(name="action", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action defined by the plan", formalDefinition="An action to be taken as part of the plan.")
    protected List<PlanDefinitionActionComponent> action;
    private static final long serialVersionUID = -1191108677L;
    @SearchParamDefinition(name="date", path="PlanDefinition.date", description="The plan definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="PlanDefinition.identifier", description="External identifier for the plan definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="PlanDefinition.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("PlanDefinition:successor").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="PlanDefinition.jurisdiction", description="Intended jurisdiction for the plan definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="PlanDefinition.description", description="The description of the plan definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="PlanDefinition.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("PlanDefinition:derived-from").toLocked();
    @SearchParamDefinition(name="predecessor", path="PlanDefinition.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("PlanDefinition:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="PlanDefinition.title", description="The human-friendly name of the plan definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="PlanDefinition.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("PlanDefinition:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="PlanDefinition.version", description="The business version of the plan definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="PlanDefinition.url", description="The uri that identifies the plan definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="effective", path="PlanDefinition.effectivePeriod", description="The time during which the plan definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="PlanDefinition.relatedArtifact.where(type='depends-on').resource | PlanDefinition.library", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("PlanDefinition:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="PlanDefinition.name", description="Computationally friendly name of the plan definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="PlanDefinition.publisher", description="Name of the publisher of the plan definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="PlanDefinition.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="status", path="PlanDefinition.status", description="The current status of the plan definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public PlanDefinition() {
    }

    public PlanDefinition(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public PlanDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public PlanDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PlanDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PlanDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public PlanDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public PlanDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public PlanDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public PlanDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public PlanDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public PlanDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public PlanDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public PlanDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public PlanDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public PlanDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public PlanDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public PlanDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public PlanDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public PlanDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public PlanDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public PlanDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public PlanDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public PlanDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public PlanDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public PlanDefinition setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public PlanDefinition setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public PlanDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public PlanDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public PlanDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public PlanDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public PlanDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public PlanDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public PlanDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public PlanDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public PlanDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public PlanDefinition setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public PlanDefinition addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<Contributor> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        return this.contributor;
    }

    public PlanDefinition setContributor(List<Contributor> theContributor) {
        this.contributor = theContributor;
        return this;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (Contributor item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Contributor addContributor() {
        Contributor t = new Contributor();
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return t;
    }

    public PlanDefinition addContributor(Contributor t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<Contributor>();
        }
        this.contributor.add(t);
        return this;
    }

    public Contributor getContributorFirstRep() {
        if (this.getContributor().isEmpty()) {
            this.addContributor();
        }
        return this.getContributor().get(0);
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public PlanDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public PlanDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PlanDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public PlanDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public PlanDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public PlanDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public PlanDefinition addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public PlanDefinition setLibrary(List<Reference> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public PlanDefinition addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public Reference getLibraryFirstRep() {
        if (this.getLibrary().isEmpty()) {
            this.addLibrary();
        }
        return this.getLibrary().get(0);
    }

    public List<PlanDefinitionGoalComponent> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        return this.goal;
    }

    public PlanDefinition setGoal(List<PlanDefinitionGoalComponent> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (PlanDefinitionGoalComponent item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PlanDefinitionGoalComponent addGoal() {
        PlanDefinitionGoalComponent t = new PlanDefinitionGoalComponent();
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        this.goal.add(t);
        return t;
    }

    public PlanDefinition addGoal(PlanDefinitionGoalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<PlanDefinitionGoalComponent>();
        }
        this.goal.add(t);
        return this;
    }

    public PlanDefinitionGoalComponent getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<PlanDefinitionActionComponent> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        return this.action;
    }

    public PlanDefinition setAction(List<PlanDefinitionActionComponent> theAction) {
        this.action = theAction;
        return this;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (PlanDefinitionActionComponent item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PlanDefinitionActionComponent addAction() {
        PlanDefinitionActionComponent t = new PlanDefinitionActionComponent();
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        this.action.add(t);
        return t;
    }

    public PlanDefinition addAction(PlanDefinitionActionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<PlanDefinitionActionComponent>();
        }
        this.action.add(t);
        return this;
    }

    public PlanDefinitionActionComponent getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            this.addAction();
        }
        return this.getAction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this plan definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this plan definition is (or will be) published. The URL SHOULD include the major version of the plan definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the plan definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the plan definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the plan definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the plan definition.", 0, 1, this.title));
        children.add(new Property("type", "CodeableConcept", "The type of asset the plan definition represents, e.g. an order set, protocol, or event-condition-action rule.", 0, 1, this.type));
        children.add(new Property(SP_STATUS, "code", "The status of this plan definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this plan definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the plan definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the plan definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the plan definition.", 0, 1, this.publisher));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the plan definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("purpose", "markdown", "Explaination of why this plan definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description of how the asset is used from a clinical perspective.", 0, 1, this.usage));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the plan definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate plan definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the plan definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("contributor", "Contributor", "A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.", 0, 1, this.copyright));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "Reference(Library)", "A reference to a Library resource containing any formal logic used by the plan definition.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("goal", "", "Goals that describe what the activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("action", "", "An action to be taken as part of the plan.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this plan definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this plan definition is (or will be) published. The URL SHOULD include the major version of the plan definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this plan definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the plan definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the plan definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the plan definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the plan definition.", 0, 1, this.title);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of asset the plan definition represents, e.g. an order set, protocol, or event-condition-action rule.", 0, 1, this.type);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this plan definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this plan definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the plan definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the plan definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the plan definition.", 0, 1, this.publisher);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the plan definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this plan definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description of how the asset is used from a clinical perspective.", 0, 1, this.usage);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the plan definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate plan definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the plan definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the plan definition. Topics provide a high-level categorization of the definition that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1895276325: {
                return new Property("contributor", "Contributor", "A contributor to the content of the asset, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the plan definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the plan definition.", 0, 1, this.copyright);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "Reference(Library)", "A reference to a Library resource containing any formal logic used by the plan definition.", 0, Integer.MAX_VALUE, this.library);
            }
            case 3178259: {
                return new Property("goal", "", "Goals that describe what the activities within the plan are intended to achieve. For example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.", 0, Integer.MAX_VALUE, this.goal);
            }
            case -1422950858: {
                return new Property("action", "", "An action to be taken as part of the plan.", 0, Integer.MAX_VALUE, this.action);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.usage;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.copyright;
                }
                return baseArray;
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1895276325: {
                this.getContributor().add(this.castToContributor(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add((PlanDefinitionGoalComponent)((Object)value));
                return value;
            }
            case -1422950858: {
                this.getAction().add((PlanDefinitionActionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("contributor")) {
            this.getContributor().add(this.castToContributor(value));
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("goal")) {
            this.getGoal().add((PlanDefinitionGoalComponent)((Object)value));
        } else if (name.equals("action")) {
            this.getAction().add((PlanDefinitionActionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case 3178259: {
                return this.addGoal();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1895276325: {
                return new String[]{"Contributor"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"Reference"};
            }
            case 3178259: {
                return new String[0];
            }
            case -1422950858: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.title");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.publisher");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.description");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.usage");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.copyright");
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("goal")) {
            return this.addGoal();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PlanDefinition";
    }

    @Override
    public PlanDefinition copy() {
        PlanDefinition dst = new PlanDefinition();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.publisher = this.publisher == null ? null : this.publisher.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.contributor != null) {
            dst.contributor = new ArrayList<Contributor>();
            for (Contributor contributor : this.contributor) {
                dst.contributor.add(contributor.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<PlanDefinitionGoalComponent>();
            for (PlanDefinitionGoalComponent planDefinitionGoalComponent : this.goal) {
                dst.goal.add(planDefinitionGoalComponent.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<PlanDefinitionActionComponent>();
            for (PlanDefinitionActionComponent planDefinitionActionComponent : this.action) {
                dst.action.add(planDefinitionActionComponent.copy());
            }
        }
        return dst;
    }

    protected PlanDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PlanDefinition)) {
            return false;
        }
        PlanDefinition o = (PlanDefinition)other_;
        return PlanDefinition.compareDeep(this.identifier, o.identifier, true) && PlanDefinition.compareDeep(this.type, o.type, true) && PlanDefinition.compareDeep(this.purpose, o.purpose, true) && PlanDefinition.compareDeep(this.usage, o.usage, true) && PlanDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && PlanDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && PlanDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && PlanDefinition.compareDeep(this.topic, o.topic, true) && PlanDefinition.compareDeep(this.contributor, o.contributor, true) && PlanDefinition.compareDeep(this.copyright, o.copyright, true) && PlanDefinition.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && PlanDefinition.compareDeep(this.library, o.library, true) && PlanDefinition.compareDeep(this.goal, o.goal, true) && PlanDefinition.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PlanDefinition)) {
            return false;
        }
        PlanDefinition o = (PlanDefinition)other_;
        return PlanDefinition.compareValues(this.purpose, o.purpose, true) && PlanDefinition.compareValues(this.usage, o.usage, true) && PlanDefinition.compareValues(this.approvalDate, o.approvalDate, true) && PlanDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && PlanDefinition.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.purpose, this.usage, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.contributor, this.copyright, this.relatedArtifact, this.library, this.goal, this.action});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PlanDefinition;
    }

    @Block
    public static class PlanDefinitionGoalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Treatment, dietary, behavioral, etc", formalDefinition="Indicates a category the goal falls within.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-category")
        protected CodeableConcept category;
        @Child(name="description", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or text describing the goal", formalDefinition="Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected CodeableConcept description;
        @Child(name="priority", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="high-priority | medium-priority | low-priority", formalDefinition="Identifies the expected level of importance associated with reaching/sustaining the defined goal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-priority")
        protected CodeableConcept priority;
        @Child(name="start", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When goal pursuit begins", formalDefinition="The event after which the goal should begin being pursued.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/goal-start-event")
        protected CodeableConcept start;
        @Child(name="addresses", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What does the goal address", formalDefinition="Identifies problems, conditions, issues, or concerns the goal is intended to address.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected List<CodeableConcept> addresses;
        @Child(name="documentation", type={RelatedArtifact.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the goal", formalDefinition="Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="target", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Target outcome for the goal", formalDefinition="Indicates what should be done and within what timeframe.")
        protected List<PlanDefinitionGoalTargetComponent> target;
        private static final long serialVersionUID = -795308926L;

        public PlanDefinitionGoalComponent() {
        }

        public PlanDefinitionGoalComponent(CodeableConcept description) {
            this.description = description;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public PlanDefinitionGoalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getDescription() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new CodeableConcept();
                }
            }
            return this.description;
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionGoalComponent setDescription(CodeableConcept value) {
            this.description = value;
            return this;
        }

        public CodeableConcept getPriority() {
            if (this.priority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.priority");
                }
                if (Configuration.doAutoCreate()) {
                    this.priority = new CodeableConcept();
                }
            }
            return this.priority;
        }

        public boolean hasPriority() {
            return this.priority != null && !this.priority.isEmpty();
        }

        public PlanDefinitionGoalComponent setPriority(CodeableConcept value) {
            this.priority = value;
            return this;
        }

        public CodeableConcept getStart() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new CodeableConcept();
                }
            }
            return this.start;
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public PlanDefinitionGoalComponent setStart(CodeableConcept value) {
            this.start = value;
            return this;
        }

        public List<CodeableConcept> getAddresses() {
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            return this.addresses;
        }

        public PlanDefinitionGoalComponent setAddresses(List<CodeableConcept> theAddresses) {
            this.addresses = theAddresses;
            return this;
        }

        public boolean hasAddresses() {
            if (this.addresses == null) {
                return false;
            }
            for (CodeableConcept item : this.addresses) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAddresses() {
            CodeableConcept t = new CodeableConcept();
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            this.addresses.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addAddresses(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.addresses == null) {
                this.addresses = new ArrayList<CodeableConcept>();
            }
            this.addresses.add(t);
            return this;
        }

        public CodeableConcept getAddressesFirstRep() {
            if (this.getAddresses().isEmpty()) {
                this.addAddresses();
            }
            return this.getAddresses().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public PlanDefinitionGoalComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<PlanDefinitionGoalTargetComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            return this.target;
        }

        public PlanDefinitionGoalComponent setTarget(List<PlanDefinitionGoalTargetComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (PlanDefinitionGoalTargetComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionGoalTargetComponent addTarget() {
            PlanDefinitionGoalTargetComponent t = new PlanDefinitionGoalTargetComponent();
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            this.target.add(t);
            return t;
        }

        public PlanDefinitionGoalComponent addTarget(PlanDefinitionGoalTargetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
            }
            this.target.add(t);
            return this;
        }

        public PlanDefinitionGoalTargetComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Indicates a category the goal falls within.", 0, 1, this.category));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description));
            children.add(new Property("priority", "CodeableConcept", "Identifies the expected level of importance associated with reaching/sustaining the defined goal.", 0, 1, this.priority));
            children.add(new Property("start", "CodeableConcept", "The event after which the goal should begin being pursued.", 0, 1, this.start));
            children.add(new Property("addresses", "CodeableConcept", "Identifies problems, conditions, issues, or concerns the goal is intended to address.", 0, Integer.MAX_VALUE, this.addresses));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("target", "", "Indicates what should be done and within what timeframe.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Indicates a category the goal falls within.", 0, 1, this.category);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "CodeableConcept", "Human-readable and/or coded description of a specific desired objective of care, such as \"control blood pressure\" or \"negotiate an obstacle course\" or \"dance with child at wedding\".", 0, 1, this.description);
                }
                case -1165461084: {
                    return new Property("priority", "CodeableConcept", "Identifies the expected level of importance associated with reaching/sustaining the defined goal.", 0, 1, this.priority);
                }
                case 109757538: {
                    return new Property("start", "CodeableConcept", "The event after which the goal should begin being pursued.", 0, 1, this.start);
                }
                case 874544034: {
                    return new Property("addresses", "CodeableConcept", "Identifies problems, conditions, issues, or concerns the goal is intended to address.", 0, Integer.MAX_VALUE, this.addresses);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case -880905839: {
                    return new Property("target", "", "Indicates what should be done and within what timeframe.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1165461084: {
                    Base[] baseArray;
                    if (this.priority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.priority;
                    }
                    return baseArray;
                }
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.start;
                    }
                    return baseArray;
                }
                case 874544034: {
                    return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToCodeableConcept(value);
                    return value;
                }
                case -1165461084: {
                    this.priority = this.castToCodeableConcept(value);
                    return value;
                }
                case 109757538: {
                    this.start = this.castToCodeableConcept(value);
                    return value;
                }
                case 874544034: {
                    this.getAddresses().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(this.castToRelatedArtifact(value));
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((PlanDefinitionGoalTargetComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = this.castToCodeableConcept(value);
            } else if (name.equals("priority")) {
                this.priority = this.castToCodeableConcept(value);
            } else if (name.equals("start")) {
                this.start = this.castToCodeableConcept(value);
            } else if (name.equals("addresses")) {
                this.getAddresses().add(this.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(this.castToRelatedArtifact(value));
            } else if (name.equals("target")) {
                this.getTarget().add((PlanDefinitionGoalTargetComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1724546052: {
                    return this.getDescription();
                }
                case -1165461084: {
                    return this.getPriority();
                }
                case 109757538: {
                    return this.getStart();
                }
                case 874544034: {
                    return this.addAddresses();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"CodeableConcept"};
                }
                case -1165461084: {
                    return new String[]{"CodeableConcept"};
                }
                case 109757538: {
                    return new String[]{"CodeableConcept"};
                }
                case 874544034: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = new CodeableConcept();
                return this.description;
            }
            if (name.equals("priority")) {
                this.priority = new CodeableConcept();
                return this.priority;
            }
            if (name.equals("start")) {
                this.start = new CodeableConcept();
                return this.start;
            }
            if (name.equals("addresses")) {
                return this.addAddresses();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionGoalComponent copy() {
            PlanDefinitionGoalComponent dst = new PlanDefinitionGoalComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.priority = this.priority == null ? null : this.priority.copy();
            CodeableConcept codeableConcept = dst.start = this.start == null ? null : this.start.copy();
            if (this.addresses != null) {
                dst.addresses = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.addresses) {
                    dst.addresses.add(codeableConcept2.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.target != null) {
                dst.target = new ArrayList<PlanDefinitionGoalTargetComponent>();
                for (PlanDefinitionGoalTargetComponent planDefinitionGoalTargetComponent : this.target) {
                    dst.target.add(planDefinitionGoalTargetComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalComponent)) {
                return false;
            }
            PlanDefinitionGoalComponent o = (PlanDefinitionGoalComponent)other_;
            return PlanDefinitionGoalComponent.compareDeep(this.category, o.category, true) && PlanDefinitionGoalComponent.compareDeep(this.description, o.description, true) && PlanDefinitionGoalComponent.compareDeep(this.priority, o.priority, true) && PlanDefinitionGoalComponent.compareDeep(this.start, o.start, true) && PlanDefinitionGoalComponent.compareDeep(this.addresses, o.addresses, true) && PlanDefinitionGoalComponent.compareDeep(this.documentation, o.documentation, true) && PlanDefinitionGoalComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalComponent)) {
                return false;
            }
            PlanDefinitionGoalComponent o = (PlanDefinitionGoalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.description, this.priority, this.start, this.addresses, this.documentation, this.target});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.goal";
        }
    }

    @Block
    public static class PlanDefinitionActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible label for the action (e.g. 1. or A.)", formalDefinition="A user-visible label for the action.")
        protected StringType label;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User-visible title", formalDefinition="The title of the action displayed to a user.")
        protected StringType title;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short description of the action", formalDefinition="A short description of the action used to provide a summary to display to the user.")
        protected StringType description;
        @Child(name="textEquivalent", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Static text equivalent of the action, used if the dynamic aspects cannot be interpreted by the receiving system", formalDefinition="A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.")
        protected StringType textEquivalent;
        @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code representing the meaning of the action or sub-actions", formalDefinition="A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.")
        protected List<CodeableConcept> code;
        @Child(name="reason", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why the action should be performed", formalDefinition="A description of why this action is necessary or appropriate.")
        protected List<CodeableConcept> reason;
        @Child(name="documentation", type={RelatedArtifact.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting documentation for the intended performer of the action", formalDefinition="Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.")
        protected List<RelatedArtifact> documentation;
        @Child(name="goalId", type={IdType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What goals this action supports", formalDefinition="Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition.")
        protected List<IdType> goalId;
        @Child(name="triggerDefinition", type={TriggerDefinition.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should be triggered", formalDefinition="A description of when the action should be triggered.")
        protected List<TriggerDefinition> triggerDefinition;
        @Child(name="condition", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Whether or not the action is applicable", formalDefinition="An expression that describes applicability criteria, or start/stop conditions for the action.")
        protected List<PlanDefinitionActionConditionComponent> condition;
        @Child(name="input", type={DataRequirement.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Input data requirements", formalDefinition="Defines input data requirements for the action.")
        protected List<DataRequirement> input;
        @Child(name="output", type={DataRequirement.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Output data definition", formalDefinition="Defines the outputs of the action, if any.")
        protected List<DataRequirement> output;
        @Child(name="relatedAction", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relationship to another action", formalDefinition="A relationship to another action such as \"before\" or \"30-60 minutes after start of\".")
        protected List<PlanDefinitionActionRelatedActionComponent> relatedAction;
        @Child(name="timing", type={DateTimeType.class, Period.class, Duration.class, Range.class, Timing.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the action should take place", formalDefinition="An optional value describing when the action should be performed.")
        protected Type timing;
        @Child(name="participant", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who should participate in the action", formalDefinition="Indicates who should participate in performing the action described.")
        protected List<PlanDefinitionActionParticipantComponent> participant;
        @Child(name="type", type={Coding.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="create | update | remove | fire-event", formalDefinition="The type of action to perform (create, update, remove).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-type")
        protected Coding type;
        @Child(name="groupingBehavior", type={CodeType.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="visual-group | logical-group | sentence-group", formalDefinition="Defines the grouping behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-grouping-behavior")
        protected Enumeration<ActionGroupingBehavior> groupingBehavior;
        @Child(name="selectionBehavior", type={CodeType.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="any | all | all-or-none | exactly-one | at-most-one | one-or-more", formalDefinition="Defines the selection behavior for the action and its children.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-selection-behavior")
        protected Enumeration<ActionSelectionBehavior> selectionBehavior;
        @Child(name="requiredBehavior", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="must | could | must-unless-documented", formalDefinition="Defines the requiredness behavior for the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-required-behavior")
        protected Enumeration<ActionRequiredBehavior> requiredBehavior;
        @Child(name="precheckBehavior", type={CodeType.class}, order=20, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="yes | no", formalDefinition="Defines whether the action should usually be preselected.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-precheck-behavior")
        protected Enumeration<ActionPrecheckBehavior> precheckBehavior;
        @Child(name="cardinalityBehavior", type={CodeType.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="single | multiple", formalDefinition="Defines whether the action can be selected multiple times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-cardinality-behavior")
        protected Enumeration<ActionCardinalityBehavior> cardinalityBehavior;
        @Child(name="definition", type={ActivityDefinition.class, PlanDefinition.class}, order=22, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the activity to be performed", formalDefinition="A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.")
        protected Reference definition;
        protected Resource definitionTarget;
        @Child(name="transform", type={StructureMap.class}, order=23, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Transform to apply the template", formalDefinition="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.")
        protected Reference transform;
        protected StructureMap transformTarget;
        @Child(name="dynamicValue", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.")
        protected List<PlanDefinitionActionDynamicValueComponent> dynamicValue;
        @Child(name="action", type={PlanDefinitionActionComponent.class}, order=25, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A sub-action", formalDefinition="Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.")
        protected List<PlanDefinitionActionComponent> action;
        private static final long serialVersionUID = -1404963512L;

        public StringType getLabelElement() {
            if (this.label == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.label");
                }
                if (Configuration.doAutoCreate()) {
                    this.label = new StringType();
                }
            }
            return this.label;
        }

        public boolean hasLabelElement() {
            return this.label != null && !this.label.isEmpty();
        }

        public boolean hasLabel() {
            return this.label != null && !this.label.isEmpty();
        }

        public PlanDefinitionActionComponent setLabelElement(StringType value) {
            this.label = value;
            return this;
        }

        public String getLabel() {
            return this.label == null ? null : (String)this.label.getValue();
        }

        public PlanDefinitionActionComponent setLabel(String value) {
            if (Utilities.noString((String)value)) {
                this.label = null;
            } else {
                if (this.label == null) {
                    this.label = new StringType();
                }
                this.label.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public PlanDefinitionActionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public PlanDefinitionActionComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionActionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PlanDefinitionActionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getTextEquivalentElement() {
            if (this.textEquivalent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.textEquivalent");
                }
                if (Configuration.doAutoCreate()) {
                    this.textEquivalent = new StringType();
                }
            }
            return this.textEquivalent;
        }

        public boolean hasTextEquivalentElement() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public boolean hasTextEquivalent() {
            return this.textEquivalent != null && !this.textEquivalent.isEmpty();
        }

        public PlanDefinitionActionComponent setTextEquivalentElement(StringType value) {
            this.textEquivalent = value;
            return this;
        }

        public String getTextEquivalent() {
            return this.textEquivalent == null ? null : (String)this.textEquivalent.getValue();
        }

        public PlanDefinitionActionComponent setTextEquivalent(String value) {
            if (Utilities.noString((String)value)) {
                this.textEquivalent = null;
            } else {
                if (this.textEquivalent == null) {
                    this.textEquivalent = new StringType();
                }
                this.textEquivalent.setValue(value);
            }
            return this;
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public PlanDefinitionActionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public PlanDefinitionActionComponent setReason(List<CodeableConcept> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableConcept getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<RelatedArtifact> getDocumentation() {
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            return this.documentation;
        }

        public PlanDefinitionActionComponent setDocumentation(List<RelatedArtifact> theDocumentation) {
            this.documentation = theDocumentation;
            return this;
        }

        public boolean hasDocumentation() {
            if (this.documentation == null) {
                return false;
            }
            for (RelatedArtifact item : this.documentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addDocumentation() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addDocumentation(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.documentation == null) {
                this.documentation = new ArrayList<RelatedArtifact>();
            }
            this.documentation.add(t);
            return this;
        }

        public RelatedArtifact getDocumentationFirstRep() {
            if (this.getDocumentation().isEmpty()) {
                this.addDocumentation();
            }
            return this.getDocumentation().get(0);
        }

        public List<IdType> getGoalId() {
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            return this.goalId;
        }

        public PlanDefinitionActionComponent setGoalId(List<IdType> theGoalId) {
            this.goalId = theGoalId;
            return this;
        }

        public boolean hasGoalId() {
            if (this.goalId == null) {
                return false;
            }
            for (IdType item : this.goalId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public IdType addGoalIdElement() {
            IdType t = new IdType();
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            this.goalId.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addGoalId(String value) {
            IdType t = new IdType();
            t.setValue(value);
            if (this.goalId == null) {
                this.goalId = new ArrayList<IdType>();
            }
            this.goalId.add(t);
            return this;
        }

        public boolean hasGoalId(String value) {
            if (this.goalId == null) {
                return false;
            }
            for (IdType v : this.goalId) {
                if (!v.getValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<TriggerDefinition> getTriggerDefinition() {
            if (this.triggerDefinition == null) {
                this.triggerDefinition = new ArrayList<TriggerDefinition>();
            }
            return this.triggerDefinition;
        }

        public PlanDefinitionActionComponent setTriggerDefinition(List<TriggerDefinition> theTriggerDefinition) {
            this.triggerDefinition = theTriggerDefinition;
            return this;
        }

        public boolean hasTriggerDefinition() {
            if (this.triggerDefinition == null) {
                return false;
            }
            for (TriggerDefinition item : this.triggerDefinition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TriggerDefinition addTriggerDefinition() {
            TriggerDefinition t = new TriggerDefinition();
            if (this.triggerDefinition == null) {
                this.triggerDefinition = new ArrayList<TriggerDefinition>();
            }
            this.triggerDefinition.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addTriggerDefinition(TriggerDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.triggerDefinition == null) {
                this.triggerDefinition = new ArrayList<TriggerDefinition>();
            }
            this.triggerDefinition.add(t);
            return this;
        }

        public TriggerDefinition getTriggerDefinitionFirstRep() {
            if (this.getTriggerDefinition().isEmpty()) {
                this.addTriggerDefinition();
            }
            return this.getTriggerDefinition().get(0);
        }

        public List<PlanDefinitionActionConditionComponent> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            return this.condition;
        }

        public PlanDefinitionActionComponent setCondition(List<PlanDefinitionActionConditionComponent> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (PlanDefinitionActionConditionComponent item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionConditionComponent addCondition() {
            PlanDefinitionActionConditionComponent t = new PlanDefinitionActionConditionComponent();
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            this.condition.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addCondition(PlanDefinitionActionConditionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
            }
            this.condition.add(t);
            return this;
        }

        public PlanDefinitionActionConditionComponent getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<DataRequirement> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<DataRequirement>();
            }
            return this.input;
        }

        public PlanDefinitionActionComponent setInput(List<DataRequirement> theInput) {
            this.input = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (DataRequirement item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DataRequirement addInput() {
            DataRequirement t = new DataRequirement();
            if (this.input == null) {
                this.input = new ArrayList<DataRequirement>();
            }
            this.input.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addInput(DataRequirement t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<DataRequirement>();
            }
            this.input.add(t);
            return this;
        }

        public DataRequirement getInputFirstRep() {
            if (this.getInput().isEmpty()) {
                this.addInput();
            }
            return this.getInput().get(0);
        }

        public List<DataRequirement> getOutput() {
            if (this.output == null) {
                this.output = new ArrayList<DataRequirement>();
            }
            return this.output;
        }

        public PlanDefinitionActionComponent setOutput(List<DataRequirement> theOutput) {
            this.output = theOutput;
            return this;
        }

        public boolean hasOutput() {
            if (this.output == null) {
                return false;
            }
            for (DataRequirement item : this.output) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DataRequirement addOutput() {
            DataRequirement t = new DataRequirement();
            if (this.output == null) {
                this.output = new ArrayList<DataRequirement>();
            }
            this.output.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addOutput(DataRequirement t) {
            if (t == null) {
                return this;
            }
            if (this.output == null) {
                this.output = new ArrayList<DataRequirement>();
            }
            this.output.add(t);
            return this;
        }

        public DataRequirement getOutputFirstRep() {
            if (this.getOutput().isEmpty()) {
                this.addOutput();
            }
            return this.getOutput().get(0);
        }

        public List<PlanDefinitionActionRelatedActionComponent> getRelatedAction() {
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            return this.relatedAction;
        }

        public PlanDefinitionActionComponent setRelatedAction(List<PlanDefinitionActionRelatedActionComponent> theRelatedAction) {
            this.relatedAction = theRelatedAction;
            return this;
        }

        public boolean hasRelatedAction() {
            if (this.relatedAction == null) {
                return false;
            }
            for (PlanDefinitionActionRelatedActionComponent item : this.relatedAction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionRelatedActionComponent addRelatedAction() {
            PlanDefinitionActionRelatedActionComponent t = new PlanDefinitionActionRelatedActionComponent();
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addRelatedAction(PlanDefinitionActionRelatedActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAction == null) {
                this.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
            }
            this.relatedAction.add(t);
            return this;
        }

        public PlanDefinitionActionRelatedActionComponent getRelatedActionFirstRep() {
            if (this.getRelatedAction().isEmpty()) {
                this.addRelatedAction();
            }
            return this.getRelatedAction().get(0);
        }

        public Type getTiming() {
            return this.timing;
        }

        public DateTimeType getTimingDateTimeType() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.timing;
        }

        public boolean hasTimingDateTimeType() {
            return this.timing instanceof DateTimeType;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this.timing instanceof Period;
        }

        public Duration getTimingDuration() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Duration)this.timing;
        }

        public boolean hasTimingDuration() {
            return this.timing instanceof Duration;
        }

        public Range getTimingRange() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Range)this.timing;
        }

        public boolean hasTimingRange() {
            return this.timing instanceof Range;
        }

        public Timing getTimingTiming() throws FHIRException {
            if (this.timing == null) {
                return null;
            }
            if (!(this.timing instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Timing)this.timing;
        }

        public boolean hasTimingTiming() {
            return this.timing instanceof Timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public PlanDefinitionActionComponent setTiming(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Duration || value instanceof Range || value instanceof Timing)) {
                throw new FHIRFormatError("Not the right type for PlanDefinition.action.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public List<PlanDefinitionActionParticipantComponent> getParticipant() {
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            return this.participant;
        }

        public PlanDefinitionActionComponent setParticipant(List<PlanDefinitionActionParticipantComponent> theParticipant) {
            this.participant = theParticipant;
            return this;
        }

        public boolean hasParticipant() {
            if (this.participant == null) {
                return false;
            }
            for (PlanDefinitionActionParticipantComponent item : this.participant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionParticipantComponent addParticipant() {
            PlanDefinitionActionParticipantComponent t = new PlanDefinitionActionParticipantComponent();
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            this.participant.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addParticipant(PlanDefinitionActionParticipantComponent t) {
            if (t == null) {
                return this;
            }
            if (this.participant == null) {
                this.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
            }
            this.participant.add(t);
            return this;
        }

        public PlanDefinitionActionParticipantComponent getParticipantFirstRep() {
            if (this.getParticipant().isEmpty()) {
                this.addParticipant();
            }
            return this.getParticipant().get(0);
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanDefinitionActionComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Enumeration<ActionGroupingBehavior> getGroupingBehaviorElement() {
            if (this.groupingBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.groupingBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.groupingBehavior = new Enumeration<ActionGroupingBehavior>(new ActionGroupingBehaviorEnumFactory());
                }
            }
            return this.groupingBehavior;
        }

        public boolean hasGroupingBehaviorElement() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public boolean hasGroupingBehavior() {
            return this.groupingBehavior != null && !this.groupingBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setGroupingBehaviorElement(Enumeration<ActionGroupingBehavior> value) {
            this.groupingBehavior = value;
            return this;
        }

        public ActionGroupingBehavior getGroupingBehavior() {
            return this.groupingBehavior == null ? null : (ActionGroupingBehavior)((Object)this.groupingBehavior.getValue());
        }

        public PlanDefinitionActionComponent setGroupingBehavior(ActionGroupingBehavior value) {
            if (value == null) {
                this.groupingBehavior = null;
            } else {
                if (this.groupingBehavior == null) {
                    this.groupingBehavior = new Enumeration<ActionGroupingBehavior>(new ActionGroupingBehaviorEnumFactory());
                }
                this.groupingBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionSelectionBehavior> getSelectionBehaviorElement() {
            if (this.selectionBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.selectionBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.selectionBehavior = new Enumeration<ActionSelectionBehavior>(new ActionSelectionBehaviorEnumFactory());
                }
            }
            return this.selectionBehavior;
        }

        public boolean hasSelectionBehaviorElement() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public boolean hasSelectionBehavior() {
            return this.selectionBehavior != null && !this.selectionBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setSelectionBehaviorElement(Enumeration<ActionSelectionBehavior> value) {
            this.selectionBehavior = value;
            return this;
        }

        public ActionSelectionBehavior getSelectionBehavior() {
            return this.selectionBehavior == null ? null : (ActionSelectionBehavior)((Object)this.selectionBehavior.getValue());
        }

        public PlanDefinitionActionComponent setSelectionBehavior(ActionSelectionBehavior value) {
            if (value == null) {
                this.selectionBehavior = null;
            } else {
                if (this.selectionBehavior == null) {
                    this.selectionBehavior = new Enumeration<ActionSelectionBehavior>(new ActionSelectionBehaviorEnumFactory());
                }
                this.selectionBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionRequiredBehavior> getRequiredBehaviorElement() {
            if (this.requiredBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.requiredBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.requiredBehavior = new Enumeration<ActionRequiredBehavior>(new ActionRequiredBehaviorEnumFactory());
                }
            }
            return this.requiredBehavior;
        }

        public boolean hasRequiredBehaviorElement() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public boolean hasRequiredBehavior() {
            return this.requiredBehavior != null && !this.requiredBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setRequiredBehaviorElement(Enumeration<ActionRequiredBehavior> value) {
            this.requiredBehavior = value;
            return this;
        }

        public ActionRequiredBehavior getRequiredBehavior() {
            return this.requiredBehavior == null ? null : (ActionRequiredBehavior)((Object)this.requiredBehavior.getValue());
        }

        public PlanDefinitionActionComponent setRequiredBehavior(ActionRequiredBehavior value) {
            if (value == null) {
                this.requiredBehavior = null;
            } else {
                if (this.requiredBehavior == null) {
                    this.requiredBehavior = new Enumeration<ActionRequiredBehavior>(new ActionRequiredBehaviorEnumFactory());
                }
                this.requiredBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionPrecheckBehavior> getPrecheckBehaviorElement() {
            if (this.precheckBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.precheckBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.precheckBehavior = new Enumeration<ActionPrecheckBehavior>(new ActionPrecheckBehaviorEnumFactory());
                }
            }
            return this.precheckBehavior;
        }

        public boolean hasPrecheckBehaviorElement() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public boolean hasPrecheckBehavior() {
            return this.precheckBehavior != null && !this.precheckBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setPrecheckBehaviorElement(Enumeration<ActionPrecheckBehavior> value) {
            this.precheckBehavior = value;
            return this;
        }

        public ActionPrecheckBehavior getPrecheckBehavior() {
            return this.precheckBehavior == null ? null : (ActionPrecheckBehavior)((Object)this.precheckBehavior.getValue());
        }

        public PlanDefinitionActionComponent setPrecheckBehavior(ActionPrecheckBehavior value) {
            if (value == null) {
                this.precheckBehavior = null;
            } else {
                if (this.precheckBehavior == null) {
                    this.precheckBehavior = new Enumeration<ActionPrecheckBehavior>(new ActionPrecheckBehaviorEnumFactory());
                }
                this.precheckBehavior.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ActionCardinalityBehavior> getCardinalityBehaviorElement() {
            if (this.cardinalityBehavior == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.cardinalityBehavior");
                }
                if (Configuration.doAutoCreate()) {
                    this.cardinalityBehavior = new Enumeration<ActionCardinalityBehavior>(new ActionCardinalityBehaviorEnumFactory());
                }
            }
            return this.cardinalityBehavior;
        }

        public boolean hasCardinalityBehaviorElement() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public boolean hasCardinalityBehavior() {
            return this.cardinalityBehavior != null && !this.cardinalityBehavior.isEmpty();
        }

        public PlanDefinitionActionComponent setCardinalityBehaviorElement(Enumeration<ActionCardinalityBehavior> value) {
            this.cardinalityBehavior = value;
            return this;
        }

        public ActionCardinalityBehavior getCardinalityBehavior() {
            return this.cardinalityBehavior == null ? null : (ActionCardinalityBehavior)((Object)this.cardinalityBehavior.getValue());
        }

        public PlanDefinitionActionComponent setCardinalityBehavior(ActionCardinalityBehavior value) {
            if (value == null) {
                this.cardinalityBehavior = null;
            } else {
                if (this.cardinalityBehavior == null) {
                    this.cardinalityBehavior = new Enumeration<ActionCardinalityBehavior>(new ActionCardinalityBehaviorEnumFactory());
                }
                this.cardinalityBehavior.setValue((Object)value);
            }
            return this;
        }

        public Reference getDefinition() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new Reference();
                }
            }
            return this.definition;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public PlanDefinitionActionComponent setDefinition(Reference value) {
            this.definition = value;
            return this;
        }

        public Resource getDefinitionTarget() {
            return this.definitionTarget;
        }

        public PlanDefinitionActionComponent setDefinitionTarget(Resource value) {
            this.definitionTarget = value;
            return this;
        }

        public Reference getTransform() {
            if (this.transform == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transform = new Reference();
                }
            }
            return this.transform;
        }

        public boolean hasTransform() {
            return this.transform != null && !this.transform.isEmpty();
        }

        public PlanDefinitionActionComponent setTransform(Reference value) {
            this.transform = value;
            return this;
        }

        public StructureMap getTransformTarget() {
            if (this.transformTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionComponent.transform");
                }
                if (Configuration.doAutoCreate()) {
                    this.transformTarget = new StructureMap();
                }
            }
            return this.transformTarget;
        }

        public PlanDefinitionActionComponent setTransformTarget(StructureMap value) {
            this.transformTarget = value;
            return this;
        }

        public List<PlanDefinitionActionDynamicValueComponent> getDynamicValue() {
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            return this.dynamicValue;
        }

        public PlanDefinitionActionComponent setDynamicValue(List<PlanDefinitionActionDynamicValueComponent> theDynamicValue) {
            this.dynamicValue = theDynamicValue;
            return this;
        }

        public boolean hasDynamicValue() {
            if (this.dynamicValue == null) {
                return false;
            }
            for (PlanDefinitionActionDynamicValueComponent item : this.dynamicValue) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionDynamicValueComponent addDynamicValue() {
            PlanDefinitionActionDynamicValueComponent t = new PlanDefinitionActionDynamicValueComponent();
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addDynamicValue(PlanDefinitionActionDynamicValueComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dynamicValue == null) {
                this.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
            }
            this.dynamicValue.add(t);
            return this;
        }

        public PlanDefinitionActionDynamicValueComponent getDynamicValueFirstRep() {
            if (this.getDynamicValue().isEmpty()) {
                this.addDynamicValue();
            }
            return this.getDynamicValue().get(0);
        }

        public List<PlanDefinitionActionComponent> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            return this.action;
        }

        public PlanDefinitionActionComponent setAction(List<PlanDefinitionActionComponent> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (PlanDefinitionActionComponent item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PlanDefinitionActionComponent addAction() {
            PlanDefinitionActionComponent t = new PlanDefinitionActionComponent();
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            this.action.add(t);
            return t;
        }

        public PlanDefinitionActionComponent addAction(PlanDefinitionActionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<PlanDefinitionActionComponent>();
            }
            this.action.add(t);
            return this;
        }

        public PlanDefinitionActionComponent getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("label", "string", "A user-visible label for the action.", 0, 1, this.label));
            children.add(new Property(PlanDefinition.SP_TITLE, "string", "The title of the action displayed to a user.", 0, 1, this.title));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description));
            children.add(new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent));
            children.add(new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("reason", "CodeableConcept", "A description of why this action is necessary or appropriate.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation));
            children.add(new Property("goalId", "id", "Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition.", 0, Integer.MAX_VALUE, this.goalId));
            children.add(new Property("triggerDefinition", "TriggerDefinition", "A description of when the action should be triggered.", 0, Integer.MAX_VALUE, this.triggerDefinition));
            children.add(new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("input", "DataRequirement", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input));
            children.add(new Property("output", "DataRequirement", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output));
            children.add(new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction));
            children.add(new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing));
            children.add(new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant));
            children.add(new Property("type", "Coding", "The type of action to perform (create, update, remove).", 0, 1, this.type));
            children.add(new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior));
            children.add(new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior));
            children.add(new Property("requiredBehavior", "code", "Defines the requiredness behavior for the action.", 0, 1, this.requiredBehavior));
            children.add(new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior));
            children.add(new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior));
            children.add(new Property("definition", "Reference(ActivityDefinition|PlanDefinition)", "A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.", 0, 1, this.definition));
            children.add(new Property("transform", "Reference(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform));
            children.add(new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue));
            children.add(new Property("action", "@PlanDefinition.action", "Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.", 0, Integer.MAX_VALUE, this.action));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 102727412: {
                    return new Property("label", "string", "A user-visible label for the action.", 0, 1, this.label);
                }
                case 110371416: {
                    return new Property(PlanDefinition.SP_TITLE, "string", "The title of the action displayed to a user.", 0, 1, this.title);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "string", "A short description of the action used to provide a summary to display to the user.", 0, 1, this.description);
                }
                case -900391049: {
                    return new Property("textEquivalent", "string", "A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that may not be capable of interpreting it dynamically.", 0, 1, this.textEquivalent);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that provides meaning for the action or action group. For example, a section may have a LOINC code for a the section of a documentation template.", 0, Integer.MAX_VALUE, this.code);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "A description of why this action is necessary or appropriate.", 0, Integer.MAX_VALUE, this.reason);
                }
                case 1587405498: {
                    return new Property("documentation", "RelatedArtifact", "Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.", 0, Integer.MAX_VALUE, this.documentation);
                }
                case -1240658034: {
                    return new Property("goalId", "id", "Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition.", 0, Integer.MAX_VALUE, this.goalId);
                }
                case 1126736171: {
                    return new Property("triggerDefinition", "TriggerDefinition", "A description of when the action should be triggered.", 0, Integer.MAX_VALUE, this.triggerDefinition);
                }
                case -861311717: {
                    return new Property("condition", "", "An expression that describes applicability criteria, or start/stop conditions for the action.", 0, Integer.MAX_VALUE, this.condition);
                }
                case 100358090: {
                    return new Property("input", "DataRequirement", "Defines input data requirements for the action.", 0, Integer.MAX_VALUE, this.input);
                }
                case -1005512447: {
                    return new Property("output", "DataRequirement", "Defines the outputs of the action, if any.", 0, Integer.MAX_VALUE, this.output);
                }
                case -384107967: {
                    return new Property("relatedAction", "", "A relationship to another action such as \"before\" or \"30-60 minutes after start of\".", 0, Integer.MAX_VALUE, this.relatedAction);
                }
                case 164632566: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1837458939: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -1327253506: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -710871277: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case -497554124: {
                    return new Property("timing[x]", "dateTime|Period|Duration|Range|Timing", "An optional value describing when the action should be performed.", 0, 1, this.timing);
                }
                case 767422259: {
                    return new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant);
                }
                case 3575610: {
                    return new Property("type", "Coding", "The type of action to perform (create, update, remove).", 0, 1, this.type);
                }
                case 586678389: {
                    return new Property("groupingBehavior", "code", "Defines the grouping behavior for the action and its children.", 0, 1, this.groupingBehavior);
                }
                case 168639486: {
                    return new Property("selectionBehavior", "code", "Defines the selection behavior for the action and its children.", 0, 1, this.selectionBehavior);
                }
                case -1163906287: {
                    return new Property("requiredBehavior", "code", "Defines the requiredness behavior for the action.", 0, 1, this.requiredBehavior);
                }
                case -1174249033: {
                    return new Property("precheckBehavior", "code", "Defines whether the action should usually be preselected.", 0, 1, this.precheckBehavior);
                }
                case -922577408: {
                    return new Property("cardinalityBehavior", "code", "Defines whether the action can be selected multiple times.", 0, 1, this.cardinalityBehavior);
                }
                case -1014418093: {
                    return new Property("definition", "Reference(ActivityDefinition|PlanDefinition)", "A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.", 0, 1, this.definition);
                }
                case 1052666732: {
                    return new Property("transform", "Reference(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform);
                }
                case 572625010: {
                    return new Property("dynamicValue", "", "Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue);
                }
                case -1422950858: {
                    return new Property("action", "@PlanDefinition.action", "Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.", 0, Integer.MAX_VALUE, this.action);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    Base[] baseArray;
                    if (this.label == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.label;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -900391049: {
                    Base[] baseArray;
                    if (this.textEquivalent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.textEquivalent;
                    }
                    return baseArray;
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 1587405498: {
                    return this.documentation == null ? new Base[]{} : this.documentation.toArray(new Base[this.documentation.size()]);
                }
                case -1240658034: {
                    return this.goalId == null ? new Base[]{} : this.goalId.toArray(new Base[this.goalId.size()]);
                }
                case 1126736171: {
                    return this.triggerDefinition == null ? new Base[]{} : this.triggerDefinition.toArray(new Base[this.triggerDefinition.size()]);
                }
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case -1005512447: {
                    return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
                }
                case -384107967: {
                    return this.relatedAction == null ? new Base[]{} : this.relatedAction.toArray(new Base[this.relatedAction.size()]);
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.timing;
                    }
                    return baseArray;
                }
                case 767422259: {
                    return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.type;
                    }
                    return baseArray;
                }
                case 586678389: {
                    Base[] baseArray;
                    if (this.groupingBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.groupingBehavior;
                    }
                    return baseArray;
                }
                case 168639486: {
                    Base[] baseArray;
                    if (this.selectionBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.selectionBehavior;
                    }
                    return baseArray;
                }
                case -1163906287: {
                    Base[] baseArray;
                    if (this.requiredBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.requiredBehavior;
                    }
                    return baseArray;
                }
                case -1174249033: {
                    Base[] baseArray;
                    if (this.precheckBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.precheckBehavior;
                    }
                    return baseArray;
                }
                case -922577408: {
                    Base[] baseArray;
                    if (this.cardinalityBehavior == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.cardinalityBehavior;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.definition;
                    }
                    return baseArray;
                }
                case 1052666732: {
                    Base[] baseArray;
                    if (this.transform == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.transform;
                    }
                    return baseArray;
                }
                case 572625010: {
                    return this.dynamicValue == null ? new Base[]{} : this.dynamicValue.toArray(new Base[this.dynamicValue.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    this.label = this.castToString(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -900391049: {
                    this.textEquivalent = this.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.getCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -934964668: {
                    this.getReason().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1587405498: {
                    this.getDocumentation().add(this.castToRelatedArtifact(value));
                    return value;
                }
                case -1240658034: {
                    this.getGoalId().add(this.castToId(value));
                    return value;
                }
                case 1126736171: {
                    this.getTriggerDefinition().add(this.castToTriggerDefinition(value));
                    return value;
                }
                case -861311717: {
                    this.getCondition().add((PlanDefinitionActionConditionComponent)((Object)value));
                    return value;
                }
                case 100358090: {
                    this.getInput().add(this.castToDataRequirement(value));
                    return value;
                }
                case -1005512447: {
                    this.getOutput().add(this.castToDataRequirement(value));
                    return value;
                }
                case -384107967: {
                    this.getRelatedAction().add((PlanDefinitionActionRelatedActionComponent)((Object)value));
                    return value;
                }
                case -873664438: {
                    this.timing = this.castToType(value);
                    return value;
                }
                case 767422259: {
                    this.getParticipant().add((PlanDefinitionActionParticipantComponent)((Object)value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
                case 586678389: {
                    value = new ActionGroupingBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.groupingBehavior = value;
                    return value;
                }
                case 168639486: {
                    value = new ActionSelectionBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.selectionBehavior = value;
                    return value;
                }
                case -1163906287: {
                    value = new ActionRequiredBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.requiredBehavior = value;
                    return value;
                }
                case -1174249033: {
                    value = new ActionPrecheckBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.precheckBehavior = value;
                    return value;
                }
                case -922577408: {
                    value = new ActionCardinalityBehaviorEnumFactory().fromType(this.castToCode(value));
                    this.cardinalityBehavior = value;
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToReference(value);
                    return value;
                }
                case 1052666732: {
                    this.transform = this.castToReference(value);
                    return value;
                }
                case 572625010: {
                    this.getDynamicValue().add((PlanDefinitionActionDynamicValueComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add((PlanDefinitionActionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("label")) {
                this.label = this.castToString(value);
            } else if (name.equals(PlanDefinition.SP_TITLE)) {
                this.title = this.castToString(value);
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("textEquivalent")) {
                this.textEquivalent = this.castToString(value);
            } else if (name.equals("code")) {
                this.getCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("reason")) {
                this.getReason().add(this.castToCodeableConcept(value));
            } else if (name.equals("documentation")) {
                this.getDocumentation().add(this.castToRelatedArtifact(value));
            } else if (name.equals("goalId")) {
                this.getGoalId().add(this.castToId(value));
            } else if (name.equals("triggerDefinition")) {
                this.getTriggerDefinition().add(this.castToTriggerDefinition(value));
            } else if (name.equals("condition")) {
                this.getCondition().add((PlanDefinitionActionConditionComponent)((Object)value));
            } else if (name.equals("input")) {
                this.getInput().add(this.castToDataRequirement(value));
            } else if (name.equals("output")) {
                this.getOutput().add(this.castToDataRequirement(value));
            } else if (name.equals("relatedAction")) {
                this.getRelatedAction().add((PlanDefinitionActionRelatedActionComponent)((Object)value));
            } else if (name.equals("timing[x]")) {
                this.timing = this.castToType(value);
            } else if (name.equals("participant")) {
                this.getParticipant().add((PlanDefinitionActionParticipantComponent)((Object)value));
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("groupingBehavior")) {
                value = new ActionGroupingBehaviorEnumFactory().fromType(this.castToCode(value));
                this.groupingBehavior = value;
            } else if (name.equals("selectionBehavior")) {
                value = new ActionSelectionBehaviorEnumFactory().fromType(this.castToCode(value));
                this.selectionBehavior = value;
            } else if (name.equals("requiredBehavior")) {
                value = new ActionRequiredBehaviorEnumFactory().fromType(this.castToCode(value));
                this.requiredBehavior = value;
            } else if (name.equals("precheckBehavior")) {
                value = new ActionPrecheckBehaviorEnumFactory().fromType(this.castToCode(value));
                this.precheckBehavior = value;
            } else if (name.equals("cardinalityBehavior")) {
                value = new ActionCardinalityBehaviorEnumFactory().fromType(this.castToCode(value));
                this.cardinalityBehavior = value;
            } else if (name.equals("definition")) {
                this.definition = this.castToReference(value);
            } else if (name.equals("transform")) {
                this.transform = this.castToReference(value);
            } else if (name.equals("dynamicValue")) {
                this.getDynamicValue().add((PlanDefinitionActionDynamicValueComponent)((Object)value));
            } else if (name.equals("action")) {
                this.getAction().add((PlanDefinitionActionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return this.getLabelElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -900391049: {
                    return this.getTextEquivalentElement();
                }
                case 3059181: {
                    return this.addCode();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 1587405498: {
                    return this.addDocumentation();
                }
                case -1240658034: {
                    return this.addGoalIdElement();
                }
                case 1126736171: {
                    return this.addTriggerDefinition();
                }
                case -861311717: {
                    return this.addCondition();
                }
                case 100358090: {
                    return this.addInput();
                }
                case -1005512447: {
                    return this.addOutput();
                }
                case -384107967: {
                    return this.addRelatedAction();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case 767422259: {
                    return this.addParticipant();
                }
                case 3575610: {
                    return this.getType();
                }
                case 586678389: {
                    return this.getGroupingBehaviorElement();
                }
                case 168639486: {
                    return this.getSelectionBehaviorElement();
                }
                case -1163906287: {
                    return this.getRequiredBehaviorElement();
                }
                case -1174249033: {
                    return this.getPrecheckBehaviorElement();
                }
                case -922577408: {
                    return this.getCardinalityBehaviorElement();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 1052666732: {
                    return this.getTransform();
                }
                case 572625010: {
                    return this.addDynamicValue();
                }
                case -1422950858: {
                    return this.addAction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 102727412: {
                    return new String[]{"string"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -900391049: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587405498: {
                    return new String[]{"RelatedArtifact"};
                }
                case -1240658034: {
                    return new String[]{"id"};
                }
                case 1126736171: {
                    return new String[]{"TriggerDefinition"};
                }
                case -861311717: {
                    return new String[0];
                }
                case 100358090: {
                    return new String[]{"DataRequirement"};
                }
                case -1005512447: {
                    return new String[]{"DataRequirement"};
                }
                case -384107967: {
                    return new String[0];
                }
                case -873664438: {
                    return new String[]{"dateTime", "Period", "Duration", "Range", "Timing"};
                }
                case 767422259: {
                    return new String[0];
                }
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 586678389: {
                    return new String[]{"code"};
                }
                case 168639486: {
                    return new String[]{"code"};
                }
                case -1163906287: {
                    return new String[]{"code"};
                }
                case -1174249033: {
                    return new String[]{"code"};
                }
                case -922577408: {
                    return new String[]{"code"};
                }
                case -1014418093: {
                    return new String[]{"Reference"};
                }
                case 1052666732: {
                    return new String[]{"Reference"};
                }
                case 572625010: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"@PlanDefinition.action"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("label")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.label");
            }
            if (name.equals(PlanDefinition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.title");
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.description");
            }
            if (name.equals("textEquivalent")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.textEquivalent");
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals("documentation")) {
                return this.addDocumentation();
            }
            if (name.equals("goalId")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.goalId");
            }
            if (name.equals("triggerDefinition")) {
                return this.addTriggerDefinition();
            }
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("output")) {
                return this.addOutput();
            }
            if (name.equals("relatedAction")) {
                return this.addRelatedAction();
            }
            if (name.equals("timingDateTime")) {
                this.timing = new DateTimeType();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("timingDuration")) {
                this.timing = new Duration();
                return this.timing;
            }
            if (name.equals("timingRange")) {
                this.timing = new Range();
                return this.timing;
            }
            if (name.equals("timingTiming")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("participant")) {
                return this.addParticipant();
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("groupingBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.groupingBehavior");
            }
            if (name.equals("selectionBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.selectionBehavior");
            }
            if (name.equals("requiredBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.requiredBehavior");
            }
            if (name.equals("precheckBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.precheckBehavior");
            }
            if (name.equals("cardinalityBehavior")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.cardinalityBehavior");
            }
            if (name.equals("definition")) {
                this.definition = new Reference();
                return this.definition;
            }
            if (name.equals("transform")) {
                this.transform = new Reference();
                return this.transform;
            }
            if (name.equals("dynamicValue")) {
                return this.addDynamicValue();
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionComponent copy() {
            PlanDefinitionActionComponent dst = new PlanDefinitionActionComponent();
            this.copyValues(dst);
            dst.label = this.label == null ? null : this.label.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.description = this.description == null ? null : this.description.copy();
            StringType stringType = dst.textEquivalent = this.textEquivalent == null ? null : this.textEquivalent.copy();
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.reason) {
                    dst.reason.add(codeableConcept.copy());
                }
            }
            if (this.documentation != null) {
                dst.documentation = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.documentation) {
                    dst.documentation.add(relatedArtifact.copy());
                }
            }
            if (this.goalId != null) {
                dst.goalId = new ArrayList<IdType>();
                for (IdType idType : this.goalId) {
                    dst.goalId.add(idType.copy());
                }
            }
            if (this.triggerDefinition != null) {
                dst.triggerDefinition = new ArrayList<TriggerDefinition>();
                for (TriggerDefinition triggerDefinition : this.triggerDefinition) {
                    dst.triggerDefinition.add(triggerDefinition.copy());
                }
            }
            if (this.condition != null) {
                dst.condition = new ArrayList<PlanDefinitionActionConditionComponent>();
                for (PlanDefinitionActionConditionComponent planDefinitionActionConditionComponent : this.condition) {
                    dst.condition.add(planDefinitionActionConditionComponent.copy());
                }
            }
            if (this.input != null) {
                dst.input = new ArrayList<DataRequirement>();
                for (DataRequirement dataRequirement : this.input) {
                    dst.input.add(dataRequirement.copy());
                }
            }
            if (this.output != null) {
                dst.output = new ArrayList<DataRequirement>();
                for (DataRequirement dataRequirement : this.output) {
                    dst.output.add(dataRequirement.copy());
                }
            }
            if (this.relatedAction != null) {
                dst.relatedAction = new ArrayList<PlanDefinitionActionRelatedActionComponent>();
                for (PlanDefinitionActionRelatedActionComponent planDefinitionActionRelatedActionComponent : this.relatedAction) {
                    dst.relatedAction.add(planDefinitionActionRelatedActionComponent.copy());
                }
            }
            Type type = dst.timing = this.timing == null ? null : this.timing.copy();
            if (this.participant != null) {
                dst.participant = new ArrayList<PlanDefinitionActionParticipantComponent>();
                for (PlanDefinitionActionParticipantComponent planDefinitionActionParticipantComponent : this.participant) {
                    dst.participant.add(planDefinitionActionParticipantComponent.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.groupingBehavior = this.groupingBehavior == null ? null : this.groupingBehavior.copy();
            dst.selectionBehavior = this.selectionBehavior == null ? null : this.selectionBehavior.copy();
            dst.requiredBehavior = this.requiredBehavior == null ? null : this.requiredBehavior.copy();
            dst.precheckBehavior = this.precheckBehavior == null ? null : this.precheckBehavior.copy();
            dst.cardinalityBehavior = this.cardinalityBehavior == null ? null : this.cardinalityBehavior.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            Reference reference = dst.transform = this.transform == null ? null : this.transform.copy();
            if (this.dynamicValue != null) {
                dst.dynamicValue = new ArrayList<PlanDefinitionActionDynamicValueComponent>();
                for (PlanDefinitionActionDynamicValueComponent planDefinitionActionDynamicValueComponent : this.dynamicValue) {
                    dst.dynamicValue.add(planDefinitionActionDynamicValueComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<PlanDefinitionActionComponent>();
                for (PlanDefinitionActionComponent planDefinitionActionComponent : this.action) {
                    dst.action.add(planDefinitionActionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionComponent)) {
                return false;
            }
            PlanDefinitionActionComponent o = (PlanDefinitionActionComponent)other_;
            return PlanDefinitionActionComponent.compareDeep(this.label, o.label, true) && PlanDefinitionActionComponent.compareDeep(this.title, o.title, true) && PlanDefinitionActionComponent.compareDeep(this.description, o.description, true) && PlanDefinitionActionComponent.compareDeep(this.textEquivalent, o.textEquivalent, true) && PlanDefinitionActionComponent.compareDeep(this.code, o.code, true) && PlanDefinitionActionComponent.compareDeep(this.reason, o.reason, true) && PlanDefinitionActionComponent.compareDeep(this.documentation, o.documentation, true) && PlanDefinitionActionComponent.compareDeep(this.goalId, o.goalId, true) && PlanDefinitionActionComponent.compareDeep(this.triggerDefinition, o.triggerDefinition, true) && PlanDefinitionActionComponent.compareDeep(this.condition, o.condition, true) && PlanDefinitionActionComponent.compareDeep(this.input, o.input, true) && PlanDefinitionActionComponent.compareDeep(this.output, o.output, true) && PlanDefinitionActionComponent.compareDeep(this.relatedAction, o.relatedAction, true) && PlanDefinitionActionComponent.compareDeep(this.timing, o.timing, true) && PlanDefinitionActionComponent.compareDeep(this.participant, o.participant, true) && PlanDefinitionActionComponent.compareDeep(this.type, o.type, true) && PlanDefinitionActionComponent.compareDeep(this.groupingBehavior, o.groupingBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.selectionBehavior, o.selectionBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.requiredBehavior, o.requiredBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.precheckBehavior, o.precheckBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.cardinalityBehavior, o.cardinalityBehavior, true) && PlanDefinitionActionComponent.compareDeep(this.definition, o.definition, true) && PlanDefinitionActionComponent.compareDeep(this.transform, o.transform, true) && PlanDefinitionActionComponent.compareDeep(this.dynamicValue, o.dynamicValue, true) && PlanDefinitionActionComponent.compareDeep(this.action, o.action, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionComponent)) {
                return false;
            }
            PlanDefinitionActionComponent o = (PlanDefinitionActionComponent)other_;
            return PlanDefinitionActionComponent.compareValues(this.label, o.label, true) && PlanDefinitionActionComponent.compareValues(this.title, o.title, true) && PlanDefinitionActionComponent.compareValues(this.description, o.description, true) && PlanDefinitionActionComponent.compareValues(this.textEquivalent, o.textEquivalent, true) && PlanDefinitionActionComponent.compareValues(this.goalId, o.goalId, true) && PlanDefinitionActionComponent.compareValues(this.groupingBehavior, o.groupingBehavior, true) && PlanDefinitionActionComponent.compareValues(this.selectionBehavior, o.selectionBehavior, true) && PlanDefinitionActionComponent.compareValues(this.requiredBehavior, o.requiredBehavior, true) && PlanDefinitionActionComponent.compareValues(this.precheckBehavior, o.precheckBehavior, true) && PlanDefinitionActionComponent.compareValues(this.cardinalityBehavior, o.cardinalityBehavior, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.label, this.title, this.description, this.textEquivalent, this.code, this.reason, this.documentation, this.goalId, this.triggerDefinition, this.condition, this.input, this.output, this.relatedAction, this.timing, this.participant, this.type, this.groupingBehavior, this.selectionBehavior, this.requiredBehavior, this.precheckBehavior, this.cardinalityBehavior, this.definition, this.transform, this.dynamicValue, this.action});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action";
        }
    }

    @Block
    public static class PlanDefinitionActionDynamicValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the dynamic value", formalDefinition="A brief, natural language description of the intended semantics of the dynamic value.")
        protected StringType description;
        @Child(name="path", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.")
        protected StringType path;
        @Child(name="language", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the expression", formalDefinition="The media type of the language for the expression.")
        protected StringType language;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected StringType expression;
        private static final long serialVersionUID = 448404361L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PlanDefinitionActionDynamicValueComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public PlanDefinitionActionDynamicValueComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new StringType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setLanguageElement(StringType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public PlanDefinitionActionDynamicValueComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new StringType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionDynamicValueComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public PlanDefinitionActionDynamicValueComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public PlanDefinitionActionDynamicValueComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the intended semantics of the dynamic value.", 0, 1, this.description));
            children.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.", 0, 1, this.path));
            children.add(new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression specifying the value of the customized element.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the intended semantics of the dynamic value.", 0, 1, this.description);
                }
                case 3433509: {
                    return new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression.", 0, 1, this.path);
                }
                case -1613589672: {
                    return new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression specifying the value of the customized element.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.path;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.description");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.path");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionDynamicValueComponent copy() {
            PlanDefinitionActionDynamicValueComponent dst = new PlanDefinitionActionDynamicValueComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionDynamicValueComponent)) {
                return false;
            }
            PlanDefinitionActionDynamicValueComponent o = (PlanDefinitionActionDynamicValueComponent)other_;
            return PlanDefinitionActionDynamicValueComponent.compareDeep(this.description, o.description, true) && PlanDefinitionActionDynamicValueComponent.compareDeep(this.path, o.path, true) && PlanDefinitionActionDynamicValueComponent.compareDeep(this.language, o.language, true) && PlanDefinitionActionDynamicValueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionDynamicValueComponent)) {
                return false;
            }
            PlanDefinitionActionDynamicValueComponent o = (PlanDefinitionActionDynamicValueComponent)other_;
            return PlanDefinitionActionDynamicValueComponent.compareValues(this.description, o.description, true) && PlanDefinitionActionDynamicValueComponent.compareValues(this.path, o.path, true) && PlanDefinitionActionDynamicValueComponent.compareValues(this.language, o.language, true) && PlanDefinitionActionDynamicValueComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.path, this.language, this.expression});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.dynamicValue";
        }
    }

    @Block
    public static class PlanDefinitionActionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="patient | practitioner | related-person", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<ActionParticipantType> type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent, etc", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-role")
        protected CodeableConcept role;
        private static final long serialVersionUID = -1152013659L;

        public PlanDefinitionActionParticipantComponent() {
        }

        public PlanDefinitionActionParticipantComponent(Enumeration<ActionParticipantType> type) {
            this.type = type;
        }

        public Enumeration<ActionParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ActionParticipantType>(new ActionParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setTypeElement(Enumeration<ActionParticipantType> value) {
            this.type = value;
            return this;
        }

        public ActionParticipantType getType() {
            return this.type == null ? null : (ActionParticipantType)((Object)this.type.getValue());
        }

        public PlanDefinitionActionParticipantComponent setType(ActionParticipantType value) {
            if (this.type == null) {
                this.type = new Enumeration<ActionParticipantType>(new ActionParticipantTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public PlanDefinitionActionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ActionParticipantTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ActionParticipantTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.type");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionParticipantComponent copy() {
            PlanDefinitionActionParticipantComponent dst = new PlanDefinitionActionParticipantComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.role = this.role == null ? null : this.role.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionParticipantComponent)) {
                return false;
            }
            PlanDefinitionActionParticipantComponent o = (PlanDefinitionActionParticipantComponent)other_;
            return PlanDefinitionActionParticipantComponent.compareDeep(this.type, o.type, true) && PlanDefinitionActionParticipantComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionParticipantComponent)) {
                return false;
            }
            PlanDefinitionActionParticipantComponent o = (PlanDefinitionActionParticipantComponent)other_;
            return PlanDefinitionActionParticipantComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.role});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.participant";
        }
    }

    @Block
    public static class PlanDefinitionActionRelatedActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actionId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What action is this related to", formalDefinition="The element id of the related action.")
        protected IdType actionId;
        @Child(name="relationship", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="before-start | before | before-end | concurrent-with-start | concurrent | concurrent-with-end | after-start | after | after-end", formalDefinition="The relationship of this action to the related action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-relationship-type")
        protected Enumeration<ActionRelationshipType> relationship;
        @Child(name="offset", type={Duration.class, Range.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time offset for the relationship", formalDefinition="A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.")
        protected Type offset;
        private static final long serialVersionUID = 1063306770L;

        public PlanDefinitionActionRelatedActionComponent() {
        }

        public PlanDefinitionActionRelatedActionComponent(IdType actionId, Enumeration<ActionRelationshipType> relationship) {
            this.actionId = actionId;
            this.relationship = relationship;
        }

        public IdType getActionIdElement() {
            if (this.actionId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionRelatedActionComponent.actionId");
                }
                if (Configuration.doAutoCreate()) {
                    this.actionId = new IdType();
                }
            }
            return this.actionId;
        }

        public boolean hasActionIdElement() {
            return this.actionId != null && !this.actionId.isEmpty();
        }

        public boolean hasActionId() {
            return this.actionId != null && !this.actionId.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setActionIdElement(IdType value) {
            this.actionId = value;
            return this;
        }

        public String getActionId() {
            return this.actionId == null ? null : this.actionId.getValue();
        }

        public PlanDefinitionActionRelatedActionComponent setActionId(String value) {
            if (this.actionId == null) {
                this.actionId = new IdType();
            }
            this.actionId.setValue(value);
            return this;
        }

        public Enumeration<ActionRelationshipType> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionRelatedActionComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setRelationshipElement(Enumeration<ActionRelationshipType> value) {
            this.relationship = value;
            return this;
        }

        public ActionRelationshipType getRelationship() {
            return this.relationship == null ? null : (ActionRelationshipType)((Object)this.relationship.getValue());
        }

        public PlanDefinitionActionRelatedActionComponent setRelationship(ActionRelationshipType value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<ActionRelationshipType>(new ActionRelationshipTypeEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public Type getOffset() {
            return this.offset;
        }

        public Duration getOffsetDuration() throws FHIRException {
            if (this.offset == null) {
                return null;
            }
            if (!(this.offset instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Duration)this.offset;
        }

        public boolean hasOffsetDuration() {
            return this.offset instanceof Duration;
        }

        public Range getOffsetRange() throws FHIRException {
            if (this.offset == null) {
                return null;
            }
            if (!(this.offset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.offset.getClass().getName() + " was encountered");
            }
            return (Range)this.offset;
        }

        public boolean hasOffsetRange() {
            return this.offset instanceof Range;
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public PlanDefinitionActionRelatedActionComponent setOffset(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof Duration) && !(value instanceof Range)) {
                throw new FHIRFormatError("Not the right type for PlanDefinition.action.relatedAction.offset[x]: " + value.fhirType());
            }
            this.offset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actionId", "id", "The element id of the related action.", 0, 1, this.actionId));
            children.add(new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship));
            children.add(new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1656172047: {
                    return new Property("actionId", "id", "The element id of the related action.", 0, 1, this.actionId);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship of this action to the related action.", 0, 1, this.relationship);
                }
                case -1960684787: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case -1019779949: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 134075207: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
                case 1263585386: {
                    return new Property("offset[x]", "Duration|Range", "A duration or range of durations to apply to the relationship. For example, 30-60 minutes before.", 0, 1, this.offset);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    Base[] baseArray;
                    if (this.actionId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actionId;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.offset;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    this.actionId = this.castToId(value);
                    return value;
                }
                case -261851592: {
                    value = new ActionRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -1019779949: {
                    this.offset = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actionId")) {
                this.actionId = this.castToId(value);
            } else if (name.equals("relationship")) {
                value = new ActionRelationshipTypeEnumFactory().fromType(this.castToCode(value));
                this.relationship = value;
            } else if (name.equals("offset[x]")) {
                this.offset = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    return this.getActionIdElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1960684787: {
                    return this.getOffset();
                }
                case -1019779949: {
                    return this.getOffset();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1656172047: {
                    return new String[]{"id"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case -1019779949: {
                    return new String[]{"Duration", "Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actionId")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.actionId");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.relationship");
            }
            if (name.equals("offsetDuration")) {
                this.offset = new Duration();
                return this.offset;
            }
            if (name.equals("offsetRange")) {
                this.offset = new Range();
                return this.offset;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionRelatedActionComponent copy() {
            PlanDefinitionActionRelatedActionComponent dst = new PlanDefinitionActionRelatedActionComponent();
            this.copyValues(dst);
            dst.actionId = this.actionId == null ? null : this.actionId.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.offset = this.offset == null ? null : this.offset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionRelatedActionComponent)) {
                return false;
            }
            PlanDefinitionActionRelatedActionComponent o = (PlanDefinitionActionRelatedActionComponent)other_;
            return PlanDefinitionActionRelatedActionComponent.compareDeep(this.actionId, o.actionId, true) && PlanDefinitionActionRelatedActionComponent.compareDeep(this.relationship, o.relationship, true) && PlanDefinitionActionRelatedActionComponent.compareDeep(this.offset, o.offset, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionRelatedActionComponent)) {
                return false;
            }
            PlanDefinitionActionRelatedActionComponent o = (PlanDefinitionActionRelatedActionComponent)other_;
            return PlanDefinitionActionRelatedActionComponent.compareValues(this.actionId, o.actionId, true) && PlanDefinitionActionRelatedActionComponent.compareValues(this.relationship, o.relationship, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.actionId, this.relationship, this.offset});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.relatedAction";
        }
    }

    @Block
    public static class PlanDefinitionActionConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="kind", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="applicability | start | stop", formalDefinition="The kind of condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-condition-kind")
        protected Enumeration<ActionConditionKind> kind;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Natural language description of the condition", formalDefinition="A brief, natural language description of the condition that effectively communicates the intended semantics.")
        protected StringType description;
        @Child(name="language", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the expression", formalDefinition="The media type of the language for the expression.")
        protected StringType language;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Boolean-valued expression", formalDefinition="An expression that returns true or false, indicating whether or not the condition is satisfied.")
        protected StringType expression;
        private static final long serialVersionUID = 944300105L;

        public PlanDefinitionActionConditionComponent() {
        }

        public PlanDefinitionActionConditionComponent(Enumeration<ActionConditionKind> kind) {
            this.kind = kind;
        }

        public Enumeration<ActionConditionKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<ActionConditionKind>(new ActionConditionKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setKindElement(Enumeration<ActionConditionKind> value) {
            this.kind = value;
            return this;
        }

        public ActionConditionKind getKind() {
            return this.kind == null ? null : (ActionConditionKind)((Object)this.kind.getValue());
        }

        public PlanDefinitionActionConditionComponent setKind(ActionConditionKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<ActionConditionKind>(new ActionConditionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PlanDefinitionActionConditionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new StringType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setLanguageElement(StringType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public PlanDefinitionActionConditionComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new StringType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionActionConditionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public PlanDefinitionActionConditionComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public PlanDefinitionActionConditionComponent setExpression(String value) {
            if (Utilities.noString((String)value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("kind", "code", "The kind of condition.", 0, 1, this.kind));
            children.add(new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description));
            children.add(new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language));
            children.add(new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3292052: {
                    return new Property("kind", "code", "The kind of condition.", 0, 1, this.kind);
                }
                case -1724546052: {
                    return new Property(PlanDefinition.SP_DESCRIPTION, "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description);
                }
                case -1613589672: {
                    return new Property("language", "string", "The media type of the language for the expression.", 0, 1, this.language);
                }
                case -1795452264: {
                    return new Property("expression", "string", "An expression that returns true or false, indicating whether or not the condition is satisfied.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.kind;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    value = new ActionConditionKindEnumFactory().fromType(this.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("kind")) {
                value = new ActionConditionKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
            } else if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("language")) {
                this.language = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return this.getKindElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3292052: {
                    return new String[]{"code"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.kind");
            }
            if (name.equals(PlanDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.description");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.language");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a singleton property PlanDefinition.expression");
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionActionConditionComponent copy() {
            PlanDefinitionActionConditionComponent dst = new PlanDefinitionActionConditionComponent();
            this.copyValues(dst);
            dst.kind = this.kind == null ? null : this.kind.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionConditionComponent)) {
                return false;
            }
            PlanDefinitionActionConditionComponent o = (PlanDefinitionActionConditionComponent)other_;
            return PlanDefinitionActionConditionComponent.compareDeep(this.kind, o.kind, true) && PlanDefinitionActionConditionComponent.compareDeep(this.description, o.description, true) && PlanDefinitionActionConditionComponent.compareDeep(this.language, o.language, true) && PlanDefinitionActionConditionComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionActionConditionComponent)) {
                return false;
            }
            PlanDefinitionActionConditionComponent o = (PlanDefinitionActionConditionComponent)other_;
            return PlanDefinitionActionConditionComponent.compareValues(this.kind, o.kind, true) && PlanDefinitionActionConditionComponent.compareValues(this.description, o.description, true) && PlanDefinitionActionConditionComponent.compareValues(this.language, o.language, true) && PlanDefinitionActionConditionComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.kind, this.description, this.language, this.expression});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.action.condition";
        }
    }

    @Block
    public static class PlanDefinitionGoalTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="measure", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The parameter whose value is to be tracked", formalDefinition="The parameter whose value is to be tracked, e.g. body weigth, blood pressure, or hemoglobin A1c level.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept measure;
        @Child(name="detail", type={Quantity.class, Range.class, CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The target value to be achieved", formalDefinition="The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.")
        protected Type detail;
        @Child(name="due", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reach goal within", formalDefinition="Indicates the timeframe after the start of the goal in which the goal should be met.")
        protected Duration due;
        private static final long serialVersionUID = -131874144L;

        public CodeableConcept getMeasure() {
            if (this.measure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalTargetComponent.measure");
                }
                if (Configuration.doAutoCreate()) {
                    this.measure = new CodeableConcept();
                }
            }
            return this.measure;
        }

        public boolean hasMeasure() {
            return this.measure != null && !this.measure.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setMeasure(CodeableConcept value) {
            this.measure = value;
            return this;
        }

        public Type getDetail() {
            return this.detail;
        }

        public Quantity getDetailQuantity() throws FHIRException {
            if (this.detail == null) {
                return null;
            }
            if (!(this.detail instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Quantity)this.detail;
        }

        public boolean hasDetailQuantity() {
            return this.detail instanceof Quantity;
        }

        public Range getDetailRange() throws FHIRException {
            if (this.detail == null) {
                return null;
            }
            if (!(this.detail instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (Range)this.detail;
        }

        public boolean hasDetailRange() {
            return this.detail instanceof Range;
        }

        public CodeableConcept getDetailCodeableConcept() throws FHIRException {
            if (this.detail == null) {
                return null;
            }
            if (!(this.detail instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.detail.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.detail;
        }

        public boolean hasDetailCodeableConcept() {
            return this.detail instanceof CodeableConcept;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setDetail(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof Quantity || value instanceof Range || value instanceof CodeableConcept)) {
                throw new FHIRFormatError("Not the right type for PlanDefinition.goal.target.detail[x]: " + value.fhirType());
            }
            this.detail = value;
            return this;
        }

        public Duration getDue() {
            if (this.due == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PlanDefinitionGoalTargetComponent.due");
                }
                if (Configuration.doAutoCreate()) {
                    this.due = new Duration();
                }
            }
            return this.due;
        }

        public boolean hasDue() {
            return this.due != null && !this.due.isEmpty();
        }

        public PlanDefinitionGoalTargetComponent setDue(Duration value) {
            this.due = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("measure", "CodeableConcept", "The parameter whose value is to be tracked, e.g. body weigth, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure));
            children.add(new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail));
            children.add(new Property("due", "Duration", "Indicates the timeframe after the start of the goal in which the goal should be met.", 0, 1, this.due));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938321246: {
                    return new Property("measure", "CodeableConcept", "The parameter whose value is to be tracked, e.g. body weigth, blood pressure, or hemoglobin A1c level.", 0, 1, this.measure);
                }
                case -1973084529: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -1335224239: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -1313079300: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -2062632084: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case -175586544: {
                    return new Property("detail[x]", "Quantity|Range|CodeableConcept", "The target value of the measure to be achieved to signify fulfillment of the goal, e.g. 150 pounds or 7.0%. Either the high or low or both values of the range can be specified. Whan a low value is missing, it indicates that the goal is achieved at any value at or below the high value. Similarly, if the high value is missing, it indicates that the goal is achieved at any value at or above the low value.", 0, 1, this.detail);
                }
                case 99828: {
                    return new Property("due", "Duration", "Indicates the timeframe after the start of the goal in which the goal should be met.", 0, 1, this.due);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    Base[] baseArray;
                    if (this.measure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.measure;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
                case 99828: {
                    Base[] baseArray;
                    if (this.due == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.due;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    this.measure = this.castToCodeableConcept(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = this.castToType(value);
                    return value;
                }
                case 99828: {
                    this.due = this.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = this.castToCodeableConcept(value);
            } else if (name.equals("detail[x]")) {
                this.detail = this.castToType(value);
            } else if (name.equals("due")) {
                this.due = this.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return this.getMeasure();
                }
                case -1973084529: {
                    return this.getDetail();
                }
                case -1335224239: {
                    return this.getDetail();
                }
                case 99828: {
                    return this.getDue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938321246: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335224239: {
                    return new String[]{"Quantity", "Range", "CodeableConcept"};
                }
                case 99828: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("measure")) {
                this.measure = new CodeableConcept();
                return this.measure;
            }
            if (name.equals("detailQuantity")) {
                this.detail = new Quantity();
                return this.detail;
            }
            if (name.equals("detailRange")) {
                this.detail = new Range();
                return this.detail;
            }
            if (name.equals("detailCodeableConcept")) {
                this.detail = new CodeableConcept();
                return this.detail;
            }
            if (name.equals("due")) {
                this.due = new Duration();
                return this.due;
            }
            return super.addChild(name);
        }

        @Override
        public PlanDefinitionGoalTargetComponent copy() {
            PlanDefinitionGoalTargetComponent dst = new PlanDefinitionGoalTargetComponent();
            this.copyValues(dst);
            dst.measure = this.measure == null ? null : this.measure.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            dst.due = this.due == null ? null : this.due.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalTargetComponent)) {
                return false;
            }
            PlanDefinitionGoalTargetComponent o = (PlanDefinitionGoalTargetComponent)other_;
            return PlanDefinitionGoalTargetComponent.compareDeep(this.measure, o.measure, true) && PlanDefinitionGoalTargetComponent.compareDeep(this.detail, o.detail, true) && PlanDefinitionGoalTargetComponent.compareDeep(this.due, o.due, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PlanDefinitionGoalTargetComponent)) {
                return false;
            }
            PlanDefinitionGoalTargetComponent o = (PlanDefinitionGoalTargetComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.measure, this.detail, this.due});
        }

        @Override
        public String fhirType() {
            return "PlanDefinition.goal.target";
        }
    }

    public static class ActionCardinalityBehaviorEnumFactory
    implements EnumFactory<ActionCardinalityBehavior> {
        @Override
        public ActionCardinalityBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("single".equals(codeString)) {
                return ActionCardinalityBehavior.SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return ActionCardinalityBehavior.MULTIPLE;
            }
            throw new IllegalArgumentException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionCardinalityBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionCardinalityBehavior>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("single".equals(codeString)) {
                return new Enumeration<ActionCardinalityBehavior>(this, ActionCardinalityBehavior.SINGLE);
            }
            if ("multiple".equals(codeString)) {
                return new Enumeration<ActionCardinalityBehavior>(this, ActionCardinalityBehavior.MULTIPLE);
            }
            throw new FHIRException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionCardinalityBehavior code) {
            if (code == ActionCardinalityBehavior.NULL) {
                return null;
            }
            if (code == ActionCardinalityBehavior.SINGLE) {
                return "single";
            }
            if (code == ActionCardinalityBehavior.MULTIPLE) {
                return "multiple";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionCardinalityBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionCardinalityBehavior {
        SINGLE,
        MULTIPLE,
        NULL;


        public static ActionCardinalityBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("single".equals(codeString)) {
                return SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return MULTIPLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionCardinalityBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SINGLE: {
                    return "single";
                }
                case MULTIPLE: {
                    return "multiple";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SINGLE: {
                    return "http://hl7.org/fhir/action-cardinality-behavior";
                }
                case MULTIPLE: {
                    return "http://hl7.org/fhir/action-cardinality-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SINGLE: {
                    return "The action may only be selected one time";
                }
                case MULTIPLE: {
                    return "The action may be selected multiple times";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SINGLE: {
                    return "Single";
                }
                case MULTIPLE: {
                    return "Multiple";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionPrecheckBehaviorEnumFactory
    implements EnumFactory<ActionPrecheckBehavior> {
        @Override
        public ActionPrecheckBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return ActionPrecheckBehavior.YES;
            }
            if ("no".equals(codeString)) {
                return ActionPrecheckBehavior.NO;
            }
            throw new IllegalArgumentException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionPrecheckBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionPrecheckBehavior>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return new Enumeration<ActionPrecheckBehavior>(this, ActionPrecheckBehavior.YES);
            }
            if ("no".equals(codeString)) {
                return new Enumeration<ActionPrecheckBehavior>(this, ActionPrecheckBehavior.NO);
            }
            throw new FHIRException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionPrecheckBehavior code) {
            if (code == ActionPrecheckBehavior.NULL) {
                return null;
            }
            if (code == ActionPrecheckBehavior.YES) {
                return "yes";
            }
            if (code == ActionPrecheckBehavior.NO) {
                return "no";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionPrecheckBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionPrecheckBehavior {
        YES,
        NO,
        NULL;


        public static ActionPrecheckBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("yes".equals(codeString)) {
                return YES;
            }
            if ("no".equals(codeString)) {
                return NO;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case YES: {
                    return "yes";
                }
                case NO: {
                    return "no";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case YES: {
                    return "http://hl7.org/fhir/action-precheck-behavior";
                }
                case NO: {
                    return "http://hl7.org/fhir/action-precheck-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case YES: {
                    return "An action with this behavior is one of the most frequent action that is, or should be, included by an end user, for the particular context in which the action occurs. The system displaying the action to the end user should consider \"pre-checking\" such an action as a convenience for the user";
                }
                case NO: {
                    return "An action with this behavior is one of the less frequent actions included by the end user, for the particular context in which the action occurs. The system displaying the actions to the end user would typically not \"pre-check\" such an action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case YES: {
                    return "Yes";
                }
                case NO: {
                    return "No";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionRequiredBehaviorEnumFactory
    implements EnumFactory<ActionRequiredBehavior> {
        @Override
        public ActionRequiredBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("must".equals(codeString)) {
                return ActionRequiredBehavior.MUST;
            }
            if ("could".equals(codeString)) {
                return ActionRequiredBehavior.COULD;
            }
            if ("must-unless-documented".equals(codeString)) {
                return ActionRequiredBehavior.MUSTUNLESSDOCUMENTED;
            }
            throw new IllegalArgumentException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionRequiredBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionRequiredBehavior>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("must".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.MUST);
            }
            if ("could".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.COULD);
            }
            if ("must-unless-documented".equals(codeString)) {
                return new Enumeration<ActionRequiredBehavior>(this, ActionRequiredBehavior.MUSTUNLESSDOCUMENTED);
            }
            throw new FHIRException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRequiredBehavior code) {
            if (code == ActionRequiredBehavior.NULL) {
                return null;
            }
            if (code == ActionRequiredBehavior.MUST) {
                return "must";
            }
            if (code == ActionRequiredBehavior.COULD) {
                return "could";
            }
            if (code == ActionRequiredBehavior.MUSTUNLESSDOCUMENTED) {
                return "must-unless-documented";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRequiredBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionRequiredBehavior {
        MUST,
        COULD,
        MUSTUNLESSDOCUMENTED,
        NULL;


        public static ActionRequiredBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("must".equals(codeString)) {
                return MUST;
            }
            if ("could".equals(codeString)) {
                return COULD;
            }
            if ("must-unless-documented".equals(codeString)) {
                return MUSTUNLESSDOCUMENTED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionRequiredBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MUST: {
                    return "must";
                }
                case COULD: {
                    return "could";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "must-unless-documented";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MUST: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
                case COULD: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "http://hl7.org/fhir/action-required-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MUST: {
                    return "An action with this behavior must be included in the actions processed by the end user; the end user may not choose not to include this action";
                }
                case COULD: {
                    return "An action with this behavior may be included in the set of actions processed by the end user";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "An action with this behavior must be included in the set of actions processed by the end user, unless the end user provides documentation as to why the action was not included";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MUST: {
                    return "Must";
                }
                case COULD: {
                    return "Could";
                }
                case MUSTUNLESSDOCUMENTED: {
                    return "Must Unless Documented";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionSelectionBehaviorEnumFactory
    implements EnumFactory<ActionSelectionBehavior> {
        @Override
        public ActionSelectionBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("any".equals(codeString)) {
                return ActionSelectionBehavior.ANY;
            }
            if ("all".equals(codeString)) {
                return ActionSelectionBehavior.ALL;
            }
            if ("all-or-none".equals(codeString)) {
                return ActionSelectionBehavior.ALLORNONE;
            }
            if ("exactly-one".equals(codeString)) {
                return ActionSelectionBehavior.EXACTLYONE;
            }
            if ("at-most-one".equals(codeString)) {
                return ActionSelectionBehavior.ATMOSTONE;
            }
            if ("one-or-more".equals(codeString)) {
                return ActionSelectionBehavior.ONEORMORE;
            }
            throw new IllegalArgumentException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionSelectionBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionSelectionBehavior>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("any".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ANY);
            }
            if ("all".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ALL);
            }
            if ("all-or-none".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ALLORNONE);
            }
            if ("exactly-one".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.EXACTLYONE);
            }
            if ("at-most-one".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ATMOSTONE);
            }
            if ("one-or-more".equals(codeString)) {
                return new Enumeration<ActionSelectionBehavior>(this, ActionSelectionBehavior.ONEORMORE);
            }
            throw new FHIRException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionSelectionBehavior code) {
            if (code == ActionSelectionBehavior.NULL) {
                return null;
            }
            if (code == ActionSelectionBehavior.ANY) {
                return "any";
            }
            if (code == ActionSelectionBehavior.ALL) {
                return "all";
            }
            if (code == ActionSelectionBehavior.ALLORNONE) {
                return "all-or-none";
            }
            if (code == ActionSelectionBehavior.EXACTLYONE) {
                return "exactly-one";
            }
            if (code == ActionSelectionBehavior.ATMOSTONE) {
                return "at-most-one";
            }
            if (code == ActionSelectionBehavior.ONEORMORE) {
                return "one-or-more";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionSelectionBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionSelectionBehavior {
        ANY,
        ALL,
        ALLORNONE,
        EXACTLYONE,
        ATMOSTONE,
        ONEORMORE,
        NULL;


        public static ActionSelectionBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("any".equals(codeString)) {
                return ANY;
            }
            if ("all".equals(codeString)) {
                return ALL;
            }
            if ("all-or-none".equals(codeString)) {
                return ALLORNONE;
            }
            if ("exactly-one".equals(codeString)) {
                return EXACTLYONE;
            }
            if ("at-most-one".equals(codeString)) {
                return ATMOSTONE;
            }
            if ("one-or-more".equals(codeString)) {
                return ONEORMORE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionSelectionBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ANY: {
                    return "any";
                }
                case ALL: {
                    return "all";
                }
                case ALLORNONE: {
                    return "all-or-none";
                }
                case EXACTLYONE: {
                    return "exactly-one";
                }
                case ATMOSTONE: {
                    return "at-most-one";
                }
                case ONEORMORE: {
                    return "one-or-more";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ANY: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ALL: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ALLORNONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case EXACTLYONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ATMOSTONE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case ONEORMORE: {
                    return "http://hl7.org/fhir/action-selection-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ANY: {
                    return "Any number of the actions in the group may be chosen, from zero to all";
                }
                case ALL: {
                    return "All the actions in the group must be selected as a single unit";
                }
                case ALLORNONE: {
                    return "All the actions in the group are meant to be chosen as a single unit: either all must be selected by the end user, or none may be selected";
                }
                case EXACTLYONE: {
                    return "The end user must choose one and only one of the selectable actions in the group. The user may not choose none of the actions in the group";
                }
                case ATMOSTONE: {
                    return "The end user may choose zero or at most one of the actions in the group";
                }
                case ONEORMORE: {
                    return "The end user must choose a minimum of one, and as many additional as desired";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ANY: {
                    return "Any";
                }
                case ALL: {
                    return "All";
                }
                case ALLORNONE: {
                    return "All Or None";
                }
                case EXACTLYONE: {
                    return "Exactly One";
                }
                case ATMOSTONE: {
                    return "At Most One";
                }
                case ONEORMORE: {
                    return "One Or More";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionGroupingBehaviorEnumFactory
    implements EnumFactory<ActionGroupingBehavior> {
        @Override
        public ActionGroupingBehavior fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return ActionGroupingBehavior.VISUALGROUP;
            }
            if ("logical-group".equals(codeString)) {
                return ActionGroupingBehavior.LOGICALGROUP;
            }
            if ("sentence-group".equals(codeString)) {
                return ActionGroupingBehavior.SENTENCEGROUP;
            }
            throw new IllegalArgumentException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        public Enumeration<ActionGroupingBehavior> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionGroupingBehavior>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.VISUALGROUP);
            }
            if ("logical-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.LOGICALGROUP);
            }
            if ("sentence-group".equals(codeString)) {
                return new Enumeration<ActionGroupingBehavior>(this, ActionGroupingBehavior.SENTENCEGROUP);
            }
            throw new FHIRException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionGroupingBehavior code) {
            if (code == ActionGroupingBehavior.NULL) {
                return null;
            }
            if (code == ActionGroupingBehavior.VISUALGROUP) {
                return "visual-group";
            }
            if (code == ActionGroupingBehavior.LOGICALGROUP) {
                return "logical-group";
            }
            if (code == ActionGroupingBehavior.SENTENCEGROUP) {
                return "sentence-group";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionGroupingBehavior code) {
            return code.getSystem();
        }
    }

    public static enum ActionGroupingBehavior {
        VISUALGROUP,
        LOGICALGROUP,
        SENTENCEGROUP,
        NULL;


        public static ActionGroupingBehavior fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("visual-group".equals(codeString)) {
                return VISUALGROUP;
            }
            if ("logical-group".equals(codeString)) {
                return LOGICALGROUP;
            }
            if ("sentence-group".equals(codeString)) {
                return SENTENCEGROUP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionGroupingBehavior code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case VISUALGROUP: {
                    return "visual-group";
                }
                case LOGICALGROUP: {
                    return "logical-group";
                }
                case SENTENCEGROUP: {
                    return "sentence-group";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case VISUALGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
                case LOGICALGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
                case SENTENCEGROUP: {
                    return "http://hl7.org/fhir/action-grouping-behavior";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case VISUALGROUP: {
                    return "Any group marked with this behavior should be displayed as a visual group to the end user";
                }
                case LOGICALGROUP: {
                    return "A group with this behavior logically groups its sub-elements, and may be shown as a visual group to the end user, but it is not required to do so";
                }
                case SENTENCEGROUP: {
                    return "A group of related alternative actions is a sentence group if the target referenced by the action is the same in all the actions and each action simply constitutes a different variation on how to specify the details for the target. For example, two actions that could be in a SentenceGroup are \"aspirin, 500 mg, 2 times per day\" and \"aspirin, 300 mg, 3 times per day\". In both cases, aspirin is the target referenced by the action, and the two actions represent different options for how aspirin might be ordered for the patient. Note that a SentenceGroup would almost always have an associated selection behavior of \"AtMostOne\", unless it's a required action, in which case, it would be \"ExactlyOne\"";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case VISUALGROUP: {
                    return "Visual Group";
                }
                case LOGICALGROUP: {
                    return "Logical Group";
                }
                case SENTENCEGROUP: {
                    return "Sentence Group";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionParticipantTypeEnumFactory
    implements EnumFactory<ActionParticipantType> {
        @Override
        public ActionParticipantType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return ActionParticipantType.PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return ActionParticipantType.PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return ActionParticipantType.RELATEDPERSON;
            }
            throw new IllegalArgumentException("Unknown ActionParticipantType code '" + codeString + "'");
        }

        public Enumeration<ActionParticipantType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionParticipantType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return new Enumeration<ActionParticipantType>(this, ActionParticipantType.PATIENT);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<ActionParticipantType>(this, ActionParticipantType.PRACTITIONER);
            }
            if ("related-person".equals(codeString)) {
                return new Enumeration<ActionParticipantType>(this, ActionParticipantType.RELATEDPERSON);
            }
            throw new FHIRException("Unknown ActionParticipantType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionParticipantType code) {
            if (code == ActionParticipantType.NULL) {
                return null;
            }
            if (code == ActionParticipantType.PATIENT) {
                return "patient";
            }
            if (code == ActionParticipantType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == ActionParticipantType.RELATEDPERSON) {
                return "related-person";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionParticipantType code) {
            return code.getSystem();
        }
    }

    public static enum ActionParticipantType {
        PATIENT,
        PRACTITIONER,
        RELATEDPERSON,
        NULL;


        public static ActionParticipantType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return RELATEDPERSON;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionParticipantType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "patient";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case RELATEDPERSON: {
                    return "related-person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The participant is the patient under evaluation";
                }
                case PRACTITIONER: {
                    return "The participant is a practitioner involved in the patient's care";
                }
                case RELATEDPERSON: {
                    return "The participant is a person related to the patient";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case RELATEDPERSON: {
                    return "Related Person";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionRelationshipTypeEnumFactory
    implements EnumFactory<ActionRelationshipType> {
        @Override
        public ActionRelationshipType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return ActionRelationshipType.BEFORESTART;
            }
            if ("before".equals(codeString)) {
                return ActionRelationshipType.BEFORE;
            }
            if ("before-end".equals(codeString)) {
                return ActionRelationshipType.BEFOREEND;
            }
            if ("concurrent-with-start".equals(codeString)) {
                return ActionRelationshipType.CONCURRENTWITHSTART;
            }
            if ("concurrent".equals(codeString)) {
                return ActionRelationshipType.CONCURRENT;
            }
            if ("concurrent-with-end".equals(codeString)) {
                return ActionRelationshipType.CONCURRENTWITHEND;
            }
            if ("after-start".equals(codeString)) {
                return ActionRelationshipType.AFTERSTART;
            }
            if ("after".equals(codeString)) {
                return ActionRelationshipType.AFTER;
            }
            if ("after-end".equals(codeString)) {
                return ActionRelationshipType.AFTEREND;
            }
            throw new IllegalArgumentException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public Enumeration<ActionRelationshipType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionRelationshipType>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFORESTART);
            }
            if ("before".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFORE);
            }
            if ("before-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.BEFOREEND);
            }
            if ("concurrent-with-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENTWITHSTART);
            }
            if ("concurrent".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENT);
            }
            if ("concurrent-with-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.CONCURRENTWITHEND);
            }
            if ("after-start".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTERSTART);
            }
            if ("after".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTER);
            }
            if ("after-end".equals(codeString)) {
                return new Enumeration<ActionRelationshipType>(this, ActionRelationshipType.AFTEREND);
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionRelationshipType code) {
            if (code == ActionRelationshipType.NULL) {
                return null;
            }
            if (code == ActionRelationshipType.BEFORESTART) {
                return "before-start";
            }
            if (code == ActionRelationshipType.BEFORE) {
                return "before";
            }
            if (code == ActionRelationshipType.BEFOREEND) {
                return "before-end";
            }
            if (code == ActionRelationshipType.CONCURRENTWITHSTART) {
                return "concurrent-with-start";
            }
            if (code == ActionRelationshipType.CONCURRENT) {
                return "concurrent";
            }
            if (code == ActionRelationshipType.CONCURRENTWITHEND) {
                return "concurrent-with-end";
            }
            if (code == ActionRelationshipType.AFTERSTART) {
                return "after-start";
            }
            if (code == ActionRelationshipType.AFTER) {
                return "after";
            }
            if (code == ActionRelationshipType.AFTEREND) {
                return "after-end";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionRelationshipType code) {
            return code.getSystem();
        }
    }

    public static enum ActionRelationshipType {
        BEFORESTART,
        BEFORE,
        BEFOREEND,
        CONCURRENTWITHSTART,
        CONCURRENT,
        CONCURRENTWITHEND,
        AFTERSTART,
        AFTER,
        AFTEREND,
        NULL;


        public static ActionRelationshipType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("before-start".equals(codeString)) {
                return BEFORESTART;
            }
            if ("before".equals(codeString)) {
                return BEFORE;
            }
            if ("before-end".equals(codeString)) {
                return BEFOREEND;
            }
            if ("concurrent-with-start".equals(codeString)) {
                return CONCURRENTWITHSTART;
            }
            if ("concurrent".equals(codeString)) {
                return CONCURRENT;
            }
            if ("concurrent-with-end".equals(codeString)) {
                return CONCURRENTWITHEND;
            }
            if ("after-start".equals(codeString)) {
                return AFTERSTART;
            }
            if ("after".equals(codeString)) {
                return AFTER;
            }
            if ("after-end".equals(codeString)) {
                return AFTEREND;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionRelationshipType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BEFORESTART: {
                    return "before-start";
                }
                case BEFORE: {
                    return "before";
                }
                case BEFOREEND: {
                    return "before-end";
                }
                case CONCURRENTWITHSTART: {
                    return "concurrent-with-start";
                }
                case CONCURRENT: {
                    return "concurrent";
                }
                case CONCURRENTWITHEND: {
                    return "concurrent-with-end";
                }
                case AFTERSTART: {
                    return "after-start";
                }
                case AFTER: {
                    return "after";
                }
                case AFTEREND: {
                    return "after-end";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BEFORESTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case BEFORE: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case BEFOREEND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENTWITHSTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENT: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case CONCURRENTWITHEND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTERSTART: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTER: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case AFTEREND: {
                    return "http://hl7.org/fhir/action-relationship-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BEFORESTART: {
                    return "The action must be performed before the start of the related action";
                }
                case BEFORE: {
                    return "The action must be performed before the related action";
                }
                case BEFOREEND: {
                    return "The action must be performed before the end of the related action";
                }
                case CONCURRENTWITHSTART: {
                    return "The action must be performed concurrent with the start of the related action";
                }
                case CONCURRENT: {
                    return "The action must be performed concurrent with the related action";
                }
                case CONCURRENTWITHEND: {
                    return "The action must be performed concurrent with the end of the related action";
                }
                case AFTERSTART: {
                    return "The action must be performed after the start of the related action";
                }
                case AFTER: {
                    return "The action must be performed after the related action";
                }
                case AFTEREND: {
                    return "The action must be performed after the end of the related action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BEFORESTART: {
                    return "Before Start";
                }
                case BEFORE: {
                    return "Before";
                }
                case BEFOREEND: {
                    return "Before End";
                }
                case CONCURRENTWITHSTART: {
                    return "Concurrent With Start";
                }
                case CONCURRENT: {
                    return "Concurrent";
                }
                case CONCURRENTWITHEND: {
                    return "Concurrent With End";
                }
                case AFTERSTART: {
                    return "After Start";
                }
                case AFTER: {
                    return "After";
                }
                case AFTEREND: {
                    return "After End";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ActionConditionKindEnumFactory
    implements EnumFactory<ActionConditionKind> {
        @Override
        public ActionConditionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return ActionConditionKind.APPLICABILITY;
            }
            if ("start".equals(codeString)) {
                return ActionConditionKind.START;
            }
            if ("stop".equals(codeString)) {
                return ActionConditionKind.STOP;
            }
            throw new IllegalArgumentException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        public Enumeration<ActionConditionKind> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActionConditionKind>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.APPLICABILITY);
            }
            if ("start".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.START);
            }
            if ("stop".equals(codeString)) {
                return new Enumeration<ActionConditionKind>(this, ActionConditionKind.STOP);
            }
            throw new FHIRException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionConditionKind code) {
            if (code == ActionConditionKind.NULL) {
                return null;
            }
            if (code == ActionConditionKind.APPLICABILITY) {
                return "applicability";
            }
            if (code == ActionConditionKind.START) {
                return "start";
            }
            if (code == ActionConditionKind.STOP) {
                return "stop";
            }
            return "?";
        }

        @Override
        public String toSystem(ActionConditionKind code) {
            return code.getSystem();
        }
    }

    public static enum ActionConditionKind {
        APPLICABILITY,
        START,
        STOP,
        NULL;


        public static ActionConditionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("applicability".equals(codeString)) {
                return APPLICABILITY;
            }
            if ("start".equals(codeString)) {
                return START;
            }
            if ("stop".equals(codeString)) {
                return STOP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActionConditionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPLICABILITY: {
                    return "applicability";
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPLICABILITY: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
                case START: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
                case STOP: {
                    return "http://hl7.org/fhir/action-condition-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPLICABILITY: {
                    return "The condition describes whether or not a given action is applicable";
                }
                case START: {
                    return "The condition is a starting condition for the action";
                }
                case STOP: {
                    return "The condition is a stop, or exit condition for the action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPLICABILITY: {
                    return "Applicability";
                }
                case START: {
                    return "Start";
                }
                case STOP: {
                    return "Stop";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

