/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchStudy", profile="http://hl7.org/fhir/Profile/ResearchStudy")
public class ResearchStudy
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for study", formalDefinition="Identifiers assigned to this research study by the sponsor or other systems.")
    protected List<Identifier> identifier;
    @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this study", formalDefinition="A short, descriptive user-friendly label for the study.")
    protected StringType title;
    @Child(name="protocol", type={PlanDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Steps followed in executing study", formalDefinition="The set of steps expected to be performed as part of the execution of the study.")
    protected List<Reference> protocol;
    protected List<PlanDefinition> protocolTarget;
    @Child(name="partOf", type={ResearchStudy.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of larger study", formalDefinition="A larger research study of which this particular study is a component or step.")
    protected List<Reference> partOf;
    protected List<ResearchStudy> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | in-progress | suspended | stopped | completed | entered-in-error", formalDefinition="The current state of the study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-study-status")
    protected Enumeration<ResearchStudyStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classifications for the study", formalDefinition="Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.")
    protected List<CodeableConcept> category;
    @Child(name="focus", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Drugs, devices, conditions, etc. under study", formalDefinition="The condition(s), medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.")
    protected List<CodeableConcept> focus;
    @Child(name="contact", type={ContactDetail.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the study", formalDefinition="Contact details to assist a user in learning more about or engaging with the study.")
    protected List<ContactDetail> contact;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="References and dependencies", formalDefinition="Citations, references and other related documents.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="keyword", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Used to search for the study", formalDefinition="Key terms to aid in searching for or filtering the study.")
    protected List<CodeableConcept> keyword;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Geographic region(s) for study", formalDefinition="Indicates a country, state or other region where the study is taking place.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What this is study doing", formalDefinition="A full description of how the study is being conducted.")
    protected MarkdownType description;
    @Child(name="enrollment", type={Group.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Inclusion & exclusion criteria", formalDefinition="Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".")
    protected List<Reference> enrollment;
    protected List<Group> enrollmentTarget;
    @Child(name="period", type={Period.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study began and ended", formalDefinition="Identifies the start date and the expected (or actual, depending on status) end date for the study.")
    protected Period period;
    @Child(name="sponsor", type={Organization.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization responsible for the study", formalDefinition="The organization responsible for the execution of the study.")
    protected Reference sponsor;
    protected Organization sponsorTarget;
    @Child(name="principalInvestigator", type={Practitioner.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The individual responsible for the study", formalDefinition="Indicates the individual who has primary oversite of the execution of the study.")
    protected Reference principalInvestigator;
    protected Practitioner principalInvestigatorTarget;
    @Child(name="site", type={Location.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Location involved in study execution", formalDefinition="Clinic, hospital or other healthcare location that is participating in the study.")
    protected List<Reference> site;
    protected List<Location> siteTarget;
    @Child(name="reasonStopped", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for terminating study early", formalDefinition="A description and/or code explaining the premature termination of the study.")
    protected CodeableConcept reasonStopped;
    @Child(name="note", type={Annotation.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the event", formalDefinition="Comments made about the event by the performer, subject or other participants.")
    protected List<Annotation> note;
    @Child(name="arm", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Defined path through the study for a subject", formalDefinition="Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.")
    protected List<ResearchStudyArmComponent> arm;
    private static final long serialVersionUID = -1804662501L;
    @SearchParamDefinition(name="date", path="ResearchStudy.period", description="When the study began and ended", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ResearchStudy.identifier", description="Business Identifier for study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="ResearchStudy.partOf", description="Part of larger study", type="reference", target={ResearchStudy.class})
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("ResearchStudy:partof").toLocked();
    @SearchParamDefinition(name="sponsor", path="ResearchStudy.sponsor", description="Organization responsible for the study", type="reference", target={Organization.class})
    public static final String SP_SPONSOR = "sponsor";
    public static final ReferenceClientParam SPONSOR = new ReferenceClientParam("sponsor");
    public static final Include INCLUDE_SPONSOR = new Include("ResearchStudy:sponsor").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="ResearchStudy.jurisdiction", description="Geographic region(s) for study", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="focus", path="ResearchStudy.focus", description="Drugs, devices, conditions, etc. under study", type="token")
    public static final String SP_FOCUS = "focus";
    public static final TokenClientParam FOCUS = new TokenClientParam("focus");
    @SearchParamDefinition(name="principalinvestigator", path="ResearchStudy.principalInvestigator", description="The individual responsible for the study", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_PRINCIPALINVESTIGATOR = "principalinvestigator";
    public static final ReferenceClientParam PRINCIPALINVESTIGATOR = new ReferenceClientParam("principalinvestigator");
    public static final Include INCLUDE_PRINCIPALINVESTIGATOR = new Include("ResearchStudy:principalinvestigator").toLocked();
    @SearchParamDefinition(name="title", path="ResearchStudy.title", description="Name for this study", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="protocol", path="ResearchStudy.protocol", description="Steps followed in executing study", type="reference", target={PlanDefinition.class})
    public static final String SP_PROTOCOL = "protocol";
    public static final ReferenceClientParam PROTOCOL = new ReferenceClientParam("protocol");
    public static final Include INCLUDE_PROTOCOL = new Include("ResearchStudy:protocol").toLocked();
    @SearchParamDefinition(name="site", path="ResearchStudy.site", description="Location involved in study execution", type="reference", target={Location.class})
    public static final String SP_SITE = "site";
    public static final ReferenceClientParam SITE = new ReferenceClientParam("site");
    public static final Include INCLUDE_SITE = new Include("ResearchStudy:site").toLocked();
    @SearchParamDefinition(name="category", path="ResearchStudy.category", description="Classifications for the study", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="keyword", path="ResearchStudy.keyword", description="Used to search for the study", type="token")
    public static final String SP_KEYWORD = "keyword";
    public static final TokenClientParam KEYWORD = new TokenClientParam("keyword");
    @SearchParamDefinition(name="status", path="ResearchStudy.status", description="draft | in-progress | suspended | stopped | completed | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ResearchStudy() {
    }

    public ResearchStudy(Enumeration<ResearchStudyStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ResearchStudy setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ResearchStudy setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<Reference> getProtocol() {
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        return this.protocol;
    }

    public ResearchStudy setProtocol(List<Reference> theProtocol) {
        this.protocol = theProtocol;
        return this;
    }

    public boolean hasProtocol() {
        if (this.protocol == null) {
            return false;
        }
        for (Reference item : this.protocol) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProtocol() {
        Reference t = new Reference();
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return t;
    }

    public ResearchStudy addProtocol(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.protocol == null) {
            this.protocol = new ArrayList<Reference>();
        }
        this.protocol.add(t);
        return this;
    }

    public Reference getProtocolFirstRep() {
        if (this.getProtocol().isEmpty()) {
            this.addProtocol();
        }
        return this.getProtocol().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public ResearchStudy setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public ResearchStudy addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<ResearchStudyStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ResearchStudyStatus>(new ResearchStudyStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchStudy setStatusElement(Enumeration<ResearchStudyStatus> value) {
        this.status = value;
        return this;
    }

    public ResearchStudyStatus getStatus() {
        return this.status == null ? null : (ResearchStudyStatus)((Object)this.status.getValue());
    }

    public ResearchStudy setStatus(ResearchStudyStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ResearchStudyStatus>(new ResearchStudyStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ResearchStudy setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ResearchStudy addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        return this.focus;
    }

    public ResearchStudy setFocus(List<CodeableConcept> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (CodeableConcept item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFocus() {
        CodeableConcept t = new CodeableConcept();
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        this.focus.add(t);
        return t;
    }

    public ResearchStudy addFocus(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<CodeableConcept>();
        }
        this.focus.add(t);
        return this;
    }

    public CodeableConcept getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public ResearchStudy setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public ResearchStudy addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ResearchStudy setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ResearchStudy addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CodeableConcept> getKeyword() {
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        return this.keyword;
    }

    public ResearchStudy setKeyword(List<CodeableConcept> theKeyword) {
        this.keyword = theKeyword;
        return this;
    }

    public boolean hasKeyword() {
        if (this.keyword == null) {
            return false;
        }
        for (CodeableConcept item : this.keyword) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addKeyword() {
        CodeableConcept t = new CodeableConcept();
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return t;
    }

    public ResearchStudy addKeyword(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.keyword == null) {
            this.keyword = new ArrayList<CodeableConcept>();
        }
        this.keyword.add(t);
        return this;
    }

    public CodeableConcept getKeywordFirstRep() {
        if (this.getKeyword().isEmpty()) {
            this.addKeyword();
        }
        return this.getKeyword().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public ResearchStudy setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public ResearchStudy addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ResearchStudy setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ResearchStudy setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getEnrollment() {
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        return this.enrollment;
    }

    public ResearchStudy setEnrollment(List<Reference> theEnrollment) {
        this.enrollment = theEnrollment;
        return this;
    }

    public boolean hasEnrollment() {
        if (this.enrollment == null) {
            return false;
        }
        for (Reference item : this.enrollment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEnrollment() {
        Reference t = new Reference();
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        this.enrollment.add(t);
        return t;
    }

    public ResearchStudy addEnrollment(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.enrollment == null) {
            this.enrollment = new ArrayList<Reference>();
        }
        this.enrollment.add(t);
        return this;
    }

    public Reference getEnrollmentFirstRep() {
        if (this.getEnrollment().isEmpty()) {
            this.addEnrollment();
        }
        return this.getEnrollment().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchStudy setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getSponsor() {
        if (this.sponsor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.sponsor");
            }
            if (Configuration.doAutoCreate()) {
                this.sponsor = new Reference();
            }
        }
        return this.sponsor;
    }

    public boolean hasSponsor() {
        return this.sponsor != null && !this.sponsor.isEmpty();
    }

    public ResearchStudy setSponsor(Reference value) {
        this.sponsor = value;
        return this;
    }

    public Organization getSponsorTarget() {
        if (this.sponsorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.sponsor");
            }
            if (Configuration.doAutoCreate()) {
                this.sponsorTarget = new Organization();
            }
        }
        return this.sponsorTarget;
    }

    public ResearchStudy setSponsorTarget(Organization value) {
        this.sponsorTarget = value;
        return this;
    }

    public Reference getPrincipalInvestigator() {
        if (this.principalInvestigator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.principalInvestigator");
            }
            if (Configuration.doAutoCreate()) {
                this.principalInvestigator = new Reference();
            }
        }
        return this.principalInvestigator;
    }

    public boolean hasPrincipalInvestigator() {
        return this.principalInvestigator != null && !this.principalInvestigator.isEmpty();
    }

    public ResearchStudy setPrincipalInvestigator(Reference value) {
        this.principalInvestigator = value;
        return this;
    }

    public Practitioner getPrincipalInvestigatorTarget() {
        if (this.principalInvestigatorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.principalInvestigator");
            }
            if (Configuration.doAutoCreate()) {
                this.principalInvestigatorTarget = new Practitioner();
            }
        }
        return this.principalInvestigatorTarget;
    }

    public ResearchStudy setPrincipalInvestigatorTarget(Practitioner value) {
        this.principalInvestigatorTarget = value;
        return this;
    }

    public List<Reference> getSite() {
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        return this.site;
    }

    public ResearchStudy setSite(List<Reference> theSite) {
        this.site = theSite;
        return this;
    }

    public boolean hasSite() {
        if (this.site == null) {
            return false;
        }
        for (Reference item : this.site) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSite() {
        Reference t = new Reference();
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return t;
    }

    public ResearchStudy addSite(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.site == null) {
            this.site = new ArrayList<Reference>();
        }
        this.site.add(t);
        return this;
    }

    public Reference getSiteFirstRep() {
        if (this.getSite().isEmpty()) {
            this.addSite();
        }
        return this.getSite().get(0);
    }

    public CodeableConcept getReasonStopped() {
        if (this.reasonStopped == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchStudy.reasonStopped");
            }
            if (Configuration.doAutoCreate()) {
                this.reasonStopped = new CodeableConcept();
            }
        }
        return this.reasonStopped;
    }

    public boolean hasReasonStopped() {
        return this.reasonStopped != null && !this.reasonStopped.isEmpty();
    }

    public ResearchStudy setReasonStopped(CodeableConcept value) {
        this.reasonStopped = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ResearchStudy setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ResearchStudy addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<ResearchStudyArmComponent> getArm() {
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        return this.arm;
    }

    public ResearchStudy setArm(List<ResearchStudyArmComponent> theArm) {
        this.arm = theArm;
        return this;
    }

    public boolean hasArm() {
        if (this.arm == null) {
            return false;
        }
        for (ResearchStudyArmComponent item : this.arm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchStudyArmComponent addArm() {
        ResearchStudyArmComponent t = new ResearchStudyArmComponent();
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        this.arm.add(t);
        return t;
    }

    public ResearchStudy addArm(ResearchStudyArmComponent t) {
        if (t == null) {
            return this;
        }
        if (this.arm == null) {
            this.arm = new ArrayList<ResearchStudyArmComponent>();
        }
        this.arm.add(t);
        return this;
    }

    public ResearchStudyArmComponent getArmFirstRep() {
        if (this.getArm().isEmpty()) {
            this.addArm();
        }
        return this.getArm().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive user-friendly label for the study.", 0, 1, this.title));
        children.add(new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol));
        children.add(new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "The current state of the study.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_FOCUS, "CodeableConcept", "The condition(s), medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in learning more about or engaging with the study.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Citations, references and other related documents.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "Indicates a country, state or other region where the study is taking place.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("description", "markdown", "A full description of how the study is being conducted.", 0, 1, this.description));
        children.add(new Property("enrollment", "Reference(Group)", "Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".", 0, Integer.MAX_VALUE, this.enrollment));
        children.add(new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period));
        children.add(new Property(SP_SPONSOR, "Reference(Organization)", "The organization responsible for the execution of the study.", 0, 1, this.sponsor));
        children.add(new Property("principalInvestigator", "Reference(Practitioner)", "Indicates the individual who has primary oversite of the execution of the study.", 0, 1, this.principalInvestigator));
        children.add(new Property(SP_SITE, "Reference(Location)", "Clinic, hospital or other healthcare location that is participating in the study.", 0, Integer.MAX_VALUE, this.site));
        children.add(new Property("reasonStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.reasonStopped));
        children.add(new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("arm", "", "Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.", 0, Integer.MAX_VALUE, this.arm));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research study by the sponsor or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive user-friendly label for the study.", 0, 1, this.title);
            }
            case -989163880: {
                return new Property(SP_PROTOCOL, "Reference(PlanDefinition)", "The set of steps expected to be performed as part of the execution of the study.", 0, Integer.MAX_VALUE, this.protocol);
            }
            case -995410646: {
                return new Property("partOf", "Reference(ResearchStudy)", "A larger research study of which this particular study is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the study.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Codes categorizing the type of study such as investigational vs. observational, type of blinding, type of randomization, safety vs. efficacy, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 97604824: {
                return new Property(SP_FOCUS, "CodeableConcept", "The condition(s), medication(s), food(s), therapy(ies), device(s) or other concerns or interventions that the study is seeking to gain more information about.", 0, Integer.MAX_VALUE, this.focus);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in learning more about or engaging with the study.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Citations, references and other related documents.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -814408215: {
                return new Property(SP_KEYWORD, "CodeableConcept", "Key terms to aid in searching for or filtering the study.", 0, Integer.MAX_VALUE, this.keyword);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "Indicates a country, state or other region where the study is taking place.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A full description of how the study is being conducted.", 0, 1, this.description);
            }
            case 116089604: {
                return new Property("enrollment", "Reference(Group)", "Reference to a Group that defines the criteria for and quantity of subjects participating in the study.  E.g. \" 200 female Europeans between the ages of 20 and 45 with early onset diabetes\".", 0, Integer.MAX_VALUE, this.enrollment);
            }
            case -991726143: {
                return new Property("period", "Period", "Identifies the start date and the expected (or actual, depending on status) end date for the study.", 0, 1, this.period);
            }
            case -1998892262: {
                return new Property(SP_SPONSOR, "Reference(Organization)", "The organization responsible for the execution of the study.", 0, 1, this.sponsor);
            }
            case 1437117175: {
                return new Property("principalInvestigator", "Reference(Practitioner)", "Indicates the individual who has primary oversite of the execution of the study.", 0, 1, this.principalInvestigator);
            }
            case 3530567: {
                return new Property(SP_SITE, "Reference(Location)", "Clinic, hospital or other healthcare location that is participating in the study.", 0, Integer.MAX_VALUE, this.site);
            }
            case 1181369065: {
                return new Property("reasonStopped", "CodeableConcept", "A description and/or code explaining the premature termination of the study.", 0, 1, this.reasonStopped);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the event by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
            case 96860: {
                return new Property("arm", "", "Describes an expected sequence of events for one of the participants of a study.  E.g. Exposure to drug A, wash-out, exposure to drug B, wash-out, follow-up.", 0, Integer.MAX_VALUE, this.arm);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.title;
                }
                return baseArray;
            }
            case -989163880: {
                return this.protocol == null ? new Base[]{} : this.protocol.toArray(new Base[this.protocol.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -814408215: {
                return this.keyword == null ? new Base[]{} : this.keyword.toArray(new Base[this.keyword.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case 116089604: {
                return this.enrollment == null ? new Base[]{} : this.enrollment.toArray(new Base[this.enrollment.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -1998892262: {
                Base[] baseArray;
                if (this.sponsor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.sponsor;
                }
                return baseArray;
            }
            case 1437117175: {
                Base[] baseArray;
                if (this.principalInvestigator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.principalInvestigator;
                }
                return baseArray;
            }
            case 3530567: {
                return this.site == null ? new Base[]{} : this.site.toArray(new Base[this.site.size()]);
            }
            case 1181369065: {
                Base[] baseArray;
                if (this.reasonStopped == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reasonStopped;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 96860: {
                return this.arm == null ? new Base[]{} : this.arm.toArray(new Base[this.arm.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -989163880: {
                this.getProtocol().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new ResearchStudyStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 97604824: {
                this.getFocus().add(this.castToCodeableConcept(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case -814408215: {
                this.getKeyword().add(this.castToCodeableConcept(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case 116089604: {
                this.getEnrollment().add(this.castToReference(value));
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1998892262: {
                this.sponsor = this.castToReference(value);
                return value;
            }
            case 1437117175: {
                this.principalInvestigator = this.castToReference(value);
                return value;
            }
            case 3530567: {
                this.getSite().add(this.castToReference(value));
                return value;
            }
            case 1181369065: {
                this.reasonStopped = this.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 96860: {
                this.getArm().add((ResearchStudyArmComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_PROTOCOL)) {
            this.getProtocol().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ResearchStudyStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_FOCUS)) {
            this.getFocus().add(this.castToCodeableConcept(value));
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals(SP_KEYWORD)) {
            this.getKeyword().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("enrollment")) {
            this.getEnrollment().add(this.castToReference(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_SPONSOR)) {
            this.sponsor = this.castToReference(value);
        } else if (name.equals("principalInvestigator")) {
            this.principalInvestigator = this.castToReference(value);
        } else if (name.equals(SP_SITE)) {
            this.getSite().add(this.castToReference(value));
        } else if (name.equals("reasonStopped")) {
            this.reasonStopped = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("arm")) {
            this.getArm().add((ResearchStudyArmComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -989163880: {
                return this.addProtocol();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 97604824: {
                return this.addFocus();
            }
            case 951526432: {
                return this.addContact();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -814408215: {
                return this.addKeyword();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 116089604: {
                return this.addEnrollment();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1998892262: {
                return this.getSponsor();
            }
            case 1437117175: {
                return this.getPrincipalInvestigator();
            }
            case 3530567: {
                return this.addSite();
            }
            case 1181369065: {
                return this.getReasonStopped();
            }
            case 3387378: {
                return this.addNote();
            }
            case 96860: {
                return this.addArm();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -989163880: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 97604824: {
                return new String[]{"CodeableConcept"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -814408215: {
                return new String[]{"CodeableConcept"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 116089604: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1998892262: {
                return new String[]{"Reference"};
            }
            case 1437117175: {
                return new String[]{"Reference"};
            }
            case 3530567: {
                return new String[]{"Reference"};
            }
            case 1181369065: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 96860: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.title");
        }
        if (name.equals(SP_PROTOCOL)) {
            return this.addProtocol();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_FOCUS)) {
            return this.addFocus();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals(SP_KEYWORD)) {
            return this.addKeyword();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.description");
        }
        if (name.equals("enrollment")) {
            return this.addEnrollment();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_SPONSOR)) {
            this.sponsor = new Reference();
            return this.sponsor;
        }
        if (name.equals("principalInvestigator")) {
            this.principalInvestigator = new Reference();
            return this.principalInvestigator;
        }
        if (name.equals(SP_SITE)) {
            return this.addSite();
        }
        if (name.equals("reasonStopped")) {
            this.reasonStopped = new CodeableConcept();
            return this.reasonStopped;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("arm")) {
            return this.addArm();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchStudy";
    }

    @Override
    public ResearchStudy copy() {
        ResearchStudy dst = new ResearchStudy();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.protocol != null) {
            dst.protocol = new ArrayList<Reference>();
            for (Reference reference : this.protocol) {
                dst.protocol.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        Enumeration<ResearchStudyStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.focus != null) {
            dst.focus = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.focus) {
                dst.focus.add(codeableConcept.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.keyword != null) {
            dst.keyword = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.keyword) {
                dst.keyword.add(codeableConcept.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.enrollment != null) {
            dst.enrollment = new ArrayList<Reference>();
            for (Reference reference : this.enrollment) {
                dst.enrollment.add(reference.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.sponsor = this.sponsor == null ? null : this.sponsor.copy();
        Reference reference = dst.principalInvestigator = this.principalInvestigator == null ? null : this.principalInvestigator.copy();
        if (this.site != null) {
            dst.site = new ArrayList<Reference>();
            for (Reference reference2 : this.site) {
                dst.site.add(reference2.copy());
            }
        }
        CodeableConcept codeableConcept = dst.reasonStopped = this.reasonStopped == null ? null : this.reasonStopped.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.arm != null) {
            dst.arm = new ArrayList<ResearchStudyArmComponent>();
            for (ResearchStudyArmComponent researchStudyArmComponent : this.arm) {
                dst.arm.add(researchStudyArmComponent.copy());
            }
        }
        return dst;
    }

    protected ResearchStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareDeep(this.identifier, o.identifier, true) && ResearchStudy.compareDeep(this.title, o.title, true) && ResearchStudy.compareDeep(this.protocol, o.protocol, true) && ResearchStudy.compareDeep(this.partOf, o.partOf, true) && ResearchStudy.compareDeep(this.status, o.status, true) && ResearchStudy.compareDeep(this.category, o.category, true) && ResearchStudy.compareDeep(this.focus, o.focus, true) && ResearchStudy.compareDeep(this.contact, o.contact, true) && ResearchStudy.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ResearchStudy.compareDeep(this.keyword, o.keyword, true) && ResearchStudy.compareDeep(this.jurisdiction, o.jurisdiction, true) && ResearchStudy.compareDeep(this.description, o.description, true) && ResearchStudy.compareDeep(this.enrollment, o.enrollment, true) && ResearchStudy.compareDeep(this.period, o.period, true) && ResearchStudy.compareDeep(this.sponsor, o.sponsor, true) && ResearchStudy.compareDeep(this.principalInvestigator, o.principalInvestigator, true) && ResearchStudy.compareDeep(this.site, o.site, true) && ResearchStudy.compareDeep(this.reasonStopped, o.reasonStopped, true) && ResearchStudy.compareDeep(this.note, o.note, true) && ResearchStudy.compareDeep(this.arm, o.arm, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchStudy)) {
            return false;
        }
        ResearchStudy o = (ResearchStudy)other_;
        return ResearchStudy.compareValues(this.title, o.title, true) && ResearchStudy.compareValues(this.status, o.status, true) && ResearchStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.title, this.protocol, this.partOf, this.status, this.category, this.focus, this.contact, this.relatedArtifact, this.keyword, this.jurisdiction, this.description, this.enrollment, this.period, this.sponsor, this.principalInvestigator, this.site, this.reasonStopped, this.note, this.arm});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchStudy;
    }

    public static class ResearchStudyStatusEnumFactory
    implements EnumFactory<ResearchStudyStatus> {
        @Override
        public ResearchStudyStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ResearchStudyStatus.DRAFT;
            }
            if ("in-progress".equals(codeString)) {
                return ResearchStudyStatus.INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return ResearchStudyStatus.SUSPENDED;
            }
            if ("stopped".equals(codeString)) {
                return ResearchStudyStatus.STOPPED;
            }
            if ("completed".equals(codeString)) {
                return ResearchStudyStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ResearchStudyStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        public Enumeration<ResearchStudyStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResearchStudyStatus>(this);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.DRAFT);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.INPROGRESS);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.SUSPENDED);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.STOPPED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ResearchStudyStatus>(this, ResearchStudyStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ResearchStudyStatus code) {
            if (code == ResearchStudyStatus.NULL) {
                return null;
            }
            if (code == ResearchStudyStatus.DRAFT) {
                return "draft";
            }
            if (code == ResearchStudyStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == ResearchStudyStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ResearchStudyStatus.STOPPED) {
                return "stopped";
            }
            if (code == ResearchStudyStatus.COMPLETED) {
                return "completed";
            }
            if (code == ResearchStudyStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ResearchStudyStatus code) {
            return code.getSystem();
        }
    }

    public static enum ResearchStudyStatus {
        DRAFT,
        INPROGRESS,
        SUSPENDED,
        STOPPED,
        COMPLETED,
        ENTEREDINERROR,
        NULL;


        public static ResearchStudyStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/research-study-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The study is undergoing design but the process of selecting study subjects and capturing data has not yet begun.";
                }
                case INPROGRESS: {
                    return "The study is currently being executed";
                }
                case SUSPENDED: {
                    return "Execution of the study has been temporarily paused";
                }
                case STOPPED: {
                    return "The study was terminated prior to the final determination of results";
                }
                case COMPLETED: {
                    return "The information sought by the study has been gathered and compiled and no further work is being performed";
                }
                case ENTEREDINERROR: {
                    return "This study never actually existed.  The record is retained for tracking purposes in the event decisions may have been made based on this erroneous information.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case INPROGRESS: {
                    return "In-progress";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ResearchStudyArmComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for study arm", formalDefinition="Unique, human-readable label for this arm of the study.")
        protected StringType name;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Categorization of study arm", formalDefinition="Categorization of study arm, e.g. experimental, active comparator, placebo comparater.")
        protected CodeableConcept code;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short explanation of study path", formalDefinition="A succinct description of the path through the study that would be followed by a subject adhering to this arm.")
        protected StringType description;
        private static final long serialVersionUID = 1433183343L;

        public ResearchStudyArmComponent() {
        }

        public ResearchStudyArmComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ResearchStudyArmComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ResearchStudyArmComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ResearchStudyArmComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchStudyArmComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ResearchStudyArmComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ResearchStudyArmComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Unique, human-readable label for this arm of the study.", 0, 1, this.name));
            children.add(new Property("code", "CodeableConcept", "Categorization of study arm, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.code));
            children.add(new Property("description", "string", "A succinct description of the path through the study that would be followed by a subject adhering to this arm.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Unique, human-readable label for this arm of the study.", 0, 1, this.name);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Categorization of study arm, e.g. experimental, active comparator, placebo comparater.", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property("description", "string", "A succinct description of the path through the study that would be followed by a subject adhering to this arm.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.name");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchStudy.description");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchStudyArmComponent copy() {
            ResearchStudyArmComponent dst = new ResearchStudyArmComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyArmComponent)) {
                return false;
            }
            ResearchStudyArmComponent o = (ResearchStudyArmComponent)other_;
            return ResearchStudyArmComponent.compareDeep(this.name, o.name, true) && ResearchStudyArmComponent.compareDeep(this.code, o.code, true) && ResearchStudyArmComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchStudyArmComponent)) {
                return false;
            }
            ResearchStudyArmComponent o = (ResearchStudyArmComponent)other_;
            return ResearchStudyArmComponent.compareValues(this.name, o.name, true) && ResearchStudyArmComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.code, this.description});
        }

        @Override
        public String fhirType() {
            return "ResearchStudy.arm";
        }
    }
}

