/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CareTeamCategory;

public class CareTeamCategoryEnumFactory
implements EnumFactory<CareTeamCategory> {
    @Override
    public CareTeamCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("event".equals(codeString)) {
            return CareTeamCategory.EVENT;
        }
        if ("encounter".equals(codeString)) {
            return CareTeamCategory.ENCOUNTER;
        }
        if ("episode".equals(codeString)) {
            return CareTeamCategory.EPISODE;
        }
        if ("longitudinal".equals(codeString)) {
            return CareTeamCategory.LONGITUDINAL;
        }
        if ("condition".equals(codeString)) {
            return CareTeamCategory.CONDITION;
        }
        if ("clinical-research".equals(codeString)) {
            return CareTeamCategory.CLINICALRESEARCH;
        }
        throw new IllegalArgumentException("Unknown CareTeamCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(CareTeamCategory code) {
        if (code == CareTeamCategory.NULL) {
            return null;
        }
        if (code == CareTeamCategory.EVENT) {
            return "event";
        }
        if (code == CareTeamCategory.ENCOUNTER) {
            return "encounter";
        }
        if (code == CareTeamCategory.EPISODE) {
            return "episode";
        }
        if (code == CareTeamCategory.LONGITUDINAL) {
            return "longitudinal";
        }
        if (code == CareTeamCategory.CONDITION) {
            return "condition";
        }
        if (code == CareTeamCategory.CLINICALRESEARCH) {
            return "clinical-research";
        }
        return "?";
    }

    @Override
    public String toSystem(CareTeamCategory code) {
        return code.getSystem();
    }
}

