/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.CatalogEntryType;

public class CatalogEntryTypeEnumFactory
implements EnumFactory<CatalogEntryType> {
    @Override
    public CatalogEntryType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return CatalogEntryType.MEDICATION;
        }
        if ("device".equals(codeString)) {
            return CatalogEntryType.DEVICE;
        }
        throw new IllegalArgumentException("Unknown CatalogEntryType code '" + codeString + "'");
    }

    @Override
    public String toCode(CatalogEntryType code) {
        if (code == CatalogEntryType.NULL) {
            return null;
        }
        if (code == CatalogEntryType.MEDICATION) {
            return "medication";
        }
        if (code == CatalogEntryType.DEVICE) {
            return "device";
        }
        return "?";
    }

    @Override
    public String toSystem(CatalogEntryType code) {
        return code.getSystem();
    }
}

