/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.RepositoryType;

public class RepositoryTypeEnumFactory
implements EnumFactory<RepositoryType> {
    @Override
    public RepositoryType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("directlink".equals(codeString)) {
            return RepositoryType.DIRECTLINK;
        }
        if ("openapi".equals(codeString)) {
            return RepositoryType.OPENAPI;
        }
        if ("login".equals(codeString)) {
            return RepositoryType.LOGIN;
        }
        if ("oauth".equals(codeString)) {
            return RepositoryType.OAUTH;
        }
        if ("other".equals(codeString)) {
            return RepositoryType.OTHER;
        }
        throw new IllegalArgumentException("Unknown RepositoryType code '" + codeString + "'");
    }

    @Override
    public String toCode(RepositoryType code) {
        if (code == RepositoryType.NULL) {
            return null;
        }
        if (code == RepositoryType.DIRECTLINK) {
            return "directlink";
        }
        if (code == RepositoryType.OPENAPI) {
            return "openapi";
        }
        if (code == RepositoryType.LOGIN) {
            return "login";
        }
        if (code == RepositoryType.OAUTH) {
            return "oauth";
        }
        if (code == RepositoryType.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(RepositoryType code) {
        return code.getSystem();
    }
}

