/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.utils;

import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.utils.CodeSystemUtilities;
import org.hl7.fhir.dstu3.utils.ExtensionUtilities;
import org.hl7.fhir.utilities.Utilities;

public class ValueSetUtilities {
    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new UriType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return vs;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }

    public static boolean hasOID(ValueSet vs) {
        return ValueSetUtilities.getOID(vs) != null;
    }

    public static String getOID(ValueSet vs) {
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ValueSet vs, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }

    public static void markStatus(ValueSet vs, String wg, String status, String fmm) {
        String sfmm;
        String ss;
        if (wg != null && (!ExtensionUtilities.hasExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || Utilities.existsInList((String)ExtensionUtilities.readStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && !Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            ExtensionUtilities.setCodeExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", wg);
        }
        if (status != null && (Utilities.noString((String)(ss = ExtensionUtilities.readStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-ballot-status"))) || ValueSetUtilities.ssval(ss) < ValueSetUtilities.ssval(status))) {
            ExtensionUtilities.setStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-ballot-status", status);
        }
        if (fmm != null && (Utilities.noString((String)(sfmm = ExtensionUtilities.readStringExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))) || Integer.parseInt(sfmm) < Integer.parseInt(fmm))) {
            ExtensionUtilities.setIntegerExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
        }
        if (vs.hasUserData("cs")) {
            CodeSystemUtilities.markStatus((CodeSystem)vs.getUserData("cs"), wg, status, fmm);
        }
    }

    private static int ssval(String status) {
        if ("Draft".equals("status")) {
            return 1;
        }
        if ("Informative".equals("status")) {
            return 2;
        }
        if ("External".equals("status")) {
            return 3;
        }
        if ("Trial Use".equals("status")) {
            return 3;
        }
        if ("Normative".equals("status")) {
            return 4;
        }
        return -1;
    }
}

