/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3Hl7ITSVersionCode {
    XMLV1PR1,
    NULL;


    public static V3Hl7ITSVersionCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("XMLV1PR1".equals(codeString)) {
            return XMLV1PR1;
        }
        throw new FHIRException("Unknown V3Hl7ITSVersionCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case XMLV1PR1: {
                return "XMLV1PR1";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-hl7ITSVersionCode";
    }

    public String getDefinition() {
        switch (this) {
            case XMLV1PR1: {
                return "XML ITS version 1 pre-release 1.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case XMLV1PR1: {
                return "XMLV1PR1";
            }
        }
        return "?";
    }
}

