/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultValidationType {
    NOTHING,
    PRIMARY,
    MULTIPLE,
    NULL;


    public static VerificationresultValidationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("nothing".equals(codeString)) {
            return NOTHING;
        }
        if ("primary".equals(codeString)) {
            return PRIMARY;
        }
        if ("multiple".equals(codeString)) {
            return MULTIPLE;
        }
        throw new FHIRException("Unknown VerificationresultValidationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTHING: {
                return "nothing";
            }
            case PRIMARY: {
                return "primary";
            }
            case MULTIPLE: {
                return "multiple";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/validation-type";
    }

    public String getDefinition() {
        switch (this) {
            case NOTHING: {
                return "";
            }
            case PRIMARY: {
                return "";
            }
            case MULTIPLE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTHING: {
                return "Nothing";
            }
            case PRIMARY: {
                return "Primary Source";
            }
            case MULTIPLE: {
                return "Multiple Sources";
            }
        }
        return "?";
    }
}

