package org.hl7.fhir.r4.model;

/*-
 * #%L
 * org.hl7.fhir.r4
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseExtension extends Type implements IBaseExtension<Extension, Type>, IBaseHasExtensions {

	private static final long serialVersionUID = 1L;


	@Override
	public Extension setValue(IBaseDatatype theValue) {
		setValue((Type)theValue);
		return (Extension) this;
	}
	
	public abstract Extension setValue(Type theValue);
	
	
	/**
	 * Returns the value of this extension cast as a {@link IPrimitiveType}. This method is just a convenience method for easy chaining.
	 */
	public IPrimitiveType<?> getValueAsPrimitive() {
		return (IPrimitiveType<?>)getValue();
	}

	
}
