/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MedicinalProductIndication;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceSpecification;
import org.hl7.fhir.r4.model.Type;

@ResourceDef(name="MedicinalProductContraindication", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductContraindication")
public class MedicinalProductContraindication
extends DomainResource {
    @Child(name="subject", type={MedicinalProduct.class, Medication.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The medication for which this is an indication", formalDefinition="The medication for which this is an indication.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="disease", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The disease, symptom or procedure for the contraindication", formalDefinition="The disease, symptom or procedure for the contraindication.")
    protected CodeableConcept disease;
    @Child(name="diseaseStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status of the disease or symptom for the contraindication", formalDefinition="The status of the disease or symptom for the contraindication.")
    protected CodeableConcept diseaseStatus;
    @Child(name="comorbidity", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A comorbidity (concurrent condition) or coinfection", formalDefinition="A comorbidity (concurrent condition) or coinfection.")
    protected List<CodeableConcept> comorbidity;
    @Child(name="therapeuticIndication", type={MedicinalProductIndication.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication.")
    protected List<Reference> therapeuticIndication;
    protected List<MedicinalProductIndication> therapeuticIndicationTarget;
    @Child(name="otherTherapy", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication.")
    protected List<MedicinalProductContraindicationOtherTherapyComponent> otherTherapy;
    @Child(name="population", type={Population.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
    protected List<Population> population;
    private static final long serialVersionUID = -1746103034L;
    @SearchParamDefinition(name="subject", path="MedicinalProductContraindication.subject", description="The medication for which this is an contraindication", type="reference", target={Medication.class, MedicinalProduct.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductContraindication:subject").toLocked();

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public MedicinalProductContraindication setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public MedicinalProductContraindication addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public CodeableConcept getDisease() {
        if (this.disease == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductContraindication.disease");
            }
            if (Configuration.doAutoCreate()) {
                this.disease = new CodeableConcept();
            }
        }
        return this.disease;
    }

    public boolean hasDisease() {
        return this.disease != null && !this.disease.isEmpty();
    }

    public MedicinalProductContraindication setDisease(CodeableConcept value) {
        this.disease = value;
        return this;
    }

    public CodeableConcept getDiseaseStatus() {
        if (this.diseaseStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductContraindication.diseaseStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.diseaseStatus = new CodeableConcept();
            }
        }
        return this.diseaseStatus;
    }

    public boolean hasDiseaseStatus() {
        return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
    }

    public MedicinalProductContraindication setDiseaseStatus(CodeableConcept value) {
        this.diseaseStatus = value;
        return this;
    }

    public List<CodeableConcept> getComorbidity() {
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        return this.comorbidity;
    }

    public MedicinalProductContraindication setComorbidity(List<CodeableConcept> theComorbidity) {
        this.comorbidity = theComorbidity;
        return this;
    }

    public boolean hasComorbidity() {
        if (this.comorbidity == null) {
            return false;
        }
        for (CodeableConcept item : this.comorbidity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addComorbidity() {
        CodeableConcept t = new CodeableConcept();
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        this.comorbidity.add(t);
        return t;
    }

    public MedicinalProductContraindication addComorbidity(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        this.comorbidity.add(t);
        return this;
    }

    public CodeableConcept getComorbidityFirstRep() {
        if (this.getComorbidity().isEmpty()) {
            this.addComorbidity();
        }
        return this.getComorbidity().get(0);
    }

    public List<Reference> getTherapeuticIndication() {
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<Reference>();
        }
        return this.therapeuticIndication;
    }

    public MedicinalProductContraindication setTherapeuticIndication(List<Reference> theTherapeuticIndication) {
        this.therapeuticIndication = theTherapeuticIndication;
        return this;
    }

    public boolean hasTherapeuticIndication() {
        if (this.therapeuticIndication == null) {
            return false;
        }
        for (Reference item : this.therapeuticIndication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTherapeuticIndication() {
        Reference t = new Reference();
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<Reference>();
        }
        this.therapeuticIndication.add(t);
        return t;
    }

    public MedicinalProductContraindication addTherapeuticIndication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<Reference>();
        }
        this.therapeuticIndication.add(t);
        return this;
    }

    public Reference getTherapeuticIndicationFirstRep() {
        if (this.getTherapeuticIndication().isEmpty()) {
            this.addTherapeuticIndication();
        }
        return this.getTherapeuticIndication().get(0);
    }

    @Deprecated
    public List<MedicinalProductIndication> getTherapeuticIndicationTarget() {
        if (this.therapeuticIndicationTarget == null) {
            this.therapeuticIndicationTarget = new ArrayList<MedicinalProductIndication>();
        }
        return this.therapeuticIndicationTarget;
    }

    @Deprecated
    public MedicinalProductIndication addTherapeuticIndicationTarget() {
        MedicinalProductIndication r = new MedicinalProductIndication();
        if (this.therapeuticIndicationTarget == null) {
            this.therapeuticIndicationTarget = new ArrayList<MedicinalProductIndication>();
        }
        this.therapeuticIndicationTarget.add(r);
        return r;
    }

    public List<MedicinalProductContraindicationOtherTherapyComponent> getOtherTherapy() {
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductContraindicationOtherTherapyComponent>();
        }
        return this.otherTherapy;
    }

    public MedicinalProductContraindication setOtherTherapy(List<MedicinalProductContraindicationOtherTherapyComponent> theOtherTherapy) {
        this.otherTherapy = theOtherTherapy;
        return this;
    }

    public boolean hasOtherTherapy() {
        if (this.otherTherapy == null) {
            return false;
        }
        for (MedicinalProductContraindicationOtherTherapyComponent item : this.otherTherapy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductContraindicationOtherTherapyComponent addOtherTherapy() {
        MedicinalProductContraindicationOtherTherapyComponent t = new MedicinalProductContraindicationOtherTherapyComponent();
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductContraindicationOtherTherapyComponent>();
        }
        this.otherTherapy.add(t);
        return t;
    }

    public MedicinalProductContraindication addOtherTherapy(MedicinalProductContraindicationOtherTherapyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductContraindicationOtherTherapyComponent>();
        }
        this.otherTherapy.add(t);
        return this;
    }

    public MedicinalProductContraindicationOtherTherapyComponent getOtherTherapyFirstRep() {
        if (this.getOtherTherapy().isEmpty()) {
            this.addOtherTherapy();
        }
        return this.getOtherTherapy().get(0);
    }

    public List<Population> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        return this.population;
    }

    public MedicinalProductContraindication setPopulation(List<Population> thePopulation) {
        this.population = thePopulation;
        return this;
    }

    public boolean hasPopulation() {
        if (this.population == null) {
            return false;
        }
        for (Population item : this.population) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Population addPopulation() {
        Population t = new Population();
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        this.population.add(t);
        return t;
    }

    public MedicinalProductContraindication addPopulation(Population t) {
        if (t == null) {
            return this;
        }
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        this.population.add(t);
        return this;
    }

    public Population getPopulationFirstRep() {
        if (this.getPopulation().isEmpty()) {
            this.addPopulation();
        }
        return this.getPopulation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("disease", "CodeableConcept", "The disease, symptom or procedure for the contraindication.", 0, 1, this.disease));
        children.add(new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus));
        children.add(new Property("comorbidity", "CodeableConcept", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity));
        children.add(new Property("therapeuticIndication", "Reference(MedicinalProductIndication)", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.therapeuticIndication));
        children.add(new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy));
        children.add(new Property("population", "Population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject);
            }
            case 1671426428: {
                return new Property("disease", "CodeableConcept", "The disease, symptom or procedure for the contraindication.", 0, 1, this.disease);
            }
            case -505503602: {
                return new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus);
            }
            case -406395211: {
                return new Property("comorbidity", "CodeableConcept", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity);
            }
            case -1925150262: {
                return new Property("therapeuticIndication", "Reference(MedicinalProductIndication)", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.therapeuticIndication);
            }
            case -544509127: {
                return new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy);
            }
            case -2023558323: {
                return new Property("population", "Population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 1671426428: {
                Base[] baseArray;
                if (this.disease == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.disease;
                }
                return baseArray;
            }
            case -505503602: {
                Base[] baseArray;
                if (this.diseaseStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.diseaseStatus;
                }
                return baseArray;
            }
            case -406395211: {
                return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
            }
            case -1925150262: {
                return this.therapeuticIndication == null ? new Base[]{} : this.therapeuticIndication.toArray(new Base[this.therapeuticIndication.size()]);
            }
            case -544509127: {
                return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
            }
            case -2023558323: {
                return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case 1671426428: {
                this.disease = this.castToCodeableConcept(value);
                return value;
            }
            case -505503602: {
                this.diseaseStatus = this.castToCodeableConcept(value);
                return value;
            }
            case -406395211: {
                this.getComorbidity().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1925150262: {
                this.getTherapeuticIndication().add(this.castToReference(value));
                return value;
            }
            case -544509127: {
                this.getOtherTherapy().add((MedicinalProductContraindicationOtherTherapyComponent)value);
                return value;
            }
            case -2023558323: {
                this.getPopulation().add(this.castToPopulation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("disease")) {
            this.disease = this.castToCodeableConcept(value);
        } else if (name.equals("diseaseStatus")) {
            this.diseaseStatus = this.castToCodeableConcept(value);
        } else if (name.equals("comorbidity")) {
            this.getComorbidity().add(this.castToCodeableConcept(value));
        } else if (name.equals("therapeuticIndication")) {
            this.getTherapeuticIndication().add(this.castToReference(value));
        } else if (name.equals("otherTherapy")) {
            this.getOtherTherapy().add((MedicinalProductContraindicationOtherTherapyComponent)value);
        } else if (name.equals("population")) {
            this.getPopulation().add(this.castToPopulation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.addSubject();
            }
            case 1671426428: {
                return this.getDisease();
            }
            case -505503602: {
                return this.getDiseaseStatus();
            }
            case -406395211: {
                return this.addComorbidity();
            }
            case -1925150262: {
                return this.addTherapeuticIndication();
            }
            case -544509127: {
                return this.addOtherTherapy();
            }
            case -2023558323: {
                return this.addPopulation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1671426428: {
                return new String[]{"CodeableConcept"};
            }
            case -505503602: {
                return new String[]{"CodeableConcept"};
            }
            case -406395211: {
                return new String[]{"CodeableConcept"};
            }
            case -1925150262: {
                return new String[]{"Reference"};
            }
            case -544509127: {
                return new String[0];
            }
            case -2023558323: {
                return new String[]{"Population"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("disease")) {
            this.disease = new CodeableConcept();
            return this.disease;
        }
        if (name.equals("diseaseStatus")) {
            this.diseaseStatus = new CodeableConcept();
            return this.diseaseStatus;
        }
        if (name.equals("comorbidity")) {
            return this.addComorbidity();
        }
        if (name.equals("therapeuticIndication")) {
            return this.addTherapeuticIndication();
        }
        if (name.equals("otherTherapy")) {
            return this.addOtherTherapy();
        }
        if (name.equals("population")) {
            return this.addPopulation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductContraindication";
    }

    @Override
    public MedicinalProductContraindication copy() {
        MedicinalProductContraindication dst = new MedicinalProductContraindication();
        this.copyValues(dst);
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.disease = this.disease == null ? null : this.disease.copy();
        CodeableConcept codeableConcept = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
        if (this.comorbidity != null) {
            dst.comorbidity = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.comorbidity) {
                dst.comorbidity.add(codeableConcept2.copy());
            }
        }
        if (this.therapeuticIndication != null) {
            dst.therapeuticIndication = new ArrayList<Reference>();
            for (Reference reference : this.therapeuticIndication) {
                dst.therapeuticIndication.add(reference.copy());
            }
        }
        if (this.otherTherapy != null) {
            dst.otherTherapy = new ArrayList<MedicinalProductContraindicationOtherTherapyComponent>();
            for (MedicinalProductContraindicationOtherTherapyComponent medicinalProductContraindicationOtherTherapyComponent : this.otherTherapy) {
                dst.otherTherapy.add(medicinalProductContraindicationOtherTherapyComponent.copy());
            }
        }
        if (this.population != null) {
            dst.population = new ArrayList<Population>();
            for (Population population : this.population) {
                dst.population.add(population.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductContraindication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductContraindication)) {
            return false;
        }
        MedicinalProductContraindication o = (MedicinalProductContraindication)other_;
        return MedicinalProductContraindication.compareDeep(this.subject, o.subject, true) && MedicinalProductContraindication.compareDeep(this.disease, o.disease, true) && MedicinalProductContraindication.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && MedicinalProductContraindication.compareDeep(this.comorbidity, o.comorbidity, true) && MedicinalProductContraindication.compareDeep(this.therapeuticIndication, o.therapeuticIndication, true) && MedicinalProductContraindication.compareDeep(this.otherTherapy, o.otherTherapy, true) && MedicinalProductContraindication.compareDeep(this.population, o.population, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductContraindication)) {
            return false;
        }
        MedicinalProductContraindication o = (MedicinalProductContraindication)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subject, this.disease, this.diseaseStatus, this.comorbidity, this.therapeuticIndication, this.otherTherapy, this.population});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductContraindication;
    }

    @Block
    public static class MedicinalProductContraindicationOtherTherapyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="therapyRelationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy", formalDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy.")
        protected CodeableConcept therapyRelationshipType;
        @Child(name="medication", type={CodeableConcept.class, MedicinalProduct.class, Medication.class, Substance.class, SubstanceSpecification.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication", formalDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.")
        protected Type medication;
        private static final long serialVersionUID = 1438478115L;

        public MedicinalProductContraindicationOtherTherapyComponent() {
        }

        public MedicinalProductContraindicationOtherTherapyComponent(CodeableConcept therapyRelationshipType, Type medication) {
            this.therapyRelationshipType = therapyRelationshipType;
            this.medication = medication;
        }

        public CodeableConcept getTherapyRelationshipType() {
            if (this.therapyRelationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductContraindicationOtherTherapyComponent.therapyRelationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.therapyRelationshipType = new CodeableConcept();
                }
            }
            return this.therapyRelationshipType;
        }

        public boolean hasTherapyRelationshipType() {
            return this.therapyRelationshipType != null && !this.therapyRelationshipType.isEmpty();
        }

        public MedicinalProductContraindicationOtherTherapyComponent setTherapyRelationshipType(CodeableConcept value) {
            this.therapyRelationshipType = value;
            return this;
        }

        public Type getMedication() {
            return this.medication;
        }

        public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
            if (this.medication == null) {
                this.medication = new CodeableConcept();
            }
            if (!(this.medication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.medication;
        }

        public boolean hasMedicationCodeableConcept() {
            return this != null && this.medication instanceof CodeableConcept;
        }

        public Reference getMedicationReference() throws FHIRException {
            if (this.medication == null) {
                this.medication = new Reference();
            }
            if (!(this.medication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (Reference)this.medication;
        }

        public boolean hasMedicationReference() {
            return this != null && this.medication instanceof Reference;
        }

        public boolean hasMedication() {
            return this.medication != null && !this.medication.isEmpty();
        }

        public MedicinalProductContraindicationOtherTherapyComponent setMedication(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicinalProductContraindication.otherTherapy.medication[x]: " + value.fhirType());
            }
            this.medication = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType));
            children.add(new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -551658469: {
                    return new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType);
                }
                case 1458402129: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 1998965455: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case -209845038: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 2104315196: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    Base[] baseArray;
                    if (this.therapyRelationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.therapyRelationshipType;
                    }
                    return baseArray;
                }
                case 1998965455: {
                    Base[] baseArray;
                    if (this.medication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.medication;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    this.therapyRelationshipType = this.castToCodeableConcept(value);
                    return value;
                }
                case 1998965455: {
                    this.medication = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = this.castToCodeableConcept(value);
            } else if (name.equals("medication[x]")) {
                this.medication = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return this.getTherapyRelationshipType();
                }
                case 1458402129: {
                    return this.getMedication();
                }
                case 1998965455: {
                    return this.getMedication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return new String[]{"CodeableConcept"};
                }
                case 1998965455: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = new CodeableConcept();
                return this.therapyRelationshipType;
            }
            if (name.equals("medicationCodeableConcept")) {
                this.medication = new CodeableConcept();
                return this.medication;
            }
            if (name.equals("medicationReference")) {
                this.medication = new Reference();
                return this.medication;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductContraindicationOtherTherapyComponent copy() {
            MedicinalProductContraindicationOtherTherapyComponent dst = new MedicinalProductContraindicationOtherTherapyComponent();
            this.copyValues(dst);
            dst.therapyRelationshipType = this.therapyRelationshipType == null ? null : this.therapyRelationshipType.copy();
            dst.medication = this.medication == null ? null : this.medication.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductContraindicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductContraindicationOtherTherapyComponent o = (MedicinalProductContraindicationOtherTherapyComponent)other_;
            return MedicinalProductContraindicationOtherTherapyComponent.compareDeep(this.therapyRelationshipType, o.therapyRelationshipType, true) && MedicinalProductContraindicationOtherTherapyComponent.compareDeep(this.medication, o.medication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductContraindicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductContraindicationOtherTherapyComponent o = (MedicinalProductContraindicationOtherTherapyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.therapyRelationshipType, this.medication});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductContraindication.otherTherapy";
        }
    }
}

