/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractAssetsubtype {
    PARTICIPATION,
    NULL;


    public static ContractAssetsubtype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("participation".equals(codeString)) {
            return PARTICIPATION;
        }
        throw new FHIRException("Unknown ContractAssetsubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PARTICIPATION: {
                return "participation";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-asset-subtype";
    }

    public String getDefinition() {
        switch (this) {
            case PARTICIPATION: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PARTICIPATION: {
                return "Participation";
            }
        }
        return "?";
    }
}

