/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EntformulaAdditive {
    LIPID,
    PROTEIN,
    CARBOHYDRATE,
    FIBER,
    WATER,
    NULL;


    public static EntformulaAdditive fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lipid".equals(codeString)) {
            return LIPID;
        }
        if ("protein".equals(codeString)) {
            return PROTEIN;
        }
        if ("carbohydrate".equals(codeString)) {
            return CARBOHYDRATE;
        }
        if ("fiber".equals(codeString)) {
            return FIBER;
        }
        if ("water".equals(codeString)) {
            return WATER;
        }
        throw new FHIRException("Unknown EntformulaAdditive code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case LIPID: {
                return "lipid";
            }
            case PROTEIN: {
                return "protein";
            }
            case CARBOHYDRATE: {
                return "carbohydrate";
            }
            case FIBER: {
                return "fiber";
            }
            case WATER: {
                return "water";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/entformula-additive";
    }

    public String getDefinition() {
        switch (this) {
            case LIPID: {
                return "Modular lipid enteral formula component";
            }
            case PROTEIN: {
                return "Modular protein enteral formula component";
            }
            case CARBOHYDRATE: {
                return "Modular carbohydrate enteral formula component";
            }
            case FIBER: {
                return "Modular fiber enteral formula component";
            }
            case WATER: {
                return "Added water";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case LIPID: {
                return "Lipid";
            }
            case PROTEIN: {
                return "Protein";
            }
            case CARBOHYDRATE: {
                return "Carbohydrate";
            }
            case FIBER: {
                return "Fiber";
            }
            case WATER: {
                return "Water";
            }
        }
        return "?";
    }
}

