package org.hl7.fhir.r4.model.codesystems;




/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0


import org.hl7.fhir.exceptions.FHIRException;

public enum ExpansionParameterSource {

        /**
         * The parameter was supplied by the client in the $expand request.
         */
        INPUT, 
        /**
         * The parameter was added by the expansion engine on the server.
         */
        SERVER, 
        /**
         * The parameter was added from one the code systems used in the $expand operation.
         */
        CODESYSTEM, 
        /**
         * added to help the parsers
         */
        NULL;
        public static ExpansionParameterSource fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("input".equals(codeString))
          return INPUT;
        if ("server".equals(codeString))
          return SERVER;
        if ("codesystem".equals(codeString))
          return CODESYSTEM;
        throw new FHIRException("Unknown ExpansionParameterSource code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case INPUT: return "input";
            case SERVER: return "server";
            case CODESYSTEM: return "codesystem";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://terminology.hl7.org/CodeSystem/expansion-parameter-source";
        }
        public String getDefinition() {
          switch (this) {
            case INPUT: return "The parameter was supplied by the client in the $expand request.";
            case SERVER: return "The parameter was added by the expansion engine on the server.";
            case CODESYSTEM: return "The parameter was added from one the code systems used in the $expand operation.";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case INPUT: return "Client Input";
            case SERVER: return "Server Engine";
            case CODESYSTEM: return "Code System";
            case NULL: return null;
            default: return "?";
          }
    }


}