/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.conformance;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class XmlSchemaGenerator {
    private String folder;
    private IWorkerContext context;
    private boolean single;
    private String version;
    private String genDate;
    private String license;
    private boolean annotations;
    private Set<ElementDefinition> processed = new HashSet<ElementDefinition>();
    private Set<StructureDefinition> processedLibs = new HashSet<StructureDefinition>();
    private Set<String> typeNames = new HashSet<String>();
    private OutputStreamWriter writer;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Queue<ElementToGenerate> queue = new LinkedList<ElementToGenerate>();
    private Queue<StructureDefinition> queueLib = new LinkedList<StructureDefinition>();
    private Map<String, StructureDefinition> library;
    private boolean useNarrative;

    public XmlSchemaGenerator(String folder, IWorkerContext context) {
        this.folder = folder;
        this.context = context;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGenDate() {
        return this.genDate;
    }

    public void setGenDate(String genDate) {
        this.genDate = genDate;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(boolean annotations) {
        this.annotations = annotations;
    }

    private void w(String s) throws IOException {
        this.writer.write(s);
    }

    private void ln(String s) throws IOException {
        this.writer.write(s);
        this.writer.write("\r\n");
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.ln("</xs:schema>");
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    private String start(StructureDefinition sd, String ns) throws IOException, FHIRException {
        String lang = "en";
        if (sd.hasLanguage()) {
            lang = sd.getLanguage();
        }
        if (this.single && this.writer != null) {
            if (!ns.equals(this.getNs(sd))) {
                throw new FHIRException("namespace inconsistency: " + ns + " vs " + this.getNs(sd));
            }
            return lang;
        }
        this.close();
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.folder, this.tail(sd.getType() + ".xsd")})), "UTF-8");
        this.ln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.ln("<!-- ");
        this.ln(this.license);
        this.ln("");
        this.ln("  Generated on " + this.genDate + " for FHIR v" + this.version + " ");
        this.ln("");
        this.ln("  Note: this schema does not contain all the knowledge represented in the underlying content model");
        this.ln("");
        this.ln("-->");
        this.ln("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:fhir=\"http://hl7.org/fhir\" xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" xmlns:lm=\"" + ns + "\" targetNamespace=\"" + ns + "\" elementFormDefault=\"qualified\" version=\"1.0\">");
        this.ln("  <xs:import schemaLocation=\"fhir-common.xsd\" namespace=\"http://hl7.org/fhir\"/>");
        if (this.useNarrative) {
            if (ns.equals("urn:hl7-org:v3")) {
                this.ln("  <xs:include schemaLocation=\"cda-narrative.xsd\"/>");
            } else {
                this.ln("  <xs:import schemaLocation=\"cda-narrative.xsd\" namespace=\"urn:hl7-org:v3\"/>");
            }
        }
        this.namespaces.clear();
        this.namespaces.put(ns, "lm");
        this.namespaces.put("http://hl7.org/fhir", "fhir");
        this.typeNames.clear();
        return lang;
    }

    private String getNs(StructureDefinition sd) {
        String ns = "http://hl7.org/fhir";
        if (sd.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            ns = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        return ns;
    }

    public void generate(StructureDefinition entry, Map<String, StructureDefinition> library) throws Exception {
        this.processedLibs.clear();
        this.library = library;
        this.checkLib(entry);
        String ns = this.getNs(entry);
        String lang = this.start(entry, ns);
        this.w("  <xs:element name=\"" + this.tail(entry.getType()) + "\" type=\"lm:" + this.tail(entry.getType()) + "\"");
        if (this.annotations) {
            this.ln(">");
            this.ln("    <xs:annotation>");
            this.ln("      <xs:documentation xml:lang=\"" + lang + "\">" + Utilities.escapeXml((String)entry.getDescription()) + "</xs:documentation>");
            this.ln("    </xs:annotation>");
            this.ln("  </xs:element>");
        } else {
            this.ln("/>");
        }
        this.produceType(entry, entry.getSnapshot().getElement().get(0), this.tail(entry.getType()), this.getQN(entry, entry.getBaseDefinition()), lang);
        while (!this.queue.isEmpty()) {
            ElementToGenerate q = this.queue.poll();
            this.produceType(q.sd, q.ed, q.tname, this.getQN(q.sd, q.ed, "http://hl7.org/fhir/StructureDefinition/Element", false), lang);
        }
        while (!this.queueLib.isEmpty()) {
            this.generateInner(this.queueLib.poll());
        }
        this.close();
    }

    private void checkLib(StructureDefinition entry) {
        for (ElementDefinition ed : entry.getSnapshot().getElement()) {
            if (!ed.hasRepresentation(ElementDefinition.PropertyRepresentation.CDATEXT)) continue;
            this.useNarrative = true;
        }
        for (StructureDefinition sd : this.library.values()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!ed.hasRepresentation(ElementDefinition.PropertyRepresentation.CDATEXT)) continue;
                this.useNarrative = true;
            }
        }
    }

    private void generateInner(StructureDefinition sd) throws IOException, FHIRException {
        if (this.processedLibs.contains(sd)) {
            return;
        }
        this.processedLibs.add(sd);
        String ns = this.getNs(sd);
        String lang = this.start(sd, ns);
        if (sd.getSnapshot().getElement().isEmpty()) {
            throw new FHIRException("no snap shot on " + sd.getUrl());
        }
        this.produceType(sd, sd.getSnapshot().getElement().get(0), this.tail(sd.getType()), this.getQN(sd, sd.getBaseDefinition()), lang);
        while (!this.queue.isEmpty()) {
            ElementToGenerate q = this.queue.poll();
            this.produceType(q.sd, q.ed, q.tname, this.getQN(q.sd, q.ed, "http://hl7.org/fhir/StructureDefinition/Element", false), lang);
        }
    }

    private String tail(String url) {
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    private String root(String url) {
        return url.contains("/") ? url.substring(0, url.lastIndexOf("/")) : "";
    }

    private String tailDot(String url) {
        return url.contains(".") ? url.substring(url.lastIndexOf(".") + 1) : url;
    }

    private void produceType(StructureDefinition sd, ElementDefinition ed, String typeName, QName typeParent, String lang) throws IOException, FHIRException {
        if (this.processed.contains(ed)) {
            return;
        }
        this.processed.add(ed);
        this.ln("  <xs:complexType name=\"" + typeName + "\">");
        if (this.annotations) {
            this.ln("    <xs:annotation>");
            this.ln("      <xs:documentation xml:lang=\"" + lang + "\">" + Utilities.escapeXml((String)ed.getDefinition()) + "</xs:documentation>");
            this.ln("    </xs:annotation>");
        }
        this.ln("    <xs:complexContent>");
        this.ln("      <xs:extension base=\"" + typeParent.toString() + "\">");
        this.ln("        <xs:sequence>");
        for (ElementDefinition edc : ProfileUtilities.getChildList(sd, ed)) {
            if (edc.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || edc.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT) || this.inheritedElement(edc)) continue;
            this.produceElement(sd, ed, edc, lang);
        }
        this.ln("        </xs:sequence>");
        for (ElementDefinition edc : ProfileUtilities.getChildList(sd, ed)) {
            if (!edc.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) && !edc.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT) || this.inheritedElement(edc)) continue;
            this.produceAttribute(sd, ed, edc, lang);
        }
        this.ln("      </xs:extension>");
        this.ln("    </xs:complexContent>");
        this.ln("  </xs:complexType>");
    }

    private boolean inheritedElement(ElementDefinition edc) {
        return !edc.getPath().equals(edc.getBase().getPath());
    }

    private void produceElement(StructureDefinition sd, ElementDefinition ed, ElementDefinition edc, String lang) throws IOException, FHIRException {
        if (edc.getType().size() == 0) {
            throw new Error("No type at " + edc.getPath());
        }
        if (edc.getType().size() > 1 && edc.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
            StructureDefinition lib = this.getCommonAncestor(edc.getType());
            if (lib == null) {
                throw new Error("Common ancester not found at " + edc.getPath());
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent t : edc.getType()) {
                b.append(this.getQN(sd, edc, t.getWorkingCode(), true).toString());
            }
            String name = this.tailDot(edc.getPath());
            String min = String.valueOf(edc.getMin());
            String max = edc.getMax();
            if ("*".equals(max)) {
                max = "unbounded";
            }
            QName qn = this.getQN(sd, edc, lib.getUrl(), true);
            this.ln("        <xs:element name=\"" + name + "\" minOccurs=\"" + min + "\" maxOccurs=\"" + max + "\" type=\"" + qn.typeNs + ":" + qn.type + "\">");
            this.ln("          <xs:annotation>");
            this.ln("          <xs:appinfo xml:lang=\"en\">Possible types: " + b.toString() + "</xs:appinfo>");
            if (this.annotations && edc.hasDefinition()) {
                this.ln("            <xs:documentation xml:lang=\"" + lang + "\">" + Utilities.escapeXml((String)edc.getDefinition()) + "</xs:documentation>");
            }
            this.ln("          </xs:annotation>");
            this.ln("        </xs:element>");
        } else {
            for (ElementDefinition.TypeRefComponent t : edc.getType()) {
                Object name = this.tailDot(edc.getPath());
                if (edc.getType().size() > 1) {
                    name = (String)name + Utilities.capitalize((String)t.getWorkingCode());
                }
                QName qn = this.getQN(sd, edc, t.getWorkingCode(), true);
                String min = String.valueOf(edc.getMin());
                String max = edc.getMax();
                if ("*".equals(max)) {
                    max = "unbounded";
                }
                this.w("        <xs:element name=\"" + (String)name + "\" minOccurs=\"" + min + "\" maxOccurs=\"" + max + "\" type=\"" + qn.typeNs + ":" + qn.type + "\"");
                if (this.annotations && edc.hasDefinition()) {
                    this.ln(">");
                    this.ln("          <xs:annotation>");
                    this.ln("            <xs:documentation xml:lang=\"" + lang + "\">" + Utilities.escapeXml((String)edc.getDefinition()) + "</xs:documentation>");
                    this.ln("          </xs:annotation>");
                    this.ln("        </xs:element>");
                    continue;
                }
                this.ln("/>");
            }
        }
    }

    public QName getQN(StructureDefinition sd, String type) throws FHIRException {
        return this.getQN(sd, sd.getSnapshot().getElementFirstRep(), type, false);
    }

    public QName getQN(StructureDefinition sd, ElementDefinition edc, String t, boolean chase) throws FHIRException {
        QName qn = new QName();
        String string = qn.type = Utilities.isAbsoluteUrl((String)t) ? this.tail(t) : t;
        if (Utilities.isAbsoluteUrl((String)t)) {
            String ns = this.root(t);
            if (ns.equals(this.root(sd.getUrl()))) {
                ns = this.getNs(sd);
            }
            if (ns.equals("http://hl7.org/fhir/StructureDefinition")) {
                ns = "http://hl7.org/fhir";
            }
            if (!this.namespaces.containsKey(ns)) {
                throw new FHIRException("Unknown type namespace " + ns + " for " + edc.getPath());
            }
            qn.typeNs = this.namespaces.get(ns);
            StructureDefinition lib = this.library.get(t);
            if (lib == null && !Utilities.existsInList((String)t, (String[])new String[]{"http://hl7.org/fhir/cda/StructureDefinition/StrucDoc.Text", "http://hl7.org/fhir/StructureDefinition/Element"})) {
                throw new FHIRException("Unable to resolve " + t + " for " + edc.getPath());
            }
            if (lib != null) {
                this.queueLib.add(lib);
            }
        } else {
            qn.typeNs = this.namespaces.get("http://hl7.org/fhir");
        }
        if (chase && qn.type.equals("Element")) {
            Object tname = this.typeNameFromPath(edc);
            if (this.typeNames.contains(tname)) {
                int i = 1;
                while (this.typeNames.contains((String)tname + i)) {
                    ++i;
                }
                tname = (String)tname + i;
            }
            this.queue.add(new ElementToGenerate((String)tname, sd, edc));
            qn.typeNs = "lm";
            qn.type = tname;
        }
        return qn;
    }

    private StructureDefinition getCommonAncestor(List<ElementDefinition.TypeRefComponent> type) throws FHIRException {
        StructureDefinition sd = this.library.get(type.get(0).getWorkingCode());
        if (sd == null) {
            throw new FHIRException("Unable to find definition for " + type.get(0).getWorkingCode());
        }
        for (int i = 1; i < type.size(); ++i) {
            StructureDefinition t = this.library.get(type.get(i).getWorkingCode());
            if (t == null) {
                throw new FHIRException("Unable to find definition for " + type.get(i).getWorkingCode());
            }
            sd = this.getCommonAncestor(sd, t);
        }
        return sd;
    }

    private StructureDefinition getCommonAncestor(StructureDefinition sd1, StructureDefinition sd2) throws FHIRException {
        ArrayList<StructureDefinition> chain1 = new ArrayList<StructureDefinition>();
        ArrayList<StructureDefinition> chain2 = new ArrayList<StructureDefinition>();
        chain1.add(sd1);
        chain2.add(sd2);
        StructureDefinition root = this.library.get("Element");
        StructureDefinition common = this.findIntersection(chain1, chain2);
        boolean chain1Done = false;
        boolean chain2Done = false;
        while (common == null) {
            chain1Done = this.checkChain(chain1, root, chain1Done);
            chain2Done = this.checkChain(chain2, root, chain2Done);
            if (chain1Done && chain2Done) {
                return null;
            }
            common = this.findIntersection(chain1, chain2);
        }
        return common;
    }

    private StructureDefinition findIntersection(List<StructureDefinition> chain1, List<StructureDefinition> chain2) {
        for (StructureDefinition sd1 : chain1) {
            for (StructureDefinition sd2 : chain2) {
                if (sd1 != sd2) continue;
                return sd1;
            }
        }
        return null;
    }

    public boolean checkChain(List<StructureDefinition> chain1, StructureDefinition root, boolean chain1Done) throws FHIRException {
        if (!chain1Done) {
            StructureDefinition sd = chain1.get(chain1.size() - 1);
            String bu = sd.getBaseDefinition();
            if (bu == null) {
                throw new FHIRException("No base definition for " + sd.getUrl());
            }
            StructureDefinition t = this.library.get(bu);
            if (t == null) {
                chain1Done = true;
            } else {
                chain1.add(t);
            }
        }
        return chain1Done;
    }

    private StructureDefinition getBase(StructureDefinition structureDefinition) {
        return null;
    }

    private String typeNameFromPath(ElementDefinition edc) {
        StringBuilder b = new StringBuilder();
        boolean up = true;
        for (char ch : edc.getPath().toCharArray()) {
            if (ch == '.') {
                up = true;
                continue;
            }
            if (up) {
                b.append(Character.toUpperCase(ch));
                up = false;
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    private void produceAttribute(StructureDefinition sd, ElementDefinition ed, ElementDefinition edc, String lang) throws IOException, FHIRException {
        ElementDefinition.TypeRefComponent t = edc.getTypeFirstRep();
        String name = this.tailDot(edc.getPath());
        String min = String.valueOf(edc.getMin());
        String max = edc.getMax();
        String tc = t.getWorkingCode();
        if (Utilities.isAbsoluteUrl((String)tc)) {
            throw new FHIRException("Only FHIR primitive types are supported for attributes (" + tc + ")");
        }
        String typeNs = this.namespaces.get("http://hl7.org/fhir");
        String type = tc;
        this.w("        <xs:attribute name=\"" + name + "\" use=\"" + (min.equals("0") || edc.hasFixed() || edc.hasDefaultValue() ? "optional" : "required") + "\" type=\"" + typeNs + ":" + type + (typeNs.equals("fhir") ? "-primitive" : "") + "\"" + (String)(edc.hasFixed() ? " fixed=\"" + edc.getFixed().primitiveValue() + "\"" : "") + (String)(edc.hasDefaultValue() && !edc.hasFixed() ? " default=\"" + edc.getDefaultValue().primitiveValue() + "\"" : ""));
        if (this.annotations && edc.hasDefinition()) {
            this.ln(">");
            this.ln("          <xs:annotation>");
            this.ln("            <xs:documentation xml:lang=\"" + lang + "\">" + Utilities.escapeXml((String)edc.getDefinition()) + "</xs:documentation>");
            this.ln("          </xs:annotation>");
            this.ln("        </xs:attribute>");
        } else {
            this.ln("/>");
        }
    }

    public class ElementToGenerate {
        private String tname;
        private StructureDefinition sd;
        private ElementDefinition ed;

        public ElementToGenerate(String tname, StructureDefinition sd, ElementDefinition edc) {
            this.tname = tname;
            this.sd = sd;
            this.ed = edc;
        }
    }

    public class QName {
        public String type;
        public String typeNs;

        public String toString() {
            return this.typeNs + ":" + this.type;
        }
    }
}

