/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="CodeableConcept")
public class CodeableConcept
extends Type
implements ICompositeType {
    @Child(name="coding", type={Coding.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Code defined by a terminology system", formalDefinition="A reference to a code defined by a terminology system.")
    protected List<Coding> coding;
    @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Plain text representation of the concept", formalDefinition="A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user.")
    protected StringType text;
    private static final long serialVersionUID = 760353246L;

    public CodeableConcept() {
    }

    public List<Coding> getCoding() {
        if (this.coding == null) {
            this.coding = new ArrayList<Coding>();
        }
        return this.coding;
    }

    public CodeableConcept setCoding(List<Coding> theCoding) {
        this.coding = theCoding;
        return this;
    }

    public boolean hasCoding() {
        if (this.coding == null) {
            return false;
        }
        for (Coding item : this.coding) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCoding() {
        Coding t = new Coding();
        if (this.coding == null) {
            this.coding = new ArrayList<Coding>();
        }
        this.coding.add(t);
        return t;
    }

    public CodeableConcept addCoding(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.coding == null) {
            this.coding = new ArrayList<Coding>();
        }
        this.coding.add(t);
        return this;
    }

    public Coding getCodingFirstRep() {
        if (this.getCoding().isEmpty()) {
            this.addCoding();
        }
        return this.getCoding().get(0);
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeableConcept.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public CodeableConcept setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public CodeableConcept setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("coding", "Coding", "A reference to a code defined by a terminology system.", 0, Integer.MAX_VALUE, this.coding));
        children.add(new Property("text", "string", "A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user.", 0, 1, this.text));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1355086998: {
                return new Property("coding", "Coding", "A reference to a code defined by a terminology system.", 0, Integer.MAX_VALUE, this.coding);
            }
            case 3556653: {
                return new Property("text", "string", "A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user.", 0, 1, this.text);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1355086998: {
                return this.coding == null ? new Base[]{} : this.coding.toArray(new Base[this.coding.size()]);
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.text;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1355086998: {
                this.getCoding().add(this.castToCoding(value));
                return value;
            }
            case 3556653: {
                this.text = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("coding")) {
            this.getCoding().add(this.castToCoding(value));
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1355086998: {
                return this.addCoding();
            }
            case 3556653: {
                return this.getTextElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1355086998: {
                return new String[]{"Coding"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("coding")) {
            return this.addCoding();
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type CodeableConcept.text");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CodeableConcept";
    }

    @Override
    public CodeableConcept copy() {
        CodeableConcept dst = new CodeableConcept();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CodeableConcept dst) {
        super.copyValues(dst);
        if (this.coding != null) {
            dst.coding = new ArrayList<Coding>();
            for (Coding i : this.coding) {
                dst.coding.add(i.copy());
            }
        }
        dst.text = this.text == null ? null : this.text.copy();
    }

    @Override
    protected CodeableConcept typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeableConcept)) {
            return false;
        }
        CodeableConcept o = (CodeableConcept)other_;
        return CodeableConcept.compareDeep(this.coding, o.coding, true) && CodeableConcept.compareDeep(this.text, o.text, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeableConcept)) {
            return false;
        }
        CodeableConcept o = (CodeableConcept)other_;
        return CodeableConcept.compareValues(this.text, o.text, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.coding, this.text});
    }

    public boolean hasCoding(String system, String code) {
        for (Coding c : this.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept(Coding code) {
        this.addCoding(code);
    }
}

