/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Media", profile="http://hl7.org/fhir/StructureDefinition/Media")
public class Media
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) for the image", formalDefinition="Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ServiceRequest.class, CarePlan.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Procedure that caused this media to be created", formalDefinition="A procedure that is fulfilled in whole or in part by the creation of this media.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="partOf", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", formalDefinition="The current state of the {{title}}.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<MediaStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of media as image, video, or audio", formalDefinition="A code that classifies whether the media is an image, video or audio recording or some other media category.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/media-type")
    protected CodeableConcept type;
    @Child(name="modality", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of acquisition equipment/process", formalDefinition="Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/media-modality")
    protected CodeableConcept modality;
    @Child(name="view", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging view, e.g. Lateral or Antero-posterior", formalDefinition="The name of the imaging view e.g. Lateral or Antero-posterior (AP).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/media-view")
    protected CodeableConcept view;
    @Child(name="subject", type={Patient.class, Practitioner.class, PractitionerRole.class, Group.class, Device.class, Specimen.class, Location.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What this Media is a record of", formalDefinition="Who/What this Media is a record of.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter associated with media", formalDefinition="The encounter that establishes the context for this media.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="created", type={DateTimeType.class, Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When Media was collected", formalDefinition="The date and time(s) at which the media was collected.")
    protected Type created;
    @Child(name="issued", type={InstantType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time this version was made available", formalDefinition="The date and time this version of the media was made available to providers, typically after having been reviewed.")
    protected InstantType issued;
    @Child(name="operator", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who generated the image", formalDefinition="The person who administered the collection of the image.")
    protected Reference operator;
    protected Resource operatorTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was event performed?", formalDefinition="Describes why the event occurred in coded or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="bodySite", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Observed body part", formalDefinition="Indicates the site on the subject's body where the observation was made (i.e. the target site).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="deviceName", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the device/manufacturer", formalDefinition="The name of the device / manufacturer of the device  that was used to make the recording.")
    protected StringType deviceName;
    @Child(name="device", type={Device.class, DeviceMetric.class, Device.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Observing Device", formalDefinition="The device used to collect the media.")
    protected Reference device;
    protected Resource deviceTarget;
    @Child(name="height", type={PositiveIntType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Height of the image in pixels (photo/video)", formalDefinition="Height of the image in pixels (photo/video).")
    protected PositiveIntType height;
    @Child(name="width", type={PositiveIntType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video).")
    protected PositiveIntType width;
    @Child(name="frames", type={PositiveIntType.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.")
    protected PositiveIntType frames;
    @Child(name="duration", type={DecimalType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The duration of the recording in seconds - for audio and video.")
    protected DecimalType duration;
    @Child(name="content", type={Attachment.class}, order=20, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Actual Media - reference or data", formalDefinition="The actual content of the media - inline or by direct reference to the media source file.")
    protected Attachment content;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the media", formalDefinition="Comments made about the media by the performer, subject or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 2069980126L;
    @SearchParamDefinition(name="identifier", path="Media.identifier", description="Identifier(s) for the image", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="modality", path="Media.modality", description="The type of acquisition equipment/process", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="subject", path="Media.subject", description="Who/What this Media is a record of", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Device.class, Group.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, Specimen.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Media:subject").toLocked();
    @SearchParamDefinition(name="created", path="Media.created", description="When Media was collected", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="encounter", path="Media.encounter", description="Encounter associated with media", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Media:encounter").toLocked();
    @SearchParamDefinition(name="type", path="Media.type", description="Classification of media as image, video, or audio", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="operator", path="Media.operator", description="The person who generated the image", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    public static final Include INCLUDE_OPERATOR = new Include("Media:operator").toLocked();
    @SearchParamDefinition(name="view", path="Media.view", description="Imaging view, e.g. Lateral or Antero-posterior", type="token")
    public static final String SP_VIEW = "view";
    public static final TokenClientParam VIEW = new TokenClientParam("view");
    @SearchParamDefinition(name="site", path="Media.bodySite", description="Observed body part", type="token")
    public static final String SP_SITE = "site";
    public static final TokenClientParam SITE = new TokenClientParam("site");
    @SearchParamDefinition(name="based-on", path="Media.basedOn", description="Procedure that caused this media to be created", type="reference", target={CarePlan.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Media:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="Media.subject.where(resolve() is Patient)", description="Who/What this Media is a record of", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Media:patient").toLocked();
    @SearchParamDefinition(name="device", path="Media.device", description="Observing Device", type="reference", target={Device.class, DeviceMetric.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("Media:device").toLocked();
    @SearchParamDefinition(name="status", path="Media.status", description="preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Media() {
    }

    public Media(Enumeration<MediaStatus> status, Attachment content) {
        this.status = status;
        this.content = content;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Media setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Media addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Media setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Media addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Media setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Media addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Enumeration<MediaStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MediaStatus>(new MediaStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Media setStatusElement(Enumeration<MediaStatus> value) {
        this.status = value;
        return this;
    }

    public MediaStatus getStatus() {
        return this.status == null ? null : (MediaStatus)((Object)this.status.getValue());
    }

    public Media setStatus(MediaStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MediaStatus>(new MediaStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Media setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getModality() {
        if (this.modality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.modality");
            }
            if (Configuration.doAutoCreate()) {
                this.modality = new CodeableConcept();
            }
        }
        return this.modality;
    }

    public boolean hasModality() {
        return this.modality != null && !this.modality.isEmpty();
    }

    public Media setModality(CodeableConcept value) {
        this.modality = value;
        return this;
    }

    public CodeableConcept getView() {
        if (this.view == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.view");
            }
            if (Configuration.doAutoCreate()) {
                this.view = new CodeableConcept();
            }
        }
        return this.view;
    }

    public boolean hasView() {
        return this.view != null && !this.view.isEmpty();
    }

    public Media setView(CodeableConcept value) {
        this.view = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Media setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Media setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Media setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public Media setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getCreated() {
        return this.created;
    }

    public DateTimeType getCreatedDateTimeType() throws FHIRException {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        if (!(this.created instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.created.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.created;
    }

    public boolean hasCreatedDateTimeType() {
        return this != null && this.created instanceof DateTimeType;
    }

    public Period getCreatedPeriod() throws FHIRException {
        if (this.created == null) {
            this.created = new Period();
        }
        if (!(this.created instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.created.getClass().getName() + " was encountered");
        }
        return (Period)this.created;
    }

    public boolean hasCreatedPeriod() {
        return this != null && this.created instanceof Period;
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Media setCreated(Type value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new Error("Not the right type for Media.created[x]: " + value.fhirType());
        }
        this.created = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Media setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Media setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public Reference getOperator() {
        if (this.operator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.operator");
            }
            if (Configuration.doAutoCreate()) {
                this.operator = new Reference();
            }
        }
        return this.operator;
    }

    public boolean hasOperator() {
        return this.operator != null && !this.operator.isEmpty();
    }

    public Media setOperator(Reference value) {
        this.operator = value;
        return this;
    }

    public Resource getOperatorTarget() {
        return this.operatorTarget;
    }

    public Media setOperatorTarget(Resource value) {
        this.operatorTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public Media setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public Media addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public Media setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public StringType getDeviceNameElement() {
        if (this.deviceName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.deviceName");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceName = new StringType();
            }
        }
        return this.deviceName;
    }

    public boolean hasDeviceNameElement() {
        return this.deviceName != null && !this.deviceName.isEmpty();
    }

    public boolean hasDeviceName() {
        return this.deviceName != null && !this.deviceName.isEmpty();
    }

    public Media setDeviceNameElement(StringType value) {
        this.deviceName = value;
        return this;
    }

    public String getDeviceName() {
        return this.deviceName == null ? null : (String)this.deviceName.getValue();
    }

    public Media setDeviceName(String value) {
        if (Utilities.noString((String)value)) {
            this.deviceName = null;
        } else {
            if (this.deviceName == null) {
                this.deviceName = new StringType();
            }
            this.deviceName.setValue(value);
        }
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Media setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Resource getDeviceTarget() {
        return this.deviceTarget;
    }

    public Media setDeviceTarget(Resource value) {
        this.deviceTarget = value;
        return this;
    }

    public PositiveIntType getHeightElement() {
        if (this.height == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.height");
            }
            if (Configuration.doAutoCreate()) {
                this.height = new PositiveIntType();
            }
        }
        return this.height;
    }

    public boolean hasHeightElement() {
        return this.height != null && !this.height.isEmpty();
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public Media setHeightElement(PositiveIntType value) {
        this.height = value;
        return this;
    }

    public int getHeight() {
        return this.height == null || this.height.isEmpty() ? 0 : (Integer)this.height.getValue();
    }

    public Media setHeight(int value) {
        if (this.height == null) {
            this.height = new PositiveIntType();
        }
        this.height.setValue((Object)value);
        return this;
    }

    public PositiveIntType getWidthElement() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new PositiveIntType();
            }
        }
        return this.width;
    }

    public boolean hasWidthElement() {
        return this.width != null && !this.width.isEmpty();
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public Media setWidthElement(PositiveIntType value) {
        this.width = value;
        return this;
    }

    public int getWidth() {
        return this.width == null || this.width.isEmpty() ? 0 : (Integer)this.width.getValue();
    }

    public Media setWidth(int value) {
        if (this.width == null) {
            this.width = new PositiveIntType();
        }
        this.width.setValue((Object)value);
        return this;
    }

    public PositiveIntType getFramesElement() {
        if (this.frames == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.frames");
            }
            if (Configuration.doAutoCreate()) {
                this.frames = new PositiveIntType();
            }
        }
        return this.frames;
    }

    public boolean hasFramesElement() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public boolean hasFrames() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public Media setFramesElement(PositiveIntType value) {
        this.frames = value;
        return this;
    }

    public int getFrames() {
        return this.frames == null || this.frames.isEmpty() ? 0 : (Integer)this.frames.getValue();
    }

    public Media setFrames(int value) {
        if (this.frames == null) {
            this.frames = new PositiveIntType();
        }
        this.frames.setValue((Object)value);
        return this;
    }

    public DecimalType getDurationElement() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new DecimalType();
            }
        }
        return this.duration;
    }

    public boolean hasDurationElement() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public Media setDurationElement(DecimalType value) {
        this.duration = value;
        return this;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? null : (BigDecimal)this.duration.getValue();
    }

    public Media setDuration(BigDecimal value) {
        if (value == null) {
            this.duration = null;
        } else {
            if (this.duration == null) {
                this.duration = new DecimalType();
            }
            this.duration.setValue(value);
        }
        return this;
    }

    public Media setDuration(long value) {
        this.duration = new DecimalType();
        this.duration.setValue(value);
        return this;
    }

    public Media setDuration(double value) {
        this.duration = new DecimalType();
        this.duration.setValue(value);
        return this;
    }

    public Attachment getContent() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Attachment();
            }
        }
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Media setContent(Attachment value) {
        this.content = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Media setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Media addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ServiceRequest|CarePlan)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Any)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "The current state of the {{title}}.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "A code that classifies whether the media is an image, video or audio recording or some other media category.", 0, 1, this.type));
        children.add(new Property(SP_MODALITY, "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, 1, this.modality));
        children.add(new Property(SP_VIEW, "CodeableConcept", "The name of the imaging view e.g. Lateral or Antero-posterior (AP).", 0, 1, this.view));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|PractitionerRole|Group|Device|Specimen|Location)", "Who/What this Media is a record of.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this media.", 0, 1, this.encounter));
        children.add(new Property("created[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.created));
        children.add(new Property("issued", "instant", "The date and time this version of the media was made available to providers, typically after having been reviewed.", 0, 1, this.issued));
        children.add(new Property(SP_OPERATOR, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "The person who administered the collection of the image.", 0, 1, this.operator));
        children.add(new Property("reasonCode", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, 1, this.bodySite));
        children.add(new Property("deviceName", "string", "The name of the device / manufacturer of the device  that was used to make the recording.", 0, 1, this.deviceName));
        children.add(new Property(SP_DEVICE, "Reference(Device|DeviceMetric|Device)", "The device used to collect the media.", 0, 1, this.device));
        children.add(new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height));
        children.add(new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width));
        children.add(new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames));
        children.add(new Property("duration", "decimal", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration));
        children.add(new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, 1, this.content));
        children.add(new Property("note", "Annotation", "Comments made about the media by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest|CarePlan)", "A procedure that is fulfilled in whole or in part by the creation of this media.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Any)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the {{title}}.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "A code that classifies whether the media is an image, video or audio recording or some other media category.", 0, 1, this.type);
            }
            case -622722335: {
                return new Property(SP_MODALITY, "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, 1, this.modality);
            }
            case 3619493: {
                return new Property(SP_VIEW, "CodeableConcept", "The name of the imaging view e.g. Lateral or Antero-posterior (AP).", 0, 1, this.view);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|PractitionerRole|Group|Device|Specimen|Location)", "Who/What this Media is a record of.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter that establishes the context for this media.", 0, 1, this.encounter);
            }
            case 1369676952: {
                return new Property("created[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.created);
            }
            case 1028554472: {
                return new Property("created[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.created);
            }
            case -1968526685: {
                return new Property("created[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.created);
            }
            case 1525027529: {
                return new Property("created[x]", "dateTime|Period", "The date and time(s) at which the media was collected.", 0, 1, this.created);
            }
            case -1179159893: {
                return new Property("issued", "instant", "The date and time this version of the media was made available to providers, typically after having been reviewed.", 0, 1, this.issued);
            }
            case -500553564: {
                return new Property(SP_OPERATOR, "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "The person who administered the collection of the image.", 0, 1, this.operator);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "Describes why the event occurred in coded or textual form.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the observation was made (i.e. the target site).", 0, 1, this.bodySite);
            }
            case 780988929: {
                return new Property("deviceName", "string", "The name of the device / manufacturer of the device  that was used to make the recording.", 0, 1, this.deviceName);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device|DeviceMetric|Device)", "The device used to collect the media.", 0, 1, this.device);
            }
            case -1221029593: {
                return new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height);
            }
            case 113126854: {
                return new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width);
            }
            case -1266514778: {
                return new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames);
            }
            case -1992012396: {
                return new Property("duration", "decimal", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration);
            }
            case 951530617: {
                return new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, 1, this.content);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the media by the performer, subject or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -622722335: {
                Base[] baseArray;
                if (this.modality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.modality;
                }
                return baseArray;
            }
            case 3619493: {
                Base[] baseArray;
                if (this.view == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.view;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.created;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.issued;
                }
                return baseArray;
            }
            case -500553564: {
                Base[] baseArray;
                if (this.operator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.operator;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.bodySite;
                }
                return baseArray;
            }
            case 780988929: {
                Base[] baseArray;
                if (this.deviceName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.deviceName;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.device;
                }
                return baseArray;
            }
            case -1221029593: {
                Base[] baseArray;
                if (this.height == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.height;
                }
                return baseArray;
            }
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.width;
                }
                return baseArray;
            }
            case -1266514778: {
                Base[] baseArray;
                if (this.frames == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.frames;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.duration;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.content;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new MediaStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -622722335: {
                this.modality = this.castToCodeableConcept(value);
                return value;
            }
            case 3619493: {
                this.view = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = this.castToInstant(value);
                return value;
            }
            case -500553564: {
                this.operator = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = this.castToCodeableConcept(value);
                return value;
            }
            case 780988929: {
                this.deviceName = this.castToString(value);
                return value;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                return value;
            }
            case -1221029593: {
                this.height = this.castToPositiveInt(value);
                return value;
            }
            case 113126854: {
                this.width = this.castToPositiveInt(value);
                return value;
            }
            case -1266514778: {
                this.frames = this.castToPositiveInt(value);
                return value;
            }
            case -1992012396: {
                this.duration = this.castToDecimal(value);
                return value;
            }
            case 951530617: {
                this.content = this.castToAttachment(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new MediaStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_MODALITY)) {
            this.modality = this.castToCodeableConcept(value);
        } else if (name.equals(SP_VIEW)) {
            this.view = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("created[x]")) {
            this.created = this.castToType(value);
        } else if (name.equals("issued")) {
            this.issued = this.castToInstant(value);
        } else if (name.equals(SP_OPERATOR)) {
            this.operator = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = this.castToCodeableConcept(value);
        } else if (name.equals("deviceName")) {
            this.deviceName = this.castToString(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("height")) {
            this.height = this.castToPositiveInt(value);
        } else if (name.equals("width")) {
            this.width = this.castToPositiveInt(value);
        } else if (name.equals("frames")) {
            this.frames = this.castToPositiveInt(value);
        } else if (name.equals("duration")) {
            this.duration = this.castToDecimal(value);
        } else if (name.equals("content")) {
            this.content = this.castToAttachment(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -622722335: {
                return this.getModality();
            }
            case 3619493: {
                return this.getView();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1369676952: {
                return this.getCreated();
            }
            case 1028554472: {
                return this.getCreated();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case -500553564: {
                return this.getOperator();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 780988929: {
                return this.getDeviceNameElement();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1221029593: {
                return this.getHeightElement();
            }
            case 113126854: {
                return this.getWidthElement();
            }
            case -1266514778: {
                return this.getFramesElement();
            }
            case -1992012396: {
                return this.getDurationElement();
            }
            case 951530617: {
                return this.getContent();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -622722335: {
                return new String[]{"CodeableConcept"};
            }
            case 3619493: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime", "Period"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case -500553564: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 780988929: {
                return new String[]{"string"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -1221029593: {
                return new String[]{"positiveInt"};
            }
            case 113126854: {
                return new String[]{"positiveInt"};
            }
            case -1266514778: {
                return new String[]{"positiveInt"};
            }
            case -1992012396: {
                return new String[]{"decimal"};
            }
            case 951530617: {
                return new String[]{"Attachment"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_MODALITY)) {
            this.modality = new CodeableConcept();
            return this.modality;
        }
        if (name.equals(SP_VIEW)) {
            this.view = new CodeableConcept();
            return this.view;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("createdDateTime")) {
            this.created = new DateTimeType();
            return this.created;
        }
        if (name.equals("createdPeriod")) {
            this.created = new Period();
            return this.created;
        }
        if (name.equals("issued")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.issued");
        }
        if (name.equals(SP_OPERATOR)) {
            this.operator = new Reference();
            return this.operator;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("deviceName")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.deviceName");
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("height")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.height");
        }
        if (name.equals("width")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.width");
        }
        if (name.equals("frames")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.frames");
        }
        if (name.equals("duration")) {
            throw new FHIRException("Cannot call addChild on a primitive type Media.duration");
        }
        if (name.equals("content")) {
            this.content = new Attachment();
            return this.content;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Media";
    }

    @Override
    public Media copy() {
        Media dst = new Media();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Media dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.modality = this.modality == null ? null : this.modality.copy();
        dst.view = this.view == null ? null : this.view.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.issued = this.issued == null ? null : this.issued.copy();
        Reference reference = dst.operator = this.operator == null ? null : this.operator.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.deviceName = this.deviceName == null ? null : this.deviceName.copy();
        dst.device = this.device == null ? null : this.device.copy();
        dst.height = this.height == null ? null : this.height.copy();
        dst.width = this.width == null ? null : this.width.copy();
        dst.frames = this.frames == null ? null : this.frames.copy();
        dst.duration = this.duration == null ? null : this.duration.copy();
        Attachment attachment = dst.content = this.content == null ? null : this.content.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected Media typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Media)) {
            return false;
        }
        Media o = (Media)other_;
        return Media.compareDeep(this.identifier, o.identifier, true) && Media.compareDeep(this.basedOn, o.basedOn, true) && Media.compareDeep(this.partOf, o.partOf, true) && Media.compareDeep(this.status, o.status, true) && Media.compareDeep(this.type, o.type, true) && Media.compareDeep(this.modality, o.modality, true) && Media.compareDeep(this.view, o.view, true) && Media.compareDeep(this.subject, o.subject, true) && Media.compareDeep(this.encounter, o.encounter, true) && Media.compareDeep(this.created, o.created, true) && Media.compareDeep(this.issued, o.issued, true) && Media.compareDeep(this.operator, o.operator, true) && Media.compareDeep(this.reasonCode, o.reasonCode, true) && Media.compareDeep(this.bodySite, o.bodySite, true) && Media.compareDeep(this.deviceName, o.deviceName, true) && Media.compareDeep(this.device, o.device, true) && Media.compareDeep(this.height, o.height, true) && Media.compareDeep(this.width, o.width, true) && Media.compareDeep(this.frames, o.frames, true) && Media.compareDeep(this.duration, o.duration, true) && Media.compareDeep(this.content, o.content, true) && Media.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Media)) {
            return false;
        }
        Media o = (Media)other_;
        return Media.compareValues(this.status, o.status, true) && Media.compareValues(this.issued, o.issued, true) && Media.compareValues(this.deviceName, o.deviceName, true) && Media.compareValues(this.height, o.height, true) && Media.compareValues(this.width, o.width, true) && Media.compareValues(this.frames, o.frames, true) && Media.compareValues(this.duration, o.duration, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.type, this.modality, this.view, this.subject, this.encounter, this.created, this.issued, this.operator, this.reasonCode, this.bodySite, this.deviceName, this.device, this.height, this.width, this.frames, this.duration, this.content, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Media;
    }

    public static class MediaStatusEnumFactory
    implements EnumFactory<MediaStatus> {
        @Override
        public MediaStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return MediaStatus.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return MediaStatus.INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return MediaStatus.NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return MediaStatus.ONHOLD;
            }
            if ("stopped".equals(codeString)) {
                return MediaStatus.STOPPED;
            }
            if ("completed".equals(codeString)) {
                return MediaStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MediaStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return MediaStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown MediaStatus code '" + codeString + "'");
        }

        public Enumeration<MediaStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MediaStatus>(this, MediaStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.NULL, code);
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.PREPARATION, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.INPROGRESS, code);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.NOTDONE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.ONHOLD, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.STOPPED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<MediaStatus>(this, MediaStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown MediaStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MediaStatus code) {
            if (code == MediaStatus.PREPARATION) {
                return "preparation";
            }
            if (code == MediaStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == MediaStatus.NOTDONE) {
                return "not-done";
            }
            if (code == MediaStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MediaStatus.STOPPED) {
                return "stopped";
            }
            if (code == MediaStatus.COMPLETED) {
                return "completed";
            }
            if (code == MediaStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MediaStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(MediaStatus code) {
            return code.getSystem();
        }
    }

    public static enum MediaStatus {
        PREPARATION,
        INPROGRESS,
        NOTDONE,
        ONHOLD,
        STOPPED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static MediaStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MediaStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case STOPPED: {
                    return "stopped";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/event-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/event-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The event is currently occurring.";
                }
                case NOTDONE: {
                    return "The event was terminated prior to any activity beyond preparation.  I.e. The 'main' activity has not yet begun.  The boundary between preparatory and the 'main' activity is context-specific.";
                }
                case ONHOLD: {
                    return "The event has been temporarily stopped but is expected to resume in the future.";
                }
                case STOPPED: {
                    return "The event was terminated prior to the full completion of the intended activity but after at least some of the 'main' activity (beyond preparation) has occurred.";
                }
                case COMPLETED: {
                    return "The event has now concluded.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"stopped\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this event.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case NOTDONE: {
                    return "Not Done";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

