/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubstanceStatus {
    ACTIVE,
    INACTIVE,
    ENTEREDINERROR,
    NULL;


    public static SubstanceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown SubstanceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case INACTIVE: {
                return "inactive";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/substance-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The substance is considered for use or reference.";
            }
            case INACTIVE: {
                return "The substance is considered for reference, but not for use.";
            }
            case ENTEREDINERROR: {
                return "The substance was entered in error.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

