/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductInteraction", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductInteraction")
public class MedicinalProductInteraction
extends DomainResource {
    @Child(name="subject", type={MedicinalProduct.class, Medication.class, Substance.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The medication for which this is a described interaction", formalDefinition="The medication for which this is a described interaction.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The interaction described", formalDefinition="The interaction described.")
    protected StringType description;
    @Child(name="interactant", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specific medication, food or laboratory test that interacts", formalDefinition="The specific medication, food or laboratory test that interacts.")
    protected List<MedicinalProductInteractionInteractantComponent> interactant;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction", formalDefinition="The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.")
    protected CodeableConcept type;
    @Child(name="effect", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effect of the interaction, for example \"reduced gastric absorption of primary medication\"", formalDefinition="The effect of the interaction, for example \"reduced gastric absorption of primary medication\".")
    protected CodeableConcept effect;
    @Child(name="incidence", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The incidence of the interaction, e.g. theoretical, observed", formalDefinition="The incidence of the interaction, e.g. theoretical, observed.")
    protected CodeableConcept incidence;
    @Child(name="management", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Actions for managing the interaction", formalDefinition="Actions for managing the interaction.")
    protected CodeableConcept management;
    private static final long serialVersionUID = -1872687169L;
    @SearchParamDefinition(name="subject", path="MedicinalProductInteraction.subject", description="The medication for which this is an interaction", type="reference", target={Medication.class, MedicinalProduct.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductInteraction:subject").toLocked();

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public MedicinalProductInteraction setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public MedicinalProductInteraction addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductInteraction.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public MedicinalProductInteraction setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public MedicinalProductInteraction setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<MedicinalProductInteractionInteractantComponent> getInteractant() {
        if (this.interactant == null) {
            this.interactant = new ArrayList<MedicinalProductInteractionInteractantComponent>();
        }
        return this.interactant;
    }

    public MedicinalProductInteraction setInteractant(List<MedicinalProductInteractionInteractantComponent> theInteractant) {
        this.interactant = theInteractant;
        return this;
    }

    public boolean hasInteractant() {
        if (this.interactant == null) {
            return false;
        }
        for (MedicinalProductInteractionInteractantComponent item : this.interactant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductInteractionInteractantComponent addInteractant() {
        MedicinalProductInteractionInteractantComponent t = new MedicinalProductInteractionInteractantComponent();
        if (this.interactant == null) {
            this.interactant = new ArrayList<MedicinalProductInteractionInteractantComponent>();
        }
        this.interactant.add(t);
        return t;
    }

    public MedicinalProductInteraction addInteractant(MedicinalProductInteractionInteractantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.interactant == null) {
            this.interactant = new ArrayList<MedicinalProductInteractionInteractantComponent>();
        }
        this.interactant.add(t);
        return this;
    }

    public MedicinalProductInteractionInteractantComponent getInteractantFirstRep() {
        if (this.getInteractant().isEmpty()) {
            this.addInteractant();
        }
        return this.getInteractant().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductInteraction.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicinalProductInteraction setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getEffect() {
        if (this.effect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductInteraction.effect");
            }
            if (Configuration.doAutoCreate()) {
                this.effect = new CodeableConcept();
            }
        }
        return this.effect;
    }

    public boolean hasEffect() {
        return this.effect != null && !this.effect.isEmpty();
    }

    public MedicinalProductInteraction setEffect(CodeableConcept value) {
        this.effect = value;
        return this;
    }

    public CodeableConcept getIncidence() {
        if (this.incidence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductInteraction.incidence");
            }
            if (Configuration.doAutoCreate()) {
                this.incidence = new CodeableConcept();
            }
        }
        return this.incidence;
    }

    public boolean hasIncidence() {
        return this.incidence != null && !this.incidence.isEmpty();
    }

    public MedicinalProductInteraction setIncidence(CodeableConcept value) {
        this.incidence = value;
        return this;
    }

    public CodeableConcept getManagement() {
        if (this.management == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductInteraction.management");
            }
            if (Configuration.doAutoCreate()) {
                this.management = new CodeableConcept();
            }
        }
        return this.management;
    }

    public boolean hasManagement() {
        return this.management != null && !this.management.isEmpty();
    }

    public MedicinalProductInteraction setManagement(CodeableConcept value) {
        this.management = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication|Substance)", "The medication for which this is a described interaction.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("description", "string", "The interaction described.", 0, 1, this.description));
        children.add(new Property("interactant", "", "The specific medication, food or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant));
        children.add(new Property("type", "CodeableConcept", "The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.", 0, 1, this.type));
        children.add(new Property("effect", "CodeableConcept", "The effect of the interaction, for example \"reduced gastric absorption of primary medication\".", 0, 1, this.effect));
        children.add(new Property("incidence", "CodeableConcept", "The incidence of the interaction, e.g. theoretical, observed.", 0, 1, this.incidence));
        children.add(new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, 1, this.management));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication|Substance)", "The medication for which this is a described interaction.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -1724546052: {
                return new Property("description", "string", "The interaction described.", 0, 1, this.description);
            }
            case 1844097009: {
                return new Property("interactant", "", "The specific medication, food or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.", 0, 1, this.type);
            }
            case -1306084975: {
                return new Property("effect", "CodeableConcept", "The effect of the interaction, for example \"reduced gastric absorption of primary medication\".", 0, 1, this.effect);
            }
            case -1598467132: {
                return new Property("incidence", "CodeableConcept", "The incidence of the interaction, e.g. theoretical, observed.", 0, 1, this.incidence);
            }
            case -1799980989: {
                return new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, 1, this.management);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case 1844097009: {
                return this.interactant == null ? new Base[]{} : this.interactant.toArray(new Base[this.interactant.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1306084975: {
                Base[] baseArray;
                if (this.effect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.effect;
                }
                return baseArray;
            }
            case -1598467132: {
                Base[] baseArray;
                if (this.incidence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.incidence;
                }
                return baseArray;
            }
            case -1799980989: {
                Base[] baseArray;
                if (this.management == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.management;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 1844097009: {
                this.getInteractant().add((MedicinalProductInteractionInteractantComponent)value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1306084975: {
                this.effect = this.castToCodeableConcept(value);
                return value;
            }
            case -1598467132: {
                this.incidence = this.castToCodeableConcept(value);
                return value;
            }
            case -1799980989: {
                this.management = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("interactant")) {
            this.getInteractant().add((MedicinalProductInteractionInteractantComponent)value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("effect")) {
            this.effect = this.castToCodeableConcept(value);
        } else if (name.equals("incidence")) {
            this.incidence = this.castToCodeableConcept(value);
        } else if (name.equals("management")) {
            this.management = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.addSubject();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 1844097009: {
                return this.addInteractant();
            }
            case 3575610: {
                return this.getType();
            }
            case -1306084975: {
                return this.getEffect();
            }
            case -1598467132: {
                return this.getIncidence();
            }
            case -1799980989: {
                return this.getManagement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 1844097009: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1306084975: {
                return new String[]{"CodeableConcept"};
            }
            case -1598467132: {
                return new String[]{"CodeableConcept"};
            }
            case -1799980989: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductInteraction.description");
        }
        if (name.equals("interactant")) {
            return this.addInteractant();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("effect")) {
            this.effect = new CodeableConcept();
            return this.effect;
        }
        if (name.equals("incidence")) {
            this.incidence = new CodeableConcept();
            return this.incidence;
        }
        if (name.equals("management")) {
            this.management = new CodeableConcept();
            return this.management;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductInteraction";
    }

    @Override
    public MedicinalProductInteraction copy() {
        MedicinalProductInteraction dst = new MedicinalProductInteraction();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductInteraction dst) {
        super.copyValues(dst);
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.interactant != null) {
            dst.interactant = new ArrayList<MedicinalProductInteractionInteractantComponent>();
            for (MedicinalProductInteractionInteractantComponent medicinalProductInteractionInteractantComponent : this.interactant) {
                dst.interactant.add(medicinalProductInteractionInteractantComponent.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.effect = this.effect == null ? null : this.effect.copy();
        dst.incidence = this.incidence == null ? null : this.incidence.copy();
        dst.management = this.management == null ? null : this.management.copy();
    }

    protected MedicinalProductInteraction typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductInteraction)) {
            return false;
        }
        MedicinalProductInteraction o = (MedicinalProductInteraction)other_;
        return MedicinalProductInteraction.compareDeep(this.subject, o.subject, true) && MedicinalProductInteraction.compareDeep(this.description, o.description, true) && MedicinalProductInteraction.compareDeep(this.interactant, o.interactant, true) && MedicinalProductInteraction.compareDeep(this.type, o.type, true) && MedicinalProductInteraction.compareDeep(this.effect, o.effect, true) && MedicinalProductInteraction.compareDeep(this.incidence, o.incidence, true) && MedicinalProductInteraction.compareDeep(this.management, o.management, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductInteraction)) {
            return false;
        }
        MedicinalProductInteraction o = (MedicinalProductInteraction)other_;
        return MedicinalProductInteraction.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subject, this.description, this.interactant, this.type, this.effect, this.incidence, this.management});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductInteraction;
    }

    @Block
    public static class MedicinalProductInteractionInteractantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={MedicinalProduct.class, Medication.class, Substance.class, ObservationDefinition.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific medication, food or laboratory test that interacts", formalDefinition="The specific medication, food or laboratory test that interacts.")
        protected Type item;
        private static final long serialVersionUID = 1445276561L;

        public MedicinalProductInteractionInteractantComponent() {
        }

        public MedicinalProductInteractionInteractantComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicinalProductInteractionInteractantComponent setItem(Type value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for MedicinalProductInteraction.interactant.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "Reference(MedicinalProduct|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "Reference(MedicinalProduct|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "Reference(MedicinalProduct|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(MedicinalProduct|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "Reference(MedicinalProduct|Medication|Substance|ObservationDefinition)|CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("item[x]")) {
                return super.setProperty(name, value);
            }
            this.item = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductInteractionInteractantComponent copy() {
            MedicinalProductInteractionInteractantComponent dst = new MedicinalProductInteractionInteractantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductInteractionInteractantComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductInteractionInteractantComponent)) {
                return false;
            }
            MedicinalProductInteractionInteractantComponent o = (MedicinalProductInteractionInteractantComponent)other_;
            return MedicinalProductInteractionInteractantComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductInteractionInteractantComponent)) {
                return false;
            }
            MedicinalProductInteractionInteractantComponent o = (MedicinalProductInteractionInteractantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductInteraction.interactant";
        }
    }
}

