/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimUse {
    CLAIM,
    PREAUTHORIZATION,
    PREDETERMINATION,
    NULL;


    public static ClaimUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("claim".equals(codeString)) {
            return CLAIM;
        }
        if ("preauthorization".equals(codeString)) {
            return PREAUTHORIZATION;
        }
        if ("predetermination".equals(codeString)) {
            return PREDETERMINATION;
        }
        throw new FHIRException("Unknown ClaimUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CLAIM: {
                return "claim";
            }
            case PREAUTHORIZATION: {
                return "preauthorization";
            }
            case PREDETERMINATION: {
                return "predetermination";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/claim-use";
    }

    public String getDefinition() {
        switch (this) {
            case CLAIM: {
                return "The treatment is complete and this represents a Claim for the services.";
            }
            case PREAUTHORIZATION: {
                return "The treatment is proposed and this represents a Pre-authorization for the services.";
            }
            case PREDETERMINATION: {
                return "The treatment is proposed and this represents a Pre-determination for the services.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CLAIM: {
                return "Claim";
            }
            case PREAUTHORIZATION: {
                return "Preauthorization";
            }
            case PREDETERMINATION: {
                return "Predetermination";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

