package org.hl7.fhir.r4.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0

import org.hl7.fhir.exceptions.FHIRException;

public enum EpisodeOfCareStatus {

  /**
   * This episode of care is planned to start at the date specified in the
   * period.start. During this status, an organization may perform assessments to
   * determine if the patient is eligible to receive services, or be organizing to
   * make resources available to provide care services.
   */
  PLANNED,
  /**
   * This episode has been placed on a waitlist, pending the episode being made
   * active (or cancelled).
   */
  WAITLIST,
  /**
   * This episode of care is current.
   */
  ACTIVE,
  /**
   * This episode of care is on hold; the organization has limited responsibility
   * for the patient (such as while on respite).
   */
  ONHOLD,
  /**
   * This episode of care is finished and the organization is not expecting to be
   * providing further care to the patient. Can also be known as "closed",
   * "completed" or other similar terms.
   */
  FINISHED,
  /**
   * The episode of care was cancelled, or withdrawn from service, often selected
   * during the planned stage as the patient may have gone elsewhere, or the
   * circumstances have changed and the organization is unable to provide the
   * care. It indicates that services terminated outside the planned/expected
   * workflow.
   */
  CANCELLED,
  /**
   * This instance should not have been part of this patient's medical record.
   */
  ENTEREDINERROR,
  /**
   * added to help the parsers
   */
  NULL;

  public static EpisodeOfCareStatus fromCode(String codeString) throws FHIRException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("planned".equals(codeString))
      return PLANNED;
    if ("waitlist".equals(codeString))
      return WAITLIST;
    if ("active".equals(codeString))
      return ACTIVE;
    if ("onhold".equals(codeString))
      return ONHOLD;
    if ("finished".equals(codeString))
      return FINISHED;
    if ("cancelled".equals(codeString))
      return CANCELLED;
    if ("entered-in-error".equals(codeString))
      return ENTEREDINERROR;
    throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
  }

  public String toCode() {
    switch (this) {
    case PLANNED:
      return "planned";
    case WAITLIST:
      return "waitlist";
    case ACTIVE:
      return "active";
    case ONHOLD:
      return "onhold";
    case FINISHED:
      return "finished";
    case CANCELLED:
      return "cancelled";
    case ENTEREDINERROR:
      return "entered-in-error";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getSystem() {
    return "http://hl7.org/fhir/episode-of-care-status";
  }

  public String getDefinition() {
    switch (this) {
    case PLANNED:
      return "This episode of care is planned to start at the date specified in the period.start. During this status, an organization may perform assessments to determine if the patient is eligible to receive services, or be organizing to make resources available to provide care services.";
    case WAITLIST:
      return "This episode has been placed on a waitlist, pending the episode being made active (or cancelled).";
    case ACTIVE:
      return "This episode of care is current.";
    case ONHOLD:
      return "This episode of care is on hold; the organization has limited responsibility for the patient (such as while on respite).";
    case FINISHED:
      return "This episode of care is finished and the organization is not expecting to be providing further care to the patient. Can also be known as \"closed\", \"completed\" or other similar terms.";
    case CANCELLED:
      return "The episode of care was cancelled, or withdrawn from service, often selected during the planned stage as the patient may have gone elsewhere, or the circumstances have changed and the organization is unable to provide the care. It indicates that services terminated outside the planned/expected workflow.";
    case ENTEREDINERROR:
      return "This instance should not have been part of this patient's medical record.";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getDisplay() {
    switch (this) {
    case PLANNED:
      return "Planned";
    case WAITLIST:
      return "Waitlist";
    case ACTIVE:
      return "Active";
    case ONHOLD:
      return "On Hold";
    case FINISHED:
      return "Finished";
    case CANCELLED:
      return "Cancelled";
    case ENTEREDINERROR:
      return "Entered in Error";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

}