/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AuditEvent", profile="http://hl7.org/fhir/StructureDefinition/AuditEvent")
public class AuditEvent
extends DomainResource {
    @Child(name="type", type={Coding.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type/identifier of event", formalDefinition="Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-type")
    protected Coding type;
    @Child(name="subtype", type={Coding.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="More specific type/id for the event", formalDefinition="Identifier for the category of event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-sub-type")
    protected List<Coding> subtype;
    @Child(name="action", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of action performed during the event", formalDefinition="Indicator for type of action performed during the event that generated the audit.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-action")
    protected Enumeration<AuditEventAction> action;
    @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The period during which the activity occurred.")
    protected Period period;
    @Child(name="recorded", type={InstantType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time when the event was recorded", formalDefinition="The time when the event was recorded.")
    protected InstantType recorded;
    @Child(name="outcome", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the event succeeded or failed", formalDefinition="Indicates whether the event succeeded or failed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-outcome")
    protected Enumeration<AuditEventOutcome> outcome;
    @Child(name="outcomeDesc", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of the event outcome", formalDefinition="A free text description of the outcome of the event.")
    protected StringType outcomeDesc;
    @Child(name="purposeOfEvent", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The purposeOfUse of the event", formalDefinition="The purposeOfUse (reason) that was used during the event being recorded.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    protected List<CodeableConcept> purposeOfEvent;
    @Child(name="agent", type={}, order=8, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Actor involved in the event", formalDefinition="An actor taking an active role in the event or activity that is logged.")
    protected List<AuditEventAgentComponent> agent;
    @Child(name="source", type={}, order=9, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Audit Event Reporter", formalDefinition="The system that is reporting the event.")
    protected AuditEventSourceComponent source;
    @Child(name="entity", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Data or objects used", formalDefinition="Specific instances of data or objects that have been accessed.")
    protected List<AuditEventEntityComponent> entity;
    private static final long serialVersionUID = 106433685L;
    @SearchParamDefinition(name="date", path="AuditEvent.recorded", description="Time when the event was recorded", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="entity-type", path="AuditEvent.entity.type", description="Type of entity involved", type="token")
    public static final String SP_ENTITY_TYPE = "entity-type";
    public static final TokenClientParam ENTITY_TYPE = new TokenClientParam("entity-type");
    @SearchParamDefinition(name="agent", path="AuditEvent.agent.who", description="Identifier of who", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("AuditEvent:agent").toLocked();
    @SearchParamDefinition(name="address", path="AuditEvent.agent.network.address", description="Identifier for the network access point of the user device", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="entity-role", path="AuditEvent.entity.role", description="What role the entity played", type="token")
    public static final String SP_ENTITY_ROLE = "entity-role";
    public static final TokenClientParam ENTITY_ROLE = new TokenClientParam("entity-role");
    @SearchParamDefinition(name="source", path="AuditEvent.source.observer", description="The identity of source detecting the event", type="reference", target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("AuditEvent:source").toLocked();
    @SearchParamDefinition(name="type", path="AuditEvent.type", description="Type/identifier of event", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="altid", path="AuditEvent.agent.altId", description="Alternative User identity", type="token")
    public static final String SP_ALTID = "altid";
    public static final TokenClientParam ALTID = new TokenClientParam("altid");
    @SearchParamDefinition(name="site", path="AuditEvent.source.site", description="Logical source location within the enterprise", type="token")
    public static final String SP_SITE = "site";
    public static final TokenClientParam SITE = new TokenClientParam("site");
    @SearchParamDefinition(name="agent-name", path="AuditEvent.agent.name", description="Human friendly name for the agent", type="string")
    public static final String SP_AGENT_NAME = "agent-name";
    public static final StringClientParam AGENT_NAME = new StringClientParam("agent-name");
    @SearchParamDefinition(name="entity-name", path="AuditEvent.entity.name", description="Descriptor for entity", type="string")
    public static final String SP_ENTITY_NAME = "entity-name";
    public static final StringClientParam ENTITY_NAME = new StringClientParam("entity-name");
    @SearchParamDefinition(name="subtype", path="AuditEvent.subtype", description="More specific type/id for the event", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="patient", path="AuditEvent.agent.who.where(resolve() is Patient) | AuditEvent.entity.what.where(resolve() is Patient)", description="Identifier of who", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AuditEvent:patient").toLocked();
    @SearchParamDefinition(name="action", path="AuditEvent.action", description="Type of action performed during the event", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="agent-role", path="AuditEvent.agent.role", description="Agent role in the event", type="token")
    public static final String SP_AGENT_ROLE = "agent-role";
    public static final TokenClientParam AGENT_ROLE = new TokenClientParam("agent-role");
    @SearchParamDefinition(name="entity", path="AuditEvent.entity.what", description="Specific instance of resource", type="reference")
    public static final String SP_ENTITY = "entity";
    public static final ReferenceClientParam ENTITY = new ReferenceClientParam("entity");
    public static final Include INCLUDE_ENTITY = new Include("AuditEvent:entity").toLocked();
    @SearchParamDefinition(name="outcome", path="AuditEvent.outcome", description="Whether the event succeeded or failed", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="policy", path="AuditEvent.agent.policy", description="Policy that authorized event", type="uri")
    public static final String SP_POLICY = "policy";
    public static final UriClientParam POLICY = new UriClientParam("policy");

    public AuditEvent() {
    }

    public AuditEvent(Coding type, InstantType recorded, AuditEventSourceComponent source) {
        this.type = type;
        this.recorded = recorded;
        this.source = source;
    }

    public Coding getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Coding();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public AuditEvent setType(Coding value) {
        this.type = value;
        return this;
    }

    public List<Coding> getSubtype() {
        if (this.subtype == null) {
            this.subtype = new ArrayList<Coding>();
        }
        return this.subtype;
    }

    public AuditEvent setSubtype(List<Coding> theSubtype) {
        this.subtype = theSubtype;
        return this;
    }

    public boolean hasSubtype() {
        if (this.subtype == null) {
            return false;
        }
        for (Coding item : this.subtype) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addSubtype() {
        Coding t = new Coding();
        if (this.subtype == null) {
            this.subtype = new ArrayList<Coding>();
        }
        this.subtype.add(t);
        return t;
    }

    public AuditEvent addSubtype(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.subtype == null) {
            this.subtype = new ArrayList<Coding>();
        }
        this.subtype.add(t);
        return this;
    }

    public Coding getSubtypeFirstRep() {
        if (this.getSubtype().isEmpty()) {
            this.addSubtype();
        }
        return this.getSubtype().get(0);
    }

    public Enumeration<AuditEventAction> getActionElement() {
        if (this.action == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.action");
            }
            if (Configuration.doAutoCreate()) {
                this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
            }
        }
        return this.action;
    }

    public boolean hasActionElement() {
        return this.action != null && !this.action.isEmpty();
    }

    public boolean hasAction() {
        return this.action != null && !this.action.isEmpty();
    }

    public AuditEvent setActionElement(Enumeration<AuditEventAction> value) {
        this.action = value;
        return this;
    }

    public AuditEventAction getAction() {
        return this.action == null ? null : (AuditEventAction)((Object)this.action.getValue());
    }

    public AuditEvent setAction(AuditEventAction value) {
        if (value == null) {
            this.action = null;
        } else {
            if (this.action == null) {
                this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
            }
            this.action.setValue((Object)value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public AuditEvent setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public InstantType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new InstantType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public AuditEvent setRecordedElement(InstantType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public AuditEvent setRecorded(Date value) {
        if (this.recorded == null) {
            this.recorded = new InstantType();
        }
        this.recorded.setValue(value);
        return this;
    }

    public Enumeration<AuditEventOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<AuditEventOutcome>(new AuditEventOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public AuditEvent setOutcomeElement(Enumeration<AuditEventOutcome> value) {
        this.outcome = value;
        return this;
    }

    public AuditEventOutcome getOutcome() {
        return this.outcome == null ? null : (AuditEventOutcome)((Object)this.outcome.getValue());
    }

    public AuditEvent setOutcome(AuditEventOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<AuditEventOutcome>(new AuditEventOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getOutcomeDescElement() {
        if (this.outcomeDesc == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.outcomeDesc");
            }
            if (Configuration.doAutoCreate()) {
                this.outcomeDesc = new StringType();
            }
        }
        return this.outcomeDesc;
    }

    public boolean hasOutcomeDescElement() {
        return this.outcomeDesc != null && !this.outcomeDesc.isEmpty();
    }

    public boolean hasOutcomeDesc() {
        return this.outcomeDesc != null && !this.outcomeDesc.isEmpty();
    }

    public AuditEvent setOutcomeDescElement(StringType value) {
        this.outcomeDesc = value;
        return this;
    }

    public String getOutcomeDesc() {
        return this.outcomeDesc == null ? null : (String)this.outcomeDesc.getValue();
    }

    public AuditEvent setOutcomeDesc(String value) {
        if (Utilities.noString((String)value)) {
            this.outcomeDesc = null;
        } else {
            if (this.outcomeDesc == null) {
                this.outcomeDesc = new StringType();
            }
            this.outcomeDesc.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getPurposeOfEvent() {
        if (this.purposeOfEvent == null) {
            this.purposeOfEvent = new ArrayList<CodeableConcept>();
        }
        return this.purposeOfEvent;
    }

    public AuditEvent setPurposeOfEvent(List<CodeableConcept> thePurposeOfEvent) {
        this.purposeOfEvent = thePurposeOfEvent;
        return this;
    }

    public boolean hasPurposeOfEvent() {
        if (this.purposeOfEvent == null) {
            return false;
        }
        for (CodeableConcept item : this.purposeOfEvent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPurposeOfEvent() {
        CodeableConcept t = new CodeableConcept();
        if (this.purposeOfEvent == null) {
            this.purposeOfEvent = new ArrayList<CodeableConcept>();
        }
        this.purposeOfEvent.add(t);
        return t;
    }

    public AuditEvent addPurposeOfEvent(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.purposeOfEvent == null) {
            this.purposeOfEvent = new ArrayList<CodeableConcept>();
        }
        this.purposeOfEvent.add(t);
        return this;
    }

    public CodeableConcept getPurposeOfEventFirstRep() {
        if (this.getPurposeOfEvent().isEmpty()) {
            this.addPurposeOfEvent();
        }
        return this.getPurposeOfEvent().get(0);
    }

    public List<AuditEventAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        return this.agent;
    }

    public AuditEvent setAgent(List<AuditEventAgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (AuditEventAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventAgentComponent addAgent() {
        AuditEventAgentComponent t = new AuditEventAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public AuditEvent addAgent(AuditEventAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public AuditEventAgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public AuditEventSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new AuditEventSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public AuditEvent setSource(AuditEventSourceComponent value) {
        this.source = value;
        return this;
    }

    public List<AuditEventEntityComponent> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        return this.entity;
    }

    public AuditEvent setEntity(List<AuditEventEntityComponent> theEntity) {
        this.entity = theEntity;
        return this;
    }

    public boolean hasEntity() {
        if (this.entity == null) {
            return false;
        }
        for (AuditEventEntityComponent item : this.entity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventEntityComponent addEntity() {
        AuditEventEntityComponent t = new AuditEventEntityComponent();
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        this.entity.add(t);
        return t;
    }

    public AuditEvent addEntity(AuditEventEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        this.entity.add(t);
        return this;
    }

    public AuditEventEntityComponent getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            this.addEntity();
        }
        return this.getEntity().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_TYPE, "Coding", "Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.", 0, 1, this.type));
        children.add(new Property(SP_SUBTYPE, "Coding", "Identifier for the category of event.", 0, Integer.MAX_VALUE, this.subtype));
        children.add(new Property(SP_ACTION, "code", "Indicator for type of action performed during the event that generated the audit.", 0, 1, this.action));
        children.add(new Property("period", "Period", "The period during which the activity occurred.", 0, 1, this.period));
        children.add(new Property("recorded", "instant", "The time when the event was recorded.", 0, 1, this.recorded));
        children.add(new Property(SP_OUTCOME, "code", "Indicates whether the event succeeded or failed.", 0, 1, this.outcome));
        children.add(new Property("outcomeDesc", "string", "A free text description of the outcome of the event.", 0, 1, this.outcomeDesc));
        children.add(new Property("purposeOfEvent", "CodeableConcept", "The purposeOfUse (reason) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfEvent));
        children.add(new Property(SP_AGENT, "", "An actor taking an active role in the event or activity that is logged.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_SOURCE, "", "The system that is reporting the event.", 0, 1, this.source));
        children.add(new Property(SP_ENTITY, "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.entity));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property(SP_TYPE, "Coding", "Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.", 0, 1, this.type);
            }
            case -1867567750: {
                return new Property(SP_SUBTYPE, "Coding", "Identifier for the category of event.", 0, Integer.MAX_VALUE, this.subtype);
            }
            case -1422950858: {
                return new Property(SP_ACTION, "code", "Indicator for type of action performed during the event that generated the audit.", 0, 1, this.action);
            }
            case -991726143: {
                return new Property("period", "Period", "The period during which the activity occurred.", 0, 1, this.period);
            }
            case -799233872: {
                return new Property("recorded", "instant", "The time when the event was recorded.", 0, 1, this.recorded);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "Indicates whether the event succeeded or failed.", 0, 1, this.outcome);
            }
            case 1062502659: {
                return new Property("outcomeDesc", "string", "A free text description of the outcome of the event.", 0, 1, this.outcomeDesc);
            }
            case -341917691: {
                return new Property("purposeOfEvent", "CodeableConcept", "The purposeOfUse (reason) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfEvent);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking an active role in the event or activity that is logged.", 0, Integer.MAX_VALUE, this.agent);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "", "The system that is reporting the event.", 0, 1, this.source);
            }
            case -1298275357: {
                return new Property(SP_ENTITY, "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.entity);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1867567750: {
                return this.subtype == null ? new Base[]{} : this.subtype.toArray(new Base[this.subtype.size()]);
            }
            case -1422950858: {
                Base[] baseArray;
                if (this.action == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.action;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.period;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.recorded;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.outcome;
                }
                return baseArray;
            }
            case 1062502659: {
                Base[] baseArray;
                if (this.outcomeDesc == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.outcomeDesc;
                }
                return baseArray;
            }
            case -341917691: {
                return this.purposeOfEvent == null ? new Base[]{} : this.purposeOfEvent.toArray(new Base[this.purposeOfEvent.size()]);
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.source;
                }
                return baseArray;
            }
            case -1298275357: {
                return this.entity == null ? new Base[]{} : this.entity.toArray(new Base[this.entity.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = this.castToCoding(value);
                return value;
            }
            case -1867567750: {
                this.getSubtype().add(this.castToCoding(value));
                return value;
            }
            case -1422950858: {
                value = new AuditEventActionEnumFactory().fromType(this.castToCode(value));
                this.action = value;
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -799233872: {
                this.recorded = this.castToInstant(value);
                return value;
            }
            case -1106507950: {
                value = new AuditEventOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 1062502659: {
                this.outcomeDesc = this.castToString(value);
                return value;
            }
            case -341917691: {
                this.getPurposeOfEvent().add(this.castToCodeableConcept(value));
                return value;
            }
            case 92750597: {
                this.getAgent().add((AuditEventAgentComponent)((Object)value));
                return value;
            }
            case -896505829: {
                this.source = (AuditEventSourceComponent)((Object)value);
                return value;
            }
            case -1298275357: {
                this.getEntity().add((AuditEventEntityComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            this.type = this.castToCoding(value);
        } else if (name.equals(SP_SUBTYPE)) {
            this.getSubtype().add(this.castToCoding(value));
        } else if (name.equals(SP_ACTION)) {
            value = new AuditEventActionEnumFactory().fromType(this.castToCode(value));
            this.action = value;
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("recorded")) {
            this.recorded = this.castToInstant(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new AuditEventOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals("outcomeDesc")) {
            this.outcomeDesc = this.castToString(value);
        } else if (name.equals("purposeOfEvent")) {
            this.getPurposeOfEvent().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((AuditEventAgentComponent)((Object)value));
        } else if (name.equals(SP_SOURCE)) {
            this.source = (AuditEventSourceComponent)((Object)value);
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().add((AuditEventEntityComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_SUBTYPE)) {
            this.getSubtype().remove(this.castToCoding(value));
        } else if (name.equals(SP_ACTION)) {
            this.action = null;
        } else if (name.equals("period")) {
            this.period = null;
        } else if (name.equals("recorded")) {
            this.recorded = null;
        } else if (name.equals(SP_OUTCOME)) {
            this.outcome = null;
        } else if (name.equals("outcomeDesc")) {
            this.outcomeDesc = null;
        } else if (name.equals("purposeOfEvent")) {
            this.getPurposeOfEvent().remove(this.castToCodeableConcept(value));
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().remove((AuditEventAgentComponent)value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = (AuditEventSourceComponent)value;
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().remove((AuditEventEntityComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getType();
            }
            case -1867567750: {
                return this.addSubtype();
            }
            case -1422950858: {
                return this.getActionElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 1062502659: {
                return this.getOutcomeDescElement();
            }
            case -341917691: {
                return this.addPurposeOfEvent();
            }
            case 92750597: {
                return this.addAgent();
            }
            case -896505829: {
                return this.getSource();
            }
            case -1298275357: {
                return this.addEntity();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"Coding"};
            }
            case -1867567750: {
                return new String[]{"Coding"};
            }
            case -1422950858: {
                return new String[]{"code"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -799233872: {
                return new String[]{"instant"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 1062502659: {
                return new String[]{"string"};
            }
            case -341917691: {
                return new String[]{"CodeableConcept"};
            }
            case 92750597: {
                return new String[0];
            }
            case -896505829: {
                return new String[0];
            }
            case -1298275357: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            this.type = new Coding();
            return this.type;
        }
        if (name.equals(SP_SUBTYPE)) {
            return this.addSubtype();
        }
        if (name.equals(SP_ACTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.action");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.recorded");
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.outcome");
        }
        if (name.equals("outcomeDesc")) {
            throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.outcomeDesc");
        }
        if (name.equals("purposeOfEvent")) {
            return this.addPurposeOfEvent();
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new AuditEventSourceComponent();
            return this.source;
        }
        if (name.equals(SP_ENTITY)) {
            return this.addEntity();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AuditEvent";
    }

    @Override
    public AuditEvent copy() {
        AuditEvent dst = new AuditEvent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AuditEvent dst) {
        super.copyValues(dst);
        Coding coding = dst.type = this.type == null ? null : this.type.copy();
        if (this.subtype != null) {
            dst.subtype = new ArrayList<Coding>();
            for (Coding coding2 : this.subtype) {
                dst.subtype.add(coding2.copy());
            }
        }
        dst.action = this.action == null ? null : this.action.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        StringType stringType = dst.outcomeDesc = this.outcomeDesc == null ? null : this.outcomeDesc.copy();
        if (this.purposeOfEvent != null) {
            dst.purposeOfEvent = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.purposeOfEvent) {
                dst.purposeOfEvent.add(codeableConcept.copy());
            }
        }
        if (this.agent != null) {
            dst.agent = new ArrayList<AuditEventAgentComponent>();
            for (AuditEventAgentComponent auditEventAgentComponent : this.agent) {
                dst.agent.add(auditEventAgentComponent.copy());
            }
        }
        AuditEventSourceComponent auditEventSourceComponent = dst.source = this.source == null ? null : this.source.copy();
        if (this.entity != null) {
            dst.entity = new ArrayList<AuditEventEntityComponent>();
            for (AuditEventEntityComponent auditEventEntityComponent : this.entity) {
                dst.entity.add(auditEventEntityComponent.copy());
            }
        }
    }

    protected AuditEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other_;
        return AuditEvent.compareDeep(this.type, o.type, true) && AuditEvent.compareDeep(this.subtype, o.subtype, true) && AuditEvent.compareDeep(this.action, o.action, true) && AuditEvent.compareDeep(this.period, o.period, true) && AuditEvent.compareDeep(this.recorded, o.recorded, true) && AuditEvent.compareDeep(this.outcome, o.outcome, true) && AuditEvent.compareDeep(this.outcomeDesc, o.outcomeDesc, true) && AuditEvent.compareDeep(this.purposeOfEvent, o.purposeOfEvent, true) && AuditEvent.compareDeep(this.agent, o.agent, true) && AuditEvent.compareDeep(this.source, o.source, true) && AuditEvent.compareDeep(this.entity, o.entity, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other_;
        return AuditEvent.compareValues(this.action, o.action, true) && AuditEvent.compareValues(this.recorded, o.recorded, true) && AuditEvent.compareValues(this.outcome, o.outcome, true) && AuditEvent.compareValues(this.outcomeDesc, o.outcomeDesc, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.subtype, this.action, this.period, this.recorded, this.outcome, this.outcomeDesc, this.purposeOfEvent, this.agent, this.source, this.entity});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AuditEvent;
    }

    @Block
    public static class AuditEventEntityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the property", formalDefinition="The type of extra detail provided in the value.")
        protected StringType type;
        @Child(name="value", type={StringType.class, Base64BinaryType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property value", formalDefinition="The  value of the extra detail.")
        protected Type value;
        private static final long serialVersionUID = -1035059584L;

        public AuditEventEntityDetailComponent() {
        }

        public AuditEventEntityDetailComponent(StringType type, Type value) {
            this.type = type;
            this.value = value;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityDetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventEntityDetailComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public AuditEventEntityDetailComponent setType(String value) {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AuditEventEntityDetailComponent setValue(Type value) {
            if (value != null && !(value instanceof StringType) && !(value instanceof Base64BinaryType)) {
                throw new Error("Not the right type for AuditEvent.entity.detail.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(AuditEvent.SP_TYPE, "string", "The type of extra detail provided in the value.", 0, 1, this.type));
            children.add(new Property("value[x]", "string|base64Binary", "The  value of the extra detail.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(AuditEvent.SP_TYPE, "string", "The type of extra detail provided in the value.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "string|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string", "base64Binary"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.type");
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventEntityDetailComponent copy() {
            AuditEventEntityDetailComponent dst = new AuditEventEntityDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventEntityDetailComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityDetailComponent)) {
                return false;
            }
            AuditEventEntityDetailComponent o = (AuditEventEntityDetailComponent)other_;
            return AuditEventEntityDetailComponent.compareDeep(this.type, o.type, true) && AuditEventEntityDetailComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityDetailComponent)) {
                return false;
            }
            AuditEventEntityDetailComponent o = (AuditEventEntityDetailComponent)other_;
            return AuditEventEntityDetailComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "AuditEvent.entity.detail";
        }
    }

    @Block
    public static class AuditEventEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="what", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific instance of resource", formalDefinition="Identifies a specific instance of the entity. The reference should be version specific.")
        protected Reference what;
        protected Resource whatTarget;
        @Child(name="type", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of entity involved", formalDefinition="The type of the object that was involved in this audit event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-entity-type")
        protected Coding type;
        @Child(name="role", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What role the entity played", formalDefinition="Code representing the role the entity played in the event being audited.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/object-role")
        protected Coding role;
        @Child(name="lifecycle", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Life-cycle stage for the entity", formalDefinition="Identifier for the data life-cycle stage for the entity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/object-lifecycle-events")
        protected Coding lifecycle;
        @Child(name="securityLabel", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Security labels on the entity", formalDefinition="Security labels for the identified entity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        protected List<Coding> securityLabel;
        @Child(name="name", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Descriptor for entity", formalDefinition="A name of the entity in the audit event.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Descriptive text", formalDefinition="Text that describes the entity in more detail.")
        protected StringType description;
        @Child(name="query", type={Base64BinaryType.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query parameters", formalDefinition="The query parameters for a query-type entities.")
        protected Base64BinaryType query;
        @Child(name="detail", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional Information about the entity", formalDefinition="Tagged value pairs for conveying additional information about the entity.")
        protected List<AuditEventEntityDetailComponent> detail;
        private static final long serialVersionUID = 334545686L;

        public Reference getWhat() {
            if (this.what == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.what");
                }
                if (Configuration.doAutoCreate()) {
                    this.what = new Reference();
                }
            }
            return this.what;
        }

        public boolean hasWhat() {
            return this.what != null && !this.what.isEmpty();
        }

        public AuditEventEntityComponent setWhat(Reference value) {
            this.what = value;
            return this;
        }

        public Resource getWhatTarget() {
            return this.whatTarget;
        }

        public AuditEventEntityComponent setWhatTarget(Resource value) {
            this.whatTarget = value;
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventEntityComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Coding getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Coding();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public AuditEventEntityComponent setRole(Coding value) {
            this.role = value;
            return this;
        }

        public Coding getLifecycle() {
            if (this.lifecycle == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.lifecycle");
                }
                if (Configuration.doAutoCreate()) {
                    this.lifecycle = new Coding();
                }
            }
            return this.lifecycle;
        }

        public boolean hasLifecycle() {
            return this.lifecycle != null && !this.lifecycle.isEmpty();
        }

        public AuditEventEntityComponent setLifecycle(Coding value) {
            this.lifecycle = value;
            return this;
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public AuditEventEntityComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public AuditEventEntityComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public AuditEventEntityComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public AuditEventEntityComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AuditEventEntityComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AuditEventEntityComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getQueryElement() {
            if (this.query == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.query");
                }
                if (Configuration.doAutoCreate()) {
                    this.query = new Base64BinaryType();
                }
            }
            return this.query;
        }

        public boolean hasQueryElement() {
            return this.query != null && !this.query.isEmpty();
        }

        public boolean hasQuery() {
            return this.query != null && !this.query.isEmpty();
        }

        public AuditEventEntityComponent setQueryElement(Base64BinaryType value) {
            this.query = value;
            return this;
        }

        public byte[] getQuery() {
            return this.query == null ? null : this.query.getValue();
        }

        public AuditEventEntityComponent setQuery(byte[] value) {
            if (value == null) {
                this.query = null;
            } else {
                if (this.query == null) {
                    this.query = new Base64BinaryType();
                }
                this.query.setValue(value);
            }
            return this;
        }

        public List<AuditEventEntityDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            return this.detail;
        }

        public AuditEventEntityComponent setDetail(List<AuditEventEntityDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AuditEventEntityDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AuditEventEntityDetailComponent addDetail() {
            AuditEventEntityDetailComponent t = new AuditEventEntityDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AuditEventEntityComponent addDetail(AuditEventEntityDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public AuditEventEntityDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("what", "Reference(Any)", "Identifies a specific instance of the entity. The reference should be version specific.", 0, 1, this.what));
            children.add(new Property(AuditEvent.SP_TYPE, "Coding", "The type of the object that was involved in this audit event.", 0, 1, this.type));
            children.add(new Property("role", "Coding", "Code representing the role the entity played in the event being audited.", 0, 1, this.role));
            children.add(new Property("lifecycle", "Coding", "Identifier for the data life-cycle stage for the entity.", 0, 1, this.lifecycle));
            children.add(new Property("securityLabel", "Coding", "Security labels for the identified entity.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property("name", "string", "A name of the entity in the audit event.", 0, 1, this.name));
            children.add(new Property("description", "string", "Text that describes the entity in more detail.", 0, 1, this.description));
            children.add(new Property("query", "base64Binary", "The query parameters for a query-type entities.", 0, 1, this.query));
            children.add(new Property("detail", "", "Tagged value pairs for conveying additional information about the entity.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3648196: {
                    return new Property("what", "Reference(Any)", "Identifies a specific instance of the entity. The reference should be version specific.", 0, 1, this.what);
                }
                case 3575610: {
                    return new Property(AuditEvent.SP_TYPE, "Coding", "The type of the object that was involved in this audit event.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "Coding", "Code representing the role the entity played in the event being audited.", 0, 1, this.role);
                }
                case -302323862: {
                    return new Property("lifecycle", "Coding", "Identifier for the data life-cycle stage for the entity.", 0, 1, this.lifecycle);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "Security labels for the identified entity.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case 3373707: {
                    return new Property("name", "string", "A name of the entity in the audit event.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "Text that describes the entity in more detail.", 0, 1, this.description);
                }
                case 107944136: {
                    return new Property("query", "base64Binary", "The query parameters for a query-type entities.", 0, 1, this.query);
                }
                case -1335224239: {
                    return new Property("detail", "", "Tagged value pairs for conveying additional information about the entity.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    Base[] baseArray;
                    if (this.what == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.what;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.role;
                    }
                    return baseArray;
                }
                case -302323862: {
                    Base[] baseArray;
                    if (this.lifecycle == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lifecycle;
                    }
                    return baseArray;
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.description;
                    }
                    return baseArray;
                }
                case 107944136: {
                    Base[] baseArray;
                    if (this.query == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.query;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    this.what = this.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCoding(value);
                    return value;
                }
                case -302323862: {
                    this.lifecycle = this.castToCoding(value);
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(this.castToCoding(value));
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 107944136: {
                    this.query = this.castToBase64Binary(value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((AuditEventEntityDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("what")) {
                this.what = this.castToReference(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToCoding(value);
            } else if (name.equals("role")) {
                this.role = this.castToCoding(value);
            } else if (name.equals("lifecycle")) {
                this.lifecycle = this.castToCoding(value);
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(this.castToCoding(value));
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("query")) {
                this.query = this.castToBase64Binary(value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AuditEventEntityDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("what")) {
                this.what = null;
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("lifecycle")) {
                this.lifecycle = null;
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().remove(this.castToCoding(value));
            } else if (name.equals("name")) {
                this.name = null;
            } else if (name.equals("description")) {
                this.description = null;
            } else if (name.equals("query")) {
                this.query = null;
            } else if (name.equals("detail")) {
                this.getDetail().remove((AuditEventEntityDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    return this.getWhat();
                }
                case 3575610: {
                    return this.getType();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -302323862: {
                    return this.getLifecycle();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 107944136: {
                    return this.getQueryElement();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 3506294: {
                    return new String[]{"Coding"};
                }
                case -302323862: {
                    return new String[]{"Coding"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 107944136: {
                    return new String[]{"base64Binary"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("what")) {
                this.what = new Reference();
                return this.what;
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("role")) {
                this.role = new Coding();
                return this.role;
            }
            if (name.equals("lifecycle")) {
                this.lifecycle = new Coding();
                return this.lifecycle;
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.description");
            }
            if (name.equals("query")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.query");
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventEntityComponent copy() {
            AuditEventEntityComponent dst = new AuditEventEntityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventEntityComponent dst) {
            super.copyValues(dst);
            dst.what = this.what == null ? null : this.what.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.role = this.role == null ? null : this.role.copy();
            Coding coding = dst.lifecycle = this.lifecycle == null ? null : this.lifecycle.copy();
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding2 : this.securityLabel) {
                    dst.securityLabel.add(coding2.copy());
                }
            }
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            Base64BinaryType base64BinaryType = dst.query = this.query == null ? null : this.query.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<AuditEventEntityDetailComponent>();
                for (AuditEventEntityDetailComponent auditEventEntityDetailComponent : this.detail) {
                    dst.detail.add(auditEventEntityDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityComponent)) {
                return false;
            }
            AuditEventEntityComponent o = (AuditEventEntityComponent)other_;
            return AuditEventEntityComponent.compareDeep(this.what, o.what, true) && AuditEventEntityComponent.compareDeep(this.type, o.type, true) && AuditEventEntityComponent.compareDeep(this.role, o.role, true) && AuditEventEntityComponent.compareDeep(this.lifecycle, o.lifecycle, true) && AuditEventEntityComponent.compareDeep(this.securityLabel, o.securityLabel, true) && AuditEventEntityComponent.compareDeep(this.name, o.name, true) && AuditEventEntityComponent.compareDeep(this.description, o.description, true) && AuditEventEntityComponent.compareDeep(this.query, o.query, true) && AuditEventEntityComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityComponent)) {
                return false;
            }
            AuditEventEntityComponent o = (AuditEventEntityComponent)other_;
            return AuditEventEntityComponent.compareValues(this.name, o.name, true) && AuditEventEntityComponent.compareValues(this.description, o.description, true) && AuditEventEntityComponent.compareValues(this.query, o.query, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.what, this.type, this.role, this.lifecycle, this.securityLabel, this.name, this.description, this.query, this.detail});
        }

        @Override
        public String fhirType() {
            return "AuditEvent.entity";
        }
    }

    @Block
    public static class AuditEventSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="site", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Logical source location within the enterprise", formalDefinition="Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.")
        protected StringType site;
        @Child(name="observer", type={PractitionerRole.class, Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identity of source detecting the event", formalDefinition="Identifier of the source where the event was detected.")
        protected Reference observer;
        protected Resource observerTarget;
        @Child(name="type", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The type of source where event originated", formalDefinition="Code specifying the type of source where event originated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-source-type")
        protected List<Coding> type;
        private static final long serialVersionUID = 2133038564L;

        public AuditEventSourceComponent() {
        }

        public AuditEventSourceComponent(Reference observer) {
            this.observer = observer;
        }

        public StringType getSiteElement() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new StringType();
                }
            }
            return this.site;
        }

        public boolean hasSiteElement() {
            return this.site != null && !this.site.isEmpty();
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public AuditEventSourceComponent setSiteElement(StringType value) {
            this.site = value;
            return this;
        }

        public String getSite() {
            return this.site == null ? null : (String)this.site.getValue();
        }

        public AuditEventSourceComponent setSite(String value) {
            if (Utilities.noString((String)value)) {
                this.site = null;
            } else {
                if (this.site == null) {
                    this.site = new StringType();
                }
                this.site.setValue(value);
            }
            return this;
        }

        public Reference getObserver() {
            if (this.observer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.observer");
                }
                if (Configuration.doAutoCreate()) {
                    this.observer = new Reference();
                }
            }
            return this.observer;
        }

        public boolean hasObserver() {
            return this.observer != null && !this.observer.isEmpty();
        }

        public AuditEventSourceComponent setObserver(Reference value) {
            this.observer = value;
            return this;
        }

        public Resource getObserverTarget() {
            return this.observerTarget;
        }

        public AuditEventSourceComponent setObserverTarget(Resource value) {
            this.observerTarget = value;
            return this;
        }

        public List<Coding> getType() {
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            return this.type;
        }

        public AuditEventSourceComponent setType(List<Coding> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (Coding item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addType() {
            Coding t = new Coding();
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            this.type.add(t);
            return t;
        }

        public AuditEventSourceComponent addType(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<Coding>();
            }
            this.type.add(t);
            return this;
        }

        public Coding getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(AuditEvent.SP_SITE, "string", "Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.", 0, 1, this.site));
            children.add(new Property("observer", "Reference(PractitionerRole|Practitioner|Organization|Device|Patient|RelatedPerson)", "Identifier of the source where the event was detected.", 0, 1, this.observer));
            children.add(new Property(AuditEvent.SP_TYPE, "Coding", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3530567: {
                    return new Property(AuditEvent.SP_SITE, "string", "Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.", 0, 1, this.site);
                }
                case 348607190: {
                    return new Property("observer", "Reference(PractitionerRole|Practitioner|Organization|Device|Patient|RelatedPerson)", "Identifier of the source where the event was detected.", 0, 1, this.observer);
                }
                case 3575610: {
                    return new Property(AuditEvent.SP_TYPE, "Coding", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.site;
                    }
                    return baseArray;
                }
                case 348607190: {
                    Base[] baseArray;
                    if (this.observer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.observer;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    this.site = this.castToString(value);
                    return value;
                }
                case 348607190: {
                    this.observer = this.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCoding(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_SITE)) {
                this.site = this.castToString(value);
            } else if (name.equals("observer")) {
                this.observer = this.castToReference(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.getType().add(this.castToCoding(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_SITE)) {
                this.site = null;
            } else if (name.equals("observer")) {
                this.observer = null;
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.getType().remove(this.castToCoding(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return this.getSiteElement();
                }
                case 348607190: {
                    return this.getObserver();
                }
                case 3575610: {
                    return this.addType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return new String[]{"string"};
                }
                case 348607190: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_SITE)) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.site");
            }
            if (name.equals("observer")) {
                this.observer = new Reference();
                return this.observer;
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                return this.addType();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventSourceComponent copy() {
            AuditEventSourceComponent dst = new AuditEventSourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventSourceComponent dst) {
            super.copyValues(dst);
            dst.site = this.site == null ? null : this.site.copy();
            Reference reference = dst.observer = this.observer == null ? null : this.observer.copy();
            if (this.type != null) {
                dst.type = new ArrayList<Coding>();
                for (Coding i : this.type) {
                    dst.type.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other_;
            return AuditEventSourceComponent.compareDeep(this.site, o.site, true) && AuditEventSourceComponent.compareDeep(this.observer, o.observer, true) && AuditEventSourceComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other_;
            return AuditEventSourceComponent.compareValues(this.site, o.site, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.site, this.observer, this.type});
        }

        @Override
        public String fhirType() {
            return "AuditEvent.source";
        }
    }

    @Block
    public static class AuditEventAgentNetworkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="address", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier for the network access point of the user device", formalDefinition="An identifier for the network access point of the user device for the audit event.")
        protected StringType address;
        @Child(name="type", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of network access point", formalDefinition="An identifier for the type of network access point that originated the audit event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/network-type")
        protected Enumeration<AuditEventAgentNetworkType> type;
        private static final long serialVersionUID = -160715924L;

        public StringType getAddressElement() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentNetworkComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new StringType();
                }
            }
            return this.address;
        }

        public boolean hasAddressElement() {
            return this.address != null && !this.address.isEmpty();
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public AuditEventAgentNetworkComponent setAddressElement(StringType value) {
            this.address = value;
            return this;
        }

        public String getAddress() {
            return this.address == null ? null : (String)this.address.getValue();
        }

        public AuditEventAgentNetworkComponent setAddress(String value) {
            if (Utilities.noString((String)value)) {
                this.address = null;
            } else {
                if (this.address == null) {
                    this.address = new StringType();
                }
                this.address.setValue(value);
            }
            return this;
        }

        public Enumeration<AuditEventAgentNetworkType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentNetworkComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<AuditEventAgentNetworkType>(new AuditEventAgentNetworkTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventAgentNetworkComponent setTypeElement(Enumeration<AuditEventAgentNetworkType> value) {
            this.type = value;
            return this;
        }

        public AuditEventAgentNetworkType getType() {
            return this.type == null ? null : (AuditEventAgentNetworkType)((Object)this.type.getValue());
        }

        public AuditEventAgentNetworkComponent setType(AuditEventAgentNetworkType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<AuditEventAgentNetworkType>(new AuditEventAgentNetworkTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(AuditEvent.SP_ADDRESS, "string", "An identifier for the network access point of the user device for the audit event.", 0, 1, this.address));
            children.add(new Property(AuditEvent.SP_TYPE, "code", "An identifier for the type of network access point that originated the audit event.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1147692044: {
                    return new Property(AuditEvent.SP_ADDRESS, "string", "An identifier for the network access point of the user device for the audit event.", 0, 1, this.address);
                }
                case 3575610: {
                    return new Property(AuditEvent.SP_TYPE, "code", "An identifier for the type of network access point that originated the audit event.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.address;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1147692044: {
                    this.address = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new AuditEventAgentNetworkTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_ADDRESS)) {
                this.address = this.castToString(value);
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                value = new AuditEventAgentNetworkTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_ADDRESS)) {
                this.address = null;
            } else if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1147692044: {
                    return this.getAddressElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1147692044: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_ADDRESS)) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.address");
            }
            if (name.equals(AuditEvent.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.type");
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventAgentNetworkComponent copy() {
            AuditEventAgentNetworkComponent dst = new AuditEventAgentNetworkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventAgentNetworkComponent dst) {
            super.copyValues(dst);
            dst.address = this.address == null ? null : this.address.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentNetworkComponent)) {
                return false;
            }
            AuditEventAgentNetworkComponent o = (AuditEventAgentNetworkComponent)other_;
            return AuditEventAgentNetworkComponent.compareDeep(this.address, o.address, true) && AuditEventAgentNetworkComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentNetworkComponent)) {
                return false;
            }
            AuditEventAgentNetworkComponent o = (AuditEventAgentNetworkComponent)other_;
            return AuditEventAgentNetworkComponent.compareValues(this.address, o.address, true) && AuditEventAgentNetworkComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.address, this.type});
        }

        @Override
        public String fhirType() {
            return "AuditEvent.agent.network";
        }
    }

    @Block
    public static class AuditEventAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How agent participated", formalDefinition="Specification of the participation type the user plays when performing the event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Agent role in the event", formalDefinition="The security role that the user was acting under, that come from local codes defined by the access control security system (e.g. RBAC, ABAC) used in the local context.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected List<CodeableConcept> role;
        @Child(name="who", type={PractitionerRole.class, Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of who", formalDefinition="Reference to who this agent is that was involved in the event.")
        protected Reference who;
        protected Resource whoTarget;
        @Child(name="altId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Alternative User identity", formalDefinition="Alternative agent Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.")
        protected StringType altId;
        @Child(name="name", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human friendly name for the agent", formalDefinition="Human-meaningful name for the agent.")
        protected StringType name;
        @Child(name="requestor", type={BooleanType.class}, order=6, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether user is initiator", formalDefinition="Indicator that the user is or is not the requestor, or initiator, for the event being audited.")
        protected BooleanType requestor;
        @Child(name="location", type={Location.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where", formalDefinition="Where the event occurred.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="policy", type={UriType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Policy that authorized event", formalDefinition="The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.")
        protected List<UriType> policy;
        @Child(name="media", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of media", formalDefinition="Type of media involved. Used when the event is about exporting/importing onto media.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/dicm-405-mediatype")
        protected Coding media;
        @Child(name="network", type={}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Logical network location for application activity", formalDefinition="Logical network location for application activity, if the activity has a network location.")
        protected AuditEventAgentNetworkComponent network;
        @Child(name="purposeOfUse", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reason given for this user", formalDefinition="The reason (purpose of use), specific to this agent, that was used during the event being recorded.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<CodeableConcept> purposeOfUse;
        private static final long serialVersionUID = -957410638L;

        public AuditEventAgentComponent() {
        }

        public AuditEventAgentComponent(BooleanType requestor) {
            this.requestor = requestor;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public AuditEventAgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public AuditEventAgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public AuditEventAgentComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public Resource getWhoTarget() {
            return this.whoTarget;
        }

        public AuditEventAgentComponent setWhoTarget(Resource value) {
            this.whoTarget = value;
            return this;
        }

        public StringType getAltIdElement() {
            if (this.altId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.altId");
                }
                if (Configuration.doAutoCreate()) {
                    this.altId = new StringType();
                }
            }
            return this.altId;
        }

        public boolean hasAltIdElement() {
            return this.altId != null && !this.altId.isEmpty();
        }

        public boolean hasAltId() {
            return this.altId != null && !this.altId.isEmpty();
        }

        public AuditEventAgentComponent setAltIdElement(StringType value) {
            this.altId = value;
            return this;
        }

        public String getAltId() {
            return this.altId == null ? null : (String)this.altId.getValue();
        }

        public AuditEventAgentComponent setAltId(String value) {
            if (Utilities.noString((String)value)) {
                this.altId = null;
            } else {
                if (this.altId == null) {
                    this.altId = new StringType();
                }
                this.altId.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public AuditEventAgentComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public AuditEventAgentComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public BooleanType getRequestorElement() {
            if (this.requestor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.requestor");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestor = new BooleanType();
                }
            }
            return this.requestor;
        }

        public boolean hasRequestorElement() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public boolean hasRequestor() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public AuditEventAgentComponent setRequestorElement(BooleanType value) {
            this.requestor = value;
            return this;
        }

        public boolean getRequestor() {
            return this.requestor == null || this.requestor.isEmpty() ? false : (Boolean)this.requestor.getValue();
        }

        public AuditEventAgentComponent setRequestor(boolean value) {
            if (this.requestor == null) {
                this.requestor = new BooleanType();
            }
            this.requestor.setValue((Object)value);
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AuditEventAgentComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public AuditEventAgentComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public List<UriType> getPolicy() {
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            return this.policy;
        }

        public AuditEventAgentComponent setPolicy(List<UriType> thePolicy) {
            this.policy = thePolicy;
            return this;
        }

        public boolean hasPolicy() {
            if (this.policy == null) {
                return false;
            }
            for (UriType item : this.policy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addPolicyElement() {
            UriType t = new UriType();
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return t;
        }

        public AuditEventAgentComponent addPolicy(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return this;
        }

        public boolean hasPolicy(String value) {
            if (this.policy == null) {
                return false;
            }
            for (UriType v : this.policy) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getMedia() {
            if (this.media == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.media");
                }
                if (Configuration.doAutoCreate()) {
                    this.media = new Coding();
                }
            }
            return this.media;
        }

        public boolean hasMedia() {
            return this.media != null && !this.media.isEmpty();
        }

        public AuditEventAgentComponent setMedia(Coding value) {
            this.media = value;
            return this;
        }

        public AuditEventAgentNetworkComponent getNetwork() {
            if (this.network == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.network");
                }
                if (Configuration.doAutoCreate()) {
                    this.network = new AuditEventAgentNetworkComponent();
                }
            }
            return this.network;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public AuditEventAgentComponent setNetwork(AuditEventAgentNetworkComponent value) {
            this.network = value;
            return this;
        }

        public List<CodeableConcept> getPurposeOfUse() {
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<CodeableConcept>();
            }
            return this.purposeOfUse;
        }

        public AuditEventAgentComponent setPurposeOfUse(List<CodeableConcept> thePurposeOfUse) {
            this.purposeOfUse = thePurposeOfUse;
            return this;
        }

        public boolean hasPurposeOfUse() {
            if (this.purposeOfUse == null) {
                return false;
            }
            for (CodeableConcept item : this.purposeOfUse) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addPurposeOfUse() {
            CodeableConcept t = new CodeableConcept();
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<CodeableConcept>();
            }
            this.purposeOfUse.add(t);
            return t;
        }

        public AuditEventAgentComponent addPurposeOfUse(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.purposeOfUse == null) {
                this.purposeOfUse = new ArrayList<CodeableConcept>();
            }
            this.purposeOfUse.add(t);
            return this;
        }

        public CodeableConcept getPurposeOfUseFirstRep() {
            if (this.getPurposeOfUse().isEmpty()) {
                this.addPurposeOfUse();
            }
            return this.getPurposeOfUse().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(AuditEvent.SP_TYPE, "CodeableConcept", "Specification of the participation type the user plays when performing the event.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The security role that the user was acting under, that come from local codes defined by the access control security system (e.g. RBAC, ABAC) used in the local context.", 0, Integer.MAX_VALUE, this.role));
            children.add(new Property("who", "Reference(PractitionerRole|Practitioner|Organization|Device|Patient|RelatedPerson)", "Reference to who this agent is that was involved in the event.", 0, 1, this.who));
            children.add(new Property("altId", "string", "Alternative agent Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.", 0, 1, this.altId));
            children.add(new Property("name", "string", "Human-meaningful name for the agent.", 0, 1, this.name));
            children.add(new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, 1, this.requestor));
            children.add(new Property("location", "Reference(Location)", "Where the event occurred.", 0, 1, this.location));
            children.add(new Property(AuditEvent.SP_POLICY, "uri", "The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.", 0, Integer.MAX_VALUE, this.policy));
            children.add(new Property("media", "Coding", "Type of media involved. Used when the event is about exporting/importing onto media.", 0, 1, this.media));
            children.add(new Property("network", "", "Logical network location for application activity, if the activity has a network location.", 0, 1, this.network));
            children.add(new Property("purposeOfUse", "CodeableConcept", "The reason (purpose of use), specific to this agent, that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfUse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(AuditEvent.SP_TYPE, "CodeableConcept", "Specification of the participation type the user plays when performing the event.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The security role that the user was acting under, that come from local codes defined by the access control security system (e.g. RBAC, ABAC) used in the local context.", 0, Integer.MAX_VALUE, this.role);
                }
                case 117694: {
                    return new Property("who", "Reference(PractitionerRole|Practitioner|Organization|Device|Patient|RelatedPerson)", "Reference to who this agent is that was involved in the event.", 0, 1, this.who);
                }
                case 92912804: {
                    return new Property("altId", "string", "Alternative agent Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.", 0, 1, this.altId);
                }
                case 3373707: {
                    return new Property("name", "string", "Human-meaningful name for the agent.", 0, 1, this.name);
                }
                case 693934258: {
                    return new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, 1, this.requestor);
                }
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "Where the event occurred.", 0, 1, this.location);
                }
                case -982670030: {
                    return new Property(AuditEvent.SP_POLICY, "uri", "The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.", 0, Integer.MAX_VALUE, this.policy);
                }
                case 103772132: {
                    return new Property("media", "Coding", "Type of media involved. Used when the event is about exporting/importing onto media.", 0, 1, this.media);
                }
                case 1843485230: {
                    return new Property("network", "", "Logical network location for application activity, if the activity has a network location.", 0, 1, this.network);
                }
                case -1881902670: {
                    return new Property("purposeOfUse", "CodeableConcept", "The reason (purpose of use), specific to this agent, that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.purposeOfUse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.who;
                    }
                    return baseArray;
                }
                case 92912804: {
                    Base[] baseArray;
                    if (this.altId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.altId;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.name;
                    }
                    return baseArray;
                }
                case 693934258: {
                    Base[] baseArray;
                    if (this.requestor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requestor;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.location;
                    }
                    return baseArray;
                }
                case -982670030: {
                    return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
                }
                case 103772132: {
                    Base[] baseArray;
                    if (this.media == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.media;
                    }
                    return baseArray;
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.network;
                    }
                    return baseArray;
                }
                case -1881902670: {
                    return this.purposeOfUse == null ? new Base[]{} : this.purposeOfUse.toArray(new Base[this.purposeOfUse.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 117694: {
                    this.who = this.castToReference(value);
                    return value;
                }
                case 92912804: {
                    this.altId = this.castToString(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 693934258: {
                    this.requestor = this.castToBoolean(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToReference(value);
                    return value;
                }
                case -982670030: {
                    this.getPolicy().add(this.castToUri(value));
                    return value;
                }
                case 103772132: {
                    this.media = this.castToCoding(value);
                    return value;
                }
                case 1843485230: {
                    this.network = (AuditEventAgentNetworkComponent)value;
                    return value;
                }
                case -1881902670: {
                    this.getPurposeOfUse().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else if (name.equals("who")) {
                this.who = this.castToReference(value);
            } else if (name.equals("altId")) {
                this.altId = this.castToString(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("requestor")) {
                this.requestor = this.castToBoolean(value);
            } else if (name.equals("location")) {
                this.location = this.castToReference(value);
            } else if (name.equals(AuditEvent.SP_POLICY)) {
                this.getPolicy().add(this.castToUri(value));
            } else if (name.equals("media")) {
                this.media = this.castToCoding(value);
            } else if (name.equals("network")) {
                this.network = (AuditEventAgentNetworkComponent)value;
            } else if (name.equals("purposeOfUse")) {
                this.getPurposeOfUse().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = null;
            } else if (name.equals("role")) {
                this.getRole().remove(this.castToCodeableConcept(value));
            } else if (name.equals("who")) {
                this.who = null;
            } else if (name.equals("altId")) {
                this.altId = null;
            } else if (name.equals("name")) {
                this.name = null;
            } else if (name.equals("requestor")) {
                this.requestor = null;
            } else if (name.equals("location")) {
                this.location = null;
            } else if (name.equals(AuditEvent.SP_POLICY)) {
                this.getPolicy().remove(this.castToUri(value));
            } else if (name.equals("media")) {
                this.media = null;
            } else if (name.equals("network")) {
                this.network = (AuditEventAgentNetworkComponent)value;
            } else if (name.equals("purposeOfUse")) {
                this.getPurposeOfUse().remove(this.castToCodeableConcept(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3506294: {
                    return this.addRole();
                }
                case 117694: {
                    return this.getWho();
                }
                case 92912804: {
                    return this.getAltIdElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 693934258: {
                    return this.getRequestorElement();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -982670030: {
                    return this.addPolicyElement();
                }
                case 103772132: {
                    return this.getMedia();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case -1881902670: {
                    return this.addPurposeOfUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 117694: {
                    return new String[]{"Reference"};
                }
                case 92912804: {
                    return new String[]{"string"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 693934258: {
                    return new String[]{"boolean"};
                }
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case -982670030: {
                    return new String[]{"uri"};
                }
                case 103772132: {
                    return new String[]{"Coding"};
                }
                case 1843485230: {
                    return new String[0];
                }
                case -1881902670: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("altId")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.altId");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.name");
            }
            if (name.equals("requestor")) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.requestor");
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(AuditEvent.SP_POLICY)) {
                throw new FHIRException("Cannot call addChild on a singleton property AuditEvent.policy");
            }
            if (name.equals("media")) {
                this.media = new Coding();
                return this.media;
            }
            if (name.equals("network")) {
                this.network = new AuditEventAgentNetworkComponent();
                return this.network;
            }
            if (name.equals("purposeOfUse")) {
                return this.addPurposeOfUse();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventAgentComponent copy() {
            AuditEventAgentComponent dst = new AuditEventAgentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventAgentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.role) {
                    dst.role.add(codeableConcept2.copy());
                }
            }
            dst.who = this.who == null ? null : this.who.copy();
            dst.altId = this.altId == null ? null : this.altId.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.requestor = this.requestor == null ? null : this.requestor.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.policy != null) {
                dst.policy = new ArrayList<UriType>();
                for (UriType uriType : this.policy) {
                    dst.policy.add(uriType.copy());
                }
            }
            dst.media = this.media == null ? null : this.media.copy();
            AuditEventAgentNetworkComponent auditEventAgentNetworkComponent = dst.network = this.network == null ? null : this.network.copy();
            if (this.purposeOfUse != null) {
                dst.purposeOfUse = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.purposeOfUse) {
                    dst.purposeOfUse.add(codeableConcept3.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentComponent)) {
                return false;
            }
            AuditEventAgentComponent o = (AuditEventAgentComponent)other_;
            return AuditEventAgentComponent.compareDeep(this.type, o.type, true) && AuditEventAgentComponent.compareDeep(this.role, o.role, true) && AuditEventAgentComponent.compareDeep(this.who, o.who, true) && AuditEventAgentComponent.compareDeep(this.altId, o.altId, true) && AuditEventAgentComponent.compareDeep(this.name, o.name, true) && AuditEventAgentComponent.compareDeep(this.requestor, o.requestor, true) && AuditEventAgentComponent.compareDeep(this.location, o.location, true) && AuditEventAgentComponent.compareDeep(this.policy, o.policy, true) && AuditEventAgentComponent.compareDeep(this.media, o.media, true) && AuditEventAgentComponent.compareDeep(this.network, o.network, true) && AuditEventAgentComponent.compareDeep(this.purposeOfUse, o.purposeOfUse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentComponent)) {
                return false;
            }
            AuditEventAgentComponent o = (AuditEventAgentComponent)other_;
            return AuditEventAgentComponent.compareValues(this.altId, o.altId, true) && AuditEventAgentComponent.compareValues(this.name, o.name, true) && AuditEventAgentComponent.compareValues(this.requestor, o.requestor, true) && AuditEventAgentComponent.compareValues(this.policy, o.policy, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.role, this.who, this.altId, this.name, this.requestor, this.location, this.policy, this.media, this.network, this.purposeOfUse});
        }

        @Override
        public String fhirType() {
            return "AuditEvent.agent";
        }
    }

    public static class AuditEventAgentNetworkTypeEnumFactory
    implements EnumFactory<AuditEventAgentNetworkType> {
        @Override
        public AuditEventAgentNetworkType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("1".equals(codeString)) {
                return AuditEventAgentNetworkType._1;
            }
            if ("2".equals(codeString)) {
                return AuditEventAgentNetworkType._2;
            }
            if ("3".equals(codeString)) {
                return AuditEventAgentNetworkType._3;
            }
            if ("4".equals(codeString)) {
                return AuditEventAgentNetworkType._4;
            }
            if ("5".equals(codeString)) {
                return AuditEventAgentNetworkType._5;
            }
            throw new IllegalArgumentException("Unknown AuditEventAgentNetworkType code '" + codeString + "'");
        }

        public Enumeration<AuditEventAgentNetworkType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType.NULL, code);
            }
            if ("1".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType._1, code);
            }
            if ("2".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType._2, code);
            }
            if ("3".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType._3, code);
            }
            if ("4".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType._4, code);
            }
            if ("5".equals(codeString)) {
                return new Enumeration<AuditEventAgentNetworkType>(this, AuditEventAgentNetworkType._5, code);
            }
            throw new FHIRException("Unknown AuditEventAgentNetworkType code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventAgentNetworkType code) {
            if (code == AuditEventAgentNetworkType._1) {
                return "1";
            }
            if (code == AuditEventAgentNetworkType._2) {
                return "2";
            }
            if (code == AuditEventAgentNetworkType._3) {
                return "3";
            }
            if (code == AuditEventAgentNetworkType._4) {
                return "4";
            }
            if (code == AuditEventAgentNetworkType._5) {
                return "5";
            }
            return "?";
        }

        @Override
        public String toSystem(AuditEventAgentNetworkType code) {
            return code.getSystem();
        }
    }

    public static enum AuditEventAgentNetworkType {
        _1,
        _2,
        _3,
        _4,
        _5,
        NULL;


        public static AuditEventAgentNetworkType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("1".equals(codeString)) {
                return _1;
            }
            if ("2".equals(codeString)) {
                return _2;
            }
            if ("3".equals(codeString)) {
                return _3;
            }
            if ("4".equals(codeString)) {
                return _4;
            }
            if ("5".equals(codeString)) {
                return _5;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AuditEventAgentNetworkType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
                case _5: {
                    return "5";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _1: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _2: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _3: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _4: {
                    return "http://hl7.org/fhir/network-type";
                }
                case _5: {
                    return "http://hl7.org/fhir/network-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _1: {
                    return "The machine name, including DNS name.";
                }
                case _2: {
                    return "The assigned Internet Protocol (IP) address.";
                }
                case _3: {
                    return "The assigned telephone number.";
                }
                case _4: {
                    return "The assigned email address.";
                }
                case _5: {
                    return "URI (User directory, HTTP-PUT, ftp, etc.).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _1: {
                    return "Machine Name";
                }
                case _2: {
                    return "IP Address";
                }
                case _3: {
                    return "Telephone Number";
                }
                case _4: {
                    return "Email address";
                }
                case _5: {
                    return "URI";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AuditEventOutcomeEnumFactory
    implements EnumFactory<AuditEventOutcome> {
        @Override
        public AuditEventOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("0".equals(codeString)) {
                return AuditEventOutcome._0;
            }
            if ("4".equals(codeString)) {
                return AuditEventOutcome._4;
            }
            if ("8".equals(codeString)) {
                return AuditEventOutcome._8;
            }
            if ("12".equals(codeString)) {
                return AuditEventOutcome._12;
            }
            throw new IllegalArgumentException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        public Enumeration<AuditEventOutcome> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome.NULL, code);
            }
            if ("0".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._0, code);
            }
            if ("4".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._4, code);
            }
            if ("8".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._8, code);
            }
            if ("12".equals(codeString)) {
                return new Enumeration<AuditEventOutcome>(this, AuditEventOutcome._12, code);
            }
            throw new FHIRException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventOutcome code) {
            if (code == AuditEventOutcome._0) {
                return "0";
            }
            if (code == AuditEventOutcome._4) {
                return "4";
            }
            if (code == AuditEventOutcome._8) {
                return "8";
            }
            if (code == AuditEventOutcome._12) {
                return "12";
            }
            return "?";
        }

        @Override
        public String toSystem(AuditEventOutcome code) {
            return code.getSystem();
        }
    }

    public static enum AuditEventOutcome {
        _0,
        _4,
        _8,
        _12,
        NULL;


        public static AuditEventOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("0".equals(codeString)) {
                return _0;
            }
            if ("4".equals(codeString)) {
                return _4;
            }
            if ("8".equals(codeString)) {
                return _8;
            }
            if ("12".equals(codeString)) {
                return _12;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AuditEventOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case _0: {
                    return "0";
                }
                case _4: {
                    return "4";
                }
                case _8: {
                    return "8";
                }
                case _12: {
                    return "12";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case _0: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _4: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _8: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case _12: {
                    return "http://hl7.org/fhir/audit-event-outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case _0: {
                    return "The operation completed successfully (whether with warnings or not).";
                }
                case _4: {
                    return "The action was not successful due to some kind of minor failure (often equivalent to an HTTP 400 response).";
                }
                case _8: {
                    return "The action was not successful due to some kind of unexpected error (often equivalent to an HTTP 500 response).";
                }
                case _12: {
                    return "An error of such magnitude occurred that the system is no longer available for use (i.e. the system died).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case _0: {
                    return "Success";
                }
                case _4: {
                    return "Minor failure";
                }
                case _8: {
                    return "Serious failure";
                }
                case _12: {
                    return "Major failure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AuditEventActionEnumFactory
    implements EnumFactory<AuditEventAction> {
        @Override
        public AuditEventAction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("C".equals(codeString)) {
                return AuditEventAction.C;
            }
            if ("R".equals(codeString)) {
                return AuditEventAction.R;
            }
            if ("U".equals(codeString)) {
                return AuditEventAction.U;
            }
            if ("D".equals(codeString)) {
                return AuditEventAction.D;
            }
            if ("E".equals(codeString)) {
                return AuditEventAction.E;
            }
            throw new IllegalArgumentException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public Enumeration<AuditEventAction> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.NULL, code);
            }
            if ("C".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.C, code);
            }
            if ("R".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.R, code);
            }
            if ("U".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.U, code);
            }
            if ("D".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.D, code);
            }
            if ("E".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.E, code);
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventAction code) {
            if (code == AuditEventAction.C) {
                return "C";
            }
            if (code == AuditEventAction.R) {
                return "R";
            }
            if (code == AuditEventAction.U) {
                return "U";
            }
            if (code == AuditEventAction.D) {
                return "D";
            }
            if (code == AuditEventAction.E) {
                return "E";
            }
            return "?";
        }

        @Override
        public String toSystem(AuditEventAction code) {
            return code.getSystem();
        }
    }

    public static enum AuditEventAction {
        C,
        R,
        U,
        D,
        E,
        NULL;


        public static AuditEventAction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("C".equals(codeString)) {
                return C;
            }
            if ("R".equals(codeString)) {
                return R;
            }
            if ("U".equals(codeString)) {
                return U;
            }
            if ("D".equals(codeString)) {
                return D;
            }
            if ("E".equals(codeString)) {
                return E;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case C: {
                    return "C";
                }
                case R: {
                    return "R";
                }
                case U: {
                    return "U";
                }
                case D: {
                    return "D";
                }
                case E: {
                    return "E";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case C: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case R: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case U: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case D: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case E: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case C: {
                    return "Create a new database object, such as placing an order.";
                }
                case R: {
                    return "Display or print data, such as a doctor census.";
                }
                case U: {
                    return "Update data, such as revise patient information.";
                }
                case D: {
                    return "Delete items, such as a doctor master file record.";
                }
                case E: {
                    return "Perform a system or application function such as log-on, program execution or use of an object's method, or perform a query/search operation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case C: {
                    return "Create";
                }
                case R: {
                    return "Read/View/Print";
                }
                case U: {
                    return "Update";
                }
                case D: {
                    return "Delete";
                }
                case E: {
                    return "Execute";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

