/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class HTMLClientLogger
implements ToolingClientLogger {
    private PrintStream file;
    private int id = 0;
    private String lastId;

    public HTMLClientLogger(String log) throws IOException {
        if (log != null) {
            try {
                this.file = new PrintStream(ManagedFileAccess.outStream((String)log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        if (this.file == null) {
            return;
        }
        ++this.id;
        this.lastId = Integer.toString(this.id);
        this.file.println("<hr/><a name=\"l" + this.lastId + "\"> </a>");
        this.file.println("<pre>");
        this.file.println(method + " " + url + " HTTP/1.0");
        for (String s : headers) {
            this.file.println(Utilities.escapeXml((String)s));
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml((String)new String(body, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.file.println("</pre>");
    }

    public void logResponse(String outcome, List<String> headers, byte[] body, long start) {
        if (this.file == null) {
            return;
        }
        this.file.println("<pre>");
        this.file.println(outcome);
        for (String s : headers) {
            this.file.println(Utilities.escapeXml((String)s));
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml((String)new String(body, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.file.println("</pre>");
    }

    public String getLastId() {
        return this.lastId;
    }

    public void clearLastId() {
        this.lastId = null;
    }
}

