/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MedicationAdminCategory;

public class MedicationAdminCategoryEnumFactory
implements EnumFactory<MedicationAdminCategory> {
    @Override
    public MedicationAdminCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return MedicationAdminCategory.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return MedicationAdminCategory.OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return MedicationAdminCategory.COMMUNITY;
        }
        throw new IllegalArgumentException("Unknown MedicationAdminCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationAdminCategory code) {
        if (code == MedicationAdminCategory.NULL) {
            return null;
        }
        if (code == MedicationAdminCategory.INPATIENT) {
            return "inpatient";
        }
        if (code == MedicationAdminCategory.OUTPATIENT) {
            return "outpatient";
        }
        if (code == MedicationAdminCategory.COMMUNITY) {
            return "community";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationAdminCategory code) {
        return code.getSystem();
    }
}

