/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ParameterGroup;

public class ParameterGroupEnumFactory
implements EnumFactory<ParameterGroup> {
    @Override
    public ParameterGroup fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("haemodynamic".equals(codeString)) {
            return ParameterGroup.HAEMODYNAMIC;
        }
        if ("ecg".equals(codeString)) {
            return ParameterGroup.ECG;
        }
        if ("respiratory".equals(codeString)) {
            return ParameterGroup.RESPIRATORY;
        }
        if ("ventilation".equals(codeString)) {
            return ParameterGroup.VENTILATION;
        }
        if ("neurological".equals(codeString)) {
            return ParameterGroup.NEUROLOGICAL;
        }
        if ("drug-delivery".equals(codeString)) {
            return ParameterGroup.DRUGDELIVERY;
        }
        if ("fluid-chemistry".equals(codeString)) {
            return ParameterGroup.FLUIDCHEMISTRY;
        }
        if ("blood-chemistry".equals(codeString)) {
            return ParameterGroup.BLOODCHEMISTRY;
        }
        if ("miscellaneous".equals(codeString)) {
            return ParameterGroup.MISCELLANEOUS;
        }
        throw new IllegalArgumentException("Unknown ParameterGroup code '" + codeString + "'");
    }

    @Override
    public String toCode(ParameterGroup code) {
        if (code == ParameterGroup.NULL) {
            return null;
        }
        if (code == ParameterGroup.HAEMODYNAMIC) {
            return "haemodynamic";
        }
        if (code == ParameterGroup.ECG) {
            return "ecg";
        }
        if (code == ParameterGroup.RESPIRATORY) {
            return "respiratory";
        }
        if (code == ParameterGroup.VENTILATION) {
            return "ventilation";
        }
        if (code == ParameterGroup.NEUROLOGICAL) {
            return "neurological";
        }
        if (code == ParameterGroup.DRUGDELIVERY) {
            return "drug-delivery";
        }
        if (code == ParameterGroup.FLUIDCHEMISTRY) {
            return "fluid-chemistry";
        }
        if (code == ParameterGroup.BLOODCHEMISTRY) {
            return "blood-chemistry";
        }
        if (code == ParameterGroup.MISCELLANEOUS) {
            return "miscellaneous";
        }
        return "?";
    }

    @Override
    public String toSystem(ParameterGroup code) {
        return code.getSystem();
    }
}

