/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.SearchXpathUsage;

public class SearchXpathUsageEnumFactory
implements EnumFactory<SearchXpathUsage> {
    @Override
    public SearchXpathUsage fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("normal".equals(codeString)) {
            return SearchXpathUsage.NORMAL;
        }
        if ("phonetic".equals(codeString)) {
            return SearchXpathUsage.PHONETIC;
        }
        if ("nearby".equals(codeString)) {
            return SearchXpathUsage.NEARBY;
        }
        if ("distance".equals(codeString)) {
            return SearchXpathUsage.DISTANCE;
        }
        if ("other".equals(codeString)) {
            return SearchXpathUsage.OTHER;
        }
        throw new IllegalArgumentException("Unknown SearchXpathUsage code '" + codeString + "'");
    }

    @Override
    public String toCode(SearchXpathUsage code) {
        if (code == SearchXpathUsage.NULL) {
            return null;
        }
        if (code == SearchXpathUsage.NORMAL) {
            return "normal";
        }
        if (code == SearchXpathUsage.PHONETIC) {
            return "phonetic";
        }
        if (code == SearchXpathUsage.NEARBY) {
            return "nearby";
        }
        if (code == SearchXpathUsage.DISTANCE) {
            return "distance";
        }
        if (code == SearchXpathUsage.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(SearchXpathUsage code) {
        return code.getSystem();
    }
}

