/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.SpecialValues;

public class SpecialValuesEnumFactory
implements EnumFactory<SpecialValues> {
    @Override
    public SpecialValues fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("true".equals(codeString)) {
            return SpecialValues.TRUE;
        }
        if ("false".equals(codeString)) {
            return SpecialValues.FALSE;
        }
        if ("trace".equals(codeString)) {
            return SpecialValues.TRACE;
        }
        if ("sufficient".equals(codeString)) {
            return SpecialValues.SUFFICIENT;
        }
        if ("withdrawn".equals(codeString)) {
            return SpecialValues.WITHDRAWN;
        }
        if ("nil-known".equals(codeString)) {
            return SpecialValues.NILKNOWN;
        }
        throw new IllegalArgumentException("Unknown SpecialValues code '" + codeString + "'");
    }

    @Override
    public String toCode(SpecialValues code) {
        if (code == SpecialValues.NULL) {
            return null;
        }
        if (code == SpecialValues.TRUE) {
            return "true";
        }
        if (code == SpecialValues.FALSE) {
            return "false";
        }
        if (code == SpecialValues.TRACE) {
            return "trace";
        }
        if (code == SpecialValues.SUFFICIENT) {
            return "sufficient";
        }
        if (code == SpecialValues.WITHDRAWN) {
            return "withdrawn";
        }
        if (code == SpecialValues.NILKNOWN) {
            return "nil-known";
        }
        return "?";
    }

    @Override
    public String toSystem(SpecialValues code) {
        return code.getSystem();
    }
}

