/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.client.network;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r4.utils.ResourceUtilities;
import org.hl7.fhir.r4.utils.client.EFhirClientException;
import org.hl7.fhir.r4.utils.client.ResourceFormat;
import org.hl7.fhir.r4.utils.client.network.FhirLoggingInterceptor;
import org.hl7.fhir.r4.utils.client.network.ResourceRequest;
import org.hl7.fhir.r4.utils.client.network.RetryInterceptor;
import org.hl7.fhir.utilities.MimeType;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.xhtml.XhtmlUtils;

public class FhirRequestBuilder {
    protected static final String HTTP_PROXY_USER = "http.proxyUser";
    protected static final String HTTP_PROXY_PASS = "http.proxyPassword";
    protected static final String HEADER_PROXY_AUTH = "Proxy-Authorization";
    protected static final String LOCATION_HEADER = "location";
    protected static final String CONTENT_LOCATION_HEADER = "content-location";
    protected static final String DEFAULT_CHARSET = "UTF-8";
    private static OkHttpClient okHttpClient;
    private final Request.Builder httpRequest;
    private String resourceFormat = null;
    private Headers headers = null;
    private String message = null;
    private int retryCount = 1;
    private long timeout = 5000L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private FhirLoggingInterceptor logger = null;
    private String source;

    public FhirRequestBuilder(Request.Builder httpRequest, String source) {
        this.httpRequest = httpRequest;
        this.source = source;
    }

    protected static void formatHeaders(Request.Builder request, String format, Headers headers) {
        FhirRequestBuilder.addDefaultHeaders(request, headers);
        if (format != null) {
            FhirRequestBuilder.addResourceFormatHeaders(request, format);
        }
        if (headers != null) {
            FhirRequestBuilder.addHeaders(request, headers);
        }
    }

    protected static void addDefaultHeaders(Request.Builder request, Headers headers) {
        if (headers == null || !headers.names().contains("User-Agent")) {
            request.addHeader("User-Agent", "hapi-fhir-tooling-client");
        }
    }

    protected static void addResourceFormatHeaders(Request.Builder request, String format) {
        request.addHeader("Accept", format);
        request.addHeader("Content-Type", format + ";charset=UTF-8");
    }

    protected static void addHeaders(Request.Builder request, Headers headers) {
        headers.forEach(header -> request.addHeader((String)header.getFirst(), (String)header.getSecond()));
    }

    protected static boolean hasError(OperationOutcome oo) {
        return oo.getIssue().stream().anyMatch(issue -> issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR || issue.getSeverity() == OperationOutcome.IssueSeverity.FATAL);
    }

    protected static String getLocationHeader(Headers headers) {
        Map headerMap = headers.toMultimap();
        if (headerMap.containsKey(LOCATION_HEADER)) {
            return (String)((List)headerMap.get(LOCATION_HEADER)).get(0);
        }
        if (headerMap.containsKey(CONTENT_LOCATION_HEADER)) {
            return (String)((List)headerMap.get(CONTENT_LOCATION_HEADER)).get(0);
        }
        return null;
    }

    protected OkHttpClient getHttpClient() {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient();
        }
        Authenticator proxyAuthenticator = FhirRequestBuilder.getAuthenticator();
        OkHttpClient.Builder builder = okHttpClient.newBuilder();
        if (this.logger != null) {
            builder.addInterceptor((Interceptor)this.logger);
        }
        builder.addInterceptor((Interceptor)new RetryInterceptor(this.retryCount));
        return builder.connectTimeout(this.timeout, this.timeoutUnit).addInterceptor((Interceptor)new RetryInterceptor(this.retryCount)).connectTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).readTimeout(this.timeout, this.timeoutUnit).proxyAuthenticator(proxyAuthenticator).build();
    }

    @Nonnull
    private static Authenticator getAuthenticator() {
        return (route, response) -> {
            String httpProxyUser = System.getProperty(HTTP_PROXY_USER);
            String httpProxyPass = System.getProperty(HTTP_PROXY_PASS);
            if (httpProxyUser != null && httpProxyPass != null) {
                String credential = Credentials.basic((String)httpProxyUser, (String)httpProxyPass);
                return response.request().newBuilder().header(HEADER_PROXY_AUTH, credential).build();
            }
            return response.request().newBuilder().build();
        };
    }

    public FhirRequestBuilder withResourceFormat(String resourceFormat) {
        this.resourceFormat = resourceFormat;
        return this;
    }

    public FhirRequestBuilder withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public FhirRequestBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public FhirRequestBuilder withRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public FhirRequestBuilder withLogger(FhirLoggingInterceptor logger) {
        this.logger = logger;
        return this;
    }

    public FhirRequestBuilder withTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected Request buildRequest() {
        return this.httpRequest.build();
    }

    public <T extends Resource> ResourceRequest<T> execute() throws IOException {
        FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, this.headers);
        Response response = this.getHttpClient().newCall(this.httpRequest.build()).execute();
        T resource = this.unmarshalReference(response, this.resourceFormat, null);
        return new ResourceRequest<T>(resource, response.code(), FhirRequestBuilder.getLocationHeader(response.headers()));
    }

    public Bundle executeAsBatch() throws IOException {
        FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, null);
        Response response = this.getHttpClient().newCall(this.httpRequest.build()).execute();
        return this.unmarshalFeed(response, this.resourceFormat);
    }

    protected <T extends Resource> T unmarshalReference(Response response, String format, String resourceType) {
        String body;
        boolean ok;
        int code = response.code();
        boolean bl = ok = code >= 200 && code < 300;
        if (response.body() == null) {
            if (!ok) {
                throw new EFhirClientException(response.message());
            }
            return null;
        }
        Resource resource = null;
        try {
            body = response.body().string();
            String ct = response.header("Content-Type");
            if (ct == null) {
                if (ok) {
                    resource = this.getParser(format).parse(body);
                } else {
                    System.out.println("Got error response with no Content-Type from " + this.source + " with status " + code);
                    System.out.println(body);
                    resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                }
            } else {
                if (ct.contains(";")) {
                    ct = ct.substring(0, ct.indexOf(";"));
                }
                switch (ct) {
                    case "application/json": 
                    case "application/fhir+json": {
                        if (!format.contains("json")) {
                            System.out.println("Got json response expecting " + format + " from " + this.source + " with status " + code);
                        }
                        resource = this.getParser(ResourceFormat.RESOURCE_JSON.getHeader()).parse(body);
                        break;
                    }
                    case "application/xml": 
                    case "application/fhir+xml": 
                    case "text/xml": {
                        if (!format.contains("xml")) {
                            System.out.println("Got xml response expecting " + format + " from " + this.source + " with status " + code);
                        }
                        resource = this.getParser(ResourceFormat.RESOURCE_XML.getHeader()).parse(response.body().bytes());
                        break;
                    }
                    case "text/plain": {
                        resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                        break;
                    }
                    case "text/html": {
                        resource = OperationOutcomeUtilities.outcomeFromTextError(XhtmlUtils.convertHtmlToText((String)response.body().string(), (String)this.source));
                        break;
                    }
                    default: {
                        System.out.println("Got content-type '" + ct + "' from " + this.source);
                        System.out.println(body);
                        resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new EFhirClientException(code, "Error reading Http Response from " + this.source + ":" + ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            throw new EFhirClientException(code, "Error parsing response message from " + this.source + ": " + e.getMessage(), e);
        }
        if (!(!(resource instanceof OperationOutcome) || "OperationOutcome".equals(resourceType) && ok)) {
            OperationOutcome error = (OperationOutcome)resource;
            if (FhirRequestBuilder.hasError((OperationOutcome)resource)) {
                throw new EFhirClientException(code, "Error from " + this.source + ": " + ResourceUtilities.getErrorDescription(error), error);
            }
            System.out.println("Got OperationOutcome with no error from " + this.source + " with status " + code);
            System.out.println(body);
            return null;
        }
        if (resource == null) {
            System.out.println("No resource from " + this.source + " with status " + code);
            System.out.println(body);
            return null;
        }
        if (resourceType != null && !resource.fhirType().equals(resourceType)) {
            throw new EFhirClientException("Error parsing response message from " + this.source + ": Found an " + resource.fhirType() + " looking for a " + resourceType);
        }
        return (T)resource;
    }

    protected Bundle unmarshalFeed(Response response, String format) {
        return (Bundle)this.unmarshalReference(response, format, "Bundle");
    }

    protected IParser getParser(String format) {
        MimeType mt;
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if ((mt = new MimeType(format)).getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (mt.getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + format);
    }
}

