/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CompositionAltcodeKind;

public class CompositionAltcodeKindEnumFactory
implements EnumFactory<CompositionAltcodeKind> {
    @Override
    public CompositionAltcodeKind fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("alternate".equals(codeString)) {
            return CompositionAltcodeKind.ALTERNATE;
        }
        if ("deprecated".equals(codeString)) {
            return CompositionAltcodeKind.DEPRECATED;
        }
        if ("case-insensitive".equals(codeString)) {
            return CompositionAltcodeKind.CASEINSENSITIVE;
        }
        if ("case-sensitive".equals(codeString)) {
            return CompositionAltcodeKind.CASESENSITIVE;
        }
        if ("expression".equals(codeString)) {
            return CompositionAltcodeKind.EXPRESSION;
        }
        throw new IllegalArgumentException("Unknown CompositionAltcodeKind code '" + codeString + "'");
    }

    @Override
    public String toCode(CompositionAltcodeKind code) {
        if (code == CompositionAltcodeKind.NULL) {
            return null;
        }
        if (code == CompositionAltcodeKind.ALTERNATE) {
            return "alternate";
        }
        if (code == CompositionAltcodeKind.DEPRECATED) {
            return "deprecated";
        }
        if (code == CompositionAltcodeKind.CASEINSENSITIVE) {
            return "case-insensitive";
        }
        if (code == CompositionAltcodeKind.CASESENSITIVE) {
            return "case-sensitive";
        }
        if (code == CompositionAltcodeKind.EXPRESSION) {
            return "expression";
        }
        return "?";
    }

    @Override
    public String toSystem(CompositionAltcodeKind code) {
        return code.getSystem();
    }
}

