/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.EvidenceVariantState;

public class EvidenceVariantStateEnumFactory
implements EnumFactory<EvidenceVariantState> {
    @Override
    public EvidenceVariantState fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("low-risk".equals(codeString)) {
            return EvidenceVariantState.LOWRISK;
        }
        if ("medium-risk".equals(codeString)) {
            return EvidenceVariantState.MEDIUMRISK;
        }
        if ("high-risk".equals(codeString)) {
            return EvidenceVariantState.HIGHRISK;
        }
        throw new IllegalArgumentException("Unknown EvidenceVariantState code '" + codeString + "'");
    }

    @Override
    public String toCode(EvidenceVariantState code) {
        if (code == EvidenceVariantState.NULL) {
            return null;
        }
        if (code == EvidenceVariantState.LOWRISK) {
            return "low-risk";
        }
        if (code == EvidenceVariantState.MEDIUMRISK) {
            return "medium-risk";
        }
        if (code == EvidenceVariantState.HIGHRISK) {
            return "high-risk";
        }
        return "?";
    }

    @Override
    public String toSystem(EvidenceVariantState code) {
        return code.getSystem();
    }
}

