/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.SmartCapabilities;

public class SmartCapabilitiesEnumFactory
implements EnumFactory<SmartCapabilities> {
    @Override
    public SmartCapabilities fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("launch-ehr".equals(codeString)) {
            return SmartCapabilities.LAUNCHEHR;
        }
        if ("launch-standalone".equals(codeString)) {
            return SmartCapabilities.LAUNCHSTANDALONE;
        }
        if ("client-public".equals(codeString)) {
            return SmartCapabilities.CLIENTPUBLIC;
        }
        if ("client-confidential-symmetric".equals(codeString)) {
            return SmartCapabilities.CLIENTCONFIDENTIALSYMMETRIC;
        }
        if ("sso-openid-connect".equals(codeString)) {
            return SmartCapabilities.SSOOPENIDCONNECT;
        }
        if ("context-passthrough-banner".equals(codeString)) {
            return SmartCapabilities.CONTEXTPASSTHROUGHBANNER;
        }
        if ("context-passthrough-style".equals(codeString)) {
            return SmartCapabilities.CONTEXTPASSTHROUGHSTYLE;
        }
        if ("context-ehr-patient".equals(codeString)) {
            return SmartCapabilities.CONTEXTEHRPATIENT;
        }
        if ("context-ehr-encounter".equals(codeString)) {
            return SmartCapabilities.CONTEXTEHRENCOUNTER;
        }
        if ("context-standalone-patient".equals(codeString)) {
            return SmartCapabilities.CONTEXTSTANDALONEPATIENT;
        }
        if ("context-standalone-encounter".equals(codeString)) {
            return SmartCapabilities.CONTEXTSTANDALONEENCOUNTER;
        }
        if ("permission-offline".equals(codeString)) {
            return SmartCapabilities.PERMISSIONOFFLINE;
        }
        if ("permission-patient".equals(codeString)) {
            return SmartCapabilities.PERMISSIONPATIENT;
        }
        if ("permission-user".equals(codeString)) {
            return SmartCapabilities.PERMISSIONUSER;
        }
        throw new IllegalArgumentException("Unknown SmartCapabilities code '" + codeString + "'");
    }

    @Override
    public String toCode(SmartCapabilities code) {
        if (code == SmartCapabilities.NULL) {
            return null;
        }
        if (code == SmartCapabilities.LAUNCHEHR) {
            return "launch-ehr";
        }
        if (code == SmartCapabilities.LAUNCHSTANDALONE) {
            return "launch-standalone";
        }
        if (code == SmartCapabilities.CLIENTPUBLIC) {
            return "client-public";
        }
        if (code == SmartCapabilities.CLIENTCONFIDENTIALSYMMETRIC) {
            return "client-confidential-symmetric";
        }
        if (code == SmartCapabilities.SSOOPENIDCONNECT) {
            return "sso-openid-connect";
        }
        if (code == SmartCapabilities.CONTEXTPASSTHROUGHBANNER) {
            return "context-passthrough-banner";
        }
        if (code == SmartCapabilities.CONTEXTPASSTHROUGHSTYLE) {
            return "context-passthrough-style";
        }
        if (code == SmartCapabilities.CONTEXTEHRPATIENT) {
            return "context-ehr-patient";
        }
        if (code == SmartCapabilities.CONTEXTEHRENCOUNTER) {
            return "context-ehr-encounter";
        }
        if (code == SmartCapabilities.CONTEXTSTANDALONEPATIENT) {
            return "context-standalone-patient";
        }
        if (code == SmartCapabilities.CONTEXTSTANDALONEENCOUNTER) {
            return "context-standalone-encounter";
        }
        if (code == SmartCapabilities.PERMISSIONOFFLINE) {
            return "permission-offline";
        }
        if (code == SmartCapabilities.PERMISSIONPATIENT) {
            return "permission-patient";
        }
        if (code == SmartCapabilities.PERMISSIONUSER) {
            return "permission-user";
        }
        return "?";
    }

    @Override
    public String toSystem(SmartCapabilities code) {
        return code.getSystem();
    }
}

