/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.V3ObservationCategory;

public class V3ObservationCategoryEnumFactory
implements EnumFactory<V3ObservationCategory> {
    @Override
    public V3ObservationCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("exam".equals(codeString)) {
            return V3ObservationCategory.EXAM;
        }
        if ("imaging".equals(codeString)) {
            return V3ObservationCategory.IMAGING;
        }
        if ("laboratory".equals(codeString)) {
            return V3ObservationCategory.LABORATORY;
        }
        if ("procedure".equals(codeString)) {
            return V3ObservationCategory.PROCEDURE;
        }
        if ("social-history".equals(codeString)) {
            return V3ObservationCategory.SOCIALHISTORY;
        }
        if ("survey".equals(codeString)) {
            return V3ObservationCategory.SURVEY;
        }
        if ("therapy".equals(codeString)) {
            return V3ObservationCategory.THERAPY;
        }
        if ("vital-signs".equals(codeString)) {
            return V3ObservationCategory.VITALSIGNS;
        }
        throw new IllegalArgumentException("Unknown V3ObservationCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(V3ObservationCategory code) {
        if (code == V3ObservationCategory.NULL) {
            return null;
        }
        if (code == V3ObservationCategory.EXAM) {
            return "exam";
        }
        if (code == V3ObservationCategory.IMAGING) {
            return "imaging";
        }
        if (code == V3ObservationCategory.LABORATORY) {
            return "laboratory";
        }
        if (code == V3ObservationCategory.PROCEDURE) {
            return "procedure";
        }
        if (code == V3ObservationCategory.SOCIALHISTORY) {
            return "social-history";
        }
        if (code == V3ObservationCategory.SURVEY) {
            return "survey";
        }
        if (code == V3ObservationCategory.THERAPY) {
            return "therapy";
        }
        if (code == V3ObservationCategory.VITALSIGNS) {
            return "vital-signs";
        }
        return "?";
    }

    @Override
    public String toSystem(V3ObservationCategory code) {
        return code.getSystem();
    }
}

