/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Factory;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class ValueSetExpanderSimple
implements ValueSetExpander {
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private List<ValueSet.ValueSetExpansionContainsComponent> roots = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private IWorkerContext context;
    private boolean canBeHierarchy = true;
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> excludeSystems = new HashSet<String>();
    private ValueSet focus;
    private int maxExpansionSize = 500;
    private int total;

    public ValueSetExpanderSimple(IWorkerContext context) {
        this.context = context;
    }

    public void setMaxExpansionSize(int theMaxExpansionSize) {
        this.maxExpansionSize = theMaxExpansionSize;
    }

    private ValueSet.ValueSetExpansionContainsComponent addCode(String system, String code, String display, ValueSet.ValueSetExpansionContainsComponent parent, List<CodeSystem.ConceptDefinitionDesignationComponent> designations, Parameters expParams, boolean isAbstract, boolean inactive, List<ValueSet> filters) {
        CodeSystem.ConceptDefinitionDesignationComponent t;
        if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code)) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        if (isAbstract) {
            n.setAbstract(true);
        }
        if (inactive) {
            n.setInactive(true);
        }
        if (expParams.getParameterBool("includeDesignations") && designations != null) {
            for (CodeSystem.ConceptDefinitionDesignationComponent t2 : designations) {
                ToolingExtensions.addLanguageTranslation(n, t2.getLanguage(), t2.getValue());
            }
        }
        CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent = t = expParams.hasLanguage() ? this.getMatchingLang(designations, expParams.getLanguage()) : null;
        if (t == null) {
            n.setDisplay(display);
        } else {
            n.setDisplay(t.getValue());
        }
        String s = this.key(n);
        if (this.map.containsKey(s) || this.excludeKeys.contains(s)) {
            this.canBeHierarchy = false;
        } else {
            this.codes.add(n);
            this.map.put(s, n);
            ++this.total;
        }
        if (this.canBeHierarchy && parent != null) {
            parent.getContains().add(n);
        } else {
            this.roots.add(n);
        }
        return n;
    }

    private boolean filterContainsCode(List<ValueSet> filters, String system, String code) {
        for (ValueSet vse : filters) {
            if (!this.expansionContainsCode(vse.getExpansion().getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean expansionContainsCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (system.equals(cc.getSystem()) && code.equals(cc.getCode())) {
                return true;
            }
            if (!this.expansionContainsCode(cc.getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent getMatchingLang(List<CodeSystem.ConceptDefinitionDesignationComponent> list, String lang) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().equals(lang)) continue;
            return t;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!t.getLanguage().startsWith(lang)) continue;
            return t;
        }
        return null;
    }

    private void addCodeAndDescendents(ValueSet.ValueSetExpansionContainsComponent focus, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters) throws FHIRException {
        focus.checkNoModifiers("Expansion.contains", "expanding");
        ValueSet.ValueSetExpansionContainsComponent np = this.addCode(focus.getSystem(), focus.getCode(), focus.getDisplay(), parent, this.convert(focus.getDesignation()), expParams, focus.getAbstract(), focus.getInactive(), filters);
        for (ValueSet.ValueSetExpansionContainsComponent c : focus.getContains()) {
            this.addCodeAndDescendents(focus, np, expParams, filters);
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convert(List<ValueSet.ConceptReferenceDesignationComponent> designations) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> list = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent d : designations) {
            CodeSystem.ConceptDefinitionDesignationComponent n = new CodeSystem.ConceptDefinitionDesignationComponent();
            n.setLanguage(d.getLanguage());
            n.setUse(d.getUse());
            n.setValue(d.getValue());
            list.add(n);
        }
        return list;
    }

    private void addCodeAndDescendents(CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, CodeSystem.ConceptDefinitionComponent exclusion) throws FHIRException {
        def.checkNoModifiers("Code in Code System", "expanding");
        if (exclusion != null && exclusion.getCode().equals(def.getCode())) {
            return;
        }
        if (!CodeSystemUtilities.isDeprecated(cs, def)) {
            ValueSet.ValueSetExpansionContainsComponent np = null;
            boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
            boolean inc = CodeSystemUtilities.isInactive(cs, def);
            if (this.canBeHierarchy || !abs) {
                np = this.addCode(system, def.getCode(), def.getDisplay(), parent, def.getDesignation(), expParams, abs, inc, filters);
            }
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(cs, system, c, np, expParams, filters, exclusion);
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                this.addCodeAndDescendents(cs, system, c, null, expParams, filters, exclusion);
            }
        }
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, List<ValueSet> filters) throws ValueSetExpander.ETooCostly, FHIRException {
        if (expand != null) {
            if (expand.getContains().size() > this.maxExpansionSize) {
                throw new ValueSetExpander.ETooCostly("Too many codes to display (>" + Integer.toString(expand.getContains().size()) + ")");
            }
            for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
                if (this.existsInParams(params, p.getName(), p.getValue())) continue;
                params.add(p);
            }
            this.copyImportContains(expand.getContains(), null, expParams, filters);
        }
    }

    private void excludeCode(String theSystem, String theCode) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(theSystem);
        n.setCode(theCode);
        String s = this.key(n);
        this.excludeKeys.add(s);
    }

    private void excludeCodes(ValueSet.ConceptSetComponent exc, List<ValueSet.ValueSetExpansionParameterComponent> params, String ctxt) throws FHIRException {
        exc.checkNoModifiers("Compose.exclude", "expanding");
        if (exc.hasSystem() && exc.getConcept().size() == 0 && exc.getFilter().size() == 0) {
            this.excludeSystems.add(exc.getSystem());
        }
        if (exc.hasValueSet()) {
            throw new Error("Processing Value set references in exclude is not yet done in " + ctxt);
        }
        CodeSystem cs = this.context.fetchCodeSystem(exc.getSystem());
        if ((cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(exc.getSystem())) {
            ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(exc, false);
            ValueSet valueset = vse.getValueset();
            if (valueset == null) {
                throw new TerminologyServiceException("Error Expanding ValueSet: " + vse.getError());
            }
            this.excludeCodes(valueset.getExpansion(), params);
            return;
        }
        for (ValueSet.ConceptReferenceComponent c : exc.getConcept()) {
            this.excludeCode(exc.getSystem(), c.getCode());
        }
        if (exc.getFilter().size() > 0) {
            throw new NotImplementedException("not done yet");
        }
    }

    private void excludeCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params) {
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.excludeCode(c.getSystem(), c.getCode());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, Type value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source, Parameters expParams) {
        try {
            return this.doExpand(source, expParams);
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome(e.getMessage(), ValueSetExpander.TerminologyServiceErrorClass.UNKNOWN);
        }
    }

    public ValueSetExpander.ValueSetExpansionOutcome doExpand(ValueSet source, Parameters expParams) throws FHIRException, ValueSetExpander.ETooCostly, FileNotFoundException, IOException {
        if (expParams == null) {
            expParams = this.makeDefaultExpansion();
        }
        source.checkNoModifiers("ValueSet", "expanding");
        this.focus = source.copy();
        this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
        this.focus.getExpansion().setTimestampElement(DateTimeType.now());
        this.focus.getExpansion().setIdentifier(Factory.createUUID());
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!Utilities.existsInList((String)p.getName(), (String[])new String[]{"includeDesignations", "excludeNested"})) continue;
            this.focus.getExpansion().addParameter().setName(p.getName()).setValue(p.getValue());
        }
        if (source.hasCompose()) {
            this.handleCompose(source.getCompose(), this.focus.getExpansion().getParameter(), expParams, source.getUrl());
        }
        if (this.canBeHierarchy) {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.roots) {
                this.focus.getExpansion().getContains().add(c);
            }
        } else {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.codes) {
                if (!this.map.containsKey(this.key(c)) || c.getAbstract()) continue;
                this.focus.getExpansion().getContains().add(c);
                c.getContains().clear();
            }
        }
        if (this.total > 0) {
            this.focus.getExpansion().setTotal(this.total);
        }
        return new ValueSetExpander.ValueSetExpansionOutcome(this.focus);
    }

    private Parameters makeDefaultExpansion() {
        Parameters res = new Parameters();
        res.addParameter("excludeNested", true);
        res.addParameter("includeDesignations", false);
        return res;
    }

    private String getCodeDisplay(CodeSystem cs, String code) throws TerminologyServiceException {
        CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), code);
        if (def == null) {
            throw new TerminologyServiceException("Unable to find code '" + code + "' in code system " + cs.getUrl());
        }
        return def.getDisplay();
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, String ctxt) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        compose.checkNoModifiers("ValueSet.compose", "expanding");
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(inc, params, ctxt);
        }
        this.canBeHierarchy = !expParams.getParameterBool("excludeNested") && this.excludeKeys.isEmpty() && this.excludeSystems.isEmpty();
        boolean first = true;
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            if (first) {
                first = false;
            } else {
                this.canBeHierarchy = false;
            }
            this.includeCodes(inc, params, expParams, this.canBeHierarchy);
        }
    }

    private ValueSet importValueSet(String value, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams) throws ValueSetExpander.ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        if (value == null) {
            throw new TerminologyServiceException("unable to find value set with no identity");
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs == null) {
            throw new TerminologyServiceException("Unable to find imported value set " + value);
        }
        ValueSetExpander.ValueSetExpansionOutcome vso = new ValueSetExpanderSimple(this.context).expand(vs, expParams);
        if (vso.getError() != null) {
            throw new TerminologyServiceException("Unable to expand imported value set: " + vso.getError());
        }
        if (vs.hasVersion() && !this.existsInParams(params, "version", new UriType(vs.getUrl() + "|" + vs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "|" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        this.canBeHierarchy = false;
        return vso.getValueset();
    }

    private void copyImportContains(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filter) throws FHIRException {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            c.checkNoModifiers("Imported Expansion in Code System", "expanding");
            ValueSet.ValueSetExpansionContainsComponent np = this.addCode(c.getSystem(), c.getCode(), c.getDisplay(), parent, null, expParams, c.getAbstract(), c.getInactive(), filter);
            this.copyImportContains(c.getContains(), np, expParams, filter);
        }
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, boolean heirarchical) throws ValueSetExpander.ETooCostly, FileNotFoundException, IOException, FHIRException {
        inc.checkNoModifiers("Compose.include", "expanding");
        ArrayList<ValueSet> imports = new ArrayList<ValueSet>();
        for (UriType uriType : inc.getValueSet()) {
            imports.add(this.importValueSet((String)uriType.getValue(), params, expParams));
        }
        if (!inc.hasSystem()) {
            if (imports.isEmpty()) {
                return;
            }
            ValueSet base = (ValueSet)imports.get(0);
            imports.remove(0);
            base.checkNoModifiers("Imported ValueSet", "expanding");
            this.copyImportContains(base.getExpansion().getContains(), null, expParams, imports);
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(inc.getSystem());
            if (cs == null || cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                this.doServerIncludeCodes(inc, heirarchical, params, imports, expParams);
            } else {
                this.doInternalIncludeCodes(inc, params, expParams, imports, cs);
            }
        }
    }

    private void doServerIncludeCodes(ValueSet.ConceptSetComponent inc, boolean heirarchical, List<ValueSet.ValueSetExpansionParameterComponent> params, List<ValueSet> imports, Parameters expParams) throws FHIRException {
        ValueSetExpander.ValueSetExpansionOutcome vso = this.context.expandVS(inc, heirarchical);
        if (vso.getError() != null) {
            throw new TerminologyServiceException("Unable to expand imported value set: " + vso.getError());
        }
        ValueSet vs = vso.getValueset();
        if (vs.hasVersion() && !this.existsInParams(params, "version", new UriType(vs.getUrl() + "|" + vs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(vs.getUrl() + "|" + vs.getVersion())));
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(params, p.getName(), p.getValue())) continue;
            params.add(p);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            this.addCodeAndDescendents(cc, null, expParams, imports);
        }
    }

    public void doInternalIncludeCodes(ValueSet.ConceptSetComponent inc, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, List<ValueSet> imports, CodeSystem cs) throws NoTerminologyServiceException, TerminologyServiceException, FHIRException {
        if (cs == null) {
            if (this.context.isNoTerminologyServer()) {
                throw new NoTerminologyServiceException("unable to find code system " + inc.getSystem().toString());
            }
            throw new TerminologyServiceException("unable to find code system " + inc.getSystem().toString());
        }
        cs.checkNoModifiers("Code System", "expanding");
        if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            throw new TerminologyServiceException("Code system " + inc.getSystem().toString() + " is incomplete");
        }
        if (cs.hasVersion() && !this.existsInParams(params, "version", new UriType(cs.getUrl() + "|" + cs.getVersion()))) {
            params.add(new ValueSet.ValueSetExpansionParameterComponent().setName("version").setValue(new UriType(cs.getUrl() + "|" + cs.getVersion())));
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(cs, inc.getSystem(), def, null, expParams, imports, null);
            }
        }
        if (!inc.getConcept().isEmpty()) {
            this.canBeHierarchy = false;
            for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                c.checkNoModifiers("Code in Code System", "expanding");
                this.addCode(inc.getSystem(), c.getCode(), Utilities.noString((String)c.getDisplay()) ? this.getCodeDisplay(cs, c.getCode()) : c.getDisplay(), null, this.convertDesignations(c.getDesignation()), expParams, false, CodeSystemUtilities.isInactive(cs, c.getCode()), imports);
            }
        }
        if (inc.getFilter().size() > 1) {
            this.canBeHierarchy = false;
            throw new TerminologyServiceException("Multiple filters not handled yet");
        }
        if (inc.getFilter().size() == 1) {
            CodeSystem.ConceptDefinitionComponent def;
            ValueSet.ConceptSetFilterComponent fc = inc.getFilter().get(0);
            if ("concept".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.ISA) {
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def == null) {
                    throw new TerminologyServiceException("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                this.addCodeAndDescendents(cs, inc.getSystem(), def, null, expParams, imports, null);
            } else if ("concept".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.ISNOTA) {
                CodeSystem.ConceptDefinitionComponent defEx = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (defEx == null) {
                    throw new TerminologyServiceException("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                for (CodeSystem.ConceptDefinitionComponent def2 : cs.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), def2, null, expParams, imports, defEx);
                }
            } else if ("concept".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.DESCENDENTOF) {
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def == null) {
                    throw new TerminologyServiceException("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
                }
                for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
                    this.addCodeAndDescendents(cs, inc.getSystem(), c, null, expParams, imports, null);
                }
            } else if ("display".equals(fc.getProperty()) && fc.getOp() == ValueSet.FilterOperator.EQUAL) {
                this.canBeHierarchy = false;
                def = this.getConceptForCode(cs.getConcept(), fc.getValue());
                if (def != null && StringUtils.isNotBlank((CharSequence)def.getDisplay()) && StringUtils.isNotBlank((CharSequence)fc.getValue()) && def.getDisplay().contains(fc.getValue())) {
                    this.addCode(inc.getSystem(), def.getCode(), def.getDisplay(), null, def.getDesignation(), expParams, CodeSystemUtilities.isNotSelectable(cs, def), CodeSystemUtilities.isInactive(cs, def), imports);
                }
            } else {
                throw new NotImplementedException("Search by property[" + fc.getProperty() + "] and op[" + fc.getOp() + "] is not supported yet");
            }
        }
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convertDesignations(List<ValueSet.ConceptReferenceDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent t : list) {
            CodeSystem.ConceptDefinitionDesignationComponent c = new CodeSystem.ConceptDefinitionDesignationComponent();
            c.setLanguage(t.getLanguage());
            c.setUse(t.getUse());
            c.setValue(t.getValue());
        }
        return res;
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }
}

