/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.client;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.OperationOutcome;

public class EFhirClientException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int code;
    private List<OperationOutcome> errors = new ArrayList<OperationOutcome>();

    public EFhirClientException(String message) {
        super(message);
    }

    public EFhirClientException(int code, String message, List<OperationOutcome> serverErrors) {
        super(message);
        this.code = code;
        if (serverErrors != null && serverErrors.size() > 0) {
            this.errors.addAll(serverErrors);
        }
    }

    public EFhirClientException(Exception cause) {
        super(cause);
    }

    public EFhirClientException(int code, String message, Exception cause) {
        super(message, cause);
        this.code = code;
    }

    public EFhirClientException(int code, String message, OperationOutcome serverError) {
        super(message);
        this.code = code;
        if (serverError != null) {
            this.errors.add(serverError);
        }
    }

    public EFhirClientException(int code, OperationOutcome serverError) {
        super("Error on the server: " + serverError.getText().getDiv().allText() + ". Refer to e.getServerErrors() for additional details.");
        this.code = code;
        if (serverError != null) {
            this.errors.add(serverError);
        }
    }

    public List<OperationOutcome> getServerErrors() {
        return this.errors;
    }

    public boolean hasServerErrors() {
        return this.errors.size() > 0;
    }

    public int getCode() {
        return this.code;
    }
}

