/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.AccountStatus;

public class AccountStatusEnumFactory
implements EnumFactory<AccountStatus> {
    @Override
    public AccountStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return AccountStatus.ACTIVE;
        }
        if ("inactive".equals(codeString)) {
            return AccountStatus.INACTIVE;
        }
        if ("entered-in-error".equals(codeString)) {
            return AccountStatus.ENTEREDINERROR;
        }
        if ("on-hold".equals(codeString)) {
            return AccountStatus.ONHOLD;
        }
        if ("unknown".equals(codeString)) {
            return AccountStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("Unknown AccountStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(AccountStatus code) {
        if (code == AccountStatus.NULL) {
            return null;
        }
        if (code == AccountStatus.ACTIVE) {
            return "active";
        }
        if (code == AccountStatus.INACTIVE) {
            return "inactive";
        }
        if (code == AccountStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        if (code == AccountStatus.ONHOLD) {
            return "on-hold";
        }
        if (code == AccountStatus.UNKNOWN) {
            return "unknown";
        }
        return "?";
    }

    @Override
    public String toSystem(AccountStatus code) {
        return code.getSystem();
    }
}

