/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.RequestResourceTypes;

public class RequestResourceTypesEnumFactory
implements EnumFactory<RequestResourceTypes> {
    @Override
    public RequestResourceTypes fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Appointment".equals(codeString)) {
            return RequestResourceTypes.APPOINTMENT;
        }
        if ("AppointmentResponse".equals(codeString)) {
            return RequestResourceTypes.APPOINTMENTRESPONSE;
        }
        if ("CarePlan".equals(codeString)) {
            return RequestResourceTypes.CAREPLAN;
        }
        if ("Claim".equals(codeString)) {
            return RequestResourceTypes.CLAIM;
        }
        if ("CommunicationRequest".equals(codeString)) {
            return RequestResourceTypes.COMMUNICATIONREQUEST;
        }
        if ("Contract".equals(codeString)) {
            return RequestResourceTypes.CONTRACT;
        }
        if ("DeviceRequest".equals(codeString)) {
            return RequestResourceTypes.DEVICEREQUEST;
        }
        if ("EnrollmentRequest".equals(codeString)) {
            return RequestResourceTypes.ENROLLMENTREQUEST;
        }
        if ("ImmunizationRecommendation".equals(codeString)) {
            return RequestResourceTypes.IMMUNIZATIONRECOMMENDATION;
        }
        if ("MedicationRequest".equals(codeString)) {
            return RequestResourceTypes.MEDICATIONREQUEST;
        }
        if ("NutritionOrder".equals(codeString)) {
            return RequestResourceTypes.NUTRITIONORDER;
        }
        if ("ServiceRequest".equals(codeString)) {
            return RequestResourceTypes.SERVICEREQUEST;
        }
        if ("SupplyRequest".equals(codeString)) {
            return RequestResourceTypes.SUPPLYREQUEST;
        }
        if ("Task".equals(codeString)) {
            return RequestResourceTypes.TASK;
        }
        if ("VisionPrescription".equals(codeString)) {
            return RequestResourceTypes.VISIONPRESCRIPTION;
        }
        throw new IllegalArgumentException("Unknown RequestResourceTypes code '" + codeString + "'");
    }

    @Override
    public String toCode(RequestResourceTypes code) {
        if (code == RequestResourceTypes.NULL) {
            return null;
        }
        if (code == RequestResourceTypes.APPOINTMENT) {
            return "Appointment";
        }
        if (code == RequestResourceTypes.APPOINTMENTRESPONSE) {
            return "AppointmentResponse";
        }
        if (code == RequestResourceTypes.CAREPLAN) {
            return "CarePlan";
        }
        if (code == RequestResourceTypes.CLAIM) {
            return "Claim";
        }
        if (code == RequestResourceTypes.COMMUNICATIONREQUEST) {
            return "CommunicationRequest";
        }
        if (code == RequestResourceTypes.CONTRACT) {
            return "Contract";
        }
        if (code == RequestResourceTypes.DEVICEREQUEST) {
            return "DeviceRequest";
        }
        if (code == RequestResourceTypes.ENROLLMENTREQUEST) {
            return "EnrollmentRequest";
        }
        if (code == RequestResourceTypes.IMMUNIZATIONRECOMMENDATION) {
            return "ImmunizationRecommendation";
        }
        if (code == RequestResourceTypes.MEDICATIONREQUEST) {
            return "MedicationRequest";
        }
        if (code == RequestResourceTypes.NUTRITIONORDER) {
            return "NutritionOrder";
        }
        if (code == RequestResourceTypes.SERVICEREQUEST) {
            return "ServiceRequest";
        }
        if (code == RequestResourceTypes.SUPPLYREQUEST) {
            return "SupplyRequest";
        }
        if (code == RequestResourceTypes.TASK) {
            return "Task";
        }
        if (code == RequestResourceTypes.VISIONPRESCRIPTION) {
            return "VisionPrescription";
        }
        return "?";
    }

    @Override
    public String toSystem(RequestResourceTypes code) {
        return code.getSystem();
    }
}

