/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Dosage")
public class Dosage
extends BackboneType
implements ICompositeType {
    @Child(name="sequence", type={IntegerType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The order of the dosage instructions", formalDefinition="Indicates the order in which the dosage instructions should be applied or interpreted.")
    protected IntegerType sequence;
    @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage instructions e.g. SIG.")
    protected StringType text;
    @Child(name="additionalInstruction", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supplemental instruction or warnings to the patient - e.g. \"with meals\", \"may cause drowsiness\"", formalDefinition="Supplemental instructions to the patient on how to take the medication  (e.g. \"with meals\" or\"take half to one hour before food\") or warnings for the patient about the medication (e.g. \"may cause drowsiness\" or \"avoid exposure of skin to direct sunlight or sunlamps\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/additional-instruction-codes")
    protected List<CodeableConcept> additionalInstruction;
    @Child(name="patientInstruction", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient or consumer oriented instructions", formalDefinition="Instructions in terms that are understood by the patient or consumer.")
    protected StringType patientInstruction;
    @Child(name="timing", type={Timing.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When medication should be administered", formalDefinition="When medication should be administered.")
    protected Timing timing;
    @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Take \"as needed\" (for x)", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-as-needed-reason")
    protected Type asNeeded;
    @Child(name="site", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body site to administer to", formalDefinition="Body site to administer to.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
    protected CodeableConcept site;
    @Child(name="route", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How drug should enter body", formalDefinition="How drug should enter body.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected CodeableConcept route;
    @Child(name="method", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Technique for administering medication", formalDefinition="Technique for administering medication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
    protected CodeableConcept method;
    @Child(name="doseAndRate", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of medication administered", formalDefinition="The amount of medication administered.")
    protected List<DosageDoseAndRateComponent> doseAndRate;
    @Child(name="maxDosePerPeriod", type={Ratio.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="Upper limit on medication per unit of time.")
    protected Ratio maxDosePerPeriod;
    @Child(name="maxDosePerAdministration", type={Quantity.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per administration", formalDefinition="Upper limit on medication per administration.")
    protected Quantity maxDosePerAdministration;
    @Child(name="maxDosePerLifetime", type={Quantity.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Upper limit on medication per lifetime of the patient", formalDefinition="Upper limit on medication per lifetime of the patient.")
    protected Quantity maxDosePerLifetime;
    private static final long serialVersionUID = -1095063329L;

    public IntegerType getSequenceElement() {
        if (this.sequence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.sequence");
            }
            if (Configuration.doAutoCreate()) {
                this.sequence = new IntegerType();
            }
        }
        return this.sequence;
    }

    public boolean hasSequenceElement() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public boolean hasSequence() {
        return this.sequence != null && !this.sequence.isEmpty();
    }

    public Dosage setSequenceElement(IntegerType value) {
        this.sequence = value;
        return this;
    }

    public int getSequence() {
        return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
    }

    public Dosage setSequence(int value) {
        if (this.sequence == null) {
            this.sequence = new IntegerType();
        }
        this.sequence.setValue((Object)value);
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public Dosage setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public Dosage setText(String value) {
        if (Utilities.noString((String)value)) {
            this.text = null;
        } else {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getAdditionalInstruction() {
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        return this.additionalInstruction;
    }

    public Dosage setAdditionalInstruction(List<CodeableConcept> theAdditionalInstruction) {
        this.additionalInstruction = theAdditionalInstruction;
        return this;
    }

    public boolean hasAdditionalInstruction() {
        if (this.additionalInstruction == null) {
            return false;
        }
        for (CodeableConcept item : this.additionalInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAdditionalInstruction() {
        CodeableConcept t = new CodeableConcept();
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        this.additionalInstruction.add(t);
        return t;
    }

    public Dosage addAdditionalInstruction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.additionalInstruction == null) {
            this.additionalInstruction = new ArrayList<CodeableConcept>();
        }
        this.additionalInstruction.add(t);
        return this;
    }

    public CodeableConcept getAdditionalInstructionFirstRep() {
        if (this.getAdditionalInstruction().isEmpty()) {
            this.addAdditionalInstruction();
        }
        return this.getAdditionalInstruction().get(0);
    }

    public StringType getPatientInstructionElement() {
        if (this.patientInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.patientInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.patientInstruction = new StringType();
            }
        }
        return this.patientInstruction;
    }

    public boolean hasPatientInstructionElement() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public boolean hasPatientInstruction() {
        return this.patientInstruction != null && !this.patientInstruction.isEmpty();
    }

    public Dosage setPatientInstructionElement(StringType value) {
        this.patientInstruction = value;
        return this;
    }

    public String getPatientInstruction() {
        return this.patientInstruction == null ? null : (String)this.patientInstruction.getValue();
    }

    public Dosage setPatientInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.patientInstruction = null;
        } else {
            if (this.patientInstruction == null) {
                this.patientInstruction = new StringType();
            }
            this.patientInstruction.setValue(value);
        }
        return this;
    }

    public Timing getTiming() {
        if (this.timing == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.timing");
            }
            if (Configuration.doAutoCreate()) {
                this.timing = new Timing();
            }
        }
        return this.timing;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public Dosage setTiming(Timing value) {
        this.timing = value;
        return this;
    }

    public Type getAsNeeded() {
        return this.asNeeded;
    }

    public BooleanType getAsNeededBooleanType() throws FHIRException {
        if (this.asNeeded == null) {
            this.asNeeded = new BooleanType();
        }
        if (!(this.asNeeded instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.asNeeded;
    }

    public boolean hasAsNeededBooleanType() {
        return this.asNeeded instanceof BooleanType;
    }

    public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
        if (this.asNeeded == null) {
            this.asNeeded = new CodeableConcept();
        }
        if (!(this.asNeeded instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.asNeeded;
    }

    public boolean hasAsNeededCodeableConcept() {
        return this.asNeeded instanceof CodeableConcept;
    }

    public boolean hasAsNeeded() {
        return this.asNeeded != null && !this.asNeeded.isEmpty();
    }

    public Dosage setAsNeeded(Type value) {
        if (value != null && !(value instanceof BooleanType) && !(value instanceof CodeableConcept)) {
            throw new Error("Not the right type for Dosage.asNeeded[x]: " + value.fhirType());
        }
        this.asNeeded = value;
        return this;
    }

    public CodeableConcept getSite() {
        if (this.site == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.site");
            }
            if (Configuration.doAutoCreate()) {
                this.site = new CodeableConcept();
            }
        }
        return this.site;
    }

    public boolean hasSite() {
        return this.site != null && !this.site.isEmpty();
    }

    public Dosage setSite(CodeableConcept value) {
        this.site = value;
        return this;
    }

    public CodeableConcept getRoute() {
        if (this.route == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.route");
            }
            if (Configuration.doAutoCreate()) {
                this.route = new CodeableConcept();
            }
        }
        return this.route;
    }

    public boolean hasRoute() {
        return this.route != null && !this.route.isEmpty();
    }

    public Dosage setRoute(CodeableConcept value) {
        this.route = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public Dosage setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public List<DosageDoseAndRateComponent> getDoseAndRate() {
        if (this.doseAndRate == null) {
            this.doseAndRate = new ArrayList<DosageDoseAndRateComponent>();
        }
        return this.doseAndRate;
    }

    public Dosage setDoseAndRate(List<DosageDoseAndRateComponent> theDoseAndRate) {
        this.doseAndRate = theDoseAndRate;
        return this;
    }

    public boolean hasDoseAndRate() {
        if (this.doseAndRate == null) {
            return false;
        }
        for (DosageDoseAndRateComponent item : this.doseAndRate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DosageDoseAndRateComponent addDoseAndRate() {
        DosageDoseAndRateComponent t = new DosageDoseAndRateComponent();
        if (this.doseAndRate == null) {
            this.doseAndRate = new ArrayList<DosageDoseAndRateComponent>();
        }
        this.doseAndRate.add(t);
        return t;
    }

    public Dosage addDoseAndRate(DosageDoseAndRateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.doseAndRate == null) {
            this.doseAndRate = new ArrayList<DosageDoseAndRateComponent>();
        }
        this.doseAndRate.add(t);
        return this;
    }

    public DosageDoseAndRateComponent getDoseAndRateFirstRep() {
        if (this.getDoseAndRate().isEmpty()) {
            this.addDoseAndRate();
        }
        return this.getDoseAndRate().get(0);
    }

    public Ratio getMaxDosePerPeriod() {
        if (this.maxDosePerPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerPeriod = new Ratio();
            }
        }
        return this.maxDosePerPeriod;
    }

    public boolean hasMaxDosePerPeriod() {
        return this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty();
    }

    public Dosage setMaxDosePerPeriod(Ratio value) {
        this.maxDosePerPeriod = value;
        return this;
    }

    public Quantity getMaxDosePerAdministration() {
        if (this.maxDosePerAdministration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerAdministration");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerAdministration = new Quantity();
            }
        }
        return this.maxDosePerAdministration;
    }

    public boolean hasMaxDosePerAdministration() {
        return this.maxDosePerAdministration != null && !this.maxDosePerAdministration.isEmpty();
    }

    public Dosage setMaxDosePerAdministration(Quantity value) {
        this.maxDosePerAdministration = value;
        return this;
    }

    public Quantity getMaxDosePerLifetime() {
        if (this.maxDosePerLifetime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Dosage.maxDosePerLifetime");
            }
            if (Configuration.doAutoCreate()) {
                this.maxDosePerLifetime = new Quantity();
            }
        }
        return this.maxDosePerLifetime;
    }

    public boolean hasMaxDosePerLifetime() {
        return this.maxDosePerLifetime != null && !this.maxDosePerLifetime.isEmpty();
    }

    public Dosage setMaxDosePerLifetime(Quantity value) {
        this.maxDosePerLifetime = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("sequence", "integer", "Indicates the order in which the dosage instructions should be applied or interpreted.", 0, 1, this.sequence));
        children.add(new Property("text", "string", "Free text dosage instructions e.g. SIG.", 0, 1, this.text));
        children.add(new Property("additionalInstruction", "CodeableConcept", "Supplemental instructions to the patient on how to take the medication  (e.g. \"with meals\" or\"take half to one hour before food\") or warnings for the patient about the medication (e.g. \"may cause drowsiness\" or \"avoid exposure of skin to direct sunlight or sunlamps\").", 0, Integer.MAX_VALUE, this.additionalInstruction));
        children.add(new Property("patientInstruction", "string", "Instructions in terms that are understood by the patient or consumer.", 0, 1, this.patientInstruction));
        children.add(new Property("timing", "Timing", "When medication should be administered.", 0, 1, this.timing));
        children.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded));
        children.add(new Property("site", "CodeableConcept", "Body site to administer to.", 0, 1, this.site));
        children.add(new Property("route", "CodeableConcept", "How drug should enter body.", 0, 1, this.route));
        children.add(new Property("method", "CodeableConcept", "Technique for administering medication.", 0, 1, this.method));
        children.add(new Property("doseAndRate", "", "The amount of medication administered.", 0, Integer.MAX_VALUE, this.doseAndRate));
        children.add(new Property("maxDosePerPeriod", "Ratio", "Upper limit on medication per unit of time.", 0, 1, this.maxDosePerPeriod));
        children.add(new Property("maxDosePerAdministration", "SimpleQuantity", "Upper limit on medication per administration.", 0, 1, this.maxDosePerAdministration));
        children.add(new Property("maxDosePerLifetime", "SimpleQuantity", "Upper limit on medication per lifetime of the patient.", 0, 1, this.maxDosePerLifetime));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1349547969: {
                return new Property("sequence", "integer", "Indicates the order in which the dosage instructions should be applied or interpreted.", 0, 1, this.sequence);
            }
            case 3556653: {
                return new Property("text", "string", "Free text dosage instructions e.g. SIG.", 0, 1, this.text);
            }
            case 1623641575: {
                return new Property("additionalInstruction", "CodeableConcept", "Supplemental instructions to the patient on how to take the medication  (e.g. \"with meals\" or\"take half to one hour before food\") or warnings for the patient about the medication (e.g. \"may cause drowsiness\" or \"avoid exposure of skin to direct sunlight or sunlamps\").", 0, Integer.MAX_VALUE, this.additionalInstruction);
            }
            case 737543241: {
                return new Property("patientInstruction", "string", "Instructions in terms that are understood by the patient or consumer.", 0, 1, this.patientInstruction);
            }
            case -873664438: {
                return new Property("timing", "Timing", "When medication should be administered.", 0, 1, this.timing);
            }
            case -544329575: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case -1432923513: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case -591717471: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case 1556420122: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, 1, this.asNeeded);
            }
            case 3530567: {
                return new Property("site", "CodeableConcept", "Body site to administer to.", 0, 1, this.site);
            }
            case 108704329: {
                return new Property("route", "CodeableConcept", "How drug should enter body.", 0, 1, this.route);
            }
            case -1077554975: {
                return new Property("method", "CodeableConcept", "Technique for administering medication.", 0, 1, this.method);
            }
            case -611024774: {
                return new Property("doseAndRate", "", "The amount of medication administered.", 0, Integer.MAX_VALUE, this.doseAndRate);
            }
            case 1506263709: {
                return new Property("maxDosePerPeriod", "Ratio", "Upper limit on medication per unit of time.", 0, 1, this.maxDosePerPeriod);
            }
            case 2004889914: {
                return new Property("maxDosePerAdministration", "SimpleQuantity", "Upper limit on medication per administration.", 0, 1, this.maxDosePerAdministration);
            }
            case 642099621: {
                return new Property("maxDosePerLifetime", "SimpleQuantity", "Upper limit on medication per lifetime of the patient.", 0, 1, this.maxDosePerLifetime);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                Base[] baseArray;
                if (this.sequence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.sequence;
                }
                return baseArray;
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.text;
                }
                return baseArray;
            }
            case 1623641575: {
                return this.additionalInstruction == null ? new Base[]{} : this.additionalInstruction.toArray(new Base[this.additionalInstruction.size()]);
            }
            case 737543241: {
                Base[] baseArray;
                if (this.patientInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patientInstruction;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timing;
                }
                return baseArray;
            }
            case -1432923513: {
                Base[] baseArray;
                if (this.asNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.asNeeded;
                }
                return baseArray;
            }
            case 3530567: {
                Base[] baseArray;
                if (this.site == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.site;
                }
                return baseArray;
            }
            case 108704329: {
                Base[] baseArray;
                if (this.route == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.route;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.method;
                }
                return baseArray;
            }
            case -611024774: {
                return this.doseAndRate == null ? new Base[]{} : this.doseAndRate.toArray(new Base[this.doseAndRate.size()]);
            }
            case 1506263709: {
                Base[] baseArray;
                if (this.maxDosePerPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.maxDosePerPeriod;
                }
                return baseArray;
            }
            case 2004889914: {
                Base[] baseArray;
                if (this.maxDosePerAdministration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.maxDosePerAdministration;
                }
                return baseArray;
            }
            case 642099621: {
                Base[] baseArray;
                if (this.maxDosePerLifetime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.maxDosePerLifetime;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                this.sequence = this.castToInteger(value);
                return value;
            }
            case 3556653: {
                this.text = this.castToString(value);
                return value;
            }
            case 1623641575: {
                this.getAdditionalInstruction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 737543241: {
                this.patientInstruction = this.castToString(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToTiming(value);
                return value;
            }
            case -1432923513: {
                this.asNeeded = this.castToType(value);
                return value;
            }
            case 3530567: {
                this.site = this.castToCodeableConcept(value);
                return value;
            }
            case 108704329: {
                this.route = this.castToCodeableConcept(value);
                return value;
            }
            case -1077554975: {
                this.method = this.castToCodeableConcept(value);
                return value;
            }
            case -611024774: {
                this.getDoseAndRate().add((DosageDoseAndRateComponent)value);
                return value;
            }
            case 1506263709: {
                this.maxDosePerPeriod = this.castToRatio(value);
                return value;
            }
            case 2004889914: {
                this.maxDosePerAdministration = this.castToQuantity(value);
                return value;
            }
            case 642099621: {
                this.maxDosePerLifetime = this.castToQuantity(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("sequence")) {
            this.sequence = this.castToInteger(value);
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else if (name.equals("additionalInstruction")) {
            this.getAdditionalInstruction().add(this.castToCodeableConcept(value));
        } else if (name.equals("patientInstruction")) {
            this.patientInstruction = this.castToString(value);
        } else if (name.equals("timing")) {
            this.timing = this.castToTiming(value);
        } else if (name.equals("asNeeded[x]")) {
            this.asNeeded = this.castToType(value);
        } else if (name.equals("site")) {
            this.site = this.castToCodeableConcept(value);
        } else if (name.equals("route")) {
            this.route = this.castToCodeableConcept(value);
        } else if (name.equals("method")) {
            this.method = this.castToCodeableConcept(value);
        } else if (name.equals("doseAndRate")) {
            this.getDoseAndRate().add((DosageDoseAndRateComponent)value);
        } else if (name.equals("maxDosePerPeriod")) {
            this.maxDosePerPeriod = this.castToRatio(value);
        } else if (name.equals("maxDosePerAdministration")) {
            this.maxDosePerAdministration = this.castToQuantity(value);
        } else if (name.equals("maxDosePerLifetime")) {
            this.maxDosePerLifetime = this.castToQuantity(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("sequence")) {
            this.sequence = null;
        } else if (name.equals("text")) {
            this.text = null;
        } else if (name.equals("additionalInstruction")) {
            this.getAdditionalInstruction().remove(this.castToCodeableConcept(value));
        } else if (name.equals("patientInstruction")) {
            this.patientInstruction = null;
        } else if (name.equals("timing")) {
            this.timing = null;
        } else if (name.equals("asNeeded[x]")) {
            this.asNeeded = null;
        } else if (name.equals("site")) {
            this.site = null;
        } else if (name.equals("route")) {
            this.route = null;
        } else if (name.equals("method")) {
            this.method = null;
        } else if (name.equals("doseAndRate")) {
            this.getDoseAndRate().remove((DosageDoseAndRateComponent)value);
        } else if (name.equals("maxDosePerPeriod")) {
            this.maxDosePerPeriod = null;
        } else if (name.equals("maxDosePerAdministration")) {
            this.maxDosePerAdministration = null;
        } else if (name.equals("maxDosePerLifetime")) {
            this.maxDosePerLifetime = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                return this.getSequenceElement();
            }
            case 3556653: {
                return this.getTextElement();
            }
            case 1623641575: {
                return this.addAdditionalInstruction();
            }
            case 737543241: {
                return this.getPatientInstructionElement();
            }
            case -873664438: {
                return this.getTiming();
            }
            case -544329575: {
                return this.getAsNeeded();
            }
            case -1432923513: {
                return this.getAsNeeded();
            }
            case 3530567: {
                return this.getSite();
            }
            case 108704329: {
                return this.getRoute();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -611024774: {
                return this.addDoseAndRate();
            }
            case 1506263709: {
                return this.getMaxDosePerPeriod();
            }
            case 2004889914: {
                return this.getMaxDosePerAdministration();
            }
            case 642099621: {
                return this.getMaxDosePerLifetime();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1349547969: {
                return new String[]{"integer"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
            case 1623641575: {
                return new String[]{"CodeableConcept"};
            }
            case 737543241: {
                return new String[]{"string"};
            }
            case -873664438: {
                return new String[]{"Timing"};
            }
            case -1432923513: {
                return new String[]{"boolean", "CodeableConcept"};
            }
            case 3530567: {
                return new String[]{"CodeableConcept"};
            }
            case 108704329: {
                return new String[]{"CodeableConcept"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -611024774: {
                return new String[0];
            }
            case 1506263709: {
                return new String[]{"Ratio"};
            }
            case 2004889914: {
                return new String[]{"SimpleQuantity"};
            }
            case 642099621: {
                return new String[]{"SimpleQuantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("sequence")) {
            throw new FHIRException("Cannot call addChild on a singleton property Dosage.sequence");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a singleton property Dosage.text");
        }
        if (name.equals("additionalInstruction")) {
            return this.addAdditionalInstruction();
        }
        if (name.equals("patientInstruction")) {
            throw new FHIRException("Cannot call addChild on a singleton property Dosage.patientInstruction");
        }
        if (name.equals("timing")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("asNeededBoolean")) {
            this.asNeeded = new BooleanType();
            return this.asNeeded;
        }
        if (name.equals("asNeededCodeableConcept")) {
            this.asNeeded = new CodeableConcept();
            return this.asNeeded;
        }
        if (name.equals("site")) {
            this.site = new CodeableConcept();
            return this.site;
        }
        if (name.equals("route")) {
            this.route = new CodeableConcept();
            return this.route;
        }
        if (name.equals("method")) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("doseAndRate")) {
            return this.addDoseAndRate();
        }
        if (name.equals("maxDosePerPeriod")) {
            this.maxDosePerPeriod = new Ratio();
            return this.maxDosePerPeriod;
        }
        if (name.equals("maxDosePerAdministration")) {
            this.maxDosePerAdministration = new Quantity();
            return this.maxDosePerAdministration;
        }
        if (name.equals("maxDosePerLifetime")) {
            this.maxDosePerLifetime = new Quantity();
            return this.maxDosePerLifetime;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Dosage";
    }

    @Override
    public Dosage copy() {
        Dosage dst = new Dosage();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Dosage dst) {
        super.copyValues(dst);
        dst.sequence = this.sequence == null ? null : this.sequence.copy();
        StringType stringType = dst.text = this.text == null ? null : this.text.copy();
        if (this.additionalInstruction != null) {
            dst.additionalInstruction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.additionalInstruction) {
                dst.additionalInstruction.add(codeableConcept.copy());
            }
        }
        dst.patientInstruction = this.patientInstruction == null ? null : this.patientInstruction.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
        dst.site = this.site == null ? null : this.site.copy();
        dst.route = this.route == null ? null : this.route.copy();
        CodeableConcept codeableConcept = dst.method = this.method == null ? null : this.method.copy();
        if (this.doseAndRate != null) {
            dst.doseAndRate = new ArrayList<DosageDoseAndRateComponent>();
            for (DosageDoseAndRateComponent dosageDoseAndRateComponent : this.doseAndRate) {
                dst.doseAndRate.add(dosageDoseAndRateComponent.copy());
            }
        }
        dst.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
        dst.maxDosePerAdministration = this.maxDosePerAdministration == null ? null : this.maxDosePerAdministration.copy();
        dst.maxDosePerLifetime = this.maxDosePerLifetime == null ? null : this.maxDosePerLifetime.copy();
    }

    @Override
    protected Dosage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Dosage)) {
            return false;
        }
        Dosage o = (Dosage)other_;
        return Dosage.compareDeep(this.sequence, o.sequence, true) && Dosage.compareDeep(this.text, o.text, true) && Dosage.compareDeep(this.additionalInstruction, o.additionalInstruction, true) && Dosage.compareDeep(this.patientInstruction, o.patientInstruction, true) && Dosage.compareDeep(this.timing, o.timing, true) && Dosage.compareDeep(this.asNeeded, o.asNeeded, true) && Dosage.compareDeep(this.site, o.site, true) && Dosage.compareDeep(this.route, o.route, true) && Dosage.compareDeep(this.method, o.method, true) && Dosage.compareDeep(this.doseAndRate, o.doseAndRate, true) && Dosage.compareDeep(this.maxDosePerPeriod, o.maxDosePerPeriod, true) && Dosage.compareDeep(this.maxDosePerAdministration, o.maxDosePerAdministration, true) && Dosage.compareDeep(this.maxDosePerLifetime, o.maxDosePerLifetime, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Dosage)) {
            return false;
        }
        Dosage o = (Dosage)other_;
        return Dosage.compareValues(this.sequence, o.sequence, true) && Dosage.compareValues(this.text, o.text, true) && Dosage.compareValues(this.patientInstruction, o.patientInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.text, this.additionalInstruction, this.patientInstruction, this.timing, this.asNeeded, this.site, this.route, this.method, this.doseAndRate, this.maxDosePerPeriod, this.maxDosePerAdministration, this.maxDosePerLifetime});
    }

    @Block
    public static class DosageDoseAndRateComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The kind of dose or rate specified", formalDefinition="The kind of dose or rate specified, for example, ordered or calculated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/dose-rate-type")
        protected CodeableConcept type;
        @Child(name="dose", type={Range.class, Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="Amount of medication per dose.")
        protected Type dose;
        @Child(name="rate", type={Ratio.class, Range.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Amount of medication per unit of time.")
        protected Type rate;
        private static final long serialVersionUID = -2133698888L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DosageDoseAndRateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DosageDoseAndRateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getDose() {
            return this.dose;
        }

        public Range getDoseRange() throws FHIRException {
            if (this.dose == null) {
                this.dose = new Range();
            }
            if (!(this.dose instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (Range)this.dose;
        }

        public boolean hasDoseRange() {
            return this.dose instanceof Range;
        }

        public Quantity getDoseQuantity() throws FHIRException {
            if (this.dose == null) {
                this.dose = new Quantity();
            }
            if (!(this.dose instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (Quantity)this.dose;
        }

        public boolean hasDoseQuantity() {
            return this.dose instanceof Quantity;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public DosageDoseAndRateComponent setDose(Type value) {
            if (value != null && !(value instanceof Range) && !(value instanceof Quantity)) {
                throw new Error("Not the right type for Dosage.doseAndRate.dose[x]: " + value.fhirType());
            }
            this.dose = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Ratio();
            }
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public Range getRateRange() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Range();
            }
            if (!(this.rate instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Range)this.rate;
        }

        public boolean hasRateRange() {
            return this.rate instanceof Range;
        }

        public Quantity getRateQuantity() throws FHIRException {
            if (this.rate == null) {
                this.rate = new Quantity();
            }
            if (!(this.rate instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Quantity)this.rate;
        }

        public boolean hasRateQuantity() {
            return this.rate instanceof Quantity;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public DosageDoseAndRateComponent setRate(Type value) {
            if (!(value == null || value instanceof Ratio || value instanceof Range || value instanceof Quantity)) {
                throw new Error("Not the right type for Dosage.doseAndRate.rate[x]: " + value.fhirType());
            }
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The kind of dose or rate specified, for example, ordered or calculated.", 0, 1, this.type));
            children.add(new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose));
            children.add(new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The kind of dose or rate specified, for example, ordered or calculated.", 0, 1, this.type);
                }
                case 1843195715: {
                    return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
                }
                case 3089437: {
                    return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
                }
                case 1775578912: {
                    return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
                }
                case -2083618872: {
                    return new Property("dose[x]", "Range|SimpleQuantity", "Amount of medication per dose.", 0, 1, this.dose);
                }
                case 983460768: {
                    return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
                }
                case 3493088: {
                    return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
                }
                case 204021515: {
                    return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
                }
                case 204015677: {
                    return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
                }
                case -1085459061: {
                    return new Property("rate[x]", "Ratio|Range|SimpleQuantity", "Amount of medication per unit of time.", 0, 1, this.rate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3089437: {
                    Base[] baseArray;
                    if (this.dose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.dose;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3089437: {
                    this.dose = this.castToType(value);
                    return value;
                }
                case 3493088: {
                    this.rate = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("dose[x]")) {
                this.dose = this.castToType(value);
            } else if (name.equals("rate[x]")) {
                this.rate = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("dose[x]")) {
                this.dose = null;
            } else if (name.equals("rate[x]")) {
                this.rate = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1843195715: {
                    return this.getDose();
                }
                case 3089437: {
                    return this.getDose();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 3493088: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3089437: {
                    return new String[]{"Range", "SimpleQuantity"};
                }
                case 3493088: {
                    return new String[]{"Ratio", "Range", "SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("doseRange")) {
                this.dose = new Range();
                return this.dose;
            }
            if (name.equals("doseQuantity")) {
                this.dose = new Quantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateRange")) {
                this.rate = new Range();
                return this.rate;
            }
            if (name.equals("rateQuantity")) {
                this.rate = new Quantity();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public DosageDoseAndRateComponent copy() {
            DosageDoseAndRateComponent dst = new DosageDoseAndRateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DosageDoseAndRateComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DosageDoseAndRateComponent)) {
                return false;
            }
            DosageDoseAndRateComponent o = (DosageDoseAndRateComponent)other_;
            return DosageDoseAndRateComponent.compareDeep(this.type, o.type, true) && DosageDoseAndRateComponent.compareDeep(this.dose, o.dose, true) && DosageDoseAndRateComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DosageDoseAndRateComponent)) {
                return false;
            }
            DosageDoseAndRateComponent o = (DosageDoseAndRateComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.dose, this.rate});
        }

        @Override
        public String fhirType() {
            return "Dosage.doseAndRate";
        }
    }
}

