/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MedicinalProductAuthorization;
import org.hl7.fhir.r4.model.MedicinalProductManufactured;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductPackaged", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductPackaged")
public class MedicinalProductPackaged
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={MedicinalProduct.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product with this is a pack for", formalDefinition="The product with this is a pack for.")
    protected List<Reference> subject;
    protected List<MedicinalProduct> subjectTarget;
    @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description", formalDefinition="Textual description.")
    protected StringType description;
    @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the medicinal product as classified by the regulator", formalDefinition="The legal status of supply of the medicinal product as classified by the regulator.")
    protected CodeableConcept legalStatusOfSupply;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing information", formalDefinition="Marketing information.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="marketingAuthorization", type={MedicinalProductAuthorization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
    protected Reference marketingAuthorization;
    protected MedicinalProductAuthorization marketingAuthorizationTarget;
    @Child(name="manufacturer", type={Organization.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
    protected List<Reference> manufacturer;
    protected List<Organization> manufacturerTarget;
    @Child(name="batchIdentifier", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Batch numbering", formalDefinition="Batch numbering.")
    protected List<MedicinalProductPackagedBatchIdentifierComponent> batchIdentifier;
    @Child(name="packageItem", type={}, order=8, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within", formalDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within.")
    protected List<MedicinalProductPackagedPackageItemComponent> packageItem;
    private static final long serialVersionUID = -1530863773L;
    @SearchParamDefinition(name="identifier", path="MedicinalProductPackaged.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="MedicinalProductPackaged.subject", description="The product with this is a pack for", type="reference", target={MedicinalProduct.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductPackaged:subject").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductPackaged setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductPackaged addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public MedicinalProductPackaged setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public MedicinalProductPackaged addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public MedicinalProductPackaged setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public MedicinalProductPackaged setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.legalStatusOfSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.legalStatusOfSupply = new CodeableConcept();
            }
        }
        return this.legalStatusOfSupply;
    }

    public boolean hasLegalStatusOfSupply() {
        return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
    }

    public MedicinalProductPackaged setLegalStatusOfSupply(CodeableConcept value) {
        this.legalStatusOfSupply = value;
        return this;
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public MedicinalProductPackaged setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public MedicinalProductPackaged addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public Reference getMarketingAuthorization() {
        if (this.marketingAuthorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorization = new Reference();
            }
        }
        return this.marketingAuthorization;
    }

    public boolean hasMarketingAuthorization() {
        return this.marketingAuthorization != null && !this.marketingAuthorization.isEmpty();
    }

    public MedicinalProductPackaged setMarketingAuthorization(Reference value) {
        this.marketingAuthorization = value;
        return this;
    }

    public MedicinalProductAuthorization getMarketingAuthorizationTarget() {
        if (this.marketingAuthorizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorizationTarget = new MedicinalProductAuthorization();
            }
        }
        return this.marketingAuthorizationTarget;
    }

    public MedicinalProductPackaged setMarketingAuthorizationTarget(MedicinalProductAuthorization value) {
        this.marketingAuthorizationTarget = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public MedicinalProductPackaged setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public MedicinalProductPackaged addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<MedicinalProductPackagedBatchIdentifierComponent> getBatchIdentifier() {
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        return this.batchIdentifier;
    }

    public MedicinalProductPackaged setBatchIdentifier(List<MedicinalProductPackagedBatchIdentifierComponent> theBatchIdentifier) {
        this.batchIdentifier = theBatchIdentifier;
        return this;
    }

    public boolean hasBatchIdentifier() {
        if (this.batchIdentifier == null) {
            return false;
        }
        for (MedicinalProductPackagedBatchIdentifierComponent item : this.batchIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPackagedBatchIdentifierComponent addBatchIdentifier() {
        MedicinalProductPackagedBatchIdentifierComponent t = new MedicinalProductPackagedBatchIdentifierComponent();
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return t;
    }

    public MedicinalProductPackaged addBatchIdentifier(MedicinalProductPackagedBatchIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return this;
    }

    public MedicinalProductPackagedBatchIdentifierComponent getBatchIdentifierFirstRep() {
        if (this.getBatchIdentifier().isEmpty()) {
            this.addBatchIdentifier();
        }
        return this.getBatchIdentifier().get(0);
    }

    public List<MedicinalProductPackagedPackageItemComponent> getPackageItem() {
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        return this.packageItem;
    }

    public MedicinalProductPackaged setPackageItem(List<MedicinalProductPackagedPackageItemComponent> thePackageItem) {
        this.packageItem = thePackageItem;
        return this;
    }

    public boolean hasPackageItem() {
        if (this.packageItem == null) {
            return false;
        }
        for (MedicinalProductPackagedPackageItemComponent item : this.packageItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPackagedPackageItemComponent addPackageItem() {
        MedicinalProductPackagedPackageItemComponent t = new MedicinalProductPackagedPackageItemComponent();
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        this.packageItem.add(t);
        return t;
    }

    public MedicinalProductPackaged addPackageItem(MedicinalProductPackagedPackageItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        this.packageItem.add(t);
        return this;
    }

    public MedicinalProductPackagedPackageItemComponent getPackageItemFirstRep() {
        if (this.getPackageItem().isEmpty()) {
            this.addPackageItem();
        }
        return this.getPackageItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct)", "The product with this is a pack for.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("description", "string", "Textual description.", 0, 1, this.description));
        children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("marketingAuthorization", "Reference(MedicinalProductAuthorization)", "Manufacturer of this Package Item.", 0, 1, this.marketingAuthorization));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier));
        children.add(new Property("packageItem", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.packageItem));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct)", "The product with this is a pack for.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -1724546052: {
                return new Property("description", "string", "Textual description.", 0, 1, this.description);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply of the medicinal product as classified by the regulator.", 0, 1, this.legalStatusOfSupply);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case 571831283: {
                return new Property("marketingAuthorization", "Reference(MedicinalProductAuthorization)", "Manufacturer of this Package Item.", 0, 1, this.marketingAuthorization);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -1688395901: {
                return new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier);
            }
            case 908628089: {
                return new Property("packageItem", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.packageItem);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case -844874031: {
                Base[] baseArray;
                if (this.legalStatusOfSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.legalStatusOfSupply;
                }
                return baseArray;
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case 571831283: {
                Base[] baseArray;
                if (this.marketingAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.marketingAuthorization;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -1688395901: {
                return this.batchIdentifier == null ? new Base[]{} : this.batchIdentifier.toArray(new Base[this.batchIdentifier.size()]);
            }
            case 908628089: {
                return this.packageItem == null ? new Base[]{} : this.packageItem.toArray(new Base[this.packageItem.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -844874031: {
                this.legalStatusOfSupply = this.castToCodeableConcept(value);
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(this.castToMarketingStatus(value));
                return value;
            }
            case 571831283: {
                this.marketingAuthorization = this.castToReference(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(this.castToReference(value));
                return value;
            }
            case -1688395901: {
                this.getBatchIdentifier().add((MedicinalProductPackagedBatchIdentifierComponent)value);
                return value;
            }
            case 908628089: {
                this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = this.castToCodeableConcept(value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(this.castToMarketingStatus(value));
        } else if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = this.castToReference(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(this.castToReference(value));
        } else if (name.equals("batchIdentifier")) {
            this.getBatchIdentifier().add((MedicinalProductPackagedBatchIdentifierComponent)value);
        } else if (name.equals("packageItem")) {
            this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().remove(this.castToReference(value));
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = null;
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().remove(this.castToMarketingStatus(value));
        } else if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = null;
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().remove(this.castToReference(value));
        } else if (name.equals("batchIdentifier")) {
            this.getBatchIdentifier().remove((MedicinalProductPackagedBatchIdentifierComponent)value);
        } else if (name.equals("packageItem")) {
            this.getPackageItem().remove((MedicinalProductPackagedPackageItemComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -844874031: {
                return this.getLegalStatusOfSupply();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case 571831283: {
                return this.getMarketingAuthorization();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -1688395901: {
                return this.addBatchIdentifier();
            }
            case 908628089: {
                return this.addPackageItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -844874031: {
                return new String[]{"CodeableConcept"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case 571831283: {
                return new String[]{"Reference"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -1688395901: {
                return new String[0];
            }
            case 908628089: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicinalProductPackaged.description");
        }
        if (name.equals("legalStatusOfSupply")) {
            this.legalStatusOfSupply = new CodeableConcept();
            return this.legalStatusOfSupply;
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = new Reference();
            return this.marketingAuthorization;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("batchIdentifier")) {
            return this.addBatchIdentifier();
        }
        if (name.equals("packageItem")) {
            return this.addPackageItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductPackaged";
    }

    @Override
    public MedicinalProductPackaged copy() {
        MedicinalProductPackaged dst = new MedicinalProductPackaged();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(MedicinalProductPackaged dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        CodeableConcept codeableConcept = dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        Reference reference = dst.marketingAuthorization = this.marketingAuthorization == null ? null : this.marketingAuthorization.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference2 : this.manufacturer) {
                dst.manufacturer.add(reference2.copy());
            }
        }
        if (this.batchIdentifier != null) {
            dst.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
            for (MedicinalProductPackagedBatchIdentifierComponent medicinalProductPackagedBatchIdentifierComponent : this.batchIdentifier) {
                dst.batchIdentifier.add(medicinalProductPackagedBatchIdentifierComponent.copy());
            }
        }
        if (this.packageItem != null) {
            dst.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            for (MedicinalProductPackagedPackageItemComponent medicinalProductPackagedPackageItemComponent : this.packageItem) {
                dst.packageItem.add(medicinalProductPackagedPackageItemComponent.copy());
            }
        }
    }

    protected MedicinalProductPackaged typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPackaged)) {
            return false;
        }
        MedicinalProductPackaged o = (MedicinalProductPackaged)other_;
        return MedicinalProductPackaged.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPackaged.compareDeep(this.subject, o.subject, true) && MedicinalProductPackaged.compareDeep(this.description, o.description, true) && MedicinalProductPackaged.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && MedicinalProductPackaged.compareDeep(this.marketingStatus, o.marketingStatus, true) && MedicinalProductPackaged.compareDeep(this.marketingAuthorization, o.marketingAuthorization, true) && MedicinalProductPackaged.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductPackaged.compareDeep(this.batchIdentifier, o.batchIdentifier, true) && MedicinalProductPackaged.compareDeep(this.packageItem, o.packageItem, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPackaged)) {
            return false;
        }
        MedicinalProductPackaged o = (MedicinalProductPackaged)other_;
        return MedicinalProductPackaged.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.subject, this.description, this.legalStatusOfSupply, this.marketingStatus, this.marketingAuthorization, this.manufacturer, this.batchIdentifier, this.packageItem});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductPackaged;
    }

    @Block
    public static class MedicinalProductPackagedBatchIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outerPackaging", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the outer packaging of a specific batch", formalDefinition="A number appearing on the outer packaging of a specific batch.")
        protected Identifier outerPackaging;
        @Child(name="immediatePackaging", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the immediate packaging (and not the outer packaging)", formalDefinition="A number appearing on the immediate packaging (and not the outer packaging).")
        protected Identifier immediatePackaging;
        private static final long serialVersionUID = 1187365068L;

        public MedicinalProductPackagedBatchIdentifierComponent() {
        }

        public MedicinalProductPackagedBatchIdentifierComponent(Identifier outerPackaging) {
            this.outerPackaging = outerPackaging;
        }

        public Identifier getOuterPackaging() {
            if (this.outerPackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedBatchIdentifierComponent.outerPackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.outerPackaging = new Identifier();
                }
            }
            return this.outerPackaging;
        }

        public boolean hasOuterPackaging() {
            return this.outerPackaging != null && !this.outerPackaging.isEmpty();
        }

        public MedicinalProductPackagedBatchIdentifierComponent setOuterPackaging(Identifier value) {
            this.outerPackaging = value;
            return this;
        }

        public Identifier getImmediatePackaging() {
            if (this.immediatePackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedBatchIdentifierComponent.immediatePackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.immediatePackaging = new Identifier();
                }
            }
            return this.immediatePackaging;
        }

        public boolean hasImmediatePackaging() {
            return this.immediatePackaging != null && !this.immediatePackaging.isEmpty();
        }

        public MedicinalProductPackagedBatchIdentifierComponent setImmediatePackaging(Identifier value) {
            this.immediatePackaging = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging));
            children.add(new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -682249912: {
                    return new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging);
                }
                case 721147602: {
                    return new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    Base[] baseArray;
                    if (this.outerPackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.outerPackaging;
                    }
                    return baseArray;
                }
                case 721147602: {
                    Base[] baseArray;
                    if (this.immediatePackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.immediatePackaging;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    this.outerPackaging = this.castToIdentifier(value);
                    return value;
                }
                case 721147602: {
                    this.immediatePackaging = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = this.castToIdentifier(value);
            } else if (name.equals("immediatePackaging")) {
                this.immediatePackaging = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = null;
            } else if (name.equals("immediatePackaging")) {
                this.immediatePackaging = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return this.getOuterPackaging();
                }
                case 721147602: {
                    return this.getImmediatePackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return new String[]{"Identifier"};
                }
                case 721147602: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = new Identifier();
                return this.outerPackaging;
            }
            if (name.equals("immediatePackaging")) {
                this.immediatePackaging = new Identifier();
                return this.immediatePackaging;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPackagedBatchIdentifierComponent copy() {
            MedicinalProductPackagedBatchIdentifierComponent dst = new MedicinalProductPackagedBatchIdentifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPackagedBatchIdentifierComponent dst) {
            super.copyValues(dst);
            dst.outerPackaging = this.outerPackaging == null ? null : this.outerPackaging.copy();
            dst.immediatePackaging = this.immediatePackaging == null ? null : this.immediatePackaging.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedBatchIdentifierComponent)) {
                return false;
            }
            MedicinalProductPackagedBatchIdentifierComponent o = (MedicinalProductPackagedBatchIdentifierComponent)other_;
            return MedicinalProductPackagedBatchIdentifierComponent.compareDeep(this.outerPackaging, o.outerPackaging, true) && MedicinalProductPackagedBatchIdentifierComponent.compareDeep(this.immediatePackaging, o.immediatePackaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedBatchIdentifierComponent)) {
                return false;
            }
            MedicinalProductPackagedBatchIdentifierComponent o = (MedicinalProductPackagedBatchIdentifierComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.outerPackaging, this.immediatePackaging});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPackaged.batchIdentifier";
        }
    }

    @Block
    public static class MedicinalProductPackagedPackageItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Including possibly Data Carrier Identifier", formalDefinition="Including possibly Data Carrier Identifier.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The physical type of the container of the medicine", formalDefinition="The physical type of the container of the medicine.")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1", formalDefinition="The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.")
        protected Quantity quantity;
        @Child(name="material", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        protected List<CodeableConcept> material;
        @Child(name="alternateMaterial", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A possible alternate material for the packaging", formalDefinition="A possible alternate material for the packaging.")
        protected List<CodeableConcept> alternateMaterial;
        @Child(name="device", type={DeviceDefinition.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A device accompanying a medicinal product", formalDefinition="A device accompanying a medicinal product.")
        protected List<Reference> device;
        protected List<DeviceDefinition> deviceTarget;
        @Child(name="manufacturedItem", type={MedicinalProductManufactured.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The manufactured item as contained in the packaged medicinal product", formalDefinition="The manufactured item as contained in the packaged medicinal product.")
        protected List<Reference> manufacturedItem;
        protected List<MedicinalProductManufactured> manufacturedItemTarget;
        @Child(name="packageItem", type={MedicinalProductPackagedPackageItemComponent.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Allows containers within containers", formalDefinition="Allows containers within containers.")
        protected List<MedicinalProductPackagedPackageItemComponent> packageItem;
        @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
        protected ProdCharacteristic physicalCharacteristics;
        @Child(name="otherCharacteristics", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Other codeable characteristics", formalDefinition="Other codeable characteristics.")
        protected List<CodeableConcept> otherCharacteristics;
        @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
        protected List<ProductShelfLife> shelfLifeStorage;
        @Child(name="manufacturer", type={Organization.class}, order=12, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
        protected List<Reference> manufacturer;
        protected List<Organization> manufacturerTarget;
        private static final long serialVersionUID = 1454286533L;

        public MedicinalProductPackagedPackageItemComponent() {
        }

        public MedicinalProductPackagedPackageItemComponent(CodeableConcept type, Quantity quantity) {
            this.type = type;
            this.quantity = quantity;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public MedicinalProductPackagedPackageItemComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public List<CodeableConcept> getMaterial() {
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            return this.material;
        }

        public MedicinalProductPackagedPackageItemComponent setMaterial(List<CodeableConcept> theMaterial) {
            this.material = theMaterial;
            return this;
        }

        public boolean hasMaterial() {
            if (this.material == null) {
                return false;
            }
            for (CodeableConcept item : this.material) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return this;
        }

        public CodeableConcept getMaterialFirstRep() {
            if (this.getMaterial().isEmpty()) {
                this.addMaterial();
            }
            return this.getMaterial().get(0);
        }

        public List<CodeableConcept> getAlternateMaterial() {
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            return this.alternateMaterial;
        }

        public MedicinalProductPackagedPackageItemComponent setAlternateMaterial(List<CodeableConcept> theAlternateMaterial) {
            this.alternateMaterial = theAlternateMaterial;
            return this;
        }

        public boolean hasAlternateMaterial() {
            if (this.alternateMaterial == null) {
                return false;
            }
            for (CodeableConcept item : this.alternateMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAlternateMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addAlternateMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return this;
        }

        public CodeableConcept getAlternateMaterialFirstRep() {
            if (this.getAlternateMaterial().isEmpty()) {
                this.addAlternateMaterial();
            }
            return this.getAlternateMaterial().get(0);
        }

        public List<Reference> getDevice() {
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            return this.device;
        }

        public MedicinalProductPackagedPackageItemComponent setDevice(List<Reference> theDevice) {
            this.device = theDevice;
            return this;
        }

        public boolean hasDevice() {
            if (this.device == null) {
                return false;
            }
            for (Reference item : this.device) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDevice() {
            Reference t = new Reference();
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addDevice(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return this;
        }

        public Reference getDeviceFirstRep() {
            if (this.getDevice().isEmpty()) {
                this.addDevice();
            }
            return this.getDevice().get(0);
        }

        public List<Reference> getManufacturedItem() {
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<Reference>();
            }
            return this.manufacturedItem;
        }

        public MedicinalProductPackagedPackageItemComponent setManufacturedItem(List<Reference> theManufacturedItem) {
            this.manufacturedItem = theManufacturedItem;
            return this;
        }

        public boolean hasManufacturedItem() {
            if (this.manufacturedItem == null) {
                return false;
            }
            for (Reference item : this.manufacturedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturedItem() {
            Reference t = new Reference();
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<Reference>();
            }
            this.manufacturedItem.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addManufacturedItem(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<Reference>();
            }
            this.manufacturedItem.add(t);
            return this;
        }

        public Reference getManufacturedItemFirstRep() {
            if (this.getManufacturedItem().isEmpty()) {
                this.addManufacturedItem();
            }
            return this.getManufacturedItem().get(0);
        }

        public List<MedicinalProductPackagedPackageItemComponent> getPackageItem() {
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            return this.packageItem;
        }

        public MedicinalProductPackagedPackageItemComponent setPackageItem(List<MedicinalProductPackagedPackageItemComponent> thePackageItem) {
            this.packageItem = thePackageItem;
            return this;
        }

        public boolean hasPackageItem() {
            if (this.packageItem == null) {
                return false;
            }
            for (MedicinalProductPackagedPackageItemComponent item : this.packageItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductPackagedPackageItemComponent addPackageItem() {
            MedicinalProductPackagedPackageItemComponent t = new MedicinalProductPackagedPackageItemComponent();
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            this.packageItem.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addPackageItem(MedicinalProductPackagedPackageItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            this.packageItem.add(t);
            return this;
        }

        public MedicinalProductPackagedPackageItemComponent getPackageItemFirstRep() {
            if (this.getPackageItem().isEmpty()) {
                this.addPackageItem();
            }
            return this.getPackageItem().get(0);
        }

        public ProdCharacteristic getPhysicalCharacteristics() {
            if (this.physicalCharacteristics == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.physicalCharacteristics");
                }
                if (Configuration.doAutoCreate()) {
                    this.physicalCharacteristics = new ProdCharacteristic();
                }
            }
            return this.physicalCharacteristics;
        }

        public boolean hasPhysicalCharacteristics() {
            return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setPhysicalCharacteristics(ProdCharacteristic value) {
            this.physicalCharacteristics = value;
            return this;
        }

        public List<CodeableConcept> getOtherCharacteristics() {
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            return this.otherCharacteristics;
        }

        public MedicinalProductPackagedPackageItemComponent setOtherCharacteristics(List<CodeableConcept> theOtherCharacteristics) {
            this.otherCharacteristics = theOtherCharacteristics;
            return this;
        }

        public boolean hasOtherCharacteristics() {
            if (this.otherCharacteristics == null) {
                return false;
            }
            for (CodeableConcept item : this.otherCharacteristics) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addOtherCharacteristics() {
            CodeableConcept t = new CodeableConcept();
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            this.otherCharacteristics.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addOtherCharacteristics(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            this.otherCharacteristics.add(t);
            return this;
        }

        public CodeableConcept getOtherCharacteristicsFirstRep() {
            if (this.getOtherCharacteristics().isEmpty()) {
                this.addOtherCharacteristics();
            }
            return this.getOtherCharacteristics().get(0);
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            return this.shelfLifeStorage;
        }

        public MedicinalProductPackagedPackageItemComponent setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
            this.shelfLifeStorage = theShelfLifeStorage;
            return this;
        }

        public boolean hasShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                return false;
            }
            for (ProductShelfLife item : this.shelfLifeStorage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductShelfLife addShelfLifeStorage() {
            ProductShelfLife t = new ProductShelfLife();
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addShelfLifeStorage(ProductShelfLife t) {
            if (t == null) {
                return this;
            }
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return this;
        }

        public ProductShelfLife getShelfLifeStorageFirstRep() {
            if (this.getShelfLifeStorage().isEmpty()) {
                this.addShelfLifeStorage();
            }
            return this.getShelfLifeStorage().get(0);
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public MedicinalProductPackagedPackageItemComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductPackaged.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.", 0, 1, this.quantity));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material));
            children.add(new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial));
            children.add(new Property("device", "Reference(DeviceDefinition)", "A device accompanying a medicinal product.", 0, Integer.MAX_VALUE, this.device));
            children.add(new Property("manufacturedItem", "Reference(MedicinalProductManufactured)", "The manufactured item as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.manufacturedItem));
            children.add(new Property("packageItem", "@MedicinalProductPackaged.packageItem", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.packageItem));
            children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
            children.add(new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics));
            children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
            children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(MedicinalProductPackaged.SP_IDENTIFIER, "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.", 0, 1, this.quantity);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material);
                }
                case -1021448255: {
                    return new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial);
                }
                case -1335157162: {
                    return new Property("device", "Reference(DeviceDefinition)", "A device accompanying a medicinal product.", 0, Integer.MAX_VALUE, this.device);
                }
                case 62093686: {
                    return new Property("manufacturedItem", "Reference(MedicinalProductManufactured)", "The manufactured item as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.manufacturedItem);
                }
                case 908628089: {
                    return new Property("packageItem", "@MedicinalProductPackaged.packageItem", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.packageItem);
                }
                case -1599676319: {
                    return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
                }
                case 722135304: {
                    return new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics);
                }
                case 172049237: {
                    return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 299066663: {
                    return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
                }
                case -1021448255: {
                    return this.alternateMaterial == null ? new Base[]{} : this.alternateMaterial.toArray(new Base[this.alternateMaterial.size()]);
                }
                case -1335157162: {
                    return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
                }
                case 62093686: {
                    return this.manufacturedItem == null ? new Base[]{} : this.manufacturedItem.toArray(new Base[this.manufacturedItem.size()]);
                }
                case 908628089: {
                    return this.packageItem == null ? new Base[]{} : this.packageItem.toArray(new Base[this.packageItem.size()]);
                }
                case -1599676319: {
                    Base[] baseArray;
                    if (this.physicalCharacteristics == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.physicalCharacteristics;
                    }
                    return baseArray;
                }
                case 722135304: {
                    return this.otherCharacteristics == null ? new Base[]{} : this.otherCharacteristics.toArray(new Base[this.otherCharacteristics.size()]);
                }
                case 172049237: {
                    return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case 299066663: {
                    this.getMaterial().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1021448255: {
                    this.getAlternateMaterial().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1335157162: {
                    this.getDevice().add(this.castToReference(value));
                    return value;
                }
                case 62093686: {
                    this.getManufacturedItem().add(this.castToReference(value));
                    return value;
                }
                case 908628089: {
                    this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
                    return value;
                }
                case -1599676319: {
                    this.physicalCharacteristics = this.castToProdCharacteristic(value);
                    return value;
                }
                case 722135304: {
                    this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 172049237: {
                    this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductPackaged.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("material")) {
                this.getMaterial().add(this.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().add(this.castToCodeableConcept(value));
            } else if (name.equals("device")) {
                this.getDevice().add(this.castToReference(value));
            } else if (name.equals("manufacturedItem")) {
                this.getManufacturedItem().add(this.castToReference(value));
            } else if (name.equals("packageItem")) {
                this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
            } else if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
            } else if (name.equals("otherCharacteristics")) {
                this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductPackaged.SP_IDENTIFIER)) {
                this.getIdentifier().remove(this.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("material")) {
                this.getMaterial().remove(this.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().remove(this.castToCodeableConcept(value));
            } else if (name.equals("device")) {
                this.getDevice().remove(this.castToReference(value));
            } else if (name.equals("manufacturedItem")) {
                this.getManufacturedItem().remove(this.castToReference(value));
            } else if (name.equals("packageItem")) {
                this.getPackageItem().remove((MedicinalProductPackagedPackageItemComponent)value);
            } else if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = null;
            } else if (name.equals("otherCharacteristics")) {
                this.getOtherCharacteristics().remove(this.castToCodeableConcept(value));
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().remove(this.castToProductShelfLife(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 299066663: {
                    return this.addMaterial();
                }
                case -1021448255: {
                    return this.addAlternateMaterial();
                }
                case -1335157162: {
                    return this.addDevice();
                }
                case 62093686: {
                    return this.addManufacturedItem();
                }
                case 908628089: {
                    return this.addPackageItem();
                }
                case -1599676319: {
                    return this.getPhysicalCharacteristics();
                }
                case 722135304: {
                    return this.addOtherCharacteristics();
                }
                case 172049237: {
                    return this.addShelfLifeStorage();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case -1021448255: {
                    return new String[]{"CodeableConcept"};
                }
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 62093686: {
                    return new String[]{"Reference"};
                }
                case 908628089: {
                    return new String[]{"@MedicinalProductPackaged.packageItem"};
                }
                case -1599676319: {
                    return new String[]{"ProdCharacteristic"};
                }
                case 722135304: {
                    return new String[]{"CodeableConcept"};
                }
                case 172049237: {
                    return new String[]{"ProductShelfLife"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductPackaged.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("material")) {
                return this.addMaterial();
            }
            if (name.equals("alternateMaterial")) {
                return this.addAlternateMaterial();
            }
            if (name.equals("device")) {
                return this.addDevice();
            }
            if (name.equals("manufacturedItem")) {
                return this.addManufacturedItem();
            }
            if (name.equals("packageItem")) {
                return this.addPackageItem();
            }
            if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = new ProdCharacteristic();
                return this.physicalCharacteristics;
            }
            if (name.equals("otherCharacteristics")) {
                return this.addOtherCharacteristics();
            }
            if (name.equals("shelfLifeStorage")) {
                return this.addShelfLifeStorage();
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPackagedPackageItemComponent copy() {
            MedicinalProductPackagedPackageItemComponent dst = new MedicinalProductPackagedPackageItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MedicinalProductPackagedPackageItemComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.material != null) {
                dst.material = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.material) {
                    dst.material.add(codeableConcept.copy());
                }
            }
            if (this.alternateMaterial != null) {
                dst.alternateMaterial = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.alternateMaterial) {
                    dst.alternateMaterial.add(codeableConcept.copy());
                }
            }
            if (this.device != null) {
                dst.device = new ArrayList<Reference>();
                for (Reference reference : this.device) {
                    dst.device.add(reference.copy());
                }
            }
            if (this.manufacturedItem != null) {
                dst.manufacturedItem = new ArrayList<Reference>();
                for (Reference reference : this.manufacturedItem) {
                    dst.manufacturedItem.add(reference.copy());
                }
            }
            if (this.packageItem != null) {
                dst.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
                for (MedicinalProductPackagedPackageItemComponent medicinalProductPackagedPackageItemComponent : this.packageItem) {
                    dst.packageItem.add(medicinalProductPackagedPackageItemComponent.copy());
                }
            }
            ProdCharacteristic prodCharacteristic = dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
            if (this.otherCharacteristics != null) {
                dst.otherCharacteristics = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.otherCharacteristics) {
                    dst.otherCharacteristics.add(codeableConcept.copy());
                }
            }
            if (this.shelfLifeStorage != null) {
                dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
                for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                    dst.shelfLifeStorage.add(productShelfLife.copy());
                }
            }
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference reference : this.manufacturer) {
                    dst.manufacturer.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemComponent o = (MedicinalProductPackagedPackageItemComponent)other_;
            return MedicinalProductPackagedPackageItemComponent.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.type, o.type, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.quantity, o.quantity, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.material, o.material, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.alternateMaterial, o.alternateMaterial, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.device, o.device, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.manufacturedItem, o.manufacturedItem, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.packageItem, o.packageItem, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.otherCharacteristics, o.otherCharacteristics, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.manufacturer, o.manufacturer, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemComponent o = (MedicinalProductPackagedPackageItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.device, this.manufacturedItem, this.packageItem, this.physicalCharacteristics, this.otherCharacteristics, this.shelfLifeStorage, this.manufacturer});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPackaged.packageItem";
        }
    }
}

